# encoding: utf-8

def absent(node):
    assert hasattr(node, 'location'), f'Tried to get location of {node.name} in {node.character.name}'
    return (node.location != node.character.place['classroom'])

def be_timely(node):
    for user in node.leader.values():
        if (user.name not in ('physical', 'student_body')):
            return ((not user.stat['lazy']) or node.engine.coin_flip())

def is_drunkard(character):
    return character.stat['drunkard']

def class_in_session(node):
    return (8 <= node.engine.character['physical'].stat['hour'] < 15)

def pay_attention(node):
    return (node['drunk'] == node['slow'] == 0)

def in_class(node):
    classroom = node.engine.character['physical'].place['classroom']
    student = node.character.unit['physical'].only
    assert hasattr(student, 'location'), f'Tried to get location of {student.name} in physical, a unit of {node.character.name}'
    return (student.location == classroom)
