# PyPformat

[![tests](https://github.com/SpectraL519/pypformat/actions/workflows/tests.yaml/badge.svg)](https://github.com/SpectraL519/pypformat/actions/workflows/tests)
[![examples](https://github.com/SpectraL519/pypformat/actions/workflows/examples.yaml/badge.svg)](https://github.com/SpectraL519/pypformat/actions/workflows/examples)
[![ruff - linter & formatter](https://github.com/SpectraL519/pypformat/actions/workflows/ruff.yaml/badge.svg)](https://github.com/SpectraL519/pypformat/actions/workflows/ruff)
[![coverage](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/SpectraL519/60ba7283e412ea91cd2db2b3b649003d/raw/pypf_covbadge.json)]()

<br />

## Overview

`PyPformat` is a simple and highly customizable python pretty-formatting package designed as an alternative to the built-in [pprint library](https://docs.python.org/3/library/pprint.html) - `PyPformat` uses a different, more natural formatting style and provides extensive personalization capabilities, including text colorizing or customized indentation marking, on top of the basic options like compact printing.

<br />

The example below demostrates the difference in the **default** outputs produced by the `pprint` and `PyPformat` libraries.

```txt
>>> from pprint import pprint
>>> import pformat as pf
>>>
>>> from collections import ChainMap, Counter, OrderedDict, UserDict, defaultdict
>>>
>>> mapping = {
...     "key1": 1,
...     "key2": OrderedDict({"key3": 3, "key4": 4}),
...     "key5": defaultdict(
...         str,
...         {
...             "key6": 6,
...             "a_very_long_dictionary_key7": ChainMap(
...                 {"key10": [10, 11, 12, 13], "key8": 8, "key9": 9}
...             ),
...             "key11": Counter("Hello"),
...         },
...     ),
...     "key12": UserDict({0: "a", 1: "b", 2: "c"}),
... }
>>>
>>> pprint(mapping)
{'key1': 1,
 'key12': {0: 'a', 1: 'b', 2: 'c'},
 'key2': OrderedDict({'key3': 3, 'key4': 4}),
 'key5': defaultdict(<class 'str'>,
                     {'a_very_long_dictionary_key7': ChainMap({'key10': [10,
                                                                         11,
                                                                         12,
                                                                         13],
                                                               'key8': 8,
                                                               'key9': 9}),
                      'key11': Counter({'l': 2, 'H': 1, 'e': 1, 'o': 1}),
                      'key6': 6})}
>>>
>>> formatter = pf.PrettyFormatter()
>>> print(formatter(mapping))
{
    'key1': 1,
    'key2': OrderedDict({
        'key3': 3,
        'key4': 4,
    }),
    'key5': defaultdict(<class 'str'>, {
        'key6': 6,
        'a_very_long_dictionary_key7': ChainMap({
            'key10': [
                10,
                11,
                12,
                13,
            ],
            'key8': 8,
            'key9': 9,
        }),
        'key11': Counter({
            'H': 1,
            'e': 1,
            'l': 2,
            'o': 1,
        }),
    }),
    'key12': {
        0: 'a',
        1: 'b',
        2: 'c',
    },
}
```

> [!IMPORTANT]
>
> - The minimum (tested) python version required to use the `PyPformat` package is **3.9**.
> - The complete functionality of the `PyPformat` package (including all format configuration options) is described in [PyPformat - Usage](https://github.com/SpectraL519/pypformat/blob/v1.2.4/docs/usage.md) and [PyPformat - Utility](https://github.com/SpectraL519/pypformat/blob/v1.2.4/docs/utility.md) documents.
> - While the `PyPformat` package is already quite versatile and customizable, its development is ongoing. A detailed list of the planned features/improvements can be found in the [PyPformat - TODO](https://github.com/SpectraL519/pypformat/blob/v1.2.4/docs/todo.md) document (please note that this list is not fixed and may be expanded).

<br />
<br />

## Installation

The `PyPformat` package can be installed via pip:

```shell
pip install pypformat
```

<br />
<br />

## For Developers

The [PyPformat - Dev notes](https://github.com/SpectraL519/pypformat/blob/v1.2.4/docs/dev_notes.md) document contains the information about project development, testing and formatting.

<br />
<br />

## Licence

The `PyPformat` project is licenced under the [MIT Licence](https://opensource.org/license/mit/), which can be inspected in the [LICENCE](https://github.com/SpectraL519/pypformat/blob/v1.2.4/LICENSE) file in the project's root directory.
