"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.hypothetical_license_details import HypotheticalLicenseDetails
from agilicus_api.model.hypothetical_license_details_query import HypotheticalLicenseDetailsQuery
from agilicus_api.model.license import License
from agilicus_api.model.list_license_details_response import ListLicenseDetailsResponse
from agilicus_api.model.list_license_evaluation_contexts_response import ListLicenseEvaluationContextsResponse
from agilicus_api.model.list_licenses_response import ListLicensesResponse
from agilicus_api.model.list_product_table_versions_response import ListProductTableVersionsResponse
from agilicus_api.model.product_table_version import ProductTableVersion


class LicensingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_hypothetical_license_details_query(
            self,
            hypothetical_license_details_query,
            **kwargs
        ):
            """Query a hypothetical set of license details  # noqa: E501

            Get all per-org license details matching the query. This will return the actual constraints available to an organisation, taking into account their product, the hypothetical version of the product table, and any overrides applied to their organisation. Multiple organisations' constraints may be returned at a time.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hypothetical_license_details_query(hypothetical_license_details_query, async_req=True)
            >>> result = thread.get()

            Args:
                hypothetical_license_details_query (HypotheticalLicenseDetailsQuery):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HypotheticalLicenseDetails
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hypothetical_license_details_query'] = \
                hypothetical_license_details_query
            return self.call_with_http_info(**kwargs)

        if self.create_hypothetical_license_details_query is None:
            self.create_hypothetical_license_details_query = _Endpoint(
                settings={
                    'response_type': (HypotheticalLicenseDetails,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/license_details/hypothetical',
                    'operation_id': 'create_hypothetical_license_details_query',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'hypothetical_license_details_query',
                    ],
                    'required': [
                        'hypothetical_license_details_query',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'hypothetical_license_details_query':
                            (HypotheticalLicenseDetailsQuery,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'hypothetical_license_details_query': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_hypothetical_license_details_query
            )

        def __create_license(
            self,
            license,
            **kwargs
        ):
            """Create a license  # noqa: E501

            Create a license  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_license(license, async_req=True)
            >>> result = thread.get()

            Args:
                license (License):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                License
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['license'] = \
                license
            return self.call_with_http_info(**kwargs)

        if self.create_license is None:
            self.create_license = _Endpoint(
                settings={
                    'response_type': (License,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses',
                    'operation_id': 'create_license',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'license',
                    ],
                    'required': [
                        'license',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'license':
                            (License,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'license': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_license
            )

        def __create_product_table_version(
            self,
            product_table_version,
            **kwargs
        ):
            """Create a product table version  # noqa: E501

            Create a product table version  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_product_table_version(product_table_version, async_req=True)
            >>> result = thread.get()

            Args:
                product_table_version (ProductTableVersion):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProductTableVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_table_version'] = \
                product_table_version
            return self.call_with_http_info(**kwargs)

        if self.create_product_table_version is None:
            self.create_product_table_version = _Endpoint(
                settings={
                    'response_type': (ProductTableVersion,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/product_table_versions',
                    'operation_id': 'create_product_table_version',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_table_version',
                    ],
                    'required': [
                        'product_table_version',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_table_version':
                            (ProductTableVersion,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'product_table_version': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_product_table_version
            )

        def __delete_license(
            self,
            license_id,
            **kwargs
        ):
            """Delete a license  # noqa: E501

            Delete a license  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_license(license_id, async_req=True)
            >>> result = thread.get()

            Args:
                license_id (str): A license id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['license_id'] = \
                license_id
            return self.call_with_http_info(**kwargs)

        if self.delete_license is None:
            self.delete_license = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses/{license_id}',
                    'operation_id': 'delete_license',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'license_id',
                    ],
                    'required': [
                        'license_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'license_id':
                            (str,),
                    },
                    'attribute_map': {
                        'license_id': 'license_id',
                    },
                    'location_map': {
                        'license_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_license
            )

        def __delete_product_table_version(
            self,
            product_table_version_id,
            **kwargs
        ):
            """Delete a product table version  # noqa: E501

            Delete a product table version  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_product_table_version(product_table_version_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_table_version_id (str): A product table version id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_table_version_id'] = \
                product_table_version_id
            return self.call_with_http_info(**kwargs)

        if self.delete_product_table_version is None:
            self.delete_product_table_version = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/product_table_versions/{product_table_version_id}',
                    'operation_id': 'delete_product_table_version',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_table_version_id',
                    ],
                    'required': [
                        'product_table_version_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_table_version_id':
                            (str,),
                    },
                    'attribute_map': {
                        'product_table_version_id': 'product_table_version_id',
                    },
                    'location_map': {
                        'product_table_version_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_product_table_version
            )

        def __get_license(
            self,
            license_id,
            **kwargs
        ):
            """Get a single license  # noqa: E501

            Get a single license  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_license(license_id, async_req=True)
            >>> result = thread.get()

            Args:
                license_id (str): A license id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                License
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['license_id'] = \
                license_id
            return self.call_with_http_info(**kwargs)

        if self.get_license is None:
            self.get_license = _Endpoint(
                settings={
                    'response_type': (License,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses/{license_id}',
                    'operation_id': 'get_license',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'license_id',
                    ],
                    'required': [
                        'license_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'license_id':
                            (str,),
                    },
                    'attribute_map': {
                        'license_id': 'license_id',
                    },
                    'location_map': {
                        'license_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_license
            )

        def __get_product_table_version(
            self,
            product_table_version_id,
            **kwargs
        ):
            """Get a single product table version  # noqa: E501

            Get a single product table version  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_product_table_version(product_table_version_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_table_version_id (str): A product table version id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProductTableVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_table_version_id'] = \
                product_table_version_id
            return self.call_with_http_info(**kwargs)

        if self.get_product_table_version is None:
            self.get_product_table_version = _Endpoint(
                settings={
                    'response_type': (ProductTableVersion,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/product_table_versions/{product_table_version_id}',
                    'operation_id': 'get_product_table_version',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_table_version_id',
                    ],
                    'required': [
                        'product_table_version_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_table_version_id':
                            (str,),
                    },
                    'attribute_map': {
                        'product_table_version_id': 'product_table_version_id',
                    },
                    'location_map': {
                        'product_table_version_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_product_table_version
            )

        def __list_license_details(
            self,
            **kwargs
        ):
            """Get all license details  # noqa: E501

            Get all per-org license details matching the query. This will return the actual constraints available to an organisation, taking into account their product, version of the product table, and any overrides applied to their organisation. Multiple organisations' constraints may be returned at a time, and paged through using page_at_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_license_details(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                license_id (str): A license id. [optional]
                license_ids ([str]): A list of license ids. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListLicenseDetailsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_license_details is None:
            self.list_license_details = _Endpoint(
                settings={
                    'response_type': (ListLicenseDetailsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/license_details',
                    'operation_id': 'list_license_details',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'license_id',
                        'license_ids',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'license_id':
                            (str,),
                        'license_ids':
                            ([str],),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'license_id': 'license_id',
                        'license_ids': 'license_ids',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'license_id': 'query',
                        'license_ids': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                        'license_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_license_details
            )

        def __list_license_evaluation_contexts(
            self,
            **kwargs
        ):
            """Get license evaluation context  # noqa: E501

            Get all per-org license evaluation input matching the query. This will return the context dictionary to pass into the evaluation of a license. Multiple organisations' input may be returned at a time, and paged through using page_at_id.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_license_evaluation_contexts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                license_id (str): A license id. [optional]
                license_ids ([str]): A list of license ids. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListLicenseEvaluationContextsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_license_evaluation_contexts is None:
            self.list_license_evaluation_contexts = _Endpoint(
                settings={
                    'response_type': (ListLicenseEvaluationContextsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses/evaluation_contexts',
                    'operation_id': 'list_license_evaluation_contexts',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'license_id',
                        'license_ids',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'license_id':
                            (str,),
                        'license_ids':
                            ([str],),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'license_id': 'license_id',
                        'license_ids': 'license_ids',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'license_id': 'query',
                        'license_ids': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                        'license_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_license_evaluation_contexts
            )

        def __list_licenses(
            self,
            **kwargs
        ):
            """Get all licenses  # noqa: E501

            Get all Licenses matching the query  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_licenses(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListLicensesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_licenses is None:
            self.list_licenses = _Endpoint(
                settings={
                    'response_type': (ListLicensesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses',
                    'operation_id': 'list_licenses',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_licenses
            )

        def __list_product_table_versions(
            self,
            **kwargs
        ):
            """Get all product table versions  # noqa: E501

            Get all product table versions matching the query  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_product_table_versions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                version (str): Query based on a version. [optional]
                page_at_version (str): Page based on a version. [optional]
                published (bool): Query based on a whether something is published. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListProductTableVersionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_product_table_versions is None:
            self.list_product_table_versions = _Endpoint(
                settings={
                    'response_type': (ListProductTableVersionsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/product_table_versions',
                    'operation_id': 'list_product_table_versions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'version',
                        'page_at_version',
                        'published',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'version':
                            (str,),
                        'page_at_version':
                            (str,),
                        'published':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'version': 'version',
                        'page_at_version': 'page_at_version',
                        'published': 'published',
                    },
                    'location_map': {
                        'limit': 'query',
                        'version': 'query',
                        'page_at_version': 'query',
                        'published': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_product_table_versions
            )

        def __replace_license(
            self,
            license_id,
            **kwargs
        ):
            """Create or update a license  # noqa: E501

            Update a license. If subscription_reconcil is set and the product changes, then the system will update the prices in the billing system to align.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_license(license_id, async_req=True)
            >>> result = thread.get()

            Args:
                license_id (str): A license id

            Keyword Args:
                subscription_reconcile (bool): Allows control when communicating with backend provider, specifically with regard to subscriptions, and reconcile the subscription with the product . [optional]
                license (License): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                License
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['license_id'] = \
                license_id
            return self.call_with_http_info(**kwargs)

        if self.replace_license is None:
            self.replace_license = _Endpoint(
                settings={
                    'response_type': (License,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/licenses/{license_id}',
                    'operation_id': 'replace_license',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'license_id',
                        'subscription_reconcile',
                        'license',
                    ],
                    'required': [
                        'license_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'license_id':
                            (str,),
                        'subscription_reconcile':
                            (bool,),
                        'license':
                            (License,),
                    },
                    'attribute_map': {
                        'license_id': 'license_id',
                        'subscription_reconcile': 'subscription_reconcile',
                    },
                    'location_map': {
                        'license_id': 'path',
                        'subscription_reconcile': 'query',
                        'license': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_license
            )

        def __replace_product_table_version(
            self,
            product_table_version_id,
            **kwargs
        ):
            """Create or update a product table version  # noqa: E501

            Update a product table version  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_product_table_version(product_table_version_id, async_req=True)
            >>> result = thread.get()

            Args:
                product_table_version_id (str): A product table version id

            Keyword Args:
                product_table_version (ProductTableVersion): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProductTableVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['product_table_version_id'] = \
                product_table_version_id
            return self.call_with_http_info(**kwargs)

        if self.replace_product_table_version is None:
            self.replace_product_table_version = _Endpoint(
                settings={
                    'response_type': (ProductTableVersion,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/product_table_versions/{product_table_version_id}',
                    'operation_id': 'replace_product_table_version',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'product_table_version_id',
                        'product_table_version',
                    ],
                    'required': [
                        'product_table_version_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'product_table_version_id':
                            (str,),
                        'product_table_version':
                            (ProductTableVersion,),
                    },
                    'attribute_map': {
                        'product_table_version_id': 'product_table_version_id',
                    },
                    'location_map': {
                        'product_table_version_id': 'path',
                        'product_table_version': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_product_table_version
            )

    create_hypothetical_license_details_query = None 
    create_license = None 
    create_product_table_version = None 
    delete_license = None 
    delete_product_table_version = None 
    get_license = None 
    get_product_table_version = None 
    list_license_details = None 
    list_license_evaluation_contexts = None 
    list_licenses = None 
    list_product_table_versions = None 
    replace_license = None 
    replace_product_table_version = None 
