"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_elevated_user_roles import ListElevatedUserRoles
from agilicus_api.model.list_resource_permissions_response import ListResourcePermissionsResponse
from agilicus_api.model.list_resource_roles_response import ListResourceRolesResponse
from agilicus_api.model.replace_user_role_request import ReplaceUserRoleRequest
from agilicus_api.model.resource_permission import ResourcePermission
from agilicus_api.model.resource_role import ResourceRole
from agilicus_api.model.resource_type_enum import ResourceTypeEnum
from agilicus_api.model.user_roles import UserRoles


class PermissionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bulk_delete_resource_permission(
            self,
            **kwargs
        ):
            """Delete a set of resource permissions matching the resource id  # noqa: E501

            Delete a set of resource permissions matching the resource  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_delete_resource_permission(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.bulk_delete_resource_permission is None:
            self.bulk_delete_resource_permission = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions',
                    'operation_id': 'bulk_delete_resource_permission',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'resource_id',
                        'resource_type',
                        'user_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'resource_id':
                            (str,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'resource_id': 'resource_id',
                        'resource_type': 'resource_type',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'resource_id': 'query',
                        'resource_type': 'query',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__bulk_delete_resource_permission
            )

        def __create_resource_permission(
            self,
            resource_permission,
            **kwargs
        ):
            """Create a ResourcePermission  # noqa: E501

            Create a ResourcePermission  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_resource_permission(resource_permission, async_req=True)
            >>> result = thread.get()

            Args:
                resource_permission (ResourcePermission):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourcePermission
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_permission'] = \
                resource_permission
            return self.call_with_http_info(**kwargs)

        if self.create_resource_permission is None:
            self.create_resource_permission = _Endpoint(
                settings={
                    'response_type': (ResourcePermission,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions',
                    'operation_id': 'create_resource_permission',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_permission',
                    ],
                    'required': [
                        'resource_permission',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_permission':
                            (ResourcePermission,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'resource_permission': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_resource_permission
            )

        def __create_resource_role(
            self,
            resource_type,
            resource_role,
            **kwargs
        ):
            """Create a ResourceRole  # noqa: E501

            Create a ResourceRole  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_resource_role(resource_type, resource_role, async_req=True)
            >>> result = thread.get()

            Args:
                resource_type (str): The type of resource in the path
                resource_role (ResourceRole):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourceRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_type'] = \
                resource_type
            kwargs['resource_role'] = \
                resource_role
            return self.call_with_http_info(**kwargs)

        if self.create_resource_role is None:
            self.create_resource_role = _Endpoint(
                settings={
                    'response_type': (ResourceRole,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_type}/roles',
                    'operation_id': 'create_resource_role',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_type',
                        'resource_role',
                    ],
                    'required': [
                        'resource_type',
                        'resource_role',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'resource_type',
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                        ('resource_type',): {

                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'resource_type':
                            (str,),
                        'resource_role':
                            (ResourceRole,),
                    },
                    'attribute_map': {
                        'resource_type': 'resource_type',
                    },
                    'location_map': {
                        'resource_type': 'path',
                        'resource_role': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_resource_role
            )

        def __delete_resource_permission(
            self,
            resource_permission_id,
            **kwargs
        ):
            """Delete a ResourcePermission  # noqa: E501

            Delete a ResourcePermission  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_resource_permission(resource_permission_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_permission_id (str): A resource permission id found in the path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_permission_id'] = \
                resource_permission_id
            return self.call_with_http_info(**kwargs)

        if self.delete_resource_permission is None:
            self.delete_resource_permission = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions/{resource_permission_id}',
                    'operation_id': 'delete_resource_permission',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_permission_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_permission_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_permission_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_permission_id': 'resource_permission_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_permission_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_resource_permission
            )

        def __delete_resource_role(
            self,
            resource_type,
            role_name,
            **kwargs
        ):
            """Delete a ResourceRole  # noqa: E501

            Delete a ResourceRole  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_resource_role(resource_type, role_name, async_req=True)
            >>> result = thread.get()

            Args:
                resource_type (str): The type of resource in the path
                role_name (str): A resource role name found in the path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_type'] = \
                resource_type
            kwargs['role_name'] = \
                role_name
            return self.call_with_http_info(**kwargs)

        if self.delete_resource_role is None:
            self.delete_resource_role = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_type}/roles/{role_name}',
                    'operation_id': 'delete_resource_role',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_type',
                        'role_name',
                    ],
                    'required': [
                        'resource_type',
                        'role_name',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'resource_type',
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                        ('resource_type',): {

                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'resource_type':
                            (str,),
                        'role_name':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_type': 'resource_type',
                        'role_name': 'role_name',
                    },
                    'location_map': {
                        'resource_type': 'path',
                        'role_name': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_resource_role
            )

        def __get_elevated_user_roles(
            self,
            user_id,
            **kwargs
        ):
            """Get elevated roles for a user  # noqa: E501

            Get elevated roles for a user  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_elevated_user_roles(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UserRoles
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.get_elevated_user_roles is None:
            self.get_elevated_user_roles = _Endpoint(
                settings={
                    'response_type': (UserRoles,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/elevated_permissions/{user_id}',
                    'operation_id': 'get_elevated_user_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_elevated_user_roles
            )

        def __get_resource_permission(
            self,
            resource_permission_id,
            **kwargs
        ):
            """Get a ResourcePermission  # noqa: E501

            Get a ResourcePermission  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_resource_permission(resource_permission_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_permission_id (str): A resource permission id found in the path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourcePermission
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_permission_id'] = \
                resource_permission_id
            return self.call_with_http_info(**kwargs)

        if self.get_resource_permission is None:
            self.get_resource_permission = _Endpoint(
                settings={
                    'response_type': (ResourcePermission,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions/{resource_permission_id}',
                    'operation_id': 'get_resource_permission',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_permission_id',
                        'org_id',
                    ],
                    'required': [
                        'resource_permission_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_permission_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_permission_id': 'resource_permission_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'resource_permission_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_resource_permission
            )

        def __get_resource_role(
            self,
            resource_type,
            role_name,
            **kwargs
        ):
            """Get a ResourceRole  # noqa: E501

            Get a ResourceRole  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_resource_role(resource_type, role_name, async_req=True)
            >>> result = thread.get()

            Args:
                resource_type (str): The type of resource in the path
                role_name (str): A resource role name found in the path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourceRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_type'] = \
                resource_type
            kwargs['role_name'] = \
                role_name
            return self.call_with_http_info(**kwargs)

        if self.get_resource_role is None:
            self.get_resource_role = _Endpoint(
                settings={
                    'response_type': (ResourceRole,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_type}/roles/{role_name}',
                    'operation_id': 'get_resource_role',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_type',
                        'role_name',
                    ],
                    'required': [
                        'resource_type',
                        'role_name',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'resource_type',
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                        ('resource_type',): {

                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'resource_type':
                            (str,),
                        'role_name':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_type': 'resource_type',
                        'role_name': 'role_name',
                    },
                    'location_map': {
                        'resource_type': 'path',
                        'role_name': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_resource_role
            )

        def __list_elevated_user_roles(
            self,
            **kwargs
        ):
            """List all elevated users and their roles  # noqa: E501

            List all elevated users and their roles  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_elevated_user_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListElevatedUserRoles
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_elevated_user_roles is None:
            self.list_elevated_user_roles = _Endpoint(
                settings={
                    'response_type': (ListElevatedUserRoles,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/elevated_permissions',
                    'operation_id': 'list_elevated_user_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_elevated_user_roles
            )

        def __list_resource_permissions(
            self,
            **kwargs
        ):
            """List all ResourcePermissions  # noqa: E501

            List all ResourcePermissions  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resource_permissions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                resource_role_name (str): The name of the role to query for. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResourcePermissionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_resource_permissions is None:
            self.list_resource_permissions = _Endpoint(
                settings={
                    'response_type': (ListResourcePermissionsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions',
                    'operation_id': 'list_resource_permissions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                        'resource_type',
                        'resource_role_name',
                        'resource_id',
                        'page_at_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'resource_role_name':
                            (str,),
                        'resource_id':
                            (str,),
                        'page_at_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'resource_type': 'resource_type',
                        'resource_role_name': 'resource_role_name',
                        'resource_id': 'resource_id',
                        'page_at_id': 'page_at_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                        'resource_type': 'query',
                        'resource_role_name': 'query',
                        'resource_id': 'query',
                        'page_at_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resource_permissions
            )

        def __list_resource_roles(
            self,
            **kwargs
        ):
            """List all ResourceRoles  # noqa: E501

            List all ResourceRoles  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resource_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                resource_role_name (str): The name of the role to query for. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResourceRolesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_resource_roles is None:
            self.list_resource_roles = _Endpoint(
                settings={
                    'response_type': (ListResourceRolesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_roles',
                    'operation_id': 'list_resource_roles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'resource_type',
                        'resource_role_name',
                        'limit',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'resource_role_name':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'resource_type': 'resource_type',
                        'resource_role_name': 'resource_role_name',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'resource_type': 'query',
                        'resource_role_name': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resource_roles
            )

        def __list_resource_roles_for_type(
            self,
            resource_type,
            **kwargs
        ):
            """List all ResourceRoles  # noqa: E501

            List all ResourceRoles for a given resource type.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_resource_roles_for_type(resource_type, async_req=True)
            >>> result = thread.get()

            Args:
                resource_type (str): The type of resource in the path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                resource_role_name (str): The name of the role to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResourceRolesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_type'] = \
                resource_type
            return self.call_with_http_info(**kwargs)

        if self.list_resource_roles_for_type is None:
            self.list_resource_roles_for_type = _Endpoint(
                settings={
                    'response_type': (ListResourceRolesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_type}/roles',
                    'operation_id': 'list_resource_roles_for_type',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_type',
                        'limit',
                        'resource_role_name',
                    ],
                    'required': [
                        'resource_type',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'resource_type',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('resource_type',): {

                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'resource_type':
                            (str,),
                        'limit':
                            (int,),
                        'resource_role_name':
                            (str,),
                    },
                    'attribute_map': {
                        'resource_type': 'resource_type',
                        'limit': 'limit',
                        'resource_role_name': 'resource_role_name',
                    },
                    'location_map': {
                        'resource_type': 'path',
                        'limit': 'query',
                        'resource_role_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_resource_roles_for_type
            )

        def __replace_elevated_user_role(
            self,
            user_id,
            **kwargs
        ):
            """Create or update an elevated user role  # noqa: E501

            Create or update an elevated user role  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_elevated_user_role(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                replace_user_role_request (ReplaceUserRoleRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.replace_elevated_user_role is None:
            self.replace_elevated_user_role = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/elevated_permissions/{user_id}',
                    'operation_id': 'replace_elevated_user_role',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'replace_user_role_request',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'replace_user_role_request':
                            (ReplaceUserRoleRequest,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'replace_user_role_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_elevated_user_role
            )

        def __replace_resource_permission(
            self,
            resource_permission_id,
            **kwargs
        ):
            """Update a ResourcePermission  # noqa: E501

            Update a ResourcePermission  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_resource_permission(resource_permission_id, async_req=True)
            >>> result = thread.get()

            Args:
                resource_permission_id (str): A resource permission id found in the path

            Keyword Args:
                resource_permission (ResourcePermission): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourcePermission
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_permission_id'] = \
                resource_permission_id
            return self.call_with_http_info(**kwargs)

        if self.replace_resource_permission is None:
            self.replace_resource_permission = _Endpoint(
                settings={
                    'response_type': (ResourcePermission,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resource_permissions/{resource_permission_id}',
                    'operation_id': 'replace_resource_permission',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_permission_id',
                        'resource_permission',
                    ],
                    'required': [
                        'resource_permission_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'resource_permission_id':
                            (str,),
                        'resource_permission':
                            (ResourcePermission,),
                    },
                    'attribute_map': {
                        'resource_permission_id': 'resource_permission_id',
                    },
                    'location_map': {
                        'resource_permission_id': 'path',
                        'resource_permission': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_resource_permission
            )

        def __replace_resource_role(
            self,
            resource_type,
            role_name,
            **kwargs
        ):
            """Update a ResourceRole  # noqa: E501

            Update a ResourceRole  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_resource_role(resource_type, role_name, async_req=True)
            >>> result = thread.get()

            Args:
                resource_type (str): The type of resource in the path
                role_name (str): A resource role name found in the path

            Keyword Args:
                resource_role (ResourceRole): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResourceRole
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['resource_type'] = \
                resource_type
            kwargs['role_name'] = \
                role_name
            return self.call_with_http_info(**kwargs)

        if self.replace_resource_role is None:
            self.replace_resource_role = _Endpoint(
                settings={
                    'response_type': (ResourceRole,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/resources/{resource_type}/roles/{role_name}',
                    'operation_id': 'replace_resource_role',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'resource_type',
                        'role_name',
                        'resource_role',
                    ],
                    'required': [
                        'resource_type',
                        'role_name',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                        'resource_type',
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                        ('resource_type',): {

                            "FILESHARE": "fileshare",
                            "APPLICATION_SERVICE": "application_service",
                            "DESKTOP": "desktop",
                            "SSH": "ssh",
                            "DATABASE": "database"
                        },
                    },
                    'openapi_types': {
                        'resource_type':
                            (str,),
                        'role_name':
                            (str,),
                        'resource_role':
                            (ResourceRole,),
                    },
                    'attribute_map': {
                        'resource_type': 'resource_type',
                        'role_name': 'role_name',
                    },
                    'location_map': {
                        'resource_type': 'path',
                        'role_name': 'path',
                        'resource_role': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_resource_role
            )

    bulk_delete_resource_permission = None 
    create_resource_permission = None 
    create_resource_role = None 
    delete_resource_permission = None 
    delete_resource_role = None 
    get_elevated_user_roles = None 
    get_resource_permission = None 
    get_resource_role = None 
    list_elevated_user_roles = None 
    list_resource_permissions = None 
    list_resource_roles = None 
    list_resource_roles_for_type = None 
    replace_elevated_user_role = None 
    replace_resource_permission = None 
    replace_resource_role = None 
