"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.emptiable_object_type import EmptiableObjectType
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_standalone_rule_policies_response import ListStandaloneRulePoliciesResponse
from agilicus_api.model.list_standalone_rule_trees_response import ListStandaloneRuleTreesResponse
from agilicus_api.model.list_standalone_rules_response import ListStandaloneRulesResponse
from agilicus_api.model.list_standalone_ruleset_bundles_response import ListStandaloneRulesetBundlesResponse
from agilicus_api.model.list_standalone_ruleset_labels_response import ListStandaloneRulesetLabelsResponse
from agilicus_api.model.list_standalone_rulesets_response import ListStandaloneRulesetsResponse
from agilicus_api.model.standalone_rule import StandaloneRule
from agilicus_api.model.standalone_rule_policy import StandaloneRulePolicy
from agilicus_api.model.standalone_rule_tree import StandaloneRuleTree
from agilicus_api.model.standalone_rules_cleanup import StandaloneRulesCleanup
from agilicus_api.model.standalone_ruleset import StandaloneRuleset
from agilicus_api.model.standalone_ruleset_bundle import StandaloneRulesetBundle
from agilicus_api.model.standalone_ruleset_label import StandaloneRulesetLabel
from agilicus_api.model.trusted_certificate_label_name import TrustedCertificateLabelName


class RulesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __cleanup_standalone_rules(
            self,
            **kwargs
        ):
            """cleanup of standalone rules  # noqa: E501

            deletion of all standalone rules/sets/labels/bundles that are associated with object_type,object_id and label   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cleanup_standalone_rules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                standalone_rules_cleanup (StandaloneRulesCleanup): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesCleanup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.cleanup_standalone_rules is None:
            self.cleanup_standalone_rules = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesCleanup,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules/cleanup',
                    'operation_id': 'cleanup_standalone_rules',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rules_cleanup',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rules_cleanup':
                            (StandaloneRulesCleanup,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_rules_cleanup': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__cleanup_standalone_rules
            )

        def __create_ruleset_label(
            self,
            standalone_ruleset_label,
            **kwargs
        ):
            """Creates a StandaloneRulesetLabel  # noqa: E501

            Creates a StandaloneRulesetLabel   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_ruleset_label(standalone_ruleset_label, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_label (StandaloneRulesetLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesetLabel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_label'] = \
                standalone_ruleset_label
            return self.call_with_http_info(**kwargs)

        if self.create_ruleset_label is None:
            self.create_ruleset_label = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesetLabel,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_labels',
                    'operation_id': 'create_ruleset_label',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_label',
                    ],
                    'required': [
                        'standalone_ruleset_label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_label':
                            (StandaloneRulesetLabel,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_ruleset_label': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_ruleset_label
            )

        def __create_standalone_rule(
            self,
            standalone_rule,
            **kwargs
        ):
            """Add a standalone rule  # noqa: E501

            Adds a new standalone rule. Rules must have unique names within an org. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_standalone_rule(standalone_rule, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule (StandaloneRule):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule'] = \
                standalone_rule
            return self.call_with_http_info(**kwargs)

        if self.create_standalone_rule is None:
            self.create_standalone_rule = _Endpoint(
                settings={
                    'response_type': (StandaloneRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules',
                    'operation_id': 'create_standalone_rule',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule',
                    ],
                    'required': [
                        'standalone_rule',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule':
                            (StandaloneRule,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_rule': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_standalone_rule
            )

        def __create_standalone_rule_policy(
            self,
            standalone_rule_policy,
            **kwargs
        ):
            """Add a standalone rule policy  # noqa: E501

            Adds a new standalone rule policy. Policies must have a unique (object_type, object_id, policy_class, policy_name) is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_standalone_rule_policy(standalone_rule_policy, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_policy (StandaloneRulePolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_policy'] = \
                standalone_rule_policy
            return self.call_with_http_info(**kwargs)

        if self.create_standalone_rule_policy is None:
            self.create_standalone_rule_policy = _Endpoint(
                settings={
                    'response_type': (StandaloneRulePolicy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_policies',
                    'operation_id': 'create_standalone_rule_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_policy',
                    ],
                    'required': [
                        'standalone_rule_policy',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_policy':
                            (StandaloneRulePolicy,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_rule_policy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_standalone_rule_policy
            )

        def __create_standalone_rule_tree(
            self,
            standalone_rule_tree,
            **kwargs
        ):
            """Add a standalone rule tree  # noqa: E501

            Adds a new standalone rule tree. Rule trees must have unique names within an org. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_standalone_rule_tree(standalone_rule_tree, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_tree (StandaloneRuleTree):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleTree
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_tree'] = \
                standalone_rule_tree
            return self.call_with_http_info(**kwargs)

        if self.create_standalone_rule_tree is None:
            self.create_standalone_rule_tree = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleTree,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_trees',
                    'operation_id': 'create_standalone_rule_tree',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_tree',
                    ],
                    'required': [
                        'standalone_rule_tree',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_tree':
                            (StandaloneRuleTree,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_rule_tree': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_standalone_rule_tree
            )

        def __create_standalone_ruleset(
            self,
            standalone_ruleset,
            **kwargs
        ):
            """Add a standalone ruleset  # noqa: E501

            Adds a new standalone ruleset. rulesets must have unique names within an org. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_standalone_ruleset(standalone_ruleset, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset (StandaloneRuleset):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleset
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset'] = \
                standalone_ruleset
            return self.call_with_http_info(**kwargs)

        if self.create_standalone_ruleset is None:
            self.create_standalone_ruleset = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleset,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rulesets',
                    'operation_id': 'create_standalone_ruleset',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset',
                    ],
                    'required': [
                        'standalone_ruleset',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset':
                            (StandaloneRuleset,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_ruleset': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_standalone_ruleset
            )

        def __create_standalone_ruleset_bundle(
            self,
            standalone_ruleset_bundle,
            **kwargs
        ):
            """Add a standalone ruleset bundle  # noqa: E501

            Adds a new standalone ruleset bundle. rulesets must have unique names within an org. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_standalone_ruleset_bundle(standalone_ruleset_bundle, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_bundle (StandaloneRulesetBundle):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesetBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_bundle'] = \
                standalone_ruleset_bundle
            return self.call_with_http_info(**kwargs)

        if self.create_standalone_ruleset_bundle is None:
            self.create_standalone_ruleset_bundle = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesetBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_bundles',
                    'operation_id': 'create_standalone_ruleset_bundle',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_bundle',
                    ],
                    'required': [
                        'standalone_ruleset_bundle',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_bundle':
                            (StandaloneRulesetBundle,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'standalone_ruleset_bundle': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_standalone_ruleset_bundle
            )

        def __delete_ruleset_label(
            self,
            label,
            **kwargs
        ):
            """Delete a StandaloneRulesetLabel  # noqa: E501

            Delete a StandaloneRulesetLabel  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ruleset_label(label, async_req=True)
            >>> result = thread.get()

            Args:
                label (TrustedCertificateLabelName): A TrustedCertificateLabelName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label'] = \
                label
            return self.call_with_http_info(**kwargs)

        if self.delete_ruleset_label is None:
            self.delete_ruleset_label = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_labels/{label}',
                    'operation_id': 'delete_ruleset_label',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label',
                        'org_id',
                    ],
                    'required': [
                        'label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label':
                            (TrustedCertificateLabelName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label': 'label',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_ruleset_label
            )

        def __delete_standalone_rule(
            self,
            rule_id,
            **kwargs
        ):
            """Delete a standalone rule  # noqa: E501

            Delete a standalone rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_standalone_rule(rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                rule_id (str): The id of a rule

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.delete_standalone_rule is None:
            self.delete_standalone_rule = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules/{rule_id}',
                    'operation_id': 'delete_standalone_rule',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'rule_id',
                        'org_id',
                    ],
                    'required': [
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'rule_id': 'rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_standalone_rule
            )

        def __delete_standalone_rule_policy(
            self,
            standalone_rule_policy_id,
            **kwargs
        ):
            """Delete a standalone rule policy  # noqa: E501

            Delete a standalone rule policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_standalone_rule_policy(standalone_rule_policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_policy_id (str): The id of a standalone rule policy

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_policy_id'] = \
                standalone_rule_policy_id
            return self.call_with_http_info(**kwargs)

        if self.delete_standalone_rule_policy is None:
            self.delete_standalone_rule_policy = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_policies/{standalone_rule_policy_id}',
                    'operation_id': 'delete_standalone_rule_policy',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_policy_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_rule_policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_policy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_rule_policy_id': 'standalone_rule_policy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_rule_policy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_standalone_rule_policy
            )

        def __delete_standalone_rule_tree(
            self,
            standalone_rule_tree_id,
            **kwargs
        ):
            """Delete a standalone rule tree  # noqa: E501

            Delete a standalone rule tree  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_standalone_rule_tree(standalone_rule_tree_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_tree_id (str): The id of a rule tree

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_tree_id'] = \
                standalone_rule_tree_id
            return self.call_with_http_info(**kwargs)

        if self.delete_standalone_rule_tree is None:
            self.delete_standalone_rule_tree = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_trees/{standalone_rule_tree_id}',
                    'operation_id': 'delete_standalone_rule_tree',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_tree_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_rule_tree_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_tree_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_rule_tree_id': 'standalone_rule_tree_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_rule_tree_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_standalone_rule_tree
            )

        def __delete_standalone_ruleset(
            self,
            standalone_ruleset_id,
            **kwargs
        ):
            """Delete a standalone ruleset  # noqa: E501

            Delete a standalone ruleset  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_standalone_ruleset(standalone_ruleset_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_id (str): The id of a ruleset

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_id'] = \
                standalone_ruleset_id
            return self.call_with_http_info(**kwargs)

        if self.delete_standalone_ruleset is None:
            self.delete_standalone_ruleset = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rulesets/{standalone_ruleset_id}',
                    'operation_id': 'delete_standalone_ruleset',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_ruleset_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_id': 'standalone_ruleset_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_ruleset_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_standalone_ruleset
            )

        def __delete_standalone_ruleset_bundle(
            self,
            standalone_ruleset_bundle_id,
            **kwargs
        ):
            """Delete a standalone ruleset_bundle  # noqa: E501

            Delete a standalone ruleset_bundle  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_standalone_ruleset_bundle(standalone_ruleset_bundle_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_bundle_id (str): The id of a ruleset

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_bundle_id'] = \
                standalone_ruleset_bundle_id
            return self.call_with_http_info(**kwargs)

        if self.delete_standalone_ruleset_bundle is None:
            self.delete_standalone_ruleset_bundle = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_bundles/{standalone_ruleset_bundle_id}',
                    'operation_id': 'delete_standalone_ruleset_bundle',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_bundle_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_ruleset_bundle_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_bundle_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_bundle_id': 'standalone_ruleset_bundle_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_ruleset_bundle_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_standalone_ruleset_bundle
            )

        def __get_ruleset_label(
            self,
            label,
            **kwargs
        ):
            """Get a StandaloneRulesetLabel  # noqa: E501

            Get a StandaloneRulesetLabel  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ruleset_label(label, async_req=True)
            >>> result = thread.get()

            Args:
                label (TrustedCertificateLabelName): A TrustedCertificateLabelName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesetLabel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label'] = \
                label
            return self.call_with_http_info(**kwargs)

        if self.get_ruleset_label is None:
            self.get_ruleset_label = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesetLabel,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_labels/{label}',
                    'operation_id': 'get_ruleset_label',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label',
                        'org_id',
                    ],
                    'required': [
                        'label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label':
                            (TrustedCertificateLabelName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label': 'label',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_ruleset_label
            )

        def __get_standalone_rule(
            self,
            rule_id,
            **kwargs
        ):
            """Get a standalone rule  # noqa: E501

            Get a standalone rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_standalone_rule(rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                rule_id (str): The id of a rule

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.get_standalone_rule is None:
            self.get_standalone_rule = _Endpoint(
                settings={
                    'response_type': (StandaloneRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules/{rule_id}',
                    'operation_id': 'get_standalone_rule',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'rule_id',
                        'org_id',
                    ],
                    'required': [
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'rule_id': 'rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_standalone_rule
            )

        def __get_standalone_rule_policy(
            self,
            standalone_rule_policy_id,
            **kwargs
        ):
            """Get a standalone rule policy  # noqa: E501

            Get a standalone rule policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_standalone_rule_policy(standalone_rule_policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_policy_id (str): The id of a standalone rule policy

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_policy_id'] = \
                standalone_rule_policy_id
            return self.call_with_http_info(**kwargs)

        if self.get_standalone_rule_policy is None:
            self.get_standalone_rule_policy = _Endpoint(
                settings={
                    'response_type': (StandaloneRulePolicy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_policies/{standalone_rule_policy_id}',
                    'operation_id': 'get_standalone_rule_policy',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_policy_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_rule_policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_policy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_rule_policy_id': 'standalone_rule_policy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_rule_policy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_standalone_rule_policy
            )

        def __get_standalone_rule_tree(
            self,
            standalone_rule_tree_id,
            **kwargs
        ):
            """Get a standalone rule tree  # noqa: E501

            Get a standalone rule tree  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_standalone_rule_tree(standalone_rule_tree_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_tree_id (str): The id of a rule tree

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleTree
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_tree_id'] = \
                standalone_rule_tree_id
            return self.call_with_http_info(**kwargs)

        if self.get_standalone_rule_tree is None:
            self.get_standalone_rule_tree = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleTree,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_trees/{standalone_rule_tree_id}',
                    'operation_id': 'get_standalone_rule_tree',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_tree_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_rule_tree_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_tree_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_rule_tree_id': 'standalone_rule_tree_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_rule_tree_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_standalone_rule_tree
            )

        def __get_standalone_ruleset(
            self,
            standalone_ruleset_id,
            **kwargs
        ):
            """Get a standalone ruleset  # noqa: E501

            Get a standalone ruleset  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_standalone_ruleset(standalone_ruleset_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_id (str): The id of a ruleset

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleset
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_id'] = \
                standalone_ruleset_id
            return self.call_with_http_info(**kwargs)

        if self.get_standalone_ruleset is None:
            self.get_standalone_ruleset = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleset,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rulesets/{standalone_ruleset_id}',
                    'operation_id': 'get_standalone_ruleset',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_id',
                        'org_id',
                    ],
                    'required': [
                        'standalone_ruleset_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_id': 'standalone_ruleset_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'standalone_ruleset_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_standalone_ruleset
            )

        def __get_standalone_ruleset_bundle(
            self,
            standalone_ruleset_bundle_id,
            **kwargs
        ):
            """Get a standalone ruleset bundle  # noqa: E501

            Get a standalone ruleset bundle  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_standalone_ruleset_bundle(standalone_ruleset_bundle_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_bundle_id (str): The id of a ruleset

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                get_rulesets (bool): When querying a bundle, return all rulesets associated with bundle . [optional]
                standalone_rulesets_etag (str): The entity tag (etag) for a requested bundle. If the returned etag matches the requested etag, then no data is returned, along with status code 304. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesetBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_bundle_id'] = \
                standalone_ruleset_bundle_id
            return self.call_with_http_info(**kwargs)

        if self.get_standalone_ruleset_bundle is None:
            self.get_standalone_ruleset_bundle = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesetBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_bundles/{standalone_ruleset_bundle_id}',
                    'operation_id': 'get_standalone_ruleset_bundle',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_bundle_id',
                        'org_id',
                        'get_rulesets',
                        'standalone_rulesets_etag',
                    ],
                    'required': [
                        'standalone_ruleset_bundle_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_bundle_id':
                            (str,),
                        'org_id':
                            (str,),
                        'get_rulesets':
                            (bool,),
                        'standalone_rulesets_etag':
                            (str,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_bundle_id': 'standalone_ruleset_bundle_id',
                        'org_id': 'org_id',
                        'get_rulesets': 'get_rulesets',
                        'standalone_rulesets_etag': 'standalone_rulesets_etag',
                    },
                    'location_map': {
                        'standalone_ruleset_bundle_id': 'path',
                        'org_id': 'query',
                        'get_rulesets': 'query',
                        'standalone_rulesets_etag': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_standalone_ruleset_bundle
            )

        def __list_ruleset_labels(
            self,
            **kwargs
        ):
            """list StandaloneRulesetLabel  # noqa: E501

            List StandaloneRulesetLabel   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ruleset_labels(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRulesetLabelsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_ruleset_labels is None:
            self.list_ruleset_labels = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRulesetLabelsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_labels',
                    'operation_id': 'list_ruleset_labels',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'label',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'label':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'label': 'label',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'label': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_ruleset_labels
            )

        def __list_standalone_rule_policies(
            self,
            **kwargs
        ):
            """List all standalone rule policies  # noqa: E501

            List all standalone rule policies matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_standalone_rule_policies(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                object_type (EmptiableObjectType): An object type. [optional]
                object_types ([EmptiableObjectType]): A list of object types. Returns all items which match at least one of the types. . [optional]
                object_id (str, none_type): search by object id. [optional]
                policy_class (str, none_type): search by policy class. [optional]
                policy_classes ([str]): A list of policy classes. Returns all items which match at least one of the . . [optional]
                policy_instance (str): Query the policies by instance. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRulePoliciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_standalone_rule_policies is None:
            self.list_standalone_rule_policies = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRulePoliciesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_policies',
                    'operation_id': 'list_standalone_rule_policies',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'object_type',
                        'object_types',
                        'object_id',
                        'policy_class',
                        'policy_classes',
                        'policy_instance',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                        'object_id',
                        'policy_class',
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'object_type':
                            (EmptiableObjectType,),
                        'object_types':
                            ([EmptiableObjectType],),
                        'object_id':
                            (str, none_type,),
                        'policy_class':
                            (str, none_type,),
                        'policy_classes':
                            ([str],),
                        'policy_instance':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'object_type': 'object_type',
                        'object_types': 'object_types',
                        'object_id': 'object_id',
                        'policy_class': 'policy_class',
                        'policy_classes': 'policy_classes',
                        'policy_instance': 'policy_instance',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'object_type': 'query',
                        'object_types': 'query',
                        'object_id': 'query',
                        'policy_class': 'query',
                        'policy_classes': 'query',
                        'policy_instance': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'object_types': 'multi',
                        'policy_classes': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_standalone_rule_policies
            )

        def __list_standalone_rule_trees(
            self,
            **kwargs
        ):
            """List all standalone rule trees  # noqa: E501

            List all standalone rule tres matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning. Searching for rule_id will return any tree that references that rule.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_standalone_rule_trees(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                rule_tree_id (str): The id of a rule tree. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                standalone_rule_policy_ids ([str]): A list of standalone rule policy ids. Any objects matching one of these will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRuleTreesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_standalone_rule_trees is None:
            self.list_standalone_rule_trees = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRuleTreesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_trees',
                    'operation_id': 'list_standalone_rule_trees',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'page_at_id',
                        'rule_tree_id',
                        'org_id',
                        'standalone_rule_policy_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'page_at_id':
                            (str,),
                        'rule_tree_id':
                            (str,),
                        'org_id':
                            (str,),
                        'standalone_rule_policy_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'page_at_id': 'page_at_id',
                        'rule_tree_id': 'rule_tree_id',
                        'org_id': 'org_id',
                        'standalone_rule_policy_ids': 'standalone_rule_policy_ids',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'page_at_id': 'query',
                        'rule_tree_id': 'query',
                        'org_id': 'query',
                        'standalone_rule_policy_ids': 'query',
                    },
                    'collection_format_map': {
                        'standalone_rule_policy_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_standalone_rule_trees
            )

        def __list_standalone_rules(
            self,
            **kwargs
        ):
            """List all standalone rules  # noqa: E501

            List all standalone rule matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_standalone_rules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                rule_id (str): The id of a rule. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                standalone_rule_policy_ids ([str]): A list of standalone rule policy ids. Any objects matching one of these will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRulesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_standalone_rules is None:
            self.list_standalone_rules = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRulesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules',
                    'operation_id': 'list_standalone_rules',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'page_at_id',
                        'rule_id',
                        'org_id',
                        'standalone_rule_policy_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'page_at_id':
                            (str,),
                        'rule_id':
                            (str,),
                        'org_id':
                            (str,),
                        'standalone_rule_policy_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'page_at_id': 'page_at_id',
                        'rule_id': 'rule_id',
                        'org_id': 'org_id',
                        'standalone_rule_policy_ids': 'standalone_rule_policy_ids',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'page_at_id': 'query',
                        'rule_id': 'query',
                        'org_id': 'query',
                        'standalone_rule_policy_ids': 'query',
                    },
                    'collection_format_map': {
                        'standalone_rule_policy_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_standalone_rules
            )

        def __list_standalone_ruleset_bundles(
            self,
            **kwargs
        ):
            """List all standalone ruleset bundles  # noqa: E501

            List all standalone ruleset bundles matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_standalone_ruleset_bundles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                get_rulesets (bool): When querying a bundle, return all rulesets associated with bundle . [optional]
                standalone_ruleset_bundles_etag (str): The entity tag (etag) for a list of bundles. If the returned etag matches the requested etag, then no data is returned, along with status code 304. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRulesetBundlesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_standalone_ruleset_bundles is None:
            self.list_standalone_ruleset_bundles = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRulesetBundlesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_bundles',
                    'operation_id': 'list_standalone_ruleset_bundles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'page_at_id',
                        'org_id',
                        'label',
                        'get_rulesets',
                        'standalone_ruleset_bundles_etag',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                        'label':
                            (str,),
                        'get_rulesets':
                            (bool,),
                        'standalone_ruleset_bundles_etag':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                        'label': 'label',
                        'get_rulesets': 'get_rulesets',
                        'standalone_ruleset_bundles_etag': 'standalone_ruleset_bundles_etag',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                        'label': 'query',
                        'get_rulesets': 'query',
                        'standalone_ruleset_bundles_etag': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_standalone_ruleset_bundles
            )

        def __list_standalone_rulesets(
            self,
            **kwargs
        ):
            """List all standalone rulesets  # noqa: E501

            List all standalone rulesets matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_standalone_rulesets(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                standalone_rule_policy_ids ([str]): A list of standalone rule policy ids. Any objects matching one of these will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListStandaloneRulesetsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_standalone_rulesets is None:
            self.list_standalone_rulesets = _Endpoint(
                settings={
                    'response_type': (ListStandaloneRulesetsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rulesets',
                    'operation_id': 'list_standalone_rulesets',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'page_at_id',
                        'org_id',
                        'label',
                        'standalone_rule_policy_ids',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                        'label':
                            (str,),
                        'standalone_rule_policy_ids':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                        'label': 'label',
                        'standalone_rule_policy_ids': 'standalone_rule_policy_ids',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                        'label': 'query',
                        'standalone_rule_policy_ids': 'query',
                    },
                    'collection_format_map': {
                        'standalone_rule_policy_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_standalone_rulesets
            )

        def __replace_standalone_rule(
            self,
            rule_id,
            **kwargs
        ):
            """update a standalone rule  # noqa: E501

            update a standalone rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_standalone_rule(rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                rule_id (str): The id of a rule

            Keyword Args:
                standalone_rule (StandaloneRule): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['rule_id'] = \
                rule_id
            return self.call_with_http_info(**kwargs)

        if self.replace_standalone_rule is None:
            self.replace_standalone_rule = _Endpoint(
                settings={
                    'response_type': (StandaloneRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rules/{rule_id}',
                    'operation_id': 'replace_standalone_rule',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'rule_id',
                        'standalone_rule',
                    ],
                    'required': [
                        'rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'rule_id':
                            (str,),
                        'standalone_rule':
                            (StandaloneRule,),
                    },
                    'attribute_map': {
                        'rule_id': 'rule_id',
                    },
                    'location_map': {
                        'rule_id': 'path',
                        'standalone_rule': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_standalone_rule
            )

        def __replace_standalone_rule_policy(
            self,
            standalone_rule_policy_id,
            **kwargs
        ):
            """update a standalone rule policy  # noqa: E501

            update a standalone rule policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_standalone_rule_policy(standalone_rule_policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_policy_id (str): The id of a standalone rule policy

            Keyword Args:
                standalone_rule_policy (StandaloneRulePolicy): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_policy_id'] = \
                standalone_rule_policy_id
            return self.call_with_http_info(**kwargs)

        if self.replace_standalone_rule_policy is None:
            self.replace_standalone_rule_policy = _Endpoint(
                settings={
                    'response_type': (StandaloneRulePolicy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_policies/{standalone_rule_policy_id}',
                    'operation_id': 'replace_standalone_rule_policy',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_policy_id',
                        'standalone_rule_policy',
                    ],
                    'required': [
                        'standalone_rule_policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_policy_id':
                            (str,),
                        'standalone_rule_policy':
                            (StandaloneRulePolicy,),
                    },
                    'attribute_map': {
                        'standalone_rule_policy_id': 'standalone_rule_policy_id',
                    },
                    'location_map': {
                        'standalone_rule_policy_id': 'path',
                        'standalone_rule_policy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_standalone_rule_policy
            )

        def __replace_standalone_rule_tree(
            self,
            standalone_rule_tree_id,
            **kwargs
        ):
            """update a standalone rule tree  # noqa: E501

            update a standalone rule tree  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_standalone_rule_tree(standalone_rule_tree_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_rule_tree_id (str): The id of a rule tree

            Keyword Args:
                standalone_rule_tree (StandaloneRuleTree): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleTree
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_rule_tree_id'] = \
                standalone_rule_tree_id
            return self.call_with_http_info(**kwargs)

        if self.replace_standalone_rule_tree is None:
            self.replace_standalone_rule_tree = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleTree,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rule_trees/{standalone_rule_tree_id}',
                    'operation_id': 'replace_standalone_rule_tree',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_rule_tree_id',
                        'standalone_rule_tree',
                    ],
                    'required': [
                        'standalone_rule_tree_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_rule_tree_id':
                            (str,),
                        'standalone_rule_tree':
                            (StandaloneRuleTree,),
                    },
                    'attribute_map': {
                        'standalone_rule_tree_id': 'standalone_rule_tree_id',
                    },
                    'location_map': {
                        'standalone_rule_tree_id': 'path',
                        'standalone_rule_tree': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_standalone_rule_tree
            )

        def __replace_standalone_ruleset(
            self,
            standalone_ruleset_id,
            **kwargs
        ):
            """update a standalone ruleset  # noqa: E501

            update a standalone ruleset  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_standalone_ruleset(standalone_ruleset_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_id (str): The id of a ruleset

            Keyword Args:
                standalone_ruleset (StandaloneRuleset): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRuleset
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_id'] = \
                standalone_ruleset_id
            return self.call_with_http_info(**kwargs)

        if self.replace_standalone_ruleset is None:
            self.replace_standalone_ruleset = _Endpoint(
                settings={
                    'response_type': (StandaloneRuleset,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_rulesets/{standalone_ruleset_id}',
                    'operation_id': 'replace_standalone_ruleset',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_id',
                        'standalone_ruleset',
                    ],
                    'required': [
                        'standalone_ruleset_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_id':
                            (str,),
                        'standalone_ruleset':
                            (StandaloneRuleset,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_id': 'standalone_ruleset_id',
                    },
                    'location_map': {
                        'standalone_ruleset_id': 'path',
                        'standalone_ruleset': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_standalone_ruleset
            )

        def __replace_standalone_ruleset_bundle(
            self,
            standalone_ruleset_bundle_id,
            **kwargs
        ):
            """update a standalone ruleset bundle  # noqa: E501

            update a standalone ruleset bundle  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_standalone_ruleset_bundle(standalone_ruleset_bundle_id, async_req=True)
            >>> result = thread.get()

            Args:
                standalone_ruleset_bundle_id (str): The id of a ruleset

            Keyword Args:
                standalone_ruleset_bundle (StandaloneRulesetBundle): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StandaloneRulesetBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['standalone_ruleset_bundle_id'] = \
                standalone_ruleset_bundle_id
            return self.call_with_http_info(**kwargs)

        if self.replace_standalone_ruleset_bundle is None:
            self.replace_standalone_ruleset_bundle = _Endpoint(
                settings={
                    'response_type': (StandaloneRulesetBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/standalone_ruleset_bundles/{standalone_ruleset_bundle_id}',
                    'operation_id': 'replace_standalone_ruleset_bundle',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'standalone_ruleset_bundle_id',
                        'standalone_ruleset_bundle',
                    ],
                    'required': [
                        'standalone_ruleset_bundle_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'standalone_ruleset_bundle_id':
                            (str,),
                        'standalone_ruleset_bundle':
                            (StandaloneRulesetBundle,),
                    },
                    'attribute_map': {
                        'standalone_ruleset_bundle_id': 'standalone_ruleset_bundle_id',
                    },
                    'location_map': {
                        'standalone_ruleset_bundle_id': 'path',
                        'standalone_ruleset_bundle': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_standalone_ruleset_bundle
            )

    cleanup_standalone_rules = None 
    create_ruleset_label = None 
    create_standalone_rule = None 
    create_standalone_rule_policy = None 
    create_standalone_rule_tree = None 
    create_standalone_ruleset = None 
    create_standalone_ruleset_bundle = None 
    delete_ruleset_label = None 
    delete_standalone_rule = None 
    delete_standalone_rule_policy = None 
    delete_standalone_rule_tree = None 
    delete_standalone_ruleset = None 
    delete_standalone_ruleset_bundle = None 
    get_ruleset_label = None 
    get_standalone_rule = None 
    get_standalone_rule_policy = None 
    get_standalone_rule_tree = None 
    get_standalone_ruleset = None 
    get_standalone_ruleset_bundle = None 
    list_ruleset_labels = None 
    list_standalone_rule_policies = None 
    list_standalone_rule_trees = None 
    list_standalone_rules = None 
    list_standalone_ruleset_bundles = None 
    list_standalone_rulesets = None 
    replace_standalone_rule = None 
    replace_standalone_rule_policy = None 
    replace_standalone_rule_tree = None 
    replace_standalone_ruleset = None 
    replace_standalone_ruleset_bundle = None 
