"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.agent_connector_cloud_routing import AgentConnectorCloudRouting
    from agilicus_api.model.agent_connector_connection_info import AgentConnectorConnectionInfo
    from agilicus_api.model.agent_connector_tunnel_info import AgentConnectorTunnelInfo
    from agilicus_api.model.allow_map_compiled import AllowMapCompiled
    from agilicus_api.model.certificate_revocation_proxy import CertificateRevocationProxy
    from agilicus_api.model.connector_secure_transfer import ConnectorSecureTransfer
    from agilicus_api.model.egress_gateway import EgressGateway
    from agilicus_api.model.rule_config import RuleConfig
    from agilicus_api.model.service_forwarder import ServiceForwarder
    from agilicus_api.model.stats_publishing_connector_config import StatsPublishingConnectorConfig
    globals()['AgentConnectorCloudRouting'] = AgentConnectorCloudRouting
    globals()['AgentConnectorConnectionInfo'] = AgentConnectorConnectionInfo
    globals()['AgentConnectorTunnelInfo'] = AgentConnectorTunnelInfo
    globals()['AllowMapCompiled'] = AllowMapCompiled
    globals()['CertificateRevocationProxy'] = CertificateRevocationProxy
    globals()['ConnectorSecureTransfer'] = ConnectorSecureTransfer
    globals()['EgressGateway'] = EgressGateway
    globals()['RuleConfig'] = RuleConfig
    globals()['ServiceForwarder'] = ServiceForwarder
    globals()['StatsPublishingConnectorConfig'] = StatsPublishingConnectorConfig


class AgentConnectorInfo(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('proxy_tunnel_termination',): {
            'max_length': 16,
        },
    }

    @property
    def local_authentication_enabled(self):
       return self.get("local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, new_value):
       self.local_authentication_enabled = new_value

    @property
    def connections_info(self):
       return self.get("connections_info")

    @connections_info.setter
    def connections_info(self, new_value):
       self.connections_info = new_value

    @property
    def allow_list(self):
       return self.get("allow_list")

    @allow_list.setter
    def allow_list(self, new_value):
       self.allow_list = new_value

    @property
    def extended_rule_map(self):
       return self.get("extended_rule_map")

    @extended_rule_map.setter
    def extended_rule_map(self, new_value):
       self.extended_rule_map = new_value

    @property
    def authz_public_key(self):
       return self.get("authz_public_key")

    @authz_public_key.setter
    def authz_public_key(self, new_value):
       self.authz_public_key = new_value

    @property
    def application_service_uri(self):
       return self.get("application_service_uri")

    @application_service_uri.setter
    def application_service_uri(self, new_value):
       self.application_service_uri = new_value

    @property
    def tunnel_uri(self):
       return self.get("tunnel_uri")

    @tunnel_uri.setter
    def tunnel_uri(self, new_value):
       self.tunnel_uri = new_value

    @property
    def proxy_tunnel_termination(self):
       return self.get("proxy_tunnel_termination")

    @proxy_tunnel_termination.setter
    def proxy_tunnel_termination(self, new_value):
       self.proxy_tunnel_termination = new_value

    @property
    def service_forwarders(self):
       return self.get("service_forwarders")

    @service_forwarders.setter
    def service_forwarders(self, new_value):
       self.service_forwarders = new_value

    @property
    def from_service_forwarders(self):
       return self.get("from_service_forwarders")

    @from_service_forwarders.setter
    def from_service_forwarders(self, new_value):
       self.from_service_forwarders = new_value

    @property
    def routing(self):
       return self.get("routing")

    @routing.setter
    def routing(self, new_value):
       self.routing = new_value

    @property
    def tunnel_info(self):
       return self.get("tunnel_info")

    @tunnel_info.setter
    def tunnel_info(self, new_value):
       self.tunnel_info = new_value

    @property
    def active_transfers(self):
       return self.get("active_transfers")

    @active_transfers.setter
    def active_transfers(self, new_value):
       self.active_transfers = new_value

    @property
    def stats_publishing(self):
       return self.get("stats_publishing")

    @stats_publishing.setter
    def stats_publishing(self, new_value):
       self.stats_publishing = new_value

    @property
    def revocation_proxy(self):
       return self.get("revocation_proxy")

    @revocation_proxy.setter
    def revocation_proxy(self, new_value):
       self.revocation_proxy = new_value

    @property
    def egress_gateway(self):
       return self.get("egress_gateway")

    @egress_gateway.setter
    def egress_gateway(self, new_value):
       self.egress_gateway = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'local_authentication_enabled': (bool,),  # noqa: E501
            'connections_info': ([AgentConnectorConnectionInfo],),  # noqa: E501
            'allow_list': (AllowMapCompiled,),  # noqa: E501
            'extended_rule_map': ({str: ([RuleConfig],)},),  # noqa: E501
            'authz_public_key': (str,),  # noqa: E501
            'application_service_uri': (str,),  # noqa: E501
            'tunnel_uri': (str,),  # noqa: E501
            'proxy_tunnel_termination': (str,),  # noqa: E501
            'service_forwarders': ([ServiceForwarder],),  # noqa: E501
            'from_service_forwarders': ([ServiceForwarder],),  # noqa: E501
            'routing': (AgentConnectorCloudRouting,),  # noqa: E501
            'tunnel_info': (AgentConnectorTunnelInfo,),  # noqa: E501
            'active_transfers': ([ConnectorSecureTransfer],),  # noqa: E501
            'stats_publishing': (StatsPublishingConnectorConfig,),  # noqa: E501
            'revocation_proxy': (CertificateRevocationProxy,),  # noqa: E501
            'egress_gateway': (EgressGateway,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'local_authentication_enabled': 'local_authentication_enabled',  # noqa: E501
        'connections_info': 'connections_info',  # noqa: E501
        'allow_list': 'allow_list',  # noqa: E501
        'extended_rule_map': 'extended_rule_map',  # noqa: E501
        'authz_public_key': 'authz_public_key',  # noqa: E501
        'application_service_uri': 'application_service_uri',  # noqa: E501
        'tunnel_uri': 'tunnel_uri',  # noqa: E501
        'proxy_tunnel_termination': 'proxy_tunnel_termination',  # noqa: E501
        'service_forwarders': 'service_forwarders',  # noqa: E501
        'from_service_forwarders': 'from_service_forwarders',  # noqa: E501
        'routing': 'routing',  # noqa: E501
        'tunnel_info': 'tunnel_info',  # noqa: E501
        'active_transfers': 'active_transfers',  # noqa: E501
        'stats_publishing': 'stats_publishing',  # noqa: E501
        'revocation_proxy': 'revocation_proxy',  # noqa: E501
        'egress_gateway': 'egress_gateway',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AgentConnectorInfo - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            local_authentication_enabled (bool): Determines whether or not the agent will expose an endpoint for local authentication. [optional]  # noqa: E501
            connections_info ([AgentConnectorConnectionInfo]): The list of connections associated with this agent. [optional]  # noqa: E501
            allow_list (AllowMapCompiled): [optional]  # noqa: E501
            extended_rule_map ({str: ([RuleConfig],)}): A map of hostname lookup to RuleConfig . [optional]  # noqa: E501
            authz_public_key (str): The PEM encoded public key used for validating bearer tokens. [optional]  # noqa: E501
            application_service_uri (str): The URI this connector will establish as the destination URI for service forwarder requests. An agent would request a certificate for the hostname provided as part of the URI for other connectors to establish a TLS connection to this connector. . [optional]  # noqa: E501
            tunnel_uri (str): The URI this connector uses to establish its tunnels.. [optional]  # noqa: E501
            proxy_tunnel_termination (str): How a proxy tunnel is terminated.   - tcp: terminate the tunnel at a TCP socket   - inproc: terminate the tunnel at an inprocess socket Note: if not specified, the connector will choose, likely based on its version. . [optional]  # noqa: E501
            service_forwarders ([ServiceForwarder]): The list of service forwarders associated with this connector.. [optional]  # noqa: E501
            from_service_forwarders ([ServiceForwarder]): The list of service forwarders that are forwarded to this connector.. [optional]  # noqa: E501
            routing (AgentConnectorCloudRouting): [optional]  # noqa: E501
            tunnel_info (AgentConnectorTunnelInfo): [optional]  # noqa: E501
            active_transfers ([ConnectorSecureTransfer]): secure transfers that are in progress for the connector.. [optional]  # noqa: E501
            stats_publishing (StatsPublishingConnectorConfig): [optional]  # noqa: E501
            revocation_proxy (CertificateRevocationProxy): [optional]  # noqa: E501
            egress_gateway (EgressGateway): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AgentConnectorInfo - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            local_authentication_enabled (bool): Determines whether or not the agent will expose an endpoint for local authentication. [optional]  # noqa: E501
            connections_info ([AgentConnectorConnectionInfo]): The list of connections associated with this agent. [optional]  # noqa: E501
            allow_list (AllowMapCompiled): [optional]  # noqa: E501
            extended_rule_map ({str: ([RuleConfig],)}): A map of hostname lookup to RuleConfig . [optional]  # noqa: E501
            authz_public_key (str): The PEM encoded public key used for validating bearer tokens. [optional]  # noqa: E501
            application_service_uri (str): The URI this connector will establish as the destination URI for service forwarder requests. An agent would request a certificate for the hostname provided as part of the URI for other connectors to establish a TLS connection to this connector. . [optional]  # noqa: E501
            tunnel_uri (str): The URI this connector uses to establish its tunnels.. [optional]  # noqa: E501
            proxy_tunnel_termination (str): How a proxy tunnel is terminated.   - tcp: terminate the tunnel at a TCP socket   - inproc: terminate the tunnel at an inprocess socket Note: if not specified, the connector will choose, likely based on its version. . [optional]  # noqa: E501
            service_forwarders ([ServiceForwarder]): The list of service forwarders associated with this connector.. [optional]  # noqa: E501
            from_service_forwarders ([ServiceForwarder]): The list of service forwarders that are forwarded to this connector.. [optional]  # noqa: E501
            routing (AgentConnectorCloudRouting): [optional]  # noqa: E501
            tunnel_info (AgentConnectorTunnelInfo): [optional]  # noqa: E501
            active_transfers ([ConnectorSecureTransfer]): secure transfers that are in progress for the connector.. [optional]  # noqa: E501
            stats_publishing (StatsPublishingConnectorConfig): [optional]  # noqa: E501
            revocation_proxy (CertificateRevocationProxy): [optional]  # noqa: E501
            egress_gateway (EgressGateway): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

