"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.licensing_api import LicensingApi  # noqa: E501


class TestLicensingApi(unittest.TestCase):
    """LicensingApi unit test stubs"""

    def setUp(self):
        self.api = LicensingApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_hypothetical_license_details_query(self):
        """Test case for create_hypothetical_license_details_query

        Query a hypothetical set of license details  # noqa: E501
        """
        pass

    def test_create_license(self):
        """Test case for create_license

        Create a license  # noqa: E501
        """
        pass

    def test_create_product_table_version(self):
        """Test case for create_product_table_version

        Create a product table version  # noqa: E501
        """
        pass

    def test_delete_license(self):
        """Test case for delete_license

        Delete a license  # noqa: E501
        """
        pass

    def test_delete_product_table_version(self):
        """Test case for delete_product_table_version

        Delete a product table version  # noqa: E501
        """
        pass

    def test_get_license(self):
        """Test case for get_license

        Get a single license  # noqa: E501
        """
        pass

    def test_get_product_table_version(self):
        """Test case for get_product_table_version

        Get a single product table version  # noqa: E501
        """
        pass

    def test_list_license_details(self):
        """Test case for list_license_details

        Get all license details  # noqa: E501
        """
        pass

    def test_list_license_evaluation_contexts(self):
        """Test case for list_license_evaluation_contexts

        Get license evaluation context  # noqa: E501
        """
        pass

    def test_list_licenses(self):
        """Test case for list_licenses

        Get all licenses  # noqa: E501
        """
        pass

    def test_list_product_table_versions(self):
        """Test case for list_product_table_versions

        Get all product table versions  # noqa: E501
        """
        pass

    def test_replace_license(self):
        """Test case for replace_license

        Create or update a license  # noqa: E501
        """
        pass

    def test_replace_product_table_version(self):
        """Test case for replace_product_table_version

        Create or update a product table version  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
