"""2025.5.0 champs relatifs à la config smtp

Create Date: 2025-04-02 11:51:58.297722

"""

# revision identifiers, used by Alembic.

# Revision ID:
revision = "0cf0aaec7599"

# Revises (previous revision or revisions):
down_revision = "b987d67518eb"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import add_column


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    add_column("company", sa.Column("smtp_configuration", sa.String(8)))
    add_column(
        "node_smtp_history",
        sa.Column("reply_to", sa.String(length=255), nullable=False),
    )
    add_column(
        "node_smtp_history", sa.Column("copy_to", sa.String(length=255), nullable=True)
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    conn.execute("update company set smtp_configuration='none';")
    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("company", "smtp_configuration")
    op.drop_column("node_smtp_history", "copy_to")
    op.drop_column("node_smtp_history", "reply_to")
    # ### end Alembic commands ###
