"""2025.5.0 ajout iban bic user et tiers


Create Date: 2025-04-17 09:36:19.019460

"""

# revision identifiers, used by Alembic.

# Revision ID:
revision = "f4e8e8beb2df"

# Revises (previous revision or revisions):

down_revision = "4aef2193c0e9"


from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "accounts", sa.Column("bank_account_bic", sa.String(length=12), nullable=True)
    )
    op.add_column(
        "accounts", sa.Column("bank_account_iban", sa.String(length=35), nullable=True)
    )
    op.add_column(
        "accounts",
        sa.Column("bank_account_owner", sa.String(length=100), nullable=True),
    )
    op.add_column(
        "third_party",
        sa.Column("bank_account_bic", sa.String(length=12), nullable=True),
    )
    op.add_column(
        "third_party",
        sa.Column("bank_account_iban", sa.String(length=35), nullable=True),
    )
    op.add_column(
        "third_party",
        sa.Column("bank_account_owner", sa.String(length=100), nullable=True),
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    from caerp.plugins.sap_urssaf3p.models.customer import UrssafCustomerData

    # On migre les informations depuis les données Urssaf vers la table des Tiers
    for data in session.query(UrssafCustomerData).all():
        data.customer.bank_account_owner = data.bank_account_owner
        data.customer.bank_account_iban = data.bank_account_iban
        data.customer.bank_account_bic = data.bank_account_bic
        session.merge(data.customer)

    from caerp.models.user.userdatas import BankAccountsDatas

    for data in session.query(BankAccountsDatas).all():
        data.userdatas.user.bank_account_owner = data.userdatas.user.label
        # Strip spaces, without that we may exceed column size
        data.userdatas.user.bank_account_iban = data.iban.replace(" ", "")
        data.userdatas.user.bank_account_bic = data.bic.replace(" ", "")
        session.merge(data.userdatas.user)
    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ##
    op.drop_column("third_party", "bank_account_owner")
    op.drop_column("third_party", "bank_account_iban")
    op.drop_column("third_party", "bank_account_bic")
    op.drop_column("accounts", "bank_account_owner")
    op.drop_column("accounts", "bank_account_iban")
    op.drop_column("accounts", "bank_account_bic")

    # ### end Alembic commands ###
