"""4.2.0 : Added general_customer_account, third_party_customer_account, bank_account column to company

Revision ID: 5362502b508c
Revises: 4f011ed2a459
Create Date: 2018-10-26 17:37:20.149975

"""

# revision identifiers, used by Alembic.
revision = "5362502b508c"
down_revision = "d777c5e2750"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "company", sa.Column("bank_account", sa.String(length=255), nullable=True)
    )
    op.add_column(
        "company",
        sa.Column("general_customer_account", sa.String(length=255), nullable=True),
    )
    op.add_column(
        "company",
        sa.Column("third_party_customer_account", sa.String(length=255), nullable=True),
    )
    op.add_column(
        "company", sa.Column("custom_insurance_rate", sa.Float(), nullable=True)
    )
    ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("company", "third_party_customer_account")
    op.drop_column("company", "general_customer_account")
    op.drop_column("company", "bank_account")
    op.drop_column(
        "company", sa.Column("custom_insurance_rate", sa.Float(), nullable=True)
    )
    ### end Alembic commands ###
