"""4.3 Add cascade

Revision ID: 226992705175
Revises: 3c03cea7c1b5
Create Date: 2019-03-21 14:52:45.336214

"""

# revision identifiers, used by Alembic.
revision = "226992705175"
down_revision = "3c03cea7c1b5"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "fk_income_statement_measure_id", "income_statement_measure", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_income_statement_measure_id"),
        "income_statement_measure",
        "base_accounting_measure",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_income_statement_measure_grid_id",
        "income_statement_measure_grid",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_income_statement_measure_grid_id"),
        "income_statement_measure_grid",
        "base_accounting_measure_grid",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_income_statement_measure_type_id",
        "income_statement_measure_type",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_income_statement_measure_type_id"),
        "income_statement_measure_type",
        "base_accounting_measure_type",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_income_statement_measure_type_category_id",
        "income_statement_measure_type_category",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_income_statement_measure_type_category_id"),
        "income_statement_measure_type_category",
        "base_accounting_measure_type_category",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint("fk_treasury_measure_id", "treasury_measure", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_treasury_measure_id"),
        "treasury_measure",
        "base_accounting_measure",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_treasury_measure_grid_id", "treasury_measure_grid", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_treasury_measure_grid_id"),
        "treasury_measure_grid",
        "base_accounting_measure_grid",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_treasury_measure_type_id", "treasury_measure_type", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_treasury_measure_type_id"),
        "treasury_measure_type",
        "base_accounting_measure_type",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_treasury_measure_type_category_id",
        "treasury_measure_type_category",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_treasury_measure_type_category_id"),
        "treasury_measure_type_category",
        "base_accounting_measure_type_category",
        ["id"],
        ["id"],
        ondelete="CASCADE",
    )
    ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    pass
