"""6.1.0 ajout de cascade company_data

Revision ID: d7c5e3dce471
Revises: 7a5daccd86a8
Create Date: 2021-02-08 13:28:31.302218

"""

# revision identifiers, used by Alembic.
revision = "d7c5e3dce471"
down_revision = "7a5daccd86a8"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import drop_foreign_key_if_exists


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    for key in (
        "company_activity_rel_ibfk_1",
        "company_activity_rel_ibfk_2",
        "fk_company_activity_rel_activity_id",
        "fk_company_activity_rel_company_id",
    ):
        drop_foreign_key_if_exists("company_activity_rel", key)
    op.create_foreign_key(
        op.f("fk_company_activity_rel_activity_id"),
        "company_activity_rel",
        "company_activity",
        ["activity_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.create_foreign_key(
        op.f("fk_company_activity_rel_company_id"),
        "company_activity_rel",
        "company",
        ["company_id"],
        ["id"],
        ondelete="CASCADE",
    )

    for key in (
        "company_datas_ibfk_2",
        "company_datas_ibfk_1",
        "fk_company_datas_activity_id",
        "fk_company_datas_userdatas_id",
    ):
        drop_foreign_key_if_exists("company_datas", key)
    op.create_foreign_key(
        op.f("fk_company_datas_activity_id"),
        "company_datas",
        "company_activity",
        ["activity_id"],
        ["id"],
        ondelete="SET NULL",
    )
    op.create_foreign_key(
        op.f("fk_company_datas_userdatas_id"),
        "company_datas",
        "user_datas",
        ["userdatas_id"],
        ["id"],
        ondelete="CASCADE",
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
