"""6.1.0 ajout_de_colonne_aux_enseignes

Revision ID: ba72c4430612
Revises: 8742fe30a7c0
Create Date: 2021-03-17 20:01:19.685347

"""

# revision identifiers, used by Alembic.
revision = "ba72c4430612"
down_revision = "8742fe30a7c0"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "company", sa.Column("internalcontribution", sa.Float(), nullable=True)
    )
    op.add_column(
        "company",
        sa.Column(
            "internalgeneral_customer_account", sa.String(length=255), nullable=True
        ),
    )
    op.add_column(
        "company",
        sa.Column(
            "internalgeneral_supplier_account", sa.String(length=255), nullable=True
        ),
    )
    op.add_column(
        "company",
        sa.Column(
            "internalthird_party_customer_account", sa.String(length=255), nullable=True
        ),
    )
    op.add_column(
        "company",
        sa.Column(
            "internalthird_party_supplier_account", sa.String(length=255), nullable=True
        ),
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    for col in (
        "contribution",
        "general_customer_account",
        "general_supplier_account",
        "third_party_supplier_account",
        "third_party_customer_account",
    ):
        conn.execute("update company set `internal{0}`=`{0}`".format(col))

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    from caerp.alembic.utils import column_exists

    for col in (
        "internalcontribution",
        "internalgeneral_customer_account",
        "internalgeneral_supplier_account",
        "internalthird_party_supplier_account",
        "internalthird_party_customer_account",
    ):
        if column_exists("company", col):
            op.drop_column("company", col)

    # ### end Alembic commands ###
