"""6.1.0 ajout de la colonne internal au expensetype

Revision ID: a5c2c70e6942
Revises: 6a83c2409886
Create Date: 2021-03-02 15:12:41.131618

"""

# revision identifiers, used by Alembic.
revision = "a5c2c70e6942"
down_revision = "6a83c2409886"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("expense_type", sa.Column("internal", sa.Boolean(), nullable=True))


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    op.execute("update expense_type set internal=0")
    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("expense_type", "internal")
