"""6.1.0 cascade_strategies

Revision ID: 8316776402ee
Revises: 0a7b4ce1193a
Create Date: 2021-01-21 14:15:20.485711

"""

# revision identifiers, used by Alembic.
revision = "8316776402ee"
down_revision = "0a7b4ce1193a"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic import utils


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "fk_progress_invoicing_group_status_source_task_line_group_id",
        "progress_invoicing_group_status",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_progress_invoicing_group_status_source_task_line_group_id"),
        "progress_invoicing_group_status",
        "task_line_group",
        ["source_task_line_group_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        "fk_progress_invoicing_line_status_source_task_line_id",
        "progress_invoicing_line_status",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_progress_invoicing_line_status_source_task_line_id"),
        "progress_invoicing_line_status",
        "task_line",
        ["source_task_line_id"],
        ["id"],
        ondelete="CASCADE",
    )

    op.drop_constraint("fk_trainer_datas_user_id", "trainer_datas", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_trainer_datas_user_id"),
        "trainer_datas",
        "accounts",
        ["user_id"],
        ["id"],
        ondelete="CASCADE",
    )

    op.drop_constraint("fk_price_study_owner_id", "price_study", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_price_study_owner_id"),
        "price_study",
        "accounts",
        ["owner_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint("fk_price_study_project_id", "price_study", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_price_study_project_id"),
        "price_study",
        "project",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint("fk_price_study_company_id", "price_study", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_price_study_company_id"),
        "price_study",
        "company",
        ["company_id"],
        ["id"],
        ondelete="CASCADE",
    )

    op.drop_constraint(
        "fk_status_log_entry_user_id", "status_log_entry", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_status_log_entry_user_id"),
        "status_log_entry",
        "accounts",
        ["user_id"],
        ["id"],
        ondelete="set null",
    )
    op.drop_constraint(
        "fk_status_log_entry_node_id", "status_log_entry", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_status_log_entry_node_id"),
        "status_log_entry",
        "node",
        ["node_id"],
        ["id"],
        ondelete="cascade",
    )

    op.drop_constraint(
        "fk_expense_sheet_paid_status_user_id", "expense_sheet", type_="foreignkey"
    )
    if not utils.foreign_key_exists("expense_sheet", "fk_expense_sheet_id"):
        op.create_foreign_key(
            op.f("fk_expense_sheet_id"), "expense_sheet", "node", ["id"], ["id"]
        )

    op.create_foreign_key(
        op.f("fk_expense_sheet_paid_status_user_id"),
        "expense_sheet",
        "accounts",
        ["paid_status_user_id"],
        ["id"],
        ondelete="set null",
    )
    op.drop_constraint(
        "fk_supplier_invoice_paid_status_user_id",
        "supplier_invoice",
        type_="foreignkey",
    )
    op.drop_constraint(
        "fk_supplier_invoice_status_user_id", "supplier_invoice", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_supplier_invoice_paid_status_user_id"),
        "supplier_invoice",
        "accounts",
        ["paid_status_user_id"],
        ["id"],
        ondelete="set null",
    )
    op.create_foreign_key(
        op.f("fk_supplier_invoice_status_user_id"),
        "supplier_invoice",
        "accounts",
        ["status_user_id"],
        ["id"],
        ondelete="set null",
    )
    op.drop_constraint(
        "fk_supplier_order_status_user_id", "supplier_order", type_="foreignkey"
    )
    op.create_foreign_key(
        op.f("fk_supplier_order_status_user_id"),
        "supplier_order",
        "accounts",
        ["status_user_id"],
        ["id"],
        ondelete="set null",
    )

    if not utils.foreign_key_exists("project", "fk_project_id"):
        op.create_foreign_key(op.f("fk_project_id"), "project", "node", ["id"], ["id"])
    if not utils.foreign_key_exists(
        "project_customer", "fk_project_customer_project_id"
    ):
        op.create_foreign_key(
            op.f("fk_project_customer_project_id"),
            "project_customer",
            "project",
            ["project_id"],
            ["id"],
        )
    if not utils.foreign_key_exists(
        "project_customer", "fk_project_customer_customer_id"
    ):
        op.create_foreign_key(
            op.f("fk_project_customer_customer_id"),
            "project_customer",
            "customer",
            ["customer_id"],
            ["id"],
        )
    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()
    from zope.sqlalchemy import mark_changed

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    pass
