"""6.1.0 produit pour facture interne

Revision ID: 93bd3589fa62
Revises: 9336bbbecf03
Create Date: 2021-02-10 17:31:38.212522

"""

# revision identifiers, used by Alembic.
revision = "93bd3589fa62"
down_revision = "9336bbbecf03"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("product", sa.Column("internal", sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()
    op.execute("update product set internal = 0")
    query = """select * from product inner join tva on tva.id=product.tva_id
    where tva.value <= 0"""
    if conn.execute(query).rowcount == 1:
        conn.execute(
            """update product inner join tva on tva.id=product.tva_id
        set internal=1 where tva.value <=0"""
        )

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("product", "internal")
