"""6.3.0 Fix 2932

Revision ID: 82c315bf84c0
Revises: 01f96429ef5c
Create Date: 2021-10-05 14:52:47.737050

"""

# revision identifiers, used by Alembic.
revision = "82c315bf84c0"
down_revision = "01f96429ef5c"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "supplier_invoice_line",
        "description",
        existing_type=mysql.VARCHAR(collation="utf8mb4_unicode_ci", length=255),
        type_=sa.Text(),
        existing_nullable=True,
    )
    op.alter_column(
        "supplier_order_line",
        "description",
        existing_type=mysql.VARCHAR(collation="utf8mb4_unicode_ci", length=255),
        type_=sa.Text(),
        existing_nullable=True,
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "supplier_order_line",
        "description",
        existing_type=sa.Text(),
        type_=mysql.VARCHAR(collation="utf8mb4_unicode_ci", length=255),
        existing_nullable=True,
    )
    op.alter_column(
        "supplier_invoice_line",
        "description",
        existing_type=sa.Text(),
        type_=mysql.VARCHAR(collation="utf8mb4_unicode_ci", length=255),
        existing_nullable=True,
    )
    # ### end Alembic commands ###
