"""6.4.0 cascade_fk_affaires

Revision ID: a9ac168053d4
Revises: c685fd419967
Create Date: 2022-03-08 15:13:47.854557

"""

# revision identifiers, used by Alembic.
revision = "a9ac168053d4"
down_revision = "c685fd419967"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import foreign_key_exists


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    if foreign_key_exists(
        "business_payment_deadline", "fk_business_payment_deadline_business_id"
    ):
        op.drop_constraint(
            op.f("fk_business_payment_deadline_business_id"),
            "business_payment_deadline",
            type_="foreignkey",
        )
        op.create_foreign_key(
            "fk_business_payment_deadline_business_id",
            "business_payment_deadline",
            "business",
            ["business_id"],
            ["id"],
        )

    if foreign_key_exists("custom_indicator", "fk_custom_indicator_business_id"):
        op.drop_constraint(
            "fk_custom_indicator_business_id", "custom_indicator", type_="foreignkey"
        )
        op.create_foreign_key(
            op.f("fk_custom_indicator_business_id"),
            "custom_indicator",
            "business",
            ["business_id"],
            ["id"],
            ondelete="cascade",
        )

    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
