"""6.5.0 sap-client

Revision ID: 09d79360a4d8
Revises: e388e68ad1d7
Create Date: 2022-10-26 13:15:55.080500

"""

# revision identifiers, used by Alembic.
revision = "09d79360a4d8"
down_revision = "e388e68ad1d7"
from typing import Tuple
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import column_exists, foreign_key_exists


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    if column_exists("base_sale_product", "general_overhead"):
        op.drop_column("base_sale_product", "general_overhead")
    if not foreign_key_exists("expense_line", "fk_expense_line_supplier_id"):
        op.create_foreign_key(
            op.f("fk_expense_line_supplier_id"),
            "expense_line",
            "supplier",
            ["supplier_id"],
            ["id"],
        )
    if column_exists("price_study_work_item", "type_"):
        op.drop_column("price_study_work_item", "type_")

    op.add_column(
        "third_party",
        sa.Column("additional_address", sa.String(length=255), nullable=True),
    )
    op.add_column(
        "third_party", sa.Column("country_code", sa.String(length=8), nullable=True)
    )
    op.add_column(
        "third_party", sa.Column("city_code", sa.String(length=8), nullable=True)
    )
    # ### end Alembic commands ###


def split_address(address: str) -> Tuple[str, str]:
    """
    Split multiline address
    """
    if not address:
        return "", ""
    splitted = address.split("\n")
    address = ""
    additional_address = ""
    address = splitted[0]
    if len(splitted) > 1:
        additional_address = "\n".join(splitted[1:])
    return address, additional_address


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from caerp.models.third_party import ThirdParty
    from caerp.consts.insee_countries import COUNTRIES

    countries = dict((a["name"], a["code_insee"]) for a in COUNTRIES)
    for element in ThirdParty.query():
        if element.country.lower() == "france" or not element.country:
            element.country = "FRANCE"
        else:
            element.country = element.country.upper()

        if element.country in countries:
            element.country_code = countries[element.country]

        element.address, element.additional_address = split_address(element.address)
        session.merge(element)

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("third_party", "additional_address")
    op.drop_column("third_party", "city_code")
    op.drop_column("third_party", "country_code")

    op.add_column(
        "price_study_work_item",
        sa.Column(
            "type_",
            mysql.VARCHAR(collation="utf8mb4_unicode_ci", length=30),
            nullable=True,
        ),
    )

    op.drop_constraint(
        op.f("fk_expense_line_supplier_id"), "expense_line", type_="foreignkey"
    )

    op.add_column(
        "base_sale_product",
        sa.Column(
            "general_overhead", mysql.DECIMAL(precision=6, scale=5), nullable=True
        ),
    )
    # ### end Alembic commands ###
