"""6.5.5  Fix 3684 : User champ non null

Revision ID: aef809bffbc3
Revises: c7ea385d87e3
Create Date: 2023-01-25 11:35:27.303143

"""

# revision identifiers, used by Alembic.
revision = "aef809bffbc3"
down_revision = "c7ea385d87e3"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "accounts", "civilite", existing_type=mysql.VARCHAR(length=10), nullable=False
    )
    op.alter_column(
        "accounts", "lastname", existing_type=mysql.VARCHAR(length=50), nullable=False
    )
    op.alter_column(
        "accounts", "firstname", existing_type=mysql.VARCHAR(length=50), nullable=False
    )
    op.alter_column(
        "accounts", "email", existing_type=mysql.VARCHAR(length=100), nullable=False
    )
    op.alter_column(
        "accounts",
        "vehicle",
        existing_type=mysql.VARCHAR(length=126),
        type_=sa.String(length=66),
        existing_nullable=True,
    )

    # ### end Alembic commands ###


def pre_migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    conn.execute(
        "update accounts set firstname='Non renseigné' where firstname is null"
    )
    conn.execute("update accounts set email='Non renseigné' where email is null")
    conn.execute("update accounts set civilite='Non renseigné' where civilite is null")

    mark_changed(session)
    session.flush()


def upgrade():
    pre_migrate_datas()
    update_database_structure()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "accounts",
        "vehicle",
        existing_type=sa.String(length=66),
        type_=mysql.VARCHAR(length=126),
        existing_nullable=True,
    )
    op.alter_column(
        "accounts", "email", existing_type=mysql.VARCHAR(length=100), nullable=True
    )
    op.alter_column(
        "accounts", "firstname", existing_type=mysql.VARCHAR(length=50), nullable=True
    )
    op.alter_column(
        "accounts", "lastname", existing_type=mysql.VARCHAR(length=50), nullable=True
    )
    op.alter_column(
        "accounts", "civilite", existing_type=mysql.VARCHAR(length=10), nullable=True
    )

    # ### end Alembic commands ###
