"""6.7 Fix 2933 mode de paiement

Revision ID: 9ff2b756eb0b
Revises: 2e0ffd36167a
Create Date: 2023-09-08 10:28:38.587926

"""

# revision identifiers, used by Alembic.
revision = "9ff2b756eb0b"
down_revision = "2e0ffd36167a"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "paymentmode",
        "label",
        existing_type=mysql.VARCHAR(length=120),
        type_=sa.String(length=50),
        existing_nullable=True,
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    op.alter_column(
        "paymentmode",
        "label",
        existing_type=sa.String(length=50),
        type_=mysql.VARCHAR(length=120),
        existing_nullable=True,
    )
