# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class SourceAuthType(str, enum.Enum):
    """
    ℹ️ This enum is non-exhaustive.
    """

    OAUTH = "oauth"
    TEAM_OAUTH = "team_oauth"
    SDK = "sdk"
    PASSWORD = "password"
    EMAIL = "email"
    APP = "app"
    EMPTY = ""
    _UNKNOWN = "__SOURCEAUTHTYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "SourceAuthType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        oauth: typing.Callable[[], T_Result],
        team_oauth: typing.Callable[[], T_Result],
        sdk: typing.Callable[[], T_Result],
        password: typing.Callable[[], T_Result],
        email: typing.Callable[[], T_Result],
        app: typing.Callable[[], T_Result],
        empty: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is SourceAuthType.OAUTH:
            return oauth()
        if self is SourceAuthType.TEAM_OAUTH:
            return team_oauth()
        if self is SourceAuthType.SDK:
            return sdk()
        if self is SourceAuthType.PASSWORD:
            return password()
        if self is SourceAuthType.EMAIL:
            return email()
        if self is SourceAuthType.APP:
            return app()
        if self is SourceAuthType.EMPTY:
            return empty()
        return _unknown_member(self._value_)
