import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAwsSuspensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#group_id ElastigroupAwsSuspension#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#id ElastigroupAwsSuspension#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * suspension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#suspension ElastigroupAwsSuspension#suspension}
    */
    readonly suspension: ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable;
}
export interface ElastigroupAwsSuspensionSuspension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension#name ElastigroupAwsSuspension#name}
    */
    readonly name: string;
}
export declare function elastigroupAwsSuspensionSuspensionToTerraform(struct?: ElastigroupAwsSuspensionSuspension | cdktf.IResolvable): any;
export declare class ElastigroupAwsSuspensionSuspensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAwsSuspensionSuspension | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAwsSuspensionSuspension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ElastigroupAwsSuspensionSuspensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAwsSuspensionSuspensionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension}
*/
export declare class ElastigroupAwsSuspension extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_aws_suspension";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_aws_suspension spotinst_elastigroup_aws_suspension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAwsSuspensionConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAwsSuspensionConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _suspension;
    get suspension(): ElastigroupAwsSuspensionSuspensionList;
    putSuspension(value: ElastigroupAwsSuspensionSuspension[] | cdktf.IResolvable): void;
    get suspensionInput(): cdktf.IResolvable | ElastigroupAwsSuspensionSuspension[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
