import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom_data ElastigroupAzure#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#desired_capacity ElastigroupAzure#desired_capacity}
    */
    readonly desiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#id ElastigroupAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_sizes ElastigroupAzure#low_priority_sizes}
    */
    readonly lowPrioritySizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_size ElastigroupAzure#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_size ElastigroupAzure#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_sizes ElastigroupAzure#od_sizes}
    */
    readonly odSizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#product ElastigroupAzure#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#region ElastigroupAzure#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#shutdown_script ElastigroupAzure#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_data ElastigroupAzure#user_data}
    */
    readonly userData?: string;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check ElastigroupAzure#health_check}
    */
    readonly healthCheck?: ElastigroupAzureHealthCheck;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image ElastigroupAzure#image}
    */
    readonly image?: ElastigroupAzureImage[] | cdktf.IResolvable;
    /**
    * integration_kubernetes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_kubernetes ElastigroupAzure#integration_kubernetes}
    */
    readonly integrationKubernetes?: ElastigroupAzureIntegrationKubernetes;
    /**
    * integration_multai_runtime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#integration_multai_runtime ElastigroupAzure#integration_multai_runtime}
    */
    readonly integrationMultaiRuntime?: ElastigroupAzureIntegrationMultaiRuntime;
    /**
    * load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#load_balancers ElastigroupAzure#load_balancers}
    */
    readonly loadBalancers?: ElastigroupAzureLoadBalancers[] | cdktf.IResolvable;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#login ElastigroupAzure#login}
    */
    readonly login?: ElastigroupAzureLogin;
    /**
    * managed_service_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#managed_service_identities ElastigroupAzure#managed_service_identities}
    */
    readonly managedServiceIdentities?: ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#network ElastigroupAzure#network}
    */
    readonly network: ElastigroupAzureNetwork;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_down_policy ElastigroupAzure#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scaling_up_policy ElastigroupAzure#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scheduled_task ElastigroupAzure#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupAzureScheduledTask[] | cdktf.IResolvable;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#strategy ElastigroupAzure#strategy}
    */
    readonly strategy: ElastigroupAzureStrategy;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#update_policy ElastigroupAzure#update_policy}
    */
    readonly updatePolicy?: ElastigroupAzureUpdatePolicy;
}
export interface ElastigroupAzureHealthCheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_healing ElastigroupAzure#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}
    */
    readonly healthCheckType: string;
}
export declare function elastigroupAzureHealthCheckToTerraform(struct?: ElastigroupAzureHealthCheckOutputReference | ElastigroupAzureHealthCheck): any;
export declare class ElastigroupAzureHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureHealthCheck | undefined;
    set internalValue(value: ElastigroupAzureHealthCheck | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    get healthCheckTypeInput(): string | undefined;
}
export interface ElastigroupAzureImageCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#image_name ElastigroupAzure#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function elastigroupAzureImageCustomToTerraform(struct?: ElastigroupAzureImageCustom | cdktf.IResolvable): any;
export declare class ElastigroupAzureImageCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureImageCustom | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureImageCustom | cdktf.IResolvable | undefined);
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
}
export declare class ElastigroupAzureImageCustomList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureImageCustom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureImageCustomOutputReference;
}
export interface ElastigroupAzureImageMarketplace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#offer ElastigroupAzure#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#publisher ElastigroupAzure#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#sku ElastigroupAzure#sku}
    */
    readonly sku: string;
}
export declare function elastigroupAzureImageMarketplaceToTerraform(struct?: ElastigroupAzureImageMarketplace | cdktf.IResolvable): any;
export declare class ElastigroupAzureImageMarketplaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureImageMarketplace | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureImageMarketplace | cdktf.IResolvable | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
}
export declare class ElastigroupAzureImageMarketplaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureImageMarketplace[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureImageMarketplaceOutputReference;
}
export interface ElastigroupAzureImage {
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#custom ElastigroupAzure#custom}
    */
    readonly custom?: ElastigroupAzureImageCustom[] | cdktf.IResolvable;
    /**
    * marketplace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#marketplace ElastigroupAzure#marketplace}
    */
    readonly marketplace?: ElastigroupAzureImageMarketplace[] | cdktf.IResolvable;
}
export declare function elastigroupAzureImageToTerraform(struct?: ElastigroupAzureImage | cdktf.IResolvable): any;
export declare class ElastigroupAzureImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureImage | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureImage | cdktf.IResolvable | undefined);
    private _custom;
    get custom(): ElastigroupAzureImageCustomList;
    putCustom(value: ElastigroupAzureImageCustom[] | cdktf.IResolvable): void;
    resetCustom(): void;
    get customInput(): cdktf.IResolvable | ElastigroupAzureImageCustom[] | undefined;
    private _marketplace;
    get marketplace(): ElastigroupAzureImageMarketplaceList;
    putMarketplace(value: ElastigroupAzureImageMarketplace[] | cdktf.IResolvable): void;
    resetMarketplace(): void;
    get marketplaceInput(): cdktf.IResolvable | ElastigroupAzureImageMarketplace[] | undefined;
}
export declare class ElastigroupAzureImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureImageOutputReference;
}
export interface ElastigroupAzureIntegrationKubernetes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cluster_identifier ElastigroupAzure#cluster_identifier}
    */
    readonly clusterIdentifier: string;
}
export declare function elastigroupAzureIntegrationKubernetesToTerraform(struct?: ElastigroupAzureIntegrationKubernetesOutputReference | ElastigroupAzureIntegrationKubernetes): any;
export declare class ElastigroupAzureIntegrationKubernetesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureIntegrationKubernetes | undefined;
    set internalValue(value: ElastigroupAzureIntegrationKubernetes | undefined);
    private _clusterIdentifier?;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get clusterIdentifierInput(): string | undefined;
}
export interface ElastigroupAzureIntegrationMultaiRuntime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#deployment_id ElastigroupAzure#deployment_id}
    */
    readonly deploymentId: string;
}
export declare function elastigroupAzureIntegrationMultaiRuntimeToTerraform(struct?: ElastigroupAzureIntegrationMultaiRuntimeOutputReference | ElastigroupAzureIntegrationMultaiRuntime): any;
export declare class ElastigroupAzureIntegrationMultaiRuntimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureIntegrationMultaiRuntime | undefined;
    set internalValue(value: ElastigroupAzureIntegrationMultaiRuntime | undefined);
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
}
export interface ElastigroupAzureLoadBalancers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#auto_weight ElastigroupAzure#auto_weight}
    */
    readonly autoWeight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#balancer_id ElastigroupAzure#balancer_id}
    */
    readonly balancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target_set_id ElastigroupAzure#target_set_id}
    */
    readonly targetSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#type ElastigroupAzure#type}
    */
    readonly type: string;
}
export declare function elastigroupAzureLoadBalancersToTerraform(struct?: ElastigroupAzureLoadBalancers | cdktf.IResolvable): any;
export declare class ElastigroupAzureLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureLoadBalancers | cdktf.IResolvable | undefined);
    private _autoWeight?;
    get autoWeight(): boolean | cdktf.IResolvable;
    set autoWeight(value: boolean | cdktf.IResolvable);
    resetAutoWeight(): void;
    get autoWeightInput(): boolean | cdktf.IResolvable | undefined;
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    resetBalancerId(): void;
    get balancerIdInput(): string | undefined;
    private _targetSetId?;
    get targetSetId(): string;
    set targetSetId(value: string);
    resetTargetSetId(): void;
    get targetSetIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ElastigroupAzureLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureLoadBalancersOutputReference;
}
export interface ElastigroupAzureLogin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#password ElastigroupAzure#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#ssh_public_key ElastigroupAzure#ssh_public_key}
    */
    readonly sshPublicKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#user_name ElastigroupAzure#user_name}
    */
    readonly userName: string;
}
export declare function elastigroupAzureLoginToTerraform(struct?: ElastigroupAzureLoginOutputReference | ElastigroupAzureLogin): any;
export declare class ElastigroupAzureLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureLogin | undefined;
    set internalValue(value: ElastigroupAzureLogin | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    resetSshPublicKey(): void;
    get sshPublicKeyInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
}
export interface ElastigroupAzureManagedServiceIdentities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function elastigroupAzureManagedServiceIdentitiesToTerraform(struct?: ElastigroupAzureManagedServiceIdentities | cdktf.IResolvable): any;
export declare class ElastigroupAzureManagedServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureManagedServiceIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureManagedServiceIdentities | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
}
export declare class ElastigroupAzureManagedServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureManagedServiceIdentitiesOutputReference;
}
export interface ElastigroupAzureNetworkAdditionalIpConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#private_ip_version ElastigroupAzure#private_ip_version}
    */
    readonly privateIpVersion?: string;
}
export declare function elastigroupAzureNetworkAdditionalIpConfigsToTerraform(struct?: ElastigroupAzureNetworkAdditionalIpConfigs | cdktf.IResolvable): any;
export declare class ElastigroupAzureNetworkAdditionalIpConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureNetworkAdditionalIpConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureNetworkAdditionalIpConfigs | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpVersion?;
    get privateIpVersion(): string;
    set privateIpVersion(value: string);
    resetPrivateIpVersion(): void;
    get privateIpVersionInput(): string | undefined;
}
export declare class ElastigroupAzureNetworkAdditionalIpConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureNetworkAdditionalIpConfigsOutputReference;
}
export interface ElastigroupAzureNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#assign_public_ip ElastigroupAzure#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#resource_group_name ElastigroupAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#subnet_name ElastigroupAzure#subnet_name}
    */
    readonly subnetName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#virtual_network_name ElastigroupAzure#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * additional_ip_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#additional_ip_configs ElastigroupAzure#additional_ip_configs}
    */
    readonly additionalIpConfigs?: ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable;
}
export declare function elastigroupAzureNetworkToTerraform(struct?: ElastigroupAzureNetworkOutputReference | ElastigroupAzureNetwork): any;
export declare class ElastigroupAzureNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureNetwork | undefined;
    set internalValue(value: ElastigroupAzureNetwork | undefined);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    get subnetNameInput(): string | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _additionalIpConfigs;
    get additionalIpConfigs(): ElastigroupAzureNetworkAdditionalIpConfigsList;
    putAdditionalIpConfigs(value: ElastigroupAzureNetworkAdditionalIpConfigs[] | cdktf.IResolvable): void;
    resetAdditionalIpConfigs(): void;
    get additionalIpConfigsInput(): cdktf.IResolvable | ElastigroupAzureNetworkAdditionalIpConfigs[] | undefined;
}
export interface ElastigroupAzureScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}
    */
    readonly value?: string;
}
export declare function elastigroupAzureScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupAzureScalingDownPolicyDimensions | cdktf.IResolvable): any;
export declare class ElastigroupAzureScalingDownPolicyDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureScalingDownPolicyDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureScalingDownPolicyDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ElastigroupAzureScalingDownPolicyDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureScalingDownPolicyDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureScalingDownPolicyDimensionsOutputReference;
}
export interface ElastigroupAzureScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
    */
    readonly dimensions?: ElastigroupAzureScalingDownPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAzureScalingDownPolicyToTerraform(struct?: ElastigroupAzureScalingDownPolicy | cdktf.IResolvable): any;
export declare class ElastigroupAzureScalingDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureScalingDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureScalingDownPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _dimensions;
    get dimensions(): ElastigroupAzureScalingDownPolicyDimensionsList;
    putDimensions(value: ElastigroupAzureScalingDownPolicyDimensions[] | cdktf.IResolvable): void;
    resetDimensions(): void;
    get dimensionsInput(): cdktf.IResolvable | ElastigroupAzureScalingDownPolicyDimensions[] | undefined;
}
export declare class ElastigroupAzureScalingDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureScalingDownPolicyOutputReference;
}
export interface ElastigroupAzureScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#name ElastigroupAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#value ElastigroupAzure#value}
    */
    readonly value?: string;
}
export declare function elastigroupAzureScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupAzureScalingUpPolicyDimensions | cdktf.IResolvable): any;
export declare class ElastigroupAzureScalingUpPolicyDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureScalingUpPolicyDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureScalingUpPolicyDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ElastigroupAzureScalingUpPolicyDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureScalingUpPolicyDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureScalingUpPolicyDimensionsOutputReference;
}
export interface ElastigroupAzureScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#action_type ElastigroupAzure#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cooldown ElastigroupAzure#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#evaluation_periods ElastigroupAzure#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#max_target_capacity ElastigroupAzure#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#maximum ElastigroupAzure#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#metric_name ElastigroupAzure#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#min_target_capacity ElastigroupAzure#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#minimum ElastigroupAzure#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#namespace ElastigroupAzure#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#operator ElastigroupAzure#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#period ElastigroupAzure#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#policy_name ElastigroupAzure#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#statistic ElastigroupAzure#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#target ElastigroupAzure#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#threshold ElastigroupAzure#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#unit ElastigroupAzure#unit}
    */
    readonly unit?: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#dimensions ElastigroupAzure#dimensions}
    */
    readonly dimensions?: ElastigroupAzureScalingUpPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupAzureScalingUpPolicyToTerraform(struct?: ElastigroupAzureScalingUpPolicy | cdktf.IResolvable): any;
export declare class ElastigroupAzureScalingUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureScalingUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureScalingUpPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _dimensions;
    get dimensions(): ElastigroupAzureScalingUpPolicyDimensionsList;
    putDimensions(value: ElastigroupAzureScalingUpPolicyDimensions[] | cdktf.IResolvable): void;
    resetDimensions(): void;
    get dimensionsInput(): cdktf.IResolvable | ElastigroupAzureScalingUpPolicyDimensions[] | undefined;
}
export declare class ElastigroupAzureScalingUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureScalingUpPolicyOutputReference;
}
export interface ElastigroupAzureScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment ElastigroupAzure#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#adjustment_percentage ElastigroupAzure#adjustment_percentage}
    */
    readonly adjustmentPercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}
    */
    readonly batchSizePercentage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#cron_expression ElastigroupAzure#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#is_enabled ElastigroupAzure#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_max_capacity ElastigroupAzure#scale_max_capacity}
    */
    readonly scaleMaxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_min_capacity ElastigroupAzure#scale_min_capacity}
    */
    readonly scaleMinCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#scale_target_capacity ElastigroupAzure#scale_target_capacity}
    */
    readonly scaleTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#task_type ElastigroupAzure#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupAzureScheduledTaskToTerraform(struct?: ElastigroupAzureScheduledTask | cdktf.IResolvable): any;
export declare class ElastigroupAzureScheduledTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupAzureScheduledTask | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupAzureScheduledTask | cdktf.IResolvable | undefined);
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _adjustmentPercentage?;
    get adjustmentPercentage(): string;
    set adjustmentPercentage(value: string);
    resetAdjustmentPercentage(): void;
    get adjustmentPercentageInput(): string | undefined;
    private _batchSizePercentage?;
    get batchSizePercentage(): string;
    set batchSizePercentage(value: string);
    resetBatchSizePercentage(): void;
    get batchSizePercentageInput(): string | undefined;
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    get cronExpressionInput(): string | undefined;
    private _gracePeriod?;
    get gracePeriod(): string;
    set gracePeriod(value: string);
    resetGracePeriod(): void;
    get gracePeriodInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scaleMaxCapacity?;
    get scaleMaxCapacity(): string;
    set scaleMaxCapacity(value: string);
    resetScaleMaxCapacity(): void;
    get scaleMaxCapacityInput(): string | undefined;
    private _scaleMinCapacity?;
    get scaleMinCapacity(): string;
    set scaleMinCapacity(value: string);
    resetScaleMinCapacity(): void;
    get scaleMinCapacityInput(): string | undefined;
    private _scaleTargetCapacity?;
    get scaleTargetCapacity(): string;
    set scaleTargetCapacity(value: string);
    resetScaleTargetCapacity(): void;
    get scaleTargetCapacityInput(): string | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
}
export declare class ElastigroupAzureScheduledTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupAzureScheduledTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupAzureScheduledTaskOutputReference;
}
export interface ElastigroupAzureStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#draining_timeout ElastigroupAzure#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#low_priority_percentage ElastigroupAzure#low_priority_percentage}
    */
    readonly lowPriorityPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#od_count ElastigroupAzure#od_count}
    */
    readonly odCount?: number;
}
export declare function elastigroupAzureStrategyToTerraform(struct?: ElastigroupAzureStrategyOutputReference | ElastigroupAzureStrategy): any;
export declare class ElastigroupAzureStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureStrategy | undefined;
    set internalValue(value: ElastigroupAzureStrategy | undefined);
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _lowPriorityPercentage?;
    get lowPriorityPercentage(): number;
    set lowPriorityPercentage(value: number);
    resetLowPriorityPercentage(): void;
    get lowPriorityPercentageInput(): number | undefined;
    private _odCount?;
    get odCount(): number;
    set odCount(value: number);
    resetOdCount(): void;
    get odCountInput(): number | undefined;
}
export interface ElastigroupAzureUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#batch_size_percentage ElastigroupAzure#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#grace_period ElastigroupAzure#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#health_check_type ElastigroupAzure#health_check_type}
    */
    readonly healthCheckType?: string;
}
export declare function elastigroupAzureUpdatePolicyRollConfigToTerraform(struct?: ElastigroupAzureUpdatePolicyRollConfigOutputReference | ElastigroupAzureUpdatePolicyRollConfig): any;
export declare class ElastigroupAzureUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureUpdatePolicyRollConfig | undefined;
    set internalValue(value: ElastigroupAzureUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
}
export interface ElastigroupAzureUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#should_roll ElastigroupAzure#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure#roll_config ElastigroupAzure#roll_config}
    */
    readonly rollConfig?: ElastigroupAzureUpdatePolicyRollConfig;
}
export declare function elastigroupAzureUpdatePolicyToTerraform(struct?: ElastigroupAzureUpdatePolicyOutputReference | ElastigroupAzureUpdatePolicy): any;
export declare class ElastigroupAzureUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupAzureUpdatePolicy | undefined;
    set internalValue(value: ElastigroupAzureUpdatePolicy | undefined);
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): ElastigroupAzureUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: ElastigroupAzureUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): ElastigroupAzureUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure}
*/
export declare class ElastigroupAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_azure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_azure spotinst_elastigroup_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupAzureConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupAzureConfig);
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lowPrioritySizes?;
    get lowPrioritySizes(): string[];
    set lowPrioritySizes(value: string[]);
    get lowPrioritySizesInput(): string[] | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _odSizes?;
    get odSizes(): string[];
    set odSizes(value: string[]);
    get odSizesInput(): string[] | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _healthCheck;
    get healthCheck(): ElastigroupAzureHealthCheckOutputReference;
    putHealthCheck(value: ElastigroupAzureHealthCheck): void;
    resetHealthCheck(): void;
    get healthCheckInput(): ElastigroupAzureHealthCheck | undefined;
    private _image;
    get image(): ElastigroupAzureImageList;
    putImage(value: ElastigroupAzureImage[] | cdktf.IResolvable): void;
    resetImage(): void;
    get imageInput(): cdktf.IResolvable | ElastigroupAzureImage[] | undefined;
    private _integrationKubernetes;
    get integrationKubernetes(): ElastigroupAzureIntegrationKubernetesOutputReference;
    putIntegrationKubernetes(value: ElastigroupAzureIntegrationKubernetes): void;
    resetIntegrationKubernetes(): void;
    get integrationKubernetesInput(): ElastigroupAzureIntegrationKubernetes | undefined;
    private _integrationMultaiRuntime;
    get integrationMultaiRuntime(): ElastigroupAzureIntegrationMultaiRuntimeOutputReference;
    putIntegrationMultaiRuntime(value: ElastigroupAzureIntegrationMultaiRuntime): void;
    resetIntegrationMultaiRuntime(): void;
    get integrationMultaiRuntimeInput(): ElastigroupAzureIntegrationMultaiRuntime | undefined;
    private _loadBalancers;
    get loadBalancers(): ElastigroupAzureLoadBalancersList;
    putLoadBalancers(value: ElastigroupAzureLoadBalancers[] | cdktf.IResolvable): void;
    resetLoadBalancers(): void;
    get loadBalancersInput(): cdktf.IResolvable | ElastigroupAzureLoadBalancers[] | undefined;
    private _login;
    get login(): ElastigroupAzureLoginOutputReference;
    putLogin(value: ElastigroupAzureLogin): void;
    resetLogin(): void;
    get loginInput(): ElastigroupAzureLogin | undefined;
    private _managedServiceIdentities;
    get managedServiceIdentities(): ElastigroupAzureManagedServiceIdentitiesList;
    putManagedServiceIdentities(value: ElastigroupAzureManagedServiceIdentities[] | cdktf.IResolvable): void;
    resetManagedServiceIdentities(): void;
    get managedServiceIdentitiesInput(): cdktf.IResolvable | ElastigroupAzureManagedServiceIdentities[] | undefined;
    private _network;
    get network(): ElastigroupAzureNetworkOutputReference;
    putNetwork(value: ElastigroupAzureNetwork): void;
    get networkInput(): ElastigroupAzureNetwork | undefined;
    private _scalingDownPolicy;
    get scalingDownPolicy(): ElastigroupAzureScalingDownPolicyList;
    putScalingDownPolicy(value: ElastigroupAzureScalingDownPolicy[] | cdktf.IResolvable): void;
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupAzureScalingDownPolicy[] | undefined;
    private _scalingUpPolicy;
    get scalingUpPolicy(): ElastigroupAzureScalingUpPolicyList;
    putScalingUpPolicy(value: ElastigroupAzureScalingUpPolicy[] | cdktf.IResolvable): void;
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupAzureScalingUpPolicy[] | undefined;
    private _scheduledTask;
    get scheduledTask(): ElastigroupAzureScheduledTaskList;
    putScheduledTask(value: ElastigroupAzureScheduledTask[] | cdktf.IResolvable): void;
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupAzureScheduledTask[] | undefined;
    private _strategy;
    get strategy(): ElastigroupAzureStrategyOutputReference;
    putStrategy(value: ElastigroupAzureStrategy): void;
    get strategyInput(): ElastigroupAzureStrategy | undefined;
    private _updatePolicy;
    get updatePolicy(): ElastigroupAzureUpdatePolicyOutputReference;
    putUpdatePolicy(value: ElastigroupAzureUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): ElastigroupAzureUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
