import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElastigroupGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_healing ElastigroupGcp#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#availability_zones ElastigroupGcp#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#description ElastigroupGcp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#desired_capacity ElastigroupGcp#desired_capacity}
    */
    readonly desiredCapacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#draining_timeout ElastigroupGcp#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#fallback_to_ondemand ElastigroupGcp#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_grace_period ElastigroupGcp#health_check_grace_period}
    */
    readonly healthCheckGracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#health_check_type ElastigroupGcp#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#id ElastigroupGcp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_ondemand ElastigroupGcp#instance_types_ondemand}
    */
    readonly instanceTypesOndemand?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_preemptible ElastigroupGcp#instance_types_preemptible}
    */
    readonly instanceTypesPreemptible?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ip_forwarding ElastigroupGcp#ip_forwarding}
    */
    readonly ipForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#max_size ElastigroupGcp#max_size}
    */
    readonly maxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#min_size ElastigroupGcp#min_size}
    */
    readonly minSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ondemand_count ElastigroupGcp#ondemand_count}
    */
    readonly ondemandCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#preemptible_percentage ElastigroupGcp#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#provisioning_model ElastigroupGcp#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#service_account ElastigroupGcp#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#shutdown_script ElastigroupGcp#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#startup_script ElastigroupGcp#startup_script}
    */
    readonly startupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#tags ElastigroupGcp#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unhealthy_duration ElastigroupGcp#unhealthy_duration}
    */
    readonly unhealthyDuration?: number;
    /**
    * backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#backend_services ElastigroupGcp#backend_services}
    */
    readonly backendServices?: ElastigroupGcpBackendServices[] | cdktf.IResolvable;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk ElastigroupGcp#disk}
    */
    readonly disk?: ElastigroupGcpDisk[] | cdktf.IResolvable;
    /**
    * gpu block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#gpu ElastigroupGcp#gpu}
    */
    readonly gpu?: ElastigroupGcpGpu[] | cdktf.IResolvable;
    /**
    * instance_types_custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#instance_types_custom ElastigroupGcp#instance_types_custom}
    */
    readonly instanceTypesCustom?: ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable;
    /**
    * integration_docker_swarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_docker_swarm ElastigroupGcp#integration_docker_swarm}
    */
    readonly integrationDockerSwarm?: ElastigroupGcpIntegrationDockerSwarm;
    /**
    * integration_gke block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#integration_gke ElastigroupGcp#integration_gke}
    */
    readonly integrationGke?: ElastigroupGcpIntegrationGke;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#labels ElastigroupGcp#labels}
    */
    readonly labels?: ElastigroupGcpLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metadata ElastigroupGcp#metadata}
    */
    readonly metadata?: ElastigroupGcpMetadata[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#network_interface ElastigroupGcp#network_interface}
    */
    readonly networkInterface?: ElastigroupGcpNetworkInterface[] | cdktf.IResolvable;
    /**
    * scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_down_policy ElastigroupGcp#scaling_down_policy}
    */
    readonly scalingDownPolicy?: ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scaling_up_policy ElastigroupGcp#scaling_up_policy}
    */
    readonly scalingUpPolicy?: ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scheduled_task ElastigroupGcp#scheduled_task}
    */
    readonly scheduledTask?: ElastigroupGcpScheduledTask[] | cdktf.IResolvable;
    /**
    * subnets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnets ElastigroupGcp#subnets}
    */
    readonly subnets?: ElastigroupGcpSubnets[] | cdktf.IResolvable;
}
export interface ElastigroupGcpBackendServicesNamedPorts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ports ElastigroupGcp#ports}
    */
    readonly ports: string[];
}
export declare function elastigroupGcpBackendServicesNamedPortsToTerraform(struct?: ElastigroupGcpBackendServicesNamedPorts | cdktf.IResolvable): any;
export declare class ElastigroupGcpBackendServicesNamedPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpBackendServicesNamedPorts | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpBackendServicesNamedPorts | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    get portsInput(): string[] | undefined;
}
export declare class ElastigroupGcpBackendServicesNamedPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpBackendServicesNamedPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpBackendServicesNamedPortsOutputReference;
}
export interface ElastigroupGcpBackendServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#location_type ElastigroupGcp#location_type}
    */
    readonly locationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#scheme ElastigroupGcp#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#service_name ElastigroupGcp#service_name}
    */
    readonly serviceName: string;
    /**
    * named_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#named_ports ElastigroupGcp#named_ports}
    */
    readonly namedPorts?: ElastigroupGcpBackendServicesNamedPorts[] | cdktf.IResolvable;
}
export declare function elastigroupGcpBackendServicesToTerraform(struct?: ElastigroupGcpBackendServices | cdktf.IResolvable): any;
export declare class ElastigroupGcpBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpBackendServices | cdktf.IResolvable | undefined);
    private _locationType?;
    get locationType(): string;
    set locationType(value: string);
    resetLocationType(): void;
    get locationTypeInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _namedPorts;
    get namedPorts(): ElastigroupGcpBackendServicesNamedPortsList;
    putNamedPorts(value: ElastigroupGcpBackendServicesNamedPorts[] | cdktf.IResolvable): void;
    resetNamedPorts(): void;
    get namedPortsInput(): cdktf.IResolvable | ElastigroupGcpBackendServicesNamedPorts[] | undefined;
}
export declare class ElastigroupGcpBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpBackendServicesOutputReference;
}
export interface ElastigroupGcpDiskInitializeParams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk_size_gb ElastigroupGcp#disk_size_gb}
    */
    readonly diskSizeGb?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#disk_type ElastigroupGcp#disk_type}
    */
    readonly diskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source_image ElastigroupGcp#source_image}
    */
    readonly sourceImage: string;
}
export declare function elastigroupGcpDiskInitializeParamsToTerraform(struct?: ElastigroupGcpDiskInitializeParams | cdktf.IResolvable): any;
export declare class ElastigroupGcpDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpDiskInitializeParams | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpDiskInitializeParams | cdktf.IResolvable | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): string;
    set diskSizeGb(value: string);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): string | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    get sourceImageInput(): string | undefined;
}
export declare class ElastigroupGcpDiskInitializeParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpDiskInitializeParams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpDiskInitializeParamsOutputReference;
}
export interface ElastigroupGcpDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_delete ElastigroupGcp#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#boot ElastigroupGcp#boot}
    */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#device_name ElastigroupGcp#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#interface ElastigroupGcp#interface}
    */
    readonly interface?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#mode ElastigroupGcp#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#initialize_params ElastigroupGcp#initialize_params}
    */
    readonly initializeParams?: ElastigroupGcpDiskInitializeParams[] | cdktf.IResolvable;
}
export declare function elastigroupGcpDiskToTerraform(struct?: ElastigroupGcpDisk | cdktf.IResolvable): any;
export declare class ElastigroupGcpDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpDisk | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpDisk | cdktf.IResolvable | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _boot?;
    get boot(): boolean | cdktf.IResolvable;
    set boot(value: boolean | cdktf.IResolvable);
    resetBoot(): void;
    get bootInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): ElastigroupGcpDiskInitializeParamsList;
    putInitializeParams(value: ElastigroupGcpDiskInitializeParams[] | cdktf.IResolvable): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): cdktf.IResolvable | ElastigroupGcpDiskInitializeParams[] | undefined;
}
export declare class ElastigroupGcpDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpDiskOutputReference;
}
export interface ElastigroupGcpGpu {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#count ElastigroupGcp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type: string;
}
export declare function elastigroupGcpGpuToTerraform(struct?: ElastigroupGcpGpu | cdktf.IResolvable): any;
export declare class ElastigroupGcpGpuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpGpu | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpGpu | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ElastigroupGcpGpuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpGpu[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpGpuOutputReference;
}
export interface ElastigroupGcpInstanceTypesCustom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#memory_gib ElastigroupGcp#memory_gib}
    */
    readonly memoryGib: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#vcpu ElastigroupGcp#vcpu}
    */
    readonly vcpu: number;
}
export declare function elastigroupGcpInstanceTypesCustomToTerraform(struct?: ElastigroupGcpInstanceTypesCustom | cdktf.IResolvable): any;
export declare class ElastigroupGcpInstanceTypesCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpInstanceTypesCustom | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpInstanceTypesCustom | cdktf.IResolvable | undefined);
    private _memoryGib?;
    get memoryGib(): number;
    set memoryGib(value: number);
    get memoryGibInput(): number | undefined;
    private _vcpu?;
    get vcpu(): number;
    set vcpu(value: number);
    get vcpuInput(): number | undefined;
}
export declare class ElastigroupGcpInstanceTypesCustomList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpInstanceTypesCustomOutputReference;
}
export interface ElastigroupGcpIntegrationDockerSwarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_host ElastigroupGcp#master_host}
    */
    readonly masterHost: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#master_port ElastigroupGcp#master_port}
    */
    readonly masterPort: number;
}
export declare function elastigroupGcpIntegrationDockerSwarmToTerraform(struct?: ElastigroupGcpIntegrationDockerSwarmOutputReference | ElastigroupGcpIntegrationDockerSwarm): any;
export declare class ElastigroupGcpIntegrationDockerSwarmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationDockerSwarm | undefined;
    set internalValue(value: ElastigroupGcpIntegrationDockerSwarm | undefined);
    private _masterHost?;
    get masterHost(): string;
    set masterHost(value: string);
    get masterHostInput(): string | undefined;
    private _masterPort?;
    get masterPort(): number;
    set masterPort(value: number);
    get masterPortInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleDownToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference | ElastigroupGcpIntegrationGkeAutoscaleDown): any;
export declare class ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGkeAutoscaleDown | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGkeAutoscaleDown | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cpu_per_unit ElastigroupGcp#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#memory_per_unit ElastigroupGcp#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#num_of_units ElastigroupGcp#num_of_units}
    */
    readonly numOfUnits?: number;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleHeadroomToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference | ElastigroupGcpIntegrationGkeAutoscaleHeadroom): any;
export declare class ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    resetNumOfUnits(): void;
    get numOfUnitsInput(): number | undefined;
}
export interface ElastigroupGcpIntegrationGkeAutoscaleLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpIntegrationGkeAutoscaleLabelsToTerraform(struct?: ElastigroupGcpIntegrationGkeAutoscaleLabels | cdktf.IResolvable): any;
export declare class ElastigroupGcpIntegrationGkeAutoscaleLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpIntegrationGkeAutoscaleLabels | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGkeAutoscaleLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ElastigroupGcpIntegrationGkeAutoscaleLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpIntegrationGkeAutoscaleLabelsOutputReference;
}
export interface ElastigroupGcpIntegrationGke {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#auto_update ElastigroupGcp#auto_update}
    */
    readonly autoUpdate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_cooldown ElastigroupGcp#autoscale_cooldown}
    */
    readonly autoscaleCooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_auto_config ElastigroupGcp#autoscale_is_auto_config}
    */
    readonly autoscaleIsAutoConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_is_enabled ElastigroupGcp#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cluster_id ElastigroupGcp#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#location ElastigroupGcp#location}
    */
    readonly location?: string;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_down ElastigroupGcp#autoscale_down}
    */
    readonly autoscaleDown?: ElastigroupGcpIntegrationGkeAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_headroom ElastigroupGcp#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: ElastigroupGcpIntegrationGkeAutoscaleHeadroom;
    /**
    * autoscale_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#autoscale_labels ElastigroupGcp#autoscale_labels}
    */
    readonly autoscaleLabels?: ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable;
}
export declare function elastigroupGcpIntegrationGkeToTerraform(struct?: ElastigroupGcpIntegrationGkeOutputReference | ElastigroupGcpIntegrationGke): any;
export declare class ElastigroupGcpIntegrationGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastigroupGcpIntegrationGke | undefined;
    set internalValue(value: ElastigroupGcpIntegrationGke | undefined);
    private _autoUpdate?;
    get autoUpdate(): boolean | cdktf.IResolvable;
    set autoUpdate(value: boolean | cdktf.IResolvable);
    resetAutoUpdate(): void;
    get autoUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleCooldown?;
    get autoscaleCooldown(): number;
    set autoscaleCooldown(value: number);
    resetAutoscaleCooldown(): void;
    get autoscaleCooldownInput(): number | undefined;
    private _autoscaleIsAutoConfig?;
    get autoscaleIsAutoConfig(): boolean | cdktf.IResolvable;
    set autoscaleIsAutoConfig(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsAutoConfig(): void;
    get autoscaleIsAutoConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _autoscaleDown;
    get autoscaleDown(): ElastigroupGcpIntegrationGkeAutoscaleDownOutputReference;
    putAutoscaleDown(value: ElastigroupGcpIntegrationGkeAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): ElastigroupGcpIntegrationGkeAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): ElastigroupGcpIntegrationGkeAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: ElastigroupGcpIntegrationGkeAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): ElastigroupGcpIntegrationGkeAutoscaleHeadroom | undefined;
    private _autoscaleLabels;
    get autoscaleLabels(): ElastigroupGcpIntegrationGkeAutoscaleLabelsList;
    putAutoscaleLabels(value: ElastigroupGcpIntegrationGkeAutoscaleLabels[] | cdktf.IResolvable): void;
    resetAutoscaleLabels(): void;
    get autoscaleLabelsInput(): cdktf.IResolvable | ElastigroupGcpIntegrationGkeAutoscaleLabels[] | undefined;
}
export interface ElastigroupGcpLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpLabelsToTerraform(struct?: ElastigroupGcpLabels | cdktf.IResolvable): any;
export declare class ElastigroupGcpLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpLabels | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ElastigroupGcpLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpLabelsOutputReference;
}
export interface ElastigroupGcpMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#key ElastigroupGcp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value: string;
}
export declare function elastigroupGcpMetadataToTerraform(struct?: ElastigroupGcpMetadata | cdktf.IResolvable): any;
export declare class ElastigroupGcpMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpMetadata | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpMetadata | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ElastigroupGcpMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpMetadata[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpMetadataOutputReference;
}
export interface ElastigroupGcpNetworkInterfaceAccessConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#type ElastigroupGcp#type}
    */
    readonly type?: string;
}
export declare function elastigroupGcpNetworkInterfaceAccessConfigsToTerraform(struct?: ElastigroupGcpNetworkInterfaceAccessConfigs | cdktf.IResolvable): any;
export declare class ElastigroupGcpNetworkInterfaceAccessConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpNetworkInterfaceAccessConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpNetworkInterfaceAccessConfigs | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ElastigroupGcpNetworkInterfaceAccessConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpNetworkInterfaceAccessConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpNetworkInterfaceAccessConfigsOutputReference;
}
export interface ElastigroupGcpNetworkInterfaceAliasIpRanges {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#ip_cidr_range ElastigroupGcp#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnetwork_range_name ElastigroupGcp#subnetwork_range_name}
    */
    readonly subnetworkRangeName: string;
}
export declare function elastigroupGcpNetworkInterfaceAliasIpRangesToTerraform(struct?: ElastigroupGcpNetworkInterfaceAliasIpRanges | cdktf.IResolvable): any;
export declare class ElastigroupGcpNetworkInterfaceAliasIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpNetworkInterfaceAliasIpRanges | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpNetworkInterfaceAliasIpRanges | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class ElastigroupGcpNetworkInterfaceAliasIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpNetworkInterfaceAliasIpRanges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpNetworkInterfaceAliasIpRangesOutputReference;
}
export interface ElastigroupGcpNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#network ElastigroupGcp#network}
    */
    readonly network: string;
    /**
    * access_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#access_configs ElastigroupGcp#access_configs}
    */
    readonly accessConfigs?: ElastigroupGcpNetworkInterfaceAccessConfigs[] | cdktf.IResolvable;
    /**
    * alias_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#alias_ip_ranges ElastigroupGcp#alias_ip_ranges}
    */
    readonly aliasIpRanges?: ElastigroupGcpNetworkInterfaceAliasIpRanges[] | cdktf.IResolvable;
}
export declare function elastigroupGcpNetworkInterfaceToTerraform(struct?: ElastigroupGcpNetworkInterface | cdktf.IResolvable): any;
export declare class ElastigroupGcpNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpNetworkInterface | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _accessConfigs;
    get accessConfigs(): ElastigroupGcpNetworkInterfaceAccessConfigsList;
    putAccessConfigs(value: ElastigroupGcpNetworkInterfaceAccessConfigs[] | cdktf.IResolvable): void;
    resetAccessConfigs(): void;
    get accessConfigsInput(): cdktf.IResolvable | ElastigroupGcpNetworkInterfaceAccessConfigs[] | undefined;
    private _aliasIpRanges;
    get aliasIpRanges(): ElastigroupGcpNetworkInterfaceAliasIpRangesList;
    putAliasIpRanges(value: ElastigroupGcpNetworkInterfaceAliasIpRanges[] | cdktf.IResolvable): void;
    resetAliasIpRanges(): void;
    get aliasIpRangesInput(): cdktf.IResolvable | ElastigroupGcpNetworkInterfaceAliasIpRanges[] | undefined;
}
export declare class ElastigroupGcpNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpNetworkInterfaceOutputReference;
}
export interface ElastigroupGcpScalingDownPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value?: string;
}
export declare function elastigroupGcpScalingDownPolicyDimensionsToTerraform(struct?: ElastigroupGcpScalingDownPolicyDimensions | cdktf.IResolvable): any;
export declare class ElastigroupGcpScalingDownPolicyDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpScalingDownPolicyDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpScalingDownPolicyDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ElastigroupGcpScalingDownPolicyDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpScalingDownPolicyDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpScalingDownPolicyDimensionsOutputReference;
}
export interface ElastigroupGcpScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#action_type ElastigroupGcp#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#adjustment ElastigroupGcp#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cooldown ElastigroupGcp#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metric_name ElastigroupGcp#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#namespace ElastigroupGcp#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#operator ElastigroupGcp#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#period ElastigroupGcp#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#policy_name ElastigroupGcp#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#statistic ElastigroupGcp#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#threshold ElastigroupGcp#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unit ElastigroupGcp#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#dimensions ElastigroupGcp#dimensions}
    */
    readonly dimensions?: ElastigroupGcpScalingDownPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGcpScalingDownPolicyToTerraform(struct?: ElastigroupGcpScalingDownPolicy | cdktf.IResolvable): any;
export declare class ElastigroupGcpScalingDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpScalingDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpScalingDownPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): number;
    set adjustment(value: number);
    resetAdjustment(): void;
    get adjustmentInput(): number | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _dimensions;
    get dimensions(): ElastigroupGcpScalingDownPolicyDimensionsList;
    putDimensions(value: ElastigroupGcpScalingDownPolicyDimensions[] | cdktf.IResolvable): void;
    resetDimensions(): void;
    get dimensionsInput(): cdktf.IResolvable | ElastigroupGcpScalingDownPolicyDimensions[] | undefined;
}
export declare class ElastigroupGcpScalingDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpScalingDownPolicyOutputReference;
}
export interface ElastigroupGcpScalingUpPolicyDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#name ElastigroupGcp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#value ElastigroupGcp#value}
    */
    readonly value?: string;
}
export declare function elastigroupGcpScalingUpPolicyDimensionsToTerraform(struct?: ElastigroupGcpScalingUpPolicyDimensions | cdktf.IResolvable): any;
export declare class ElastigroupGcpScalingUpPolicyDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpScalingUpPolicyDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpScalingUpPolicyDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ElastigroupGcpScalingUpPolicyDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpScalingUpPolicyDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpScalingUpPolicyDimensionsOutputReference;
}
export interface ElastigroupGcpScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#action_type ElastigroupGcp#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#adjustment ElastigroupGcp#adjustment}
    */
    readonly adjustment?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cooldown ElastigroupGcp#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#evaluation_periods ElastigroupGcp#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#metric_name ElastigroupGcp#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#namespace ElastigroupGcp#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#operator ElastigroupGcp#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#period ElastigroupGcp#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#policy_name ElastigroupGcp#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#source ElastigroupGcp#source}
    */
    readonly source?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#statistic ElastigroupGcp#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#threshold ElastigroupGcp#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#unit ElastigroupGcp#unit}
    */
    readonly unit: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#dimensions ElastigroupGcp#dimensions}
    */
    readonly dimensions?: ElastigroupGcpScalingUpPolicyDimensions[] | cdktf.IResolvable;
}
export declare function elastigroupGcpScalingUpPolicyToTerraform(struct?: ElastigroupGcpScalingUpPolicy | cdktf.IResolvable): any;
export declare class ElastigroupGcpScalingUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpScalingUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpScalingUpPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): number;
    set adjustment(value: number);
    resetAdjustment(): void;
    get adjustmentInput(): number | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _dimensions;
    get dimensions(): ElastigroupGcpScalingUpPolicyDimensionsList;
    putDimensions(value: ElastigroupGcpScalingUpPolicyDimensions[] | cdktf.IResolvable): void;
    resetDimensions(): void;
    get dimensionsInput(): cdktf.IResolvable | ElastigroupGcpScalingUpPolicyDimensions[] | undefined;
}
export declare class ElastigroupGcpScalingUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpScalingUpPolicyOutputReference;
}
export interface ElastigroupGcpScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#cron_expression ElastigroupGcp#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#is_enabled ElastigroupGcp#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#max_capacity ElastigroupGcp#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#min_capacity ElastigroupGcp#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#target_capacity ElastigroupGcp#target_capacity}
    */
    readonly targetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#task_type ElastigroupGcp#task_type}
    */
    readonly taskType: string;
}
export declare function elastigroupGcpScheduledTaskToTerraform(struct?: ElastigroupGcpScheduledTask | cdktf.IResolvable): any;
export declare class ElastigroupGcpScheduledTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpScheduledTask | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpScheduledTask | cdktf.IResolvable | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    resetCronExpression(): void;
    get cronExpressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxCapacity?;
    get maxCapacity(): string;
    set maxCapacity(value: string);
    resetMaxCapacity(): void;
    get maxCapacityInput(): string | undefined;
    private _minCapacity?;
    get minCapacity(): string;
    set minCapacity(value: string);
    resetMinCapacity(): void;
    get minCapacityInput(): string | undefined;
    private _targetCapacity?;
    get targetCapacity(): string;
    set targetCapacity(value: string);
    resetTargetCapacity(): void;
    get targetCapacityInput(): string | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
}
export declare class ElastigroupGcpScheduledTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpScheduledTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpScheduledTaskOutputReference;
}
export interface ElastigroupGcpSubnets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#region ElastigroupGcp#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp#subnet_names ElastigroupGcp#subnet_names}
    */
    readonly subnetNames: string[];
}
export declare function elastigroupGcpSubnetsToTerraform(struct?: ElastigroupGcpSubnets | cdktf.IResolvable): any;
export declare class ElastigroupGcpSubnetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElastigroupGcpSubnets | cdktf.IResolvable | undefined;
    set internalValue(value: ElastigroupGcpSubnets | cdktf.IResolvable | undefined);
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _subnetNames?;
    get subnetNames(): string[];
    set subnetNames(value: string[]);
    get subnetNamesInput(): string[] | undefined;
}
export declare class ElastigroupGcpSubnetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElastigroupGcpSubnets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElastigroupGcpSubnetsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp}
*/
export declare class ElastigroupGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_elastigroup_gcp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/elastigroup_gcp spotinst_elastigroup_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastigroupGcpConfig
    */
    constructor(scope: Construct, id: string, config: ElastigroupGcpConfig);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): number;
    set desiredCapacity(value: number);
    get desiredCapacityInput(): number | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheckGracePeriod?;
    get healthCheckGracePeriod(): number;
    set healthCheckGracePeriod(value: number);
    resetHealthCheckGracePeriod(): void;
    get healthCheckGracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceTypesOndemand?;
    get instanceTypesOndemand(): string;
    set instanceTypesOndemand(value: string);
    resetInstanceTypesOndemand(): void;
    get instanceTypesOndemandInput(): string | undefined;
    private _instanceTypesPreemptible?;
    get instanceTypesPreemptible(): string[];
    set instanceTypesPreemptible(value: string[]);
    resetInstanceTypesPreemptible(): void;
    get instanceTypesPreemptibleInput(): string[] | undefined;
    private _ipForwarding?;
    get ipForwarding(): boolean | cdktf.IResolvable;
    set ipForwarding(value: boolean | cdktf.IResolvable);
    resetIpForwarding(): void;
    get ipForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxSize?;
    get maxSize(): number;
    set maxSize(value: number);
    resetMaxSize(): void;
    get maxSizeInput(): number | undefined;
    private _minSize?;
    get minSize(): number;
    set minSize(value: number);
    resetMinSize(): void;
    get minSizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ondemandCount?;
    get ondemandCount(): number;
    set ondemandCount(value: number);
    resetOndemandCount(): void;
    get ondemandCountInput(): number | undefined;
    private _preemptiblePercentage?;
    get preemptiblePercentage(): number;
    set preemptiblePercentage(value: number);
    resetPreemptiblePercentage(): void;
    get preemptiblePercentageInput(): number | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _startupScript?;
    get startupScript(): string;
    set startupScript(value: string);
    resetStartupScript(): void;
    get startupScriptInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _unhealthyDuration?;
    get unhealthyDuration(): number;
    set unhealthyDuration(value: number);
    resetUnhealthyDuration(): void;
    get unhealthyDurationInput(): number | undefined;
    private _backendServices;
    get backendServices(): ElastigroupGcpBackendServicesList;
    putBackendServices(value: ElastigroupGcpBackendServices[] | cdktf.IResolvable): void;
    resetBackendServices(): void;
    get backendServicesInput(): cdktf.IResolvable | ElastigroupGcpBackendServices[] | undefined;
    private _disk;
    get disk(): ElastigroupGcpDiskList;
    putDisk(value: ElastigroupGcpDisk[] | cdktf.IResolvable): void;
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | ElastigroupGcpDisk[] | undefined;
    private _gpu;
    get gpu(): ElastigroupGcpGpuList;
    putGpu(value: ElastigroupGcpGpu[] | cdktf.IResolvable): void;
    resetGpu(): void;
    get gpuInput(): cdktf.IResolvable | ElastigroupGcpGpu[] | undefined;
    private _instanceTypesCustom;
    get instanceTypesCustom(): ElastigroupGcpInstanceTypesCustomList;
    putInstanceTypesCustom(value: ElastigroupGcpInstanceTypesCustom[] | cdktf.IResolvable): void;
    resetInstanceTypesCustom(): void;
    get instanceTypesCustomInput(): cdktf.IResolvable | ElastigroupGcpInstanceTypesCustom[] | undefined;
    private _integrationDockerSwarm;
    get integrationDockerSwarm(): ElastigroupGcpIntegrationDockerSwarmOutputReference;
    putIntegrationDockerSwarm(value: ElastigroupGcpIntegrationDockerSwarm): void;
    resetIntegrationDockerSwarm(): void;
    get integrationDockerSwarmInput(): ElastigroupGcpIntegrationDockerSwarm | undefined;
    private _integrationGke;
    get integrationGke(): ElastigroupGcpIntegrationGkeOutputReference;
    putIntegrationGke(value: ElastigroupGcpIntegrationGke): void;
    resetIntegrationGke(): void;
    get integrationGkeInput(): ElastigroupGcpIntegrationGke | undefined;
    private _labels;
    get labels(): ElastigroupGcpLabelsList;
    putLabels(value: ElastigroupGcpLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ElastigroupGcpLabels[] | undefined;
    private _metadata;
    get metadata(): ElastigroupGcpMetadataList;
    putMetadata(value: ElastigroupGcpMetadata[] | cdktf.IResolvable): void;
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | ElastigroupGcpMetadata[] | undefined;
    private _networkInterface;
    get networkInterface(): ElastigroupGcpNetworkInterfaceList;
    putNetworkInterface(value: ElastigroupGcpNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ElastigroupGcpNetworkInterface[] | undefined;
    private _scalingDownPolicy;
    get scalingDownPolicy(): ElastigroupGcpScalingDownPolicyList;
    putScalingDownPolicy(value: ElastigroupGcpScalingDownPolicy[] | cdktf.IResolvable): void;
    resetScalingDownPolicy(): void;
    get scalingDownPolicyInput(): cdktf.IResolvable | ElastigroupGcpScalingDownPolicy[] | undefined;
    private _scalingUpPolicy;
    get scalingUpPolicy(): ElastigroupGcpScalingUpPolicyList;
    putScalingUpPolicy(value: ElastigroupGcpScalingUpPolicy[] | cdktf.IResolvable): void;
    resetScalingUpPolicy(): void;
    get scalingUpPolicyInput(): cdktf.IResolvable | ElastigroupGcpScalingUpPolicy[] | undefined;
    private _scheduledTask;
    get scheduledTask(): ElastigroupGcpScheduledTaskList;
    putScheduledTask(value: ElastigroupGcpScheduledTask[] | cdktf.IResolvable): void;
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ElastigroupGcpScheduledTask[] | undefined;
    private _subnets;
    get subnets(): ElastigroupGcpSubnetsList;
    putSubnets(value: ElastigroupGcpSubnets[] | cdktf.IResolvable): void;
    resetSubnets(): void;
    get subnetsInput(): cdktf.IResolvable | ElastigroupGcpSubnets[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
