import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedInstanceAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#auto_healing ManagedInstanceAws#auto_healing}
    */
    readonly autoHealing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#block_devices_mode ManagedInstanceAws#block_devices_mode}
    */
    readonly blockDevicesMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#cpu_credits ManagedInstanceAws#cpu_credits}
    */
    readonly cpuCredits?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#description ManagedInstanceAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#draining_timeout ManagedInstanceAws#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#ebs_optimized ManagedInstanceAws#ebs_optimized}
    */
    readonly ebsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#elastic_ip ManagedInstanceAws#elastic_ip}
    */
    readonly elasticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#enable_monitoring ManagedInstanceAws#enable_monitoring}
    */
    readonly enableMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#fall_back_to_od ManagedInstanceAws#fall_back_to_od}
    */
    readonly fallBackToOd?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#grace_period ManagedInstanceAws#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#health_check_type ManagedInstanceAws#health_check_type}
    */
    readonly healthCheckType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#iam_instance_profile ManagedInstanceAws#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#id ManagedInstanceAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#image_id ManagedInstanceAws#image_id}
    */
    readonly imageId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#instance_types ManagedInstanceAws#instance_types}
    */
    readonly instanceTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#key_pair ManagedInstanceAws#key_pair}
    */
    readonly keyPair?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#life_cycle ManagedInstanceAws#life_cycle}
    */
    readonly lifeCycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#minimum_instance_lifetime ManagedInstanceAws#minimum_instance_lifetime}
    */
    readonly minimumInstanceLifetime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#optimization_windows ManagedInstanceAws#optimization_windows}
    */
    readonly optimizationWindows?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#orientation ManagedInstanceAws#orientation}
    */
    readonly orientation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_block_devices ManagedInstanceAws#persist_block_devices}
    */
    readonly persistBlockDevices: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_private_ip ManagedInstanceAws#persist_private_ip}
    */
    readonly persistPrivateIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#persist_root_device ManagedInstanceAws#persist_root_device}
    */
    readonly persistRootDevice?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#placement_tenancy ManagedInstanceAws#placement_tenancy}
    */
    readonly placementTenancy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#preferred_type ManagedInstanceAws#preferred_type}
    */
    readonly preferredType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#private_ip ManagedInstanceAws#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#product ManagedInstanceAws#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#region ManagedInstanceAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#security_group_ids ManagedInstanceAws#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#shutdown_script ManagedInstanceAws#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#subnet_ids ManagedInstanceAws#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#unhealthy_duration ManagedInstanceAws#unhealthy_duration}
    */
    readonly unhealthyDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#user_data ManagedInstanceAws#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#utilize_reserved_instances ManagedInstanceAws#utilize_reserved_instances}
    */
    readonly utilizeReservedInstances?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#vpc_id ManagedInstanceAws#vpc_id}
    */
    readonly vpcId: string;
    /**
    * block_device_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#block_device_mappings ManagedInstanceAws#block_device_mappings}
    */
    readonly blockDeviceMappings?: ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * integration_route53 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#integration_route53 ManagedInstanceAws#integration_route53}
    */
    readonly integrationRoute53?: ManagedInstanceAwsIntegrationRoute53;
    /**
    * load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#load_balancers ManagedInstanceAws#load_balancers}
    */
    readonly loadBalancers?: ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable;
    /**
    * managed_instance_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#managed_instance_action ManagedInstanceAws#managed_instance_action}
    */
    readonly managedInstanceAction?: ManagedInstanceAwsManagedInstanceAction;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#network_interface ManagedInstanceAws#network_interface}
    */
    readonly networkInterface?: ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable;
    /**
    * resource_tag_specification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#resource_tag_specification ManagedInstanceAws#resource_tag_specification}
    */
    readonly resourceTagSpecification?: ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable;
    /**
    * revert_to_spot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#revert_to_spot ManagedInstanceAws#revert_to_spot}
    */
    readonly revertToSpot?: ManagedInstanceAwsRevertToSpot;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#scheduled_task ManagedInstanceAws#scheduled_task}
    */
    readonly scheduledTask?: ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#tags ManagedInstanceAws#tags}
    */
    readonly tags?: ManagedInstanceAwsTags[] | cdktf.IResolvable;
}
export interface ManagedInstanceAwsBlockDeviceMappingsEbs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#delete_on_termination ManagedInstanceAws#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#iops ManagedInstanceAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#throughput ManagedInstanceAws#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#volume_size ManagedInstanceAws#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#volume_type ManagedInstanceAws#volume_type}
    */
    readonly volumeType?: string;
}
export declare function managedInstanceAwsBlockDeviceMappingsEbsToTerraform(struct?: ManagedInstanceAwsBlockDeviceMappingsEbsOutputReference | ManagedInstanceAwsBlockDeviceMappingsEbs): any;
export declare class ManagedInstanceAwsBlockDeviceMappingsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsBlockDeviceMappingsEbs | undefined;
    set internalValue(value: ManagedInstanceAwsBlockDeviceMappingsEbs | undefined);
    private _deleteOnTermination?;
    get deleteOnTermination(): boolean | cdktf.IResolvable;
    set deleteOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOnTermination(): void;
    get deleteOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface ManagedInstanceAwsBlockDeviceMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#device_name ManagedInstanceAws#device_name}
    */
    readonly deviceName: string;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#ebs ManagedInstanceAws#ebs}
    */
    readonly ebs?: ManagedInstanceAwsBlockDeviceMappingsEbs;
}
export declare function managedInstanceAwsBlockDeviceMappingsToTerraform(struct?: ManagedInstanceAwsBlockDeviceMappings | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsBlockDeviceMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsBlockDeviceMappings | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsBlockDeviceMappings | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    private _ebs;
    get ebs(): ManagedInstanceAwsBlockDeviceMappingsEbsOutputReference;
    putEbs(value: ManagedInstanceAwsBlockDeviceMappingsEbs): void;
    resetEbs(): void;
    get ebsInput(): ManagedInstanceAwsBlockDeviceMappingsEbs | undefined;
}
export declare class ManagedInstanceAwsBlockDeviceMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsBlockDeviceMappingsOutputReference;
}
export interface ManagedInstanceAwsIntegrationRoute53DomainsRecordSets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#use_public_dns ManagedInstanceAws#use_public_dns}
    */
    readonly usePublicDns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#use_public_ip ManagedInstanceAws#use_public_ip}
    */
    readonly usePublicIp?: boolean | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53DomainsRecordSetsToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsIntegrationRoute53DomainsRecordSetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsIntegrationRoute53DomainsRecordSets | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _usePublicDns?;
    get usePublicDns(): boolean | cdktf.IResolvable;
    set usePublicDns(value: boolean | cdktf.IResolvable);
    resetUsePublicDns(): void;
    get usePublicDnsInput(): boolean | cdktf.IResolvable | undefined;
    private _usePublicIp?;
    get usePublicIp(): boolean | cdktf.IResolvable;
    set usePublicIp(value: boolean | cdktf.IResolvable);
    resetUsePublicIp(): void;
    get usePublicIpInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ManagedInstanceAwsIntegrationRoute53DomainsRecordSetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsIntegrationRoute53DomainsRecordSetsOutputReference;
}
export interface ManagedInstanceAwsIntegrationRoute53Domains {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#hosted_zone_id ManagedInstanceAws#hosted_zone_id}
    */
    readonly hostedZoneId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#record_set_type ManagedInstanceAws#record_set_type}
    */
    readonly recordSetType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#spotinst_acct_id ManagedInstanceAws#spotinst_acct_id}
    */
    readonly spotinstAcctId?: string;
    /**
    * record_sets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#record_sets ManagedInstanceAws#record_sets}
    */
    readonly recordSets: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets[] | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53DomainsToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53Domains | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsIntegrationRoute53DomainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsIntegrationRoute53Domains | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsIntegrationRoute53Domains | cdktf.IResolvable | undefined);
    private _hostedZoneId?;
    get hostedZoneId(): string;
    set hostedZoneId(value: string);
    get hostedZoneIdInput(): string | undefined;
    private _recordSetType?;
    get recordSetType(): string;
    set recordSetType(value: string);
    resetRecordSetType(): void;
    get recordSetTypeInput(): string | undefined;
    private _spotinstAcctId?;
    get spotinstAcctId(): string;
    set spotinstAcctId(value: string);
    resetSpotinstAcctId(): void;
    get spotinstAcctIdInput(): string | undefined;
    private _recordSets;
    get recordSets(): ManagedInstanceAwsIntegrationRoute53DomainsRecordSetsList;
    putRecordSets(value: ManagedInstanceAwsIntegrationRoute53DomainsRecordSets[] | cdktf.IResolvable): void;
    get recordSetsInput(): cdktf.IResolvable | ManagedInstanceAwsIntegrationRoute53DomainsRecordSets[] | undefined;
}
export declare class ManagedInstanceAwsIntegrationRoute53DomainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsIntegrationRoute53DomainsOutputReference;
}
export interface ManagedInstanceAwsIntegrationRoute53 {
    /**
    * domains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#domains ManagedInstanceAws#domains}
    */
    readonly domains: ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable;
}
export declare function managedInstanceAwsIntegrationRoute53ToTerraform(struct?: ManagedInstanceAwsIntegrationRoute53OutputReference | ManagedInstanceAwsIntegrationRoute53): any;
export declare class ManagedInstanceAwsIntegrationRoute53OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsIntegrationRoute53 | undefined;
    set internalValue(value: ManagedInstanceAwsIntegrationRoute53 | undefined);
    private _domains;
    get domains(): ManagedInstanceAwsIntegrationRoute53DomainsList;
    putDomains(value: ManagedInstanceAwsIntegrationRoute53Domains[] | cdktf.IResolvable): void;
    get domainsInput(): cdktf.IResolvable | ManagedInstanceAwsIntegrationRoute53Domains[] | undefined;
}
export interface ManagedInstanceAwsLoadBalancers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#arn ManagedInstanceAws#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#auto_weight ManagedInstanceAws#auto_weight}
    */
    readonly autoWeight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#az_awareness ManagedInstanceAws#az_awareness}
    */
    readonly azAwareness?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#balancer_id ManagedInstanceAws#balancer_id}
    */
    readonly balancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#name ManagedInstanceAws#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#target_set_id ManagedInstanceAws#target_set_id}
    */
    readonly targetSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#type ManagedInstanceAws#type}
    */
    readonly type: string;
}
export declare function managedInstanceAwsLoadBalancersToTerraform(struct?: ManagedInstanceAwsLoadBalancers | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsLoadBalancers | cdktf.IResolvable | undefined);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    resetArn(): void;
    get arnInput(): string | undefined;
    private _autoWeight?;
    get autoWeight(): boolean | cdktf.IResolvable;
    set autoWeight(value: boolean | cdktf.IResolvable);
    resetAutoWeight(): void;
    get autoWeightInput(): boolean | cdktf.IResolvable | undefined;
    private _azAwareness?;
    get azAwareness(): boolean | cdktf.IResolvable;
    set azAwareness(value: boolean | cdktf.IResolvable);
    resetAzAwareness(): void;
    get azAwarenessInput(): boolean | cdktf.IResolvable | undefined;
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    resetBalancerId(): void;
    get balancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _targetSetId?;
    get targetSetId(): string;
    set targetSetId(value: string);
    resetTargetSetId(): void;
    get targetSetIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ManagedInstanceAwsLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsLoadBalancersOutputReference;
}
export interface ManagedInstanceAwsManagedInstanceAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#type ManagedInstanceAws#type}
    */
    readonly type: string;
}
export declare function managedInstanceAwsManagedInstanceActionToTerraform(struct?: ManagedInstanceAwsManagedInstanceActionOutputReference | ManagedInstanceAwsManagedInstanceAction): any;
export declare class ManagedInstanceAwsManagedInstanceActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsManagedInstanceAction | undefined;
    set internalValue(value: ManagedInstanceAwsManagedInstanceAction | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ManagedInstanceAwsNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#associate_ipv6_address ManagedInstanceAws#associate_ipv6_address}
    */
    readonly associateIpv6Address?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#associate_public_ip_address ManagedInstanceAws#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#device_index ManagedInstanceAws#device_index}
    */
    readonly deviceIndex: string;
}
export declare function managedInstanceAwsNetworkInterfaceToTerraform(struct?: ManagedInstanceAwsNetworkInterface | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsNetworkInterface | cdktf.IResolvable | undefined);
    private _associateIpv6Address?;
    get associateIpv6Address(): boolean | cdktf.IResolvable;
    set associateIpv6Address(value: boolean | cdktf.IResolvable);
    resetAssociateIpv6Address(): void;
    get associateIpv6AddressInput(): boolean | cdktf.IResolvable | undefined;
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | cdktf.IResolvable;
    set associatePublicIpAddress(value: boolean | cdktf.IResolvable);
    resetAssociatePublicIpAddress(): void;
    get associatePublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceIndex?;
    get deviceIndex(): string;
    set deviceIndex(value: string);
    get deviceIndexInput(): string | undefined;
}
export declare class ManagedInstanceAwsNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsNetworkInterfaceOutputReference;
}
export interface ManagedInstanceAwsResourceTagSpecification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_amis ManagedInstanceAws#should_tag_amis}
    */
    readonly shouldTagAmis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_enis ManagedInstanceAws#should_tag_enis}
    */
    readonly shouldTagEnis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_snapshots ManagedInstanceAws#should_tag_snapshots}
    */
    readonly shouldTagSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#should_tag_volumes ManagedInstanceAws#should_tag_volumes}
    */
    readonly shouldTagVolumes?: boolean | cdktf.IResolvable;
}
export declare function managedInstanceAwsResourceTagSpecificationToTerraform(struct?: ManagedInstanceAwsResourceTagSpecification | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsResourceTagSpecificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsResourceTagSpecification | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsResourceTagSpecification | cdktf.IResolvable | undefined);
    private _shouldTagAmis?;
    get shouldTagAmis(): boolean | cdktf.IResolvable;
    set shouldTagAmis(value: boolean | cdktf.IResolvable);
    resetShouldTagAmis(): void;
    get shouldTagAmisInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldTagEnis?;
    get shouldTagEnis(): boolean | cdktf.IResolvable;
    set shouldTagEnis(value: boolean | cdktf.IResolvable);
    resetShouldTagEnis(): void;
    get shouldTagEnisInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldTagSnapshots?;
    get shouldTagSnapshots(): boolean | cdktf.IResolvable;
    set shouldTagSnapshots(value: boolean | cdktf.IResolvable);
    resetShouldTagSnapshots(): void;
    get shouldTagSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldTagVolumes?;
    get shouldTagVolumes(): boolean | cdktf.IResolvable;
    set shouldTagVolumes(value: boolean | cdktf.IResolvable);
    resetShouldTagVolumes(): void;
    get shouldTagVolumesInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ManagedInstanceAwsResourceTagSpecificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsResourceTagSpecificationOutputReference;
}
export interface ManagedInstanceAwsRevertToSpot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#perform_at ManagedInstanceAws#perform_at}
    */
    readonly performAt: string;
}
export declare function managedInstanceAwsRevertToSpotToTerraform(struct?: ManagedInstanceAwsRevertToSpotOutputReference | ManagedInstanceAwsRevertToSpot): any;
export declare class ManagedInstanceAwsRevertToSpotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedInstanceAwsRevertToSpot | undefined;
    set internalValue(value: ManagedInstanceAwsRevertToSpot | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    get performAtInput(): string | undefined;
}
export interface ManagedInstanceAwsScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#cron_expression ManagedInstanceAws#cron_expression}
    */
    readonly cronExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#frequency ManagedInstanceAws#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#is_enabled ManagedInstanceAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#start_time ManagedInstanceAws#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#task_type ManagedInstanceAws#task_type}
    */
    readonly taskType: string;
}
export declare function managedInstanceAwsScheduledTaskToTerraform(struct?: ManagedInstanceAwsScheduledTask | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsScheduledTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsScheduledTask | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsScheduledTask | cdktf.IResolvable | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    resetCronExpression(): void;
    get cronExpressionInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
}
export declare class ManagedInstanceAwsScheduledTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsScheduledTaskOutputReference;
}
export interface ManagedInstanceAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#key ManagedInstanceAws#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws#value ManagedInstanceAws#value}
    */
    readonly value?: string;
}
export declare function managedInstanceAwsTagsToTerraform(struct?: ManagedInstanceAwsTags | cdktf.IResolvable): any;
export declare class ManagedInstanceAwsTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedInstanceAwsTags | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedInstanceAwsTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ManagedInstanceAwsTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedInstanceAwsTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedInstanceAwsTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws spotinst_managed_instance_aws}
*/
export declare class ManagedInstanceAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_managed_instance_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/managed_instance_aws spotinst_managed_instance_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedInstanceAwsConfig
    */
    constructor(scope: Construct, id: string, config: ManagedInstanceAwsConfig);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    resetAutoHealing(): void;
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _blockDevicesMode?;
    get blockDevicesMode(): string;
    set blockDevicesMode(value: string);
    resetBlockDevicesMode(): void;
    get blockDevicesModeInput(): string | undefined;
    private _cpuCredits?;
    get cpuCredits(): string;
    set cpuCredits(value: string);
    resetCpuCredits(): void;
    get cpuCreditsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _ebsOptimized?;
    get ebsOptimized(): boolean | cdktf.IResolvable;
    set ebsOptimized(value: boolean | cdktf.IResolvable);
    resetEbsOptimized(): void;
    get ebsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _elasticIp?;
    get elasticIp(): string;
    set elasticIp(value: string);
    resetElasticIp(): void;
    get elasticIpInput(): string | undefined;
    private _enableMonitoring?;
    get enableMonitoring(): boolean | cdktf.IResolvable;
    set enableMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableMonitoring(): void;
    get enableMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _fallBackToOd?;
    get fallBackToOd(): boolean | cdktf.IResolvable;
    set fallBackToOd(value: boolean | cdktf.IResolvable);
    resetFallBackToOd(): void;
    get fallBackToOdInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckType?;
    get healthCheckType(): string;
    set healthCheckType(value: string);
    resetHealthCheckType(): void;
    get healthCheckTypeInput(): string | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    get imageIdInput(): string | undefined;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    get instanceTypesInput(): string[] | undefined;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    resetKeyPair(): void;
    get keyPairInput(): string | undefined;
    private _lifeCycle?;
    get lifeCycle(): string;
    set lifeCycle(value: string);
    resetLifeCycle(): void;
    get lifeCycleInput(): string | undefined;
    private _minimumInstanceLifetime?;
    get minimumInstanceLifetime(): number;
    set minimumInstanceLifetime(value: number);
    resetMinimumInstanceLifetime(): void;
    get minimumInstanceLifetimeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optimizationWindows?;
    get optimizationWindows(): string[];
    set optimizationWindows(value: string[]);
    resetOptimizationWindows(): void;
    get optimizationWindowsInput(): string[] | undefined;
    private _orientation?;
    get orientation(): string;
    set orientation(value: string);
    resetOrientation(): void;
    get orientationInput(): string | undefined;
    private _persistBlockDevices?;
    get persistBlockDevices(): boolean | cdktf.IResolvable;
    set persistBlockDevices(value: boolean | cdktf.IResolvable);
    get persistBlockDevicesInput(): boolean | cdktf.IResolvable | undefined;
    private _persistPrivateIp?;
    get persistPrivateIp(): boolean | cdktf.IResolvable;
    set persistPrivateIp(value: boolean | cdktf.IResolvable);
    resetPersistPrivateIp(): void;
    get persistPrivateIpInput(): boolean | cdktf.IResolvable | undefined;
    private _persistRootDevice?;
    get persistRootDevice(): boolean | cdktf.IResolvable;
    set persistRootDevice(value: boolean | cdktf.IResolvable);
    resetPersistRootDevice(): void;
    get persistRootDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _placementTenancy?;
    get placementTenancy(): string;
    set placementTenancy(value: string);
    resetPlacementTenancy(): void;
    get placementTenancyInput(): string | undefined;
    private _preferredType?;
    get preferredType(): string;
    set preferredType(value: string);
    resetPreferredType(): void;
    get preferredTypeInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _unhealthyDuration?;
    get unhealthyDuration(): number;
    set unhealthyDuration(value: number);
    resetUnhealthyDuration(): void;
    get unhealthyDurationInput(): number | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _utilizeReservedInstances?;
    get utilizeReservedInstances(): boolean | cdktf.IResolvable;
    set utilizeReservedInstances(value: boolean | cdktf.IResolvable);
    resetUtilizeReservedInstances(): void;
    get utilizeReservedInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _blockDeviceMappings;
    get blockDeviceMappings(): ManagedInstanceAwsBlockDeviceMappingsList;
    putBlockDeviceMappings(value: ManagedInstanceAwsBlockDeviceMappings[] | cdktf.IResolvable): void;
    resetBlockDeviceMappings(): void;
    get blockDeviceMappingsInput(): cdktf.IResolvable | ManagedInstanceAwsBlockDeviceMappings[] | undefined;
    private _integrationRoute53;
    get integrationRoute53(): ManagedInstanceAwsIntegrationRoute53OutputReference;
    putIntegrationRoute53(value: ManagedInstanceAwsIntegrationRoute53): void;
    resetIntegrationRoute53(): void;
    get integrationRoute53Input(): ManagedInstanceAwsIntegrationRoute53 | undefined;
    private _loadBalancers;
    get loadBalancers(): ManagedInstanceAwsLoadBalancersList;
    putLoadBalancers(value: ManagedInstanceAwsLoadBalancers[] | cdktf.IResolvable): void;
    resetLoadBalancers(): void;
    get loadBalancersInput(): cdktf.IResolvable | ManagedInstanceAwsLoadBalancers[] | undefined;
    private _managedInstanceAction;
    get managedInstanceAction(): ManagedInstanceAwsManagedInstanceActionOutputReference;
    putManagedInstanceAction(value: ManagedInstanceAwsManagedInstanceAction): void;
    resetManagedInstanceAction(): void;
    get managedInstanceActionInput(): ManagedInstanceAwsManagedInstanceAction | undefined;
    private _networkInterface;
    get networkInterface(): ManagedInstanceAwsNetworkInterfaceList;
    putNetworkInterface(value: ManagedInstanceAwsNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | ManagedInstanceAwsNetworkInterface[] | undefined;
    private _resourceTagSpecification;
    get resourceTagSpecification(): ManagedInstanceAwsResourceTagSpecificationList;
    putResourceTagSpecification(value: ManagedInstanceAwsResourceTagSpecification[] | cdktf.IResolvable): void;
    resetResourceTagSpecification(): void;
    get resourceTagSpecificationInput(): cdktf.IResolvable | ManagedInstanceAwsResourceTagSpecification[] | undefined;
    private _revertToSpot;
    get revertToSpot(): ManagedInstanceAwsRevertToSpotOutputReference;
    putRevertToSpot(value: ManagedInstanceAwsRevertToSpot): void;
    resetRevertToSpot(): void;
    get revertToSpotInput(): ManagedInstanceAwsRevertToSpot | undefined;
    private _scheduledTask;
    get scheduledTask(): ManagedInstanceAwsScheduledTaskList;
    putScheduledTask(value: ManagedInstanceAwsScheduledTask[] | cdktf.IResolvable): void;
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | ManagedInstanceAwsScheduledTask[] | undefined;
    private _tags;
    get tags(): ManagedInstanceAwsTagsList;
    putTags(value: ManagedInstanceAwsTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | ManagedInstanceAwsTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
