import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MrscalerAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_info MrscalerAws#additional_info}
    */
    readonly additionalInfo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_primary_security_groups MrscalerAws#additional_primary_security_groups}
    */
    readonly additionalPrimarySecurityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#additional_replica_security_groups MrscalerAws#additional_replica_security_groups}
    */
    readonly additionalReplicaSecurityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#availability_zones MrscalerAws#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cluster_id MrscalerAws#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_desired_capacity MrscalerAws#core_desired_capacity}
    */
    readonly coreDesiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_ebs_optimized MrscalerAws#core_ebs_optimized}
    */
    readonly coreEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_instance_types MrscalerAws#core_instance_types}
    */
    readonly coreInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_lifecycle MrscalerAws#core_lifecycle}
    */
    readonly coreLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_max_size MrscalerAws#core_max_size}
    */
    readonly coreMaxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_min_size MrscalerAws#core_min_size}
    */
    readonly coreMinSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_unit MrscalerAws#core_unit}
    */
    readonly coreUnit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#custom_ami_id MrscalerAws#custom_ami_id}
    */
    readonly customAmiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#description MrscalerAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#ebs_root_volume_size MrscalerAws#ebs_root_volume_size}
    */
    readonly ebsRootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#ec2_key_name MrscalerAws#ec2_key_name}
    */
    readonly ec2KeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#expose_cluster_id MrscalerAws#expose_cluster_id}
    */
    readonly exposeClusterId?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#id MrscalerAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#job_flow_role MrscalerAws#job_flow_role}
    */
    readonly jobFlowRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#keep_job_flow_alive MrscalerAws#keep_job_flow_alive}
    */
    readonly keepJobFlowAlive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#log_uri MrscalerAws#log_uri}
    */
    readonly logUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#managed_primary_security_group MrscalerAws#managed_primary_security_group}
    */
    readonly managedPrimarySecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#managed_replica_security_group MrscalerAws#managed_replica_security_group}
    */
    readonly managedReplicaSecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_ebs_optimized MrscalerAws#master_ebs_optimized}
    */
    readonly masterEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_instance_types MrscalerAws#master_instance_types}
    */
    readonly masterInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_lifecycle MrscalerAws#master_lifecycle}
    */
    readonly masterLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_target MrscalerAws#master_target}
    */
    readonly masterTarget?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#name MrscalerAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#region MrscalerAws#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#release_label MrscalerAws#release_label}
    */
    readonly releaseLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#repo_upgrade_on_boot MrscalerAws#repo_upgrade_on_boot}
    */
    readonly repoUpgradeOnBoot?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#retries MrscalerAws#retries}
    */
    readonly retries?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#security_config MrscalerAws#security_config}
    */
    readonly securityConfig?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#service_access_security_group MrscalerAws#service_access_security_group}
    */
    readonly serviceAccessSecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#service_role MrscalerAws#service_role}
    */
    readonly serviceRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#strategy MrscalerAws#strategy}
    */
    readonly strategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_desired_capacity MrscalerAws#task_desired_capacity}
    */
    readonly taskDesiredCapacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_ebs_optimized MrscalerAws#task_ebs_optimized}
    */
    readonly taskEbsOptimized?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_instance_types MrscalerAws#task_instance_types}
    */
    readonly taskInstanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_lifecycle MrscalerAws#task_lifecycle}
    */
    readonly taskLifecycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_max_size MrscalerAws#task_max_size}
    */
    readonly taskMaxSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_min_size MrscalerAws#task_min_size}
    */
    readonly taskMinSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_unit MrscalerAws#task_unit}
    */
    readonly taskUnit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#termination_protected MrscalerAws#termination_protected}
    */
    readonly terminationProtected?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#visible_to_all_users MrscalerAws#visible_to_all_users}
    */
    readonly visibleToAllUsers?: boolean | cdktf.IResolvable;
    /**
    * applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#applications MrscalerAws#applications}
    */
    readonly applications?: MrscalerAwsApplications[] | cdktf.IResolvable;
    /**
    * bootstrap_actions_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bootstrap_actions_file MrscalerAws#bootstrap_actions_file}
    */
    readonly bootstrapActionsFile?: MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable;
    /**
    * configurations_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#configurations_file MrscalerAws#configurations_file}
    */
    readonly configurationsFile?: MrscalerAwsConfigurationsFile[] | cdktf.IResolvable;
    /**
    * core_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_ebs_block_device MrscalerAws#core_ebs_block_device}
    */
    readonly coreEbsBlockDevice?: MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * core_scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_scaling_down_policy MrscalerAws#core_scaling_down_policy}
    */
    readonly coreScalingDownPolicy?: MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * core_scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#core_scaling_up_policy MrscalerAws#core_scaling_up_policy}
    */
    readonly coreScalingUpPolicy?: MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * instance_weights block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_weights MrscalerAws#instance_weights}
    */
    readonly instanceWeights?: MrscalerAwsInstanceWeights[] | cdktf.IResolvable;
    /**
    * master_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#master_ebs_block_device MrscalerAws#master_ebs_block_device}
    */
    readonly masterEbsBlockDevice?: MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * provisioning_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#provisioning_timeout MrscalerAws#provisioning_timeout}
    */
    readonly provisioningTimeout?: MrscalerAwsProvisioningTimeout;
    /**
    * scheduled_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#scheduled_task MrscalerAws#scheduled_task}
    */
    readonly scheduledTask?: MrscalerAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * steps_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#steps_file MrscalerAws#steps_file}
    */
    readonly stepsFile?: MrscalerAwsStepsFile[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#tags MrscalerAws#tags}
    */
    readonly tags?: MrscalerAwsTags[] | cdktf.IResolvable;
    /**
    * task_ebs_block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_ebs_block_device MrscalerAws#task_ebs_block_device}
    */
    readonly taskEbsBlockDevice?: MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * task_scaling_down_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_scaling_down_policy MrscalerAws#task_scaling_down_policy}
    */
    readonly taskScalingDownPolicy?: MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * task_scaling_up_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_scaling_up_policy MrscalerAws#task_scaling_up_policy}
    */
    readonly taskScalingUpPolicy?: MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * termination_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#termination_policies MrscalerAws#termination_policies}
    */
    readonly terminationPolicies?: MrscalerAwsTerminationPolicies[] | cdktf.IResolvable;
}
export interface MrscalerAwsApplications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#args MrscalerAws#args}
    */
    readonly args?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#name MrscalerAws#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#version MrscalerAws#version}
    */
    readonly version?: string;
}
export declare function mrscalerAwsApplicationsToTerraform(struct?: MrscalerAwsApplications | cdktf.IResolvable): any;
export declare class MrscalerAwsApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsApplications | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsApplications | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class MrscalerAwsApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsApplicationsOutputReference;
}
export interface MrscalerAwsBootstrapActionsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsBootstrapActionsFileToTerraform(struct?: MrscalerAwsBootstrapActionsFile | cdktf.IResolvable): any;
export declare class MrscalerAwsBootstrapActionsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsBootstrapActionsFile | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsBootstrapActionsFile | cdktf.IResolvable | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class MrscalerAwsBootstrapActionsFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsBootstrapActionsFileOutputReference;
}
export interface MrscalerAwsConfigurationsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsConfigurationsFileToTerraform(struct?: MrscalerAwsConfigurationsFile | cdktf.IResolvable): any;
export declare class MrscalerAwsConfigurationsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsConfigurationsFile | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsConfigurationsFile | cdktf.IResolvable | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class MrscalerAwsConfigurationsFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsConfigurationsFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsConfigurationsFileOutputReference;
}
export interface MrscalerAwsCoreEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsCoreEbsBlockDeviceToTerraform(struct?: MrscalerAwsCoreEbsBlockDevice | cdktf.IResolvable): any;
export declare class MrscalerAwsCoreEbsBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsCoreEbsBlockDevice | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsCoreEbsBlockDevice | cdktf.IResolvable | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
    private _volumesPerInstance?;
    get volumesPerInstance(): number;
    set volumesPerInstance(value: number);
    resetVolumesPerInstance(): void;
    get volumesPerInstanceInput(): number | undefined;
}
export declare class MrscalerAwsCoreEbsBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsCoreEbsBlockDeviceOutputReference;
}
export interface MrscalerAwsCoreScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsCoreScalingDownPolicyToTerraform(struct?: MrscalerAwsCoreScalingDownPolicy | cdktf.IResolvable): any;
export declare class MrscalerAwsCoreScalingDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsCoreScalingDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsCoreScalingDownPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    };
    set dimensions(value: {
        [key: string]: string;
    });
    resetDimensions(): void;
    get dimensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
}
export declare class MrscalerAwsCoreScalingDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsCoreScalingDownPolicyOutputReference;
}
export interface MrscalerAwsCoreScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsCoreScalingUpPolicyToTerraform(struct?: MrscalerAwsCoreScalingUpPolicy | cdktf.IResolvable): any;
export declare class MrscalerAwsCoreScalingUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsCoreScalingUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsCoreScalingUpPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    };
    set dimensions(value: {
        [key: string]: string;
    });
    resetDimensions(): void;
    get dimensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
}
export declare class MrscalerAwsCoreScalingUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsCoreScalingUpPolicyOutputReference;
}
export interface MrscalerAwsInstanceWeights {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_type MrscalerAws#instance_type}
    */
    readonly instanceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#weighted_capacity MrscalerAws#weighted_capacity}
    */
    readonly weightedCapacity: number;
}
export declare function mrscalerAwsInstanceWeightsToTerraform(struct?: MrscalerAwsInstanceWeights | cdktf.IResolvable): any;
export declare class MrscalerAwsInstanceWeightsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsInstanceWeights | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsInstanceWeights | cdktf.IResolvable | undefined);
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
    private _weightedCapacity?;
    get weightedCapacity(): number;
    set weightedCapacity(value: number);
    get weightedCapacityInput(): number | undefined;
}
export declare class MrscalerAwsInstanceWeightsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsInstanceWeights[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsInstanceWeightsOutputReference;
}
export interface MrscalerAwsMasterEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsMasterEbsBlockDeviceToTerraform(struct?: MrscalerAwsMasterEbsBlockDevice | cdktf.IResolvable): any;
export declare class MrscalerAwsMasterEbsBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsMasterEbsBlockDevice | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsMasterEbsBlockDevice | cdktf.IResolvable | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
    private _volumesPerInstance?;
    get volumesPerInstance(): number;
    set volumesPerInstance(value: number);
    resetVolumesPerInstance(): void;
    get volumesPerInstanceInput(): number | undefined;
}
export declare class MrscalerAwsMasterEbsBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsMasterEbsBlockDeviceOutputReference;
}
export interface MrscalerAwsProvisioningTimeout {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#timeout MrscalerAws#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#timeout_action MrscalerAws#timeout_action}
    */
    readonly timeoutAction: string;
}
export declare function mrscalerAwsProvisioningTimeoutToTerraform(struct?: MrscalerAwsProvisioningTimeoutOutputReference | MrscalerAwsProvisioningTimeout): any;
export declare class MrscalerAwsProvisioningTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MrscalerAwsProvisioningTimeout | undefined;
    set internalValue(value: MrscalerAwsProvisioningTimeout | undefined);
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _timeoutAction?;
    get timeoutAction(): string;
    set timeoutAction(value: string);
    get timeoutActionInput(): string | undefined;
}
export interface MrscalerAwsScheduledTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cron MrscalerAws#cron}
    */
    readonly cron: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#desired_capacity MrscalerAws#desired_capacity}
    */
    readonly desiredCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#instance_group_type MrscalerAws#instance_group_type}
    */
    readonly instanceGroupType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#is_enabled MrscalerAws#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_capacity MrscalerAws#max_capacity}
    */
    readonly maxCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_capacity MrscalerAws#min_capacity}
    */
    readonly minCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#task_type MrscalerAws#task_type}
    */
    readonly taskType: string;
}
export declare function mrscalerAwsScheduledTaskToTerraform(struct?: MrscalerAwsScheduledTask | cdktf.IResolvable): any;
export declare class MrscalerAwsScheduledTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsScheduledTask | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsScheduledTask | cdktf.IResolvable | undefined);
    private _cron?;
    get cron(): string;
    set cron(value: string);
    get cronInput(): string | undefined;
    private _desiredCapacity?;
    get desiredCapacity(): string;
    set desiredCapacity(value: string);
    resetDesiredCapacity(): void;
    get desiredCapacityInput(): string | undefined;
    private _instanceGroupType?;
    get instanceGroupType(): string;
    set instanceGroupType(value: string);
    get instanceGroupTypeInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxCapacity?;
    get maxCapacity(): string;
    set maxCapacity(value: string);
    resetMaxCapacity(): void;
    get maxCapacityInput(): string | undefined;
    private _minCapacity?;
    get minCapacity(): string;
    set minCapacity(value: string);
    resetMinCapacity(): void;
    get minCapacityInput(): string | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
}
export declare class MrscalerAwsScheduledTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsScheduledTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsScheduledTaskOutputReference;
}
export interface MrscalerAwsStepsFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#bucket MrscalerAws#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
}
export declare function mrscalerAwsStepsFileToTerraform(struct?: MrscalerAwsStepsFile | cdktf.IResolvable): any;
export declare class MrscalerAwsStepsFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsStepsFile | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsStepsFile | cdktf.IResolvable | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class MrscalerAwsStepsFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsStepsFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsStepsFileOutputReference;
}
export interface MrscalerAwsTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#key MrscalerAws#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#value MrscalerAws#value}
    */
    readonly value: string;
}
export declare function mrscalerAwsTagsToTerraform(struct?: MrscalerAwsTags | cdktf.IResolvable): any;
export declare class MrscalerAwsTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTags | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MrscalerAwsTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTagsOutputReference;
}
export interface MrscalerAwsTaskEbsBlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#iops MrscalerAws#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#size_in_gb MrscalerAws#size_in_gb}
    */
    readonly sizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volume_type MrscalerAws#volume_type}
    */
    readonly volumeType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#volumes_per_instance MrscalerAws#volumes_per_instance}
    */
    readonly volumesPerInstance?: number;
}
export declare function mrscalerAwsTaskEbsBlockDeviceToTerraform(struct?: MrscalerAwsTaskEbsBlockDevice | cdktf.IResolvable): any;
export declare class MrscalerAwsTaskEbsBlockDeviceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTaskEbsBlockDevice | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTaskEbsBlockDevice | cdktf.IResolvable | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
    private _volumesPerInstance?;
    get volumesPerInstance(): number;
    set volumesPerInstance(value: number);
    resetVolumesPerInstance(): void;
    get volumesPerInstanceInput(): number | undefined;
}
export declare class MrscalerAwsTaskEbsBlockDeviceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTaskEbsBlockDeviceOutputReference;
}
export interface MrscalerAwsTaskScalingDownPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsTaskScalingDownPolicyToTerraform(struct?: MrscalerAwsTaskScalingDownPolicy | cdktf.IResolvable): any;
export declare class MrscalerAwsTaskScalingDownPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTaskScalingDownPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTaskScalingDownPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    };
    set dimensions(value: {
        [key: string]: string;
    });
    resetDimensions(): void;
    get dimensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
}
export declare class MrscalerAwsTaskScalingDownPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTaskScalingDownPolicyOutputReference;
}
export interface MrscalerAwsTaskScalingUpPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#action_type MrscalerAws#action_type}
    */
    readonly actionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#adjustment MrscalerAws#adjustment}
    */
    readonly adjustment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#cooldown MrscalerAws#cooldown}
    */
    readonly cooldown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#dimensions MrscalerAws#dimensions}
    */
    readonly dimensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#max_target_capacity MrscalerAws#max_target_capacity}
    */
    readonly maxTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#maximum MrscalerAws#maximum}
    */
    readonly maximum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#min_target_capacity MrscalerAws#min_target_capacity}
    */
    readonly minTargetCapacity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#minimum MrscalerAws#minimum}
    */
    readonly minimum?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#policy_name MrscalerAws#policy_name}
    */
    readonly policyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#target MrscalerAws#target}
    */
    readonly target?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit: string;
}
export declare function mrscalerAwsTaskScalingUpPolicyToTerraform(struct?: MrscalerAwsTaskScalingUpPolicy | cdktf.IResolvable): any;
export declare class MrscalerAwsTaskScalingUpPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTaskScalingUpPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTaskScalingUpPolicy | cdktf.IResolvable | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    resetActionType(): void;
    get actionTypeInput(): string | undefined;
    private _adjustment?;
    get adjustment(): string;
    set adjustment(value: string);
    resetAdjustment(): void;
    get adjustmentInput(): string | undefined;
    private _cooldown?;
    get cooldown(): number;
    set cooldown(value: number);
    resetCooldown(): void;
    get cooldownInput(): number | undefined;
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    };
    set dimensions(value: {
        [key: string]: string;
    });
    resetDimensions(): void;
    get dimensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _maxTargetCapacity?;
    get maxTargetCapacity(): string;
    set maxTargetCapacity(value: string);
    resetMaxTargetCapacity(): void;
    get maxTargetCapacityInput(): string | undefined;
    private _maximum?;
    get maximum(): string;
    set maximum(value: string);
    resetMaximum(): void;
    get maximumInput(): string | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _minTargetCapacity?;
    get minTargetCapacity(): string;
    set minTargetCapacity(value: string);
    resetMinTargetCapacity(): void;
    get minTargetCapacityInput(): string | undefined;
    private _minimum?;
    get minimum(): string;
    set minimum(value: string);
    resetMinimum(): void;
    get minimumInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
}
export declare class MrscalerAwsTaskScalingUpPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTaskScalingUpPolicyOutputReference;
}
export interface MrscalerAwsTerminationPoliciesStatements {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#evaluation_periods MrscalerAws#evaluation_periods}
    */
    readonly evaluationPeriods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#metric_name MrscalerAws#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#namespace MrscalerAws#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#operator MrscalerAws#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#period MrscalerAws#period}
    */
    readonly period?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statistic MrscalerAws#statistic}
    */
    readonly statistic?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#threshold MrscalerAws#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#unit MrscalerAws#unit}
    */
    readonly unit?: string;
}
export declare function mrscalerAwsTerminationPoliciesStatementsToTerraform(struct?: MrscalerAwsTerminationPoliciesStatements | cdktf.IResolvable): any;
export declare class MrscalerAwsTerminationPoliciesStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTerminationPoliciesStatements | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTerminationPoliciesStatements | cdktf.IResolvable | undefined);
    private _evaluationPeriods?;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    resetEvaluationPeriods(): void;
    get evaluationPeriodsInput(): number | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    resetStatistic(): void;
    get statisticInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
}
export declare class MrscalerAwsTerminationPoliciesStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTerminationPoliciesStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTerminationPoliciesStatementsOutputReference;
}
export interface MrscalerAwsTerminationPolicies {
    /**
    * statements block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws#statements MrscalerAws#statements}
    */
    readonly statements: MrscalerAwsTerminationPoliciesStatements[] | cdktf.IResolvable;
}
export declare function mrscalerAwsTerminationPoliciesToTerraform(struct?: MrscalerAwsTerminationPolicies | cdktf.IResolvable): any;
export declare class MrscalerAwsTerminationPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MrscalerAwsTerminationPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: MrscalerAwsTerminationPolicies | cdktf.IResolvable | undefined);
    private _statements;
    get statements(): MrscalerAwsTerminationPoliciesStatementsList;
    putStatements(value: MrscalerAwsTerminationPoliciesStatements[] | cdktf.IResolvable): void;
    get statementsInput(): cdktf.IResolvable | MrscalerAwsTerminationPoliciesStatements[] | undefined;
}
export declare class MrscalerAwsTerminationPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MrscalerAwsTerminationPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MrscalerAwsTerminationPoliciesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws spotinst_mrscaler_aws}
*/
export declare class MrscalerAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_mrscaler_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/mrscaler_aws spotinst_mrscaler_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MrscalerAwsConfig
    */
    constructor(scope: Construct, id: string, config: MrscalerAwsConfig);
    private _additionalInfo?;
    get additionalInfo(): string;
    set additionalInfo(value: string);
    resetAdditionalInfo(): void;
    get additionalInfoInput(): string | undefined;
    private _additionalPrimarySecurityGroups?;
    get additionalPrimarySecurityGroups(): string[];
    set additionalPrimarySecurityGroups(value: string[]);
    resetAdditionalPrimarySecurityGroups(): void;
    get additionalPrimarySecurityGroupsInput(): string[] | undefined;
    private _additionalReplicaSecurityGroups?;
    get additionalReplicaSecurityGroups(): string[];
    set additionalReplicaSecurityGroups(value: string[]);
    resetAdditionalReplicaSecurityGroups(): void;
    get additionalReplicaSecurityGroupsInput(): string[] | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _coreDesiredCapacity?;
    get coreDesiredCapacity(): number;
    set coreDesiredCapacity(value: number);
    resetCoreDesiredCapacity(): void;
    get coreDesiredCapacityInput(): number | undefined;
    private _coreEbsOptimized?;
    get coreEbsOptimized(): boolean | cdktf.IResolvable;
    set coreEbsOptimized(value: boolean | cdktf.IResolvable);
    resetCoreEbsOptimized(): void;
    get coreEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _coreInstanceTypes?;
    get coreInstanceTypes(): string[];
    set coreInstanceTypes(value: string[]);
    resetCoreInstanceTypes(): void;
    get coreInstanceTypesInput(): string[] | undefined;
    private _coreLifecycle?;
    get coreLifecycle(): string;
    set coreLifecycle(value: string);
    resetCoreLifecycle(): void;
    get coreLifecycleInput(): string | undefined;
    private _coreMaxSize?;
    get coreMaxSize(): number;
    set coreMaxSize(value: number);
    resetCoreMaxSize(): void;
    get coreMaxSizeInput(): number | undefined;
    private _coreMinSize?;
    get coreMinSize(): number;
    set coreMinSize(value: number);
    resetCoreMinSize(): void;
    get coreMinSizeInput(): number | undefined;
    private _coreUnit?;
    get coreUnit(): string;
    set coreUnit(value: string);
    resetCoreUnit(): void;
    get coreUnitInput(): string | undefined;
    private _customAmiId?;
    get customAmiId(): string;
    set customAmiId(value: string);
    resetCustomAmiId(): void;
    get customAmiIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _ebsRootVolumeSize?;
    get ebsRootVolumeSize(): number;
    set ebsRootVolumeSize(value: number);
    resetEbsRootVolumeSize(): void;
    get ebsRootVolumeSizeInput(): number | undefined;
    private _ec2KeyName?;
    get ec2KeyName(): string;
    set ec2KeyName(value: string);
    resetEc2KeyName(): void;
    get ec2KeyNameInput(): string | undefined;
    private _exposeClusterId?;
    get exposeClusterId(): boolean | cdktf.IResolvable;
    set exposeClusterId(value: boolean | cdktf.IResolvable);
    resetExposeClusterId(): void;
    get exposeClusterIdInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobFlowRole?;
    get jobFlowRole(): string;
    set jobFlowRole(value: string);
    resetJobFlowRole(): void;
    get jobFlowRoleInput(): string | undefined;
    private _keepJobFlowAlive?;
    get keepJobFlowAlive(): boolean | cdktf.IResolvable;
    set keepJobFlowAlive(value: boolean | cdktf.IResolvable);
    resetKeepJobFlowAlive(): void;
    get keepJobFlowAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _logUri?;
    get logUri(): string;
    set logUri(value: string);
    resetLogUri(): void;
    get logUriInput(): string | undefined;
    private _managedPrimarySecurityGroup?;
    get managedPrimarySecurityGroup(): string;
    set managedPrimarySecurityGroup(value: string);
    resetManagedPrimarySecurityGroup(): void;
    get managedPrimarySecurityGroupInput(): string | undefined;
    private _managedReplicaSecurityGroup?;
    get managedReplicaSecurityGroup(): string;
    set managedReplicaSecurityGroup(value: string);
    resetManagedReplicaSecurityGroup(): void;
    get managedReplicaSecurityGroupInput(): string | undefined;
    private _masterEbsOptimized?;
    get masterEbsOptimized(): boolean | cdktf.IResolvable;
    set masterEbsOptimized(value: boolean | cdktf.IResolvable);
    resetMasterEbsOptimized(): void;
    get masterEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _masterInstanceTypes?;
    get masterInstanceTypes(): string[];
    set masterInstanceTypes(value: string[]);
    resetMasterInstanceTypes(): void;
    get masterInstanceTypesInput(): string[] | undefined;
    private _masterLifecycle?;
    get masterLifecycle(): string;
    set masterLifecycle(value: string);
    resetMasterLifecycle(): void;
    get masterLifecycleInput(): string | undefined;
    private _masterTarget?;
    get masterTarget(): number;
    set masterTarget(value: number);
    resetMasterTarget(): void;
    get masterTargetInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputClusterId(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _releaseLabel?;
    get releaseLabel(): string;
    set releaseLabel(value: string);
    resetReleaseLabel(): void;
    get releaseLabelInput(): string | undefined;
    private _repoUpgradeOnBoot?;
    get repoUpgradeOnBoot(): string;
    set repoUpgradeOnBoot(value: string);
    resetRepoUpgradeOnBoot(): void;
    get repoUpgradeOnBootInput(): string | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    resetRetries(): void;
    get retriesInput(): number | undefined;
    private _securityConfig?;
    get securityConfig(): string;
    set securityConfig(value: string);
    resetSecurityConfig(): void;
    get securityConfigInput(): string | undefined;
    private _serviceAccessSecurityGroup?;
    get serviceAccessSecurityGroup(): string;
    set serviceAccessSecurityGroup(value: string);
    resetServiceAccessSecurityGroup(): void;
    get serviceAccessSecurityGroupInput(): string | undefined;
    private _serviceRole?;
    get serviceRole(): string;
    set serviceRole(value: string);
    resetServiceRole(): void;
    get serviceRoleInput(): string | undefined;
    private _strategy?;
    get strategy(): string;
    set strategy(value: string);
    get strategyInput(): string | undefined;
    private _taskDesiredCapacity?;
    get taskDesiredCapacity(): number;
    set taskDesiredCapacity(value: number);
    resetTaskDesiredCapacity(): void;
    get taskDesiredCapacityInput(): number | undefined;
    private _taskEbsOptimized?;
    get taskEbsOptimized(): boolean | cdktf.IResolvable;
    set taskEbsOptimized(value: boolean | cdktf.IResolvable);
    resetTaskEbsOptimized(): void;
    get taskEbsOptimizedInput(): boolean | cdktf.IResolvable | undefined;
    private _taskInstanceTypes?;
    get taskInstanceTypes(): string[];
    set taskInstanceTypes(value: string[]);
    resetTaskInstanceTypes(): void;
    get taskInstanceTypesInput(): string[] | undefined;
    private _taskLifecycle?;
    get taskLifecycle(): string;
    set taskLifecycle(value: string);
    resetTaskLifecycle(): void;
    get taskLifecycleInput(): string | undefined;
    private _taskMaxSize?;
    get taskMaxSize(): number;
    set taskMaxSize(value: number);
    resetTaskMaxSize(): void;
    get taskMaxSizeInput(): number | undefined;
    private _taskMinSize?;
    get taskMinSize(): number;
    set taskMinSize(value: number);
    resetTaskMinSize(): void;
    get taskMinSizeInput(): number | undefined;
    private _taskUnit?;
    get taskUnit(): string;
    set taskUnit(value: string);
    resetTaskUnit(): void;
    get taskUnitInput(): string | undefined;
    private _terminationProtected?;
    get terminationProtected(): boolean | cdktf.IResolvable;
    set terminationProtected(value: boolean | cdktf.IResolvable);
    resetTerminationProtected(): void;
    get terminationProtectedInput(): boolean | cdktf.IResolvable | undefined;
    private _visibleToAllUsers?;
    get visibleToAllUsers(): boolean | cdktf.IResolvable;
    set visibleToAllUsers(value: boolean | cdktf.IResolvable);
    resetVisibleToAllUsers(): void;
    get visibleToAllUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _applications;
    get applications(): MrscalerAwsApplicationsList;
    putApplications(value: MrscalerAwsApplications[] | cdktf.IResolvable): void;
    resetApplications(): void;
    get applicationsInput(): cdktf.IResolvable | MrscalerAwsApplications[] | undefined;
    private _bootstrapActionsFile;
    get bootstrapActionsFile(): MrscalerAwsBootstrapActionsFileList;
    putBootstrapActionsFile(value: MrscalerAwsBootstrapActionsFile[] | cdktf.IResolvable): void;
    resetBootstrapActionsFile(): void;
    get bootstrapActionsFileInput(): cdktf.IResolvable | MrscalerAwsBootstrapActionsFile[] | undefined;
    private _configurationsFile;
    get configurationsFile(): MrscalerAwsConfigurationsFileList;
    putConfigurationsFile(value: MrscalerAwsConfigurationsFile[] | cdktf.IResolvable): void;
    resetConfigurationsFile(): void;
    get configurationsFileInput(): cdktf.IResolvable | MrscalerAwsConfigurationsFile[] | undefined;
    private _coreEbsBlockDevice;
    get coreEbsBlockDevice(): MrscalerAwsCoreEbsBlockDeviceList;
    putCoreEbsBlockDevice(value: MrscalerAwsCoreEbsBlockDevice[] | cdktf.IResolvable): void;
    resetCoreEbsBlockDevice(): void;
    get coreEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsCoreEbsBlockDevice[] | undefined;
    private _coreScalingDownPolicy;
    get coreScalingDownPolicy(): MrscalerAwsCoreScalingDownPolicyList;
    putCoreScalingDownPolicy(value: MrscalerAwsCoreScalingDownPolicy[] | cdktf.IResolvable): void;
    resetCoreScalingDownPolicy(): void;
    get coreScalingDownPolicyInput(): cdktf.IResolvable | MrscalerAwsCoreScalingDownPolicy[] | undefined;
    private _coreScalingUpPolicy;
    get coreScalingUpPolicy(): MrscalerAwsCoreScalingUpPolicyList;
    putCoreScalingUpPolicy(value: MrscalerAwsCoreScalingUpPolicy[] | cdktf.IResolvable): void;
    resetCoreScalingUpPolicy(): void;
    get coreScalingUpPolicyInput(): cdktf.IResolvable | MrscalerAwsCoreScalingUpPolicy[] | undefined;
    private _instanceWeights;
    get instanceWeights(): MrscalerAwsInstanceWeightsList;
    putInstanceWeights(value: MrscalerAwsInstanceWeights[] | cdktf.IResolvable): void;
    resetInstanceWeights(): void;
    get instanceWeightsInput(): cdktf.IResolvable | MrscalerAwsInstanceWeights[] | undefined;
    private _masterEbsBlockDevice;
    get masterEbsBlockDevice(): MrscalerAwsMasterEbsBlockDeviceList;
    putMasterEbsBlockDevice(value: MrscalerAwsMasterEbsBlockDevice[] | cdktf.IResolvable): void;
    resetMasterEbsBlockDevice(): void;
    get masterEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsMasterEbsBlockDevice[] | undefined;
    private _provisioningTimeout;
    get provisioningTimeout(): MrscalerAwsProvisioningTimeoutOutputReference;
    putProvisioningTimeout(value: MrscalerAwsProvisioningTimeout): void;
    resetProvisioningTimeout(): void;
    get provisioningTimeoutInput(): MrscalerAwsProvisioningTimeout | undefined;
    private _scheduledTask;
    get scheduledTask(): MrscalerAwsScheduledTaskList;
    putScheduledTask(value: MrscalerAwsScheduledTask[] | cdktf.IResolvable): void;
    resetScheduledTask(): void;
    get scheduledTaskInput(): cdktf.IResolvable | MrscalerAwsScheduledTask[] | undefined;
    private _stepsFile;
    get stepsFile(): MrscalerAwsStepsFileList;
    putStepsFile(value: MrscalerAwsStepsFile[] | cdktf.IResolvable): void;
    resetStepsFile(): void;
    get stepsFileInput(): cdktf.IResolvable | MrscalerAwsStepsFile[] | undefined;
    private _tags;
    get tags(): MrscalerAwsTagsList;
    putTags(value: MrscalerAwsTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MrscalerAwsTags[] | undefined;
    private _taskEbsBlockDevice;
    get taskEbsBlockDevice(): MrscalerAwsTaskEbsBlockDeviceList;
    putTaskEbsBlockDevice(value: MrscalerAwsTaskEbsBlockDevice[] | cdktf.IResolvable): void;
    resetTaskEbsBlockDevice(): void;
    get taskEbsBlockDeviceInput(): cdktf.IResolvable | MrscalerAwsTaskEbsBlockDevice[] | undefined;
    private _taskScalingDownPolicy;
    get taskScalingDownPolicy(): MrscalerAwsTaskScalingDownPolicyList;
    putTaskScalingDownPolicy(value: MrscalerAwsTaskScalingDownPolicy[] | cdktf.IResolvable): void;
    resetTaskScalingDownPolicy(): void;
    get taskScalingDownPolicyInput(): cdktf.IResolvable | MrscalerAwsTaskScalingDownPolicy[] | undefined;
    private _taskScalingUpPolicy;
    get taskScalingUpPolicy(): MrscalerAwsTaskScalingUpPolicyList;
    putTaskScalingUpPolicy(value: MrscalerAwsTaskScalingUpPolicy[] | cdktf.IResolvable): void;
    resetTaskScalingUpPolicy(): void;
    get taskScalingUpPolicyInput(): cdktf.IResolvable | MrscalerAwsTaskScalingUpPolicy[] | undefined;
    private _terminationPolicies;
    get terminationPolicies(): MrscalerAwsTerminationPoliciesList;
    putTerminationPolicies(value: MrscalerAwsTerminationPolicies[] | cdktf.IResolvable): void;
    resetTerminationPolicies(): void;
    get terminationPoliciesInput(): cdktf.IResolvable | MrscalerAwsTerminationPolicies[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
