import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiBalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#dns_cname_aliases MultaiBalancer#dns_cname_aliases}
    */
    readonly dnsCnameAliases?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#id MultaiBalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#name MultaiBalancer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#scheme MultaiBalancer#scheme}
    */
    readonly scheme?: string;
    /**
    * connection_timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#connection_timeouts MultaiBalancer#connection_timeouts}
    */
    readonly connectionTimeouts?: MultaiBalancerConnectionTimeouts;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#tags MultaiBalancer#tags}
    */
    readonly tags?: MultaiBalancerTags[] | cdktf.IResolvable;
}
export interface MultaiBalancerConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#draining MultaiBalancer#draining}
    */
    readonly draining?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#idle MultaiBalancer#idle}
    */
    readonly idle?: number;
}
export declare function multaiBalancerConnectionTimeoutsToTerraform(struct?: MultaiBalancerConnectionTimeoutsOutputReference | MultaiBalancerConnectionTimeouts): any;
export declare class MultaiBalancerConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MultaiBalancerConnectionTimeouts | undefined;
    set internalValue(value: MultaiBalancerConnectionTimeouts | undefined);
    private _draining?;
    get draining(): number;
    set draining(value: number);
    resetDraining(): void;
    get drainingInput(): number | undefined;
    private _idle?;
    get idle(): number;
    set idle(value: number);
    resetIdle(): void;
    get idleInput(): number | undefined;
}
export interface MultaiBalancerTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#key MultaiBalancer#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer#value MultaiBalancer#value}
    */
    readonly value: string;
}
export declare function multaiBalancerTagsToTerraform(struct?: MultaiBalancerTags | cdktf.IResolvable): any;
export declare class MultaiBalancerTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MultaiBalancerTags | cdktf.IResolvable | undefined;
    set internalValue(value: MultaiBalancerTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MultaiBalancerTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MultaiBalancerTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MultaiBalancerTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer spotinst_multai_balancer}
*/
export declare class MultaiBalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_balancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_balancer spotinst_multai_balancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiBalancerConfig
    */
    constructor(scope: Construct, id: string, config: MultaiBalancerConfig);
    private _dnsCnameAliases?;
    get dnsCnameAliases(): string[];
    set dnsCnameAliases(value: string[]);
    resetDnsCnameAliases(): void;
    get dnsCnameAliasesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _connectionTimeouts;
    get connectionTimeouts(): MultaiBalancerConnectionTimeoutsOutputReference;
    putConnectionTimeouts(value: MultaiBalancerConnectionTimeouts): void;
    resetConnectionTimeouts(): void;
    get connectionTimeoutsInput(): MultaiBalancerConnectionTimeouts | undefined;
    private _tags;
    get tags(): MultaiBalancerTagsList;
    putTags(value: MultaiBalancerTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiBalancerTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
