import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiListenerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#balancer_id MultaiListener#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#id MultaiListener#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#port MultaiListener#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#protocol MultaiListener#protocol}
    */
    readonly protocol: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#tags MultaiListener#tags}
    */
    readonly tags?: MultaiListenerTags[] | cdktf.IResolvable;
    /**
    * tls_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#tls_config MultaiListener#tls_config}
    */
    readonly tlsConfig?: MultaiListenerTlsConfig;
}
export interface MultaiListenerTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#key MultaiListener#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#value MultaiListener#value}
    */
    readonly value: string;
}
export declare function multaiListenerTagsToTerraform(struct?: MultaiListenerTags | cdktf.IResolvable): any;
export declare class MultaiListenerTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MultaiListenerTags | cdktf.IResolvable | undefined;
    set internalValue(value: MultaiListenerTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MultaiListenerTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MultaiListenerTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MultaiListenerTagsOutputReference;
}
export interface MultaiListenerTlsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#certificate_ids MultaiListener#certificate_ids}
    */
    readonly certificateIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#cipher_suites MultaiListener#cipher_suites}
    */
    readonly cipherSuites: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#max_version MultaiListener#max_version}
    */
    readonly maxVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#min_version MultaiListener#min_version}
    */
    readonly minVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#prefer_server_cipher_suites MultaiListener#prefer_server_cipher_suites}
    */
    readonly preferServerCipherSuites: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener#session_tickets_disabled MultaiListener#session_tickets_disabled}
    */
    readonly sessionTicketsDisabled: boolean | cdktf.IResolvable;
}
export declare function multaiListenerTlsConfigToTerraform(struct?: MultaiListenerTlsConfigOutputReference | MultaiListenerTlsConfig): any;
export declare class MultaiListenerTlsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MultaiListenerTlsConfig | undefined;
    set internalValue(value: MultaiListenerTlsConfig | undefined);
    private _certificateIds?;
    get certificateIds(): string[];
    set certificateIds(value: string[]);
    get certificateIdsInput(): string[] | undefined;
    private _cipherSuites?;
    get cipherSuites(): string[];
    set cipherSuites(value: string[]);
    get cipherSuitesInput(): string[] | undefined;
    private _maxVersion?;
    get maxVersion(): string;
    set maxVersion(value: string);
    get maxVersionInput(): string | undefined;
    private _minVersion?;
    get minVersion(): string;
    set minVersion(value: string);
    get minVersionInput(): string | undefined;
    private _preferServerCipherSuites?;
    get preferServerCipherSuites(): boolean | cdktf.IResolvable;
    set preferServerCipherSuites(value: boolean | cdktf.IResolvable);
    get preferServerCipherSuitesInput(): boolean | cdktf.IResolvable | undefined;
    private _sessionTicketsDisabled?;
    get sessionTicketsDisabled(): boolean | cdktf.IResolvable;
    set sessionTicketsDisabled(value: boolean | cdktf.IResolvable);
    get sessionTicketsDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener spotinst_multai_listener}
*/
export declare class MultaiListener extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_listener";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_listener spotinst_multai_listener} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiListenerConfig
    */
    constructor(scope: Construct, id: string, config: MultaiListenerConfig);
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    get balancerIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _tags;
    get tags(): MultaiListenerTagsList;
    putTags(value: MultaiListenerTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiListenerTags[] | undefined;
    private _tlsConfig;
    get tlsConfig(): MultaiListenerTlsConfigOutputReference;
    putTlsConfig(value: MultaiListenerTlsConfig): void;
    resetTlsConfig(): void;
    get tlsConfigInput(): MultaiListenerTlsConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
