import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiRoutingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#balancer_id MultaiRoutingRule#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#id MultaiRoutingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#listener_id MultaiRoutingRule#listener_id}
    */
    readonly listenerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#middleware_ids MultaiRoutingRule#middleware_ids}
    */
    readonly middlewareIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#priority MultaiRoutingRule#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#route MultaiRoutingRule#route}
    */
    readonly route: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#strategy MultaiRoutingRule#strategy}
    */
    readonly strategy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#target_set_ids MultaiRoutingRule#target_set_ids}
    */
    readonly targetSetIds: string[];
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#tags MultaiRoutingRule#tags}
    */
    readonly tags?: MultaiRoutingRuleTags[] | cdktf.IResolvable;
}
export interface MultaiRoutingRuleTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#key MultaiRoutingRule#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule#value MultaiRoutingRule#value}
    */
    readonly value: string;
}
export declare function multaiRoutingRuleTagsToTerraform(struct?: MultaiRoutingRuleTags | cdktf.IResolvable): any;
export declare class MultaiRoutingRuleTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MultaiRoutingRuleTags | cdktf.IResolvable | undefined;
    set internalValue(value: MultaiRoutingRuleTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MultaiRoutingRuleTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MultaiRoutingRuleTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MultaiRoutingRuleTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule spotinst_multai_routing_rule}
*/
export declare class MultaiRoutingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_routing_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_routing_rule spotinst_multai_routing_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiRoutingRuleConfig
    */
    constructor(scope: Construct, id: string, config: MultaiRoutingRuleConfig);
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    get balancerIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listenerId?;
    get listenerId(): string;
    set listenerId(value: string);
    get listenerIdInput(): string | undefined;
    private _middlewareIds?;
    get middlewareIds(): string[];
    set middlewareIds(value: string[]);
    resetMiddlewareIds(): void;
    get middlewareIdsInput(): string[] | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _route?;
    get route(): string;
    set route(value: string);
    get routeInput(): string | undefined;
    private _strategy?;
    get strategy(): string;
    set strategy(value: string);
    resetStrategy(): void;
    get strategyInput(): string | undefined;
    private _targetSetIds?;
    get targetSetIds(): string[];
    set targetSetIds(value: string[]);
    get targetSetIdsInput(): string[] | undefined;
    private _tags;
    get tags(): MultaiRoutingRuleTagsList;
    putTags(value: MultaiRoutingRuleTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiRoutingRuleTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
