import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MultaiTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#balancer_id MultaiTarget#balancer_id}
    */
    readonly balancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#host MultaiTarget#host}
    */
    readonly host: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#id MultaiTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#name MultaiTarget#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#port MultaiTarget#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#target_set_id MultaiTarget#target_set_id}
    */
    readonly targetSetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#weight MultaiTarget#weight}
    */
    readonly weight: number;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#tags MultaiTarget#tags}
    */
    readonly tags?: MultaiTargetTags[] | cdktf.IResolvable;
}
export interface MultaiTargetTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#key MultaiTarget#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target#value MultaiTarget#value}
    */
    readonly value: string;
}
export declare function multaiTargetTagsToTerraform(struct?: MultaiTargetTags | cdktf.IResolvable): any;
export declare class MultaiTargetTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MultaiTargetTags | cdktf.IResolvable | undefined;
    set internalValue(value: MultaiTargetTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MultaiTargetTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MultaiTargetTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MultaiTargetTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target spotinst_multai_target}
*/
export declare class MultaiTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_multai_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/multai_target spotinst_multai_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MultaiTargetConfig
    */
    constructor(scope: Construct, id: string, config: MultaiTargetConfig);
    private _balancerId?;
    get balancerId(): string;
    set balancerId(value: string);
    get balancerIdInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _targetSetId?;
    get targetSetId(): string;
    set targetSetId(value: string);
    get targetSetIdInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _tags;
    get tags(): MultaiTargetTagsList;
    putTags(value: MultaiTargetTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | MultaiTargetTags[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
