import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAksNpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#aks_cluster_name OceanAksNp#aks_cluster_name}
    */
    readonly aksClusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#aks_infrastructure_resource_group_name OceanAksNp#aks_infrastructure_resource_group_name}
    */
    readonly aksInfrastructureResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#aks_region OceanAksNp#aks_region}
    */
    readonly aksRegion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#aks_resource_group_name OceanAksNp#aks_resource_group_name}
    */
    readonly aksResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#availability_zones OceanAksNp#availability_zones}
    */
    readonly availabilityZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#controller_cluster_id OceanAksNp#controller_cluster_id}
    */
    readonly controllerClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#enable_node_public_ip OceanAksNp#enable_node_public_ip}
    */
    readonly enableNodePublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#fallback_to_ondemand OceanAksNp#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#id OceanAksNp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#labels OceanAksNp#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#max_count OceanAksNp#max_count}
    */
    readonly maxCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#max_pods_per_node OceanAksNp#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#min_count OceanAksNp#min_count}
    */
    readonly minCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#name OceanAksNp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#os_disk_size_gb OceanAksNp#os_disk_size_gb}
    */
    readonly osDiskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#os_disk_type OceanAksNp#os_disk_type}
    */
    readonly osDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#os_type OceanAksNp#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#spot_percentage OceanAksNp#spot_percentage}
    */
    readonly spotPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#tags OceanAksNp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * autoscaler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#autoscaler OceanAksNp#autoscaler}
    */
    readonly autoscaler?: OceanAksNpAutoscaler;
    /**
    * health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#health OceanAksNp#health}
    */
    readonly health?: OceanAksNpHealth;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#taints OceanAksNp#taints}
    */
    readonly taints?: OceanAksNpTaints[] | cdktf.IResolvable;
}
export interface OceanAksNpAutoscalerAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#max_scale_down_percentage OceanAksNp#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanAksNpAutoscalerAutoscaleDownToTerraform(struct?: OceanAksNpAutoscalerAutoscaleDownOutputReference | OceanAksNpAutoscalerAutoscaleDown): any;
export declare class OceanAksNpAutoscalerAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpAutoscalerAutoscaleDown | undefined;
    set internalValue(value: OceanAksNpAutoscalerAutoscaleDown | undefined);
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface OceanAksNpAutoscalerAutoscaleHeadroomAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#is_enabled OceanAksNp#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#percentage OceanAksNp#percentage}
    */
    readonly percentage?: number;
}
export declare function oceanAksNpAutoscalerAutoscaleHeadroomAutomaticToTerraform(struct?: OceanAksNpAutoscalerAutoscaleHeadroomAutomaticOutputReference | OceanAksNpAutoscalerAutoscaleHeadroomAutomatic): any;
export declare class OceanAksNpAutoscalerAutoscaleHeadroomAutomaticOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpAutoscalerAutoscaleHeadroomAutomatic | undefined;
    set internalValue(value: OceanAksNpAutoscalerAutoscaleHeadroomAutomatic | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface OceanAksNpAutoscalerAutoscaleHeadroom {
    /**
    * automatic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#automatic OceanAksNp#automatic}
    */
    readonly automatic?: OceanAksNpAutoscalerAutoscaleHeadroomAutomatic;
}
export declare function oceanAksNpAutoscalerAutoscaleHeadroomToTerraform(struct?: OceanAksNpAutoscalerAutoscaleHeadroomOutputReference | OceanAksNpAutoscalerAutoscaleHeadroom): any;
export declare class OceanAksNpAutoscalerAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpAutoscalerAutoscaleHeadroom | undefined;
    set internalValue(value: OceanAksNpAutoscalerAutoscaleHeadroom | undefined);
    private _automatic;
    get automatic(): OceanAksNpAutoscalerAutoscaleHeadroomAutomaticOutputReference;
    putAutomatic(value: OceanAksNpAutoscalerAutoscaleHeadroomAutomatic): void;
    resetAutomatic(): void;
    get automaticInput(): OceanAksNpAutoscalerAutoscaleHeadroomAutomatic | undefined;
}
export interface OceanAksNpAutoscalerResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#max_memory_gib OceanAksNp#max_memory_gib}
    */
    readonly maxMemoryGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#max_vcpu OceanAksNp#max_vcpu}
    */
    readonly maxVcpu?: number;
}
export declare function oceanAksNpAutoscalerResourceLimitsToTerraform(struct?: OceanAksNpAutoscalerResourceLimitsOutputReference | OceanAksNpAutoscalerResourceLimits): any;
export declare class OceanAksNpAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpAutoscalerResourceLimits | undefined;
    set internalValue(value: OceanAksNpAutoscalerResourceLimits | undefined);
    private _maxMemoryGib?;
    get maxMemoryGib(): number;
    set maxMemoryGib(value: number);
    resetMaxMemoryGib(): void;
    get maxMemoryGibInput(): number | undefined;
    private _maxVcpu?;
    get maxVcpu(): number;
    set maxVcpu(value: number);
    resetMaxVcpu(): void;
    get maxVcpuInput(): number | undefined;
}
export interface OceanAksNpAutoscaler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#autoscale_is_enabled OceanAksNp#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#autoscale_down OceanAksNp#autoscale_down}
    */
    readonly autoscaleDown?: OceanAksNpAutoscalerAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#autoscale_headroom OceanAksNp#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: OceanAksNpAutoscalerAutoscaleHeadroom;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#resource_limits OceanAksNp#resource_limits}
    */
    readonly resourceLimits?: OceanAksNpAutoscalerResourceLimits;
}
export declare function oceanAksNpAutoscalerToTerraform(struct?: OceanAksNpAutoscalerOutputReference | OceanAksNpAutoscaler): any;
export declare class OceanAksNpAutoscalerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpAutoscaler | undefined;
    set internalValue(value: OceanAksNpAutoscaler | undefined);
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleDown;
    get autoscaleDown(): OceanAksNpAutoscalerAutoscaleDownOutputReference;
    putAutoscaleDown(value: OceanAksNpAutoscalerAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): OceanAksNpAutoscalerAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): OceanAksNpAutoscalerAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: OceanAksNpAutoscalerAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): OceanAksNpAutoscalerAutoscaleHeadroom | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanAksNpAutoscalerResourceLimitsOutputReference;
    putResourceLimits(value: OceanAksNpAutoscalerResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanAksNpAutoscalerResourceLimits | undefined;
}
export interface OceanAksNpHealth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#grace_period OceanAksNp#grace_period}
    */
    readonly gracePeriod?: number;
}
export declare function oceanAksNpHealthToTerraform(struct?: OceanAksNpHealthOutputReference | OceanAksNpHealth): any;
export declare class OceanAksNpHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNpHealth | undefined;
    set internalValue(value: OceanAksNpHealth | undefined);
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
}
export interface OceanAksNpTaints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#effect OceanAksNp#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#key OceanAksNp#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np#value OceanAksNp#value}
    */
    readonly value: string;
}
export declare function oceanAksNpTaintsToTerraform(struct?: OceanAksNpTaints | cdktf.IResolvable): any;
export declare class OceanAksNpTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksNpTaints | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksNpTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class OceanAksNpTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksNpTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksNpTaintsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np spotinst_ocean_aks_np}
*/
export declare class OceanAksNp extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aks_np";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_np spotinst_ocean_aks_np} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAksNpConfig
    */
    constructor(scope: Construct, id: string, config: OceanAksNpConfig);
    private _aksClusterName?;
    get aksClusterName(): string;
    set aksClusterName(value: string);
    get aksClusterNameInput(): string | undefined;
    private _aksInfrastructureResourceGroupName?;
    get aksInfrastructureResourceGroupName(): string;
    set aksInfrastructureResourceGroupName(value: string);
    get aksInfrastructureResourceGroupNameInput(): string | undefined;
    private _aksRegion?;
    get aksRegion(): string;
    set aksRegion(value: string);
    get aksRegionInput(): string | undefined;
    private _aksResourceGroupName?;
    get aksResourceGroupName(): string;
    set aksResourceGroupName(value: string);
    get aksResourceGroupNameInput(): string | undefined;
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    resetAvailabilityZones(): void;
    get availabilityZonesInput(): string[] | undefined;
    private _controllerClusterId?;
    get controllerClusterId(): string;
    set controllerClusterId(value: string);
    resetControllerClusterId(): void;
    get controllerClusterIdInput(): string | undefined;
    private _enableNodePublicIp?;
    get enableNodePublicIp(): boolean | cdktf.IResolvable;
    set enableNodePublicIp(value: boolean | cdktf.IResolvable);
    resetEnableNodePublicIp(): void;
    get enableNodePublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxCount?;
    get maxCount(): number;
    set maxCount(value: number);
    resetMaxCount(): void;
    get maxCountInput(): number | undefined;
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _minCount?;
    get minCount(): number;
    set minCount(value: number);
    resetMinCount(): void;
    get minCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osDiskSizeGb?;
    get osDiskSizeGb(): number;
    set osDiskSizeGb(value: number);
    resetOsDiskSizeGb(): void;
    get osDiskSizeGbInput(): number | undefined;
    private _osDiskType?;
    get osDiskType(): string;
    set osDiskType(value: string);
    resetOsDiskType(): void;
    get osDiskTypeInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _autoscaler;
    get autoscaler(): OceanAksNpAutoscalerOutputReference;
    putAutoscaler(value: OceanAksNpAutoscaler): void;
    resetAutoscaler(): void;
    get autoscalerInput(): OceanAksNpAutoscaler | undefined;
    private _health;
    get health(): OceanAksNpHealthOutputReference;
    putHealth(value: OceanAksNpHealth): void;
    resetHealth(): void;
    get healthInput(): OceanAksNpHealth | undefined;
    private _taints;
    get taints(): OceanAksNpTaintsList;
    putTaints(value: OceanAksNpTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | OceanAksNpTaints[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
