import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAksVirtualNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#id OceanAksVirtualNodeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#name OceanAksVirtualNodeGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#ocean_id OceanAksVirtualNodeGroup#ocean_id}
    */
    readonly oceanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#zones OceanAksVirtualNodeGroup#zones}
    */
    readonly zones?: string[];
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#autoscale OceanAksVirtualNodeGroup#autoscale}
    */
    readonly autoscale?: OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable;
    /**
    * label block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#label OceanAksVirtualNodeGroup#label}
    */
    readonly label?: OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable;
    /**
    * launch_specification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#launch_specification OceanAksVirtualNodeGroup#launch_specification}
    */
    readonly launchSpecification?: OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#resource_limits OceanAksVirtualNodeGroup#resource_limits}
    */
    readonly resourceLimits?: OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable;
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#taint OceanAksVirtualNodeGroup#taint}
    */
    readonly taint?: OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable;
}
export interface OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#cpu_per_unit OceanAksVirtualNodeGroup#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#gpu_per_unit OceanAksVirtualNodeGroup#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#memory_per_unit OceanAksVirtualNodeGroup#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#num_of_units OceanAksVirtualNodeGroup#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomToTerraform(struct?: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom | cdktf.IResolvable | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    get numOfUnitsInput(): number | undefined;
}
export declare class OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomOutputReference;
}
export interface OceanAksVirtualNodeGroupAutoscale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#auto_headroom_percentage OceanAksVirtualNodeGroup#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#autoscale_headroom OceanAksVirtualNodeGroup#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom[] | cdktf.IResolvable;
}
export declare function oceanAksVirtualNodeGroupAutoscaleToTerraform(struct?: OceanAksVirtualNodeGroupAutoscale | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupAutoscale | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupAutoscale | cdktf.IResolvable | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroomList;
    putAutoscaleHeadroom(value: OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom[] | cdktf.IResolvable): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupAutoscaleAutoscaleHeadroom[] | undefined;
}
export declare class OceanAksVirtualNodeGroupAutoscaleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupAutoscaleOutputReference;
}
export interface OceanAksVirtualNodeGroupLabel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value?: string;
}
export declare function oceanAksVirtualNodeGroupLabelToTerraform(struct?: OceanAksVirtualNodeGroupLabel | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupLabelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupLabel | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupLabel | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanAksVirtualNodeGroupLabelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupLabelOutputReference;
}
export interface OceanAksVirtualNodeGroupLaunchSpecificationOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#size_gb OceanAksVirtualNodeGroup#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#type OceanAksVirtualNodeGroup#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#utilize_ephemeral_storage OceanAksVirtualNodeGroup#utilize_ephemeral_storage}
    */
    readonly utilizeEphemeralStorage?: boolean | cdktf.IResolvable;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationOsDiskToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecificationOsDiskOutputReference | OceanAksVirtualNodeGroupLaunchSpecificationOsDisk): any;
export declare class OceanAksVirtualNodeGroupLaunchSpecificationOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksVirtualNodeGroupLaunchSpecificationOsDisk | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupLaunchSpecificationOsDisk | undefined);
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _utilizeEphemeralStorage?;
    get utilizeEphemeralStorage(): boolean | cdktf.IResolvable;
    set utilizeEphemeralStorage(value: boolean | cdktf.IResolvable);
    resetUtilizeEphemeralStorage(): void;
    get utilizeEphemeralStorageInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanAksVirtualNodeGroupLaunchSpecificationTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value?: string;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationTagToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecificationTag | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupLaunchSpecificationTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupLaunchSpecificationTag | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupLaunchSpecificationTag | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanAksVirtualNodeGroupLaunchSpecificationTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupLaunchSpecificationTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupLaunchSpecificationTagOutputReference;
}
export interface OceanAksVirtualNodeGroupLaunchSpecification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#max_pods OceanAksVirtualNodeGroup#max_pods}
    */
    readonly maxPods?: number;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#os_disk OceanAksVirtualNodeGroup#os_disk}
    */
    readonly osDisk?: OceanAksVirtualNodeGroupLaunchSpecificationOsDisk;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#tag OceanAksVirtualNodeGroup#tag}
    */
    readonly tag?: OceanAksVirtualNodeGroupLaunchSpecificationTag[] | cdktf.IResolvable;
}
export declare function oceanAksVirtualNodeGroupLaunchSpecificationToTerraform(struct?: OceanAksVirtualNodeGroupLaunchSpecification | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupLaunchSpecificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupLaunchSpecification | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupLaunchSpecification | cdktf.IResolvable | undefined);
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _osDisk;
    get osDisk(): OceanAksVirtualNodeGroupLaunchSpecificationOsDiskOutputReference;
    putOsDisk(value: OceanAksVirtualNodeGroupLaunchSpecificationOsDisk): void;
    resetOsDisk(): void;
    get osDiskInput(): OceanAksVirtualNodeGroupLaunchSpecificationOsDisk | undefined;
    private _tag;
    get tag(): OceanAksVirtualNodeGroupLaunchSpecificationTagList;
    putTag(value: OceanAksVirtualNodeGroupLaunchSpecificationTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupLaunchSpecificationTag[] | undefined;
}
export declare class OceanAksVirtualNodeGroupLaunchSpecificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupLaunchSpecificationOutputReference;
}
export interface OceanAksVirtualNodeGroupResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#max_instance_count OceanAksVirtualNodeGroup#max_instance_count}
    */
    readonly maxInstanceCount?: number;
}
export declare function oceanAksVirtualNodeGroupResourceLimitsToTerraform(struct?: OceanAksVirtualNodeGroupResourceLimits | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupResourceLimits | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupResourceLimits | cdktf.IResolvable | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
}
export declare class OceanAksVirtualNodeGroupResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupResourceLimitsOutputReference;
}
export interface OceanAksVirtualNodeGroupTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#effect OceanAksVirtualNodeGroup#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#key OceanAksVirtualNodeGroup#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group#value OceanAksVirtualNodeGroup#value}
    */
    readonly value: string;
}
export declare function oceanAksVirtualNodeGroupTaintToTerraform(struct?: OceanAksVirtualNodeGroupTaint | cdktf.IResolvable): any;
export declare class OceanAksVirtualNodeGroupTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVirtualNodeGroupTaint | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVirtualNodeGroupTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class OceanAksVirtualNodeGroupTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVirtualNodeGroupTaintOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group spotinst_ocean_aks_virtual_node_group}
*/
export declare class OceanAksVirtualNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aks_virtual_node_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks_virtual_node_group spotinst_ocean_aks_virtual_node_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAksVirtualNodeGroupConfig
    */
    constructor(scope: Construct, id: string, config: OceanAksVirtualNodeGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _autoscale;
    get autoscale(): OceanAksVirtualNodeGroupAutoscaleList;
    putAutoscale(value: OceanAksVirtualNodeGroupAutoscale[] | cdktf.IResolvable): void;
    resetAutoscale(): void;
    get autoscaleInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupAutoscale[] | undefined;
    private _label;
    get label(): OceanAksVirtualNodeGroupLabelList;
    putLabel(value: OceanAksVirtualNodeGroupLabel[] | cdktf.IResolvable): void;
    resetLabel(): void;
    get labelInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupLabel[] | undefined;
    private _launchSpecification;
    get launchSpecification(): OceanAksVirtualNodeGroupLaunchSpecificationList;
    putLaunchSpecification(value: OceanAksVirtualNodeGroupLaunchSpecification[] | cdktf.IResolvable): void;
    resetLaunchSpecification(): void;
    get launchSpecificationInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupLaunchSpecification[] | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanAksVirtualNodeGroupResourceLimitsList;
    putResourceLimits(value: OceanAksVirtualNodeGroupResourceLimits[] | cdktf.IResolvable): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupResourceLimits[] | undefined;
    private _taint;
    get taint(): OceanAksVirtualNodeGroupTaintList;
    putTaint(value: OceanAksVirtualNodeGroupTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | OceanAksVirtualNodeGroupTaint[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
