import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#acd_identifier OceanAks#acd_identifier}
    */
    readonly acdIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#aks_name OceanAks#aks_name}
    */
    readonly aksName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#aks_resource_group_name OceanAks#aks_resource_group_name}
    */
    readonly aksResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#controller_cluster_id OceanAks#controller_cluster_id}
    */
    readonly controllerClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#custom_data OceanAks#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#id OceanAks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#max_pods OceanAks#max_pods}
    */
    readonly maxPods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_group_name OceanAks#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#ssh_public_key OceanAks#ssh_public_key}
    */
    readonly sshPublicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#user_name OceanAks#user_name}
    */
    readonly userName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#zones OceanAks#zones}
    */
    readonly zones?: string[];
    /**
    * autoscaler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#autoscaler OceanAks#autoscaler}
    */
    readonly autoscaler?: OceanAksAutoscaler;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#extension OceanAks#extension}
    */
    readonly extension?: OceanAksExtension[] | cdktf.IResolvable;
    /**
    * health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#health OceanAks#health}
    */
    readonly health?: OceanAksHealth;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#image OceanAks#image}
    */
    readonly image?: OceanAksImage[] | cdktf.IResolvable;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#load_balancer OceanAks#load_balancer}
    */
    readonly loadBalancer?: OceanAksLoadBalancer[] | cdktf.IResolvable;
    /**
    * managed_service_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#managed_service_identity OceanAks#managed_service_identity}
    */
    readonly managedServiceIdentity?: OceanAksManagedServiceIdentity[] | cdktf.IResolvable;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#network OceanAks#network}
    */
    readonly network?: OceanAksNetwork;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#os_disk OceanAks#os_disk}
    */
    readonly osDisk?: OceanAksOsDisk;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#strategy OceanAks#strategy}
    */
    readonly strategy?: OceanAksStrategy[] | cdktf.IResolvable;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#tag OceanAks#tag}
    */
    readonly tag?: OceanAksTag[] | cdktf.IResolvable;
    /**
    * vm_sizes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#vm_sizes OceanAks#vm_sizes}
    */
    readonly vmSizes?: OceanAksVmSizes[] | cdktf.IResolvable;
}
export interface OceanAksAutoscalerAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#max_scale_down_percentage OceanAks#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanAksAutoscalerAutoscaleDownToTerraform(struct?: OceanAksAutoscalerAutoscaleDownOutputReference | OceanAksAutoscalerAutoscaleDown): any;
export declare class OceanAksAutoscalerAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksAutoscalerAutoscaleDown | undefined;
    set internalValue(value: OceanAksAutoscalerAutoscaleDown | undefined);
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export interface OceanAksAutoscalerAutoscaleHeadroomAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#is_enabled OceanAks#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#percentage OceanAks#percentage}
    */
    readonly percentage?: number;
}
export declare function oceanAksAutoscalerAutoscaleHeadroomAutomaticToTerraform(struct?: OceanAksAutoscalerAutoscaleHeadroomAutomaticOutputReference | OceanAksAutoscalerAutoscaleHeadroomAutomatic): any;
export declare class OceanAksAutoscalerAutoscaleHeadroomAutomaticOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksAutoscalerAutoscaleHeadroomAutomatic | undefined;
    set internalValue(value: OceanAksAutoscalerAutoscaleHeadroomAutomatic | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface OceanAksAutoscalerAutoscaleHeadroom {
    /**
    * automatic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#automatic OceanAks#automatic}
    */
    readonly automatic?: OceanAksAutoscalerAutoscaleHeadroomAutomatic;
}
export declare function oceanAksAutoscalerAutoscaleHeadroomToTerraform(struct?: OceanAksAutoscalerAutoscaleHeadroomOutputReference | OceanAksAutoscalerAutoscaleHeadroom): any;
export declare class OceanAksAutoscalerAutoscaleHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksAutoscalerAutoscaleHeadroom | undefined;
    set internalValue(value: OceanAksAutoscalerAutoscaleHeadroom | undefined);
    private _automatic;
    get automatic(): OceanAksAutoscalerAutoscaleHeadroomAutomaticOutputReference;
    putAutomatic(value: OceanAksAutoscalerAutoscaleHeadroomAutomatic): void;
    resetAutomatic(): void;
    get automaticInput(): OceanAksAutoscalerAutoscaleHeadroomAutomatic | undefined;
}
export interface OceanAksAutoscalerResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#max_memory_gib OceanAks#max_memory_gib}
    */
    readonly maxMemoryGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#max_vcpu OceanAks#max_vcpu}
    */
    readonly maxVcpu?: number;
}
export declare function oceanAksAutoscalerResourceLimitsToTerraform(struct?: OceanAksAutoscalerResourceLimitsOutputReference | OceanAksAutoscalerResourceLimits): any;
export declare class OceanAksAutoscalerResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksAutoscalerResourceLimits | undefined;
    set internalValue(value: OceanAksAutoscalerResourceLimits | undefined);
    private _maxMemoryGib?;
    get maxMemoryGib(): number;
    set maxMemoryGib(value: number);
    resetMaxMemoryGib(): void;
    get maxMemoryGibInput(): number | undefined;
    private _maxVcpu?;
    get maxVcpu(): number;
    set maxVcpu(value: number);
    resetMaxVcpu(): void;
    get maxVcpuInput(): number | undefined;
}
export interface OceanAksAutoscaler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#autoscale_is_enabled OceanAks#autoscale_is_enabled}
    */
    readonly autoscaleIsEnabled?: boolean | cdktf.IResolvable;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#autoscale_down OceanAks#autoscale_down}
    */
    readonly autoscaleDown?: OceanAksAutoscalerAutoscaleDown;
    /**
    * autoscale_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#autoscale_headroom OceanAks#autoscale_headroom}
    */
    readonly autoscaleHeadroom?: OceanAksAutoscalerAutoscaleHeadroom;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_limits OceanAks#resource_limits}
    */
    readonly resourceLimits?: OceanAksAutoscalerResourceLimits;
}
export declare function oceanAksAutoscalerToTerraform(struct?: OceanAksAutoscalerOutputReference | OceanAksAutoscaler): any;
export declare class OceanAksAutoscalerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksAutoscaler | undefined;
    set internalValue(value: OceanAksAutoscaler | undefined);
    private _autoscaleIsEnabled?;
    get autoscaleIsEnabled(): boolean | cdktf.IResolvable;
    set autoscaleIsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoscaleIsEnabled(): void;
    get autoscaleIsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoscaleDown;
    get autoscaleDown(): OceanAksAutoscalerAutoscaleDownOutputReference;
    putAutoscaleDown(value: OceanAksAutoscalerAutoscaleDown): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): OceanAksAutoscalerAutoscaleDown | undefined;
    private _autoscaleHeadroom;
    get autoscaleHeadroom(): OceanAksAutoscalerAutoscaleHeadroomOutputReference;
    putAutoscaleHeadroom(value: OceanAksAutoscalerAutoscaleHeadroom): void;
    resetAutoscaleHeadroom(): void;
    get autoscaleHeadroomInput(): OceanAksAutoscalerAutoscaleHeadroom | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanAksAutoscalerResourceLimitsOutputReference;
    putResourceLimits(value: OceanAksAutoscalerResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanAksAutoscalerResourceLimits | undefined;
}
export interface OceanAksExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#api_version OceanAks#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#minor_version_auto_upgrade OceanAks#minor_version_auto_upgrade}
    */
    readonly minorVersionAutoUpgrade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#publisher OceanAks#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#type OceanAks#type}
    */
    readonly type?: string;
}
export declare function oceanAksExtensionToTerraform(struct?: OceanAksExtension | cdktf.IResolvable): any;
export declare class OceanAksExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksExtension | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksExtension | cdktf.IResolvable | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _minorVersionAutoUpgrade?;
    get minorVersionAutoUpgrade(): boolean | cdktf.IResolvable;
    set minorVersionAutoUpgrade(value: boolean | cdktf.IResolvable);
    resetMinorVersionAutoUpgrade(): void;
    get minorVersionAutoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class OceanAksExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksExtensionOutputReference;
}
export interface OceanAksHealth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#grace_period OceanAks#grace_period}
    */
    readonly gracePeriod?: number;
}
export declare function oceanAksHealthToTerraform(struct?: OceanAksHealthOutputReference | OceanAksHealth): any;
export declare class OceanAksHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksHealth | undefined;
    set internalValue(value: OceanAksHealth | undefined);
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
}
export interface OceanAksImageMarketplace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#offer OceanAks#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#publisher OceanAks#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#sku OceanAks#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#version OceanAks#version}
    */
    readonly version?: string;
}
export declare function oceanAksImageMarketplaceToTerraform(struct?: OceanAksImageMarketplace | cdktf.IResolvable): any;
export declare class OceanAksImageMarketplaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksImageMarketplace | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksImageMarketplace | cdktf.IResolvable | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class OceanAksImageMarketplaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksImageMarketplace[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksImageMarketplaceOutputReference;
}
export interface OceanAksImage {
    /**
    * marketplace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#marketplace OceanAks#marketplace}
    */
    readonly marketplace?: OceanAksImageMarketplace[] | cdktf.IResolvable;
}
export declare function oceanAksImageToTerraform(struct?: OceanAksImage | cdktf.IResolvable): any;
export declare class OceanAksImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksImage | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksImage | cdktf.IResolvable | undefined);
    private _marketplace;
    get marketplace(): OceanAksImageMarketplaceList;
    putMarketplace(value: OceanAksImageMarketplace[] | cdktf.IResolvable): void;
    resetMarketplace(): void;
    get marketplaceInput(): cdktf.IResolvable | OceanAksImageMarketplace[] | undefined;
}
export declare class OceanAksImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksImageOutputReference;
}
export interface OceanAksLoadBalancer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#backend_pool_names OceanAks#backend_pool_names}
    */
    readonly backendPoolNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#load_balancer_sku OceanAks#load_balancer_sku}
    */
    readonly loadBalancerSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_group_name OceanAks#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#type OceanAks#type}
    */
    readonly type?: string;
}
export declare function oceanAksLoadBalancerToTerraform(struct?: OceanAksLoadBalancer | cdktf.IResolvable): any;
export declare class OceanAksLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksLoadBalancer | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksLoadBalancer | cdktf.IResolvable | undefined);
    private _backendPoolNames?;
    get backendPoolNames(): string[];
    set backendPoolNames(value: string[]);
    resetBackendPoolNames(): void;
    get backendPoolNamesInput(): string[] | undefined;
    private _loadBalancerSku?;
    get loadBalancerSku(): string;
    set loadBalancerSku(value: string);
    resetLoadBalancerSku(): void;
    get loadBalancerSkuInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class OceanAksLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksLoadBalancer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksLoadBalancerOutputReference;
}
export interface OceanAksManagedServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_group_name OceanAks#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function oceanAksManagedServiceIdentityToTerraform(struct?: OceanAksManagedServiceIdentity | cdktf.IResolvable): any;
export declare class OceanAksManagedServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksManagedServiceIdentity | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksManagedServiceIdentity | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
}
export declare class OceanAksManagedServiceIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksManagedServiceIdentity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksManagedServiceIdentityOutputReference;
}
export interface OceanAksNetworkNetworkInterfaceAdditionalIpConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#private_ip_version OceanAks#private_ip_version}
    */
    readonly privateIpVersion?: string;
}
export declare function oceanAksNetworkNetworkInterfaceAdditionalIpConfigToTerraform(struct?: OceanAksNetworkNetworkInterfaceAdditionalIpConfig | cdktf.IResolvable): any;
export declare class OceanAksNetworkNetworkInterfaceAdditionalIpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksNetworkNetworkInterfaceAdditionalIpConfig | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksNetworkNetworkInterfaceAdditionalIpConfig | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _privateIpVersion?;
    get privateIpVersion(): string;
    set privateIpVersion(value: string);
    resetPrivateIpVersion(): void;
    get privateIpVersionInput(): string | undefined;
}
export declare class OceanAksNetworkNetworkInterfaceAdditionalIpConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksNetworkNetworkInterfaceAdditionalIpConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksNetworkNetworkInterfaceAdditionalIpConfigOutputReference;
}
export interface OceanAksNetworkNetworkInterfaceSecurityGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#name OceanAks#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_group_name OceanAks#resource_group_name}
    */
    readonly resourceGroupName?: string;
}
export declare function oceanAksNetworkNetworkInterfaceSecurityGroupToTerraform(struct?: OceanAksNetworkNetworkInterfaceSecurityGroupOutputReference | OceanAksNetworkNetworkInterfaceSecurityGroup): any;
export declare class OceanAksNetworkNetworkInterfaceSecurityGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNetworkNetworkInterfaceSecurityGroup | undefined;
    set internalValue(value: OceanAksNetworkNetworkInterfaceSecurityGroup | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
}
export interface OceanAksNetworkNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#assign_public_ip OceanAks#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#is_primary OceanAks#is_primary}
    */
    readonly isPrimary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#subnet_name OceanAks#subnet_name}
    */
    readonly subnetName?: string;
    /**
    * additional_ip_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#additional_ip_config OceanAks#additional_ip_config}
    */
    readonly additionalIpConfig?: OceanAksNetworkNetworkInterfaceAdditionalIpConfig[] | cdktf.IResolvable;
    /**
    * security_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#security_group OceanAks#security_group}
    */
    readonly securityGroup?: OceanAksNetworkNetworkInterfaceSecurityGroup;
}
export declare function oceanAksNetworkNetworkInterfaceToTerraform(struct?: OceanAksNetworkNetworkInterface | cdktf.IResolvable): any;
export declare class OceanAksNetworkNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksNetworkNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksNetworkNetworkInterface | cdktf.IResolvable | undefined);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _isPrimary?;
    get isPrimary(): boolean | cdktf.IResolvable;
    set isPrimary(value: boolean | cdktf.IResolvable);
    resetIsPrimary(): void;
    get isPrimaryInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    resetSubnetName(): void;
    get subnetNameInput(): string | undefined;
    private _additionalIpConfig;
    get additionalIpConfig(): OceanAksNetworkNetworkInterfaceAdditionalIpConfigList;
    putAdditionalIpConfig(value: OceanAksNetworkNetworkInterfaceAdditionalIpConfig[] | cdktf.IResolvable): void;
    resetAdditionalIpConfig(): void;
    get additionalIpConfigInput(): cdktf.IResolvable | OceanAksNetworkNetworkInterfaceAdditionalIpConfig[] | undefined;
    private _securityGroup;
    get securityGroup(): OceanAksNetworkNetworkInterfaceSecurityGroupOutputReference;
    putSecurityGroup(value: OceanAksNetworkNetworkInterfaceSecurityGroup): void;
    resetSecurityGroup(): void;
    get securityGroupInput(): OceanAksNetworkNetworkInterfaceSecurityGroup | undefined;
}
export declare class OceanAksNetworkNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksNetworkNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksNetworkNetworkInterfaceOutputReference;
}
export interface OceanAksNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#resource_group_name OceanAks#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#virtual_network_name OceanAks#virtual_network_name}
    */
    readonly virtualNetworkName?: string;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#network_interface OceanAks#network_interface}
    */
    readonly networkInterface?: OceanAksNetworkNetworkInterface[] | cdktf.IResolvable;
}
export declare function oceanAksNetworkToTerraform(struct?: OceanAksNetworkOutputReference | OceanAksNetwork): any;
export declare class OceanAksNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksNetwork | undefined;
    set internalValue(value: OceanAksNetwork | undefined);
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    resetVirtualNetworkName(): void;
    get virtualNetworkNameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): OceanAksNetworkNetworkInterfaceList;
    putNetworkInterface(value: OceanAksNetworkNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | OceanAksNetworkNetworkInterface[] | undefined;
}
export interface OceanAksOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#size_gb OceanAks#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#type OceanAks#type}
    */
    readonly type?: string;
}
export declare function oceanAksOsDiskToTerraform(struct?: OceanAksOsDiskOutputReference | OceanAksOsDisk): any;
export declare class OceanAksOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAksOsDisk | undefined;
    set internalValue(value: OceanAksOsDisk | undefined);
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface OceanAksStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#fallback_to_ondemand OceanAks#fallback_to_ondemand}
    */
    readonly fallbackToOndemand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#spot_percentage OceanAks#spot_percentage}
    */
    readonly spotPercentage?: number;
}
export declare function oceanAksStrategyToTerraform(struct?: OceanAksStrategy | cdktf.IResolvable): any;
export declare class OceanAksStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksStrategy | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksStrategy | cdktf.IResolvable | undefined);
    private _fallbackToOndemand?;
    get fallbackToOndemand(): boolean | cdktf.IResolvable;
    set fallbackToOndemand(value: boolean | cdktf.IResolvable);
    resetFallbackToOndemand(): void;
    get fallbackToOndemandInput(): boolean | cdktf.IResolvable | undefined;
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
}
export declare class OceanAksStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksStrategy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksStrategyOutputReference;
}
export interface OceanAksTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#key OceanAks#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#value OceanAks#value}
    */
    readonly value?: string;
}
export declare function oceanAksTagToTerraform(struct?: OceanAksTag | cdktf.IResolvable): any;
export declare class OceanAksTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksTag | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksTag | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanAksTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksTagOutputReference;
}
export interface OceanAksVmSizes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks#whitelist OceanAks#whitelist}
    */
    readonly whitelist?: string[];
}
export declare function oceanAksVmSizesToTerraform(struct?: OceanAksVmSizes | cdktf.IResolvable): any;
export declare class OceanAksVmSizesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAksVmSizes | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAksVmSizes | cdktf.IResolvable | undefined);
    private _whitelist?;
    get whitelist(): string[];
    set whitelist(value: string[]);
    resetWhitelist(): void;
    get whitelistInput(): string[] | undefined;
}
export declare class OceanAksVmSizesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAksVmSizes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAksVmSizesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks spotinst_ocean_aks}
*/
export declare class OceanAks extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aks spotinst_ocean_aks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAksConfig
    */
    constructor(scope: Construct, id: string, config: OceanAksConfig);
    private _acdIdentifier?;
    get acdIdentifier(): string;
    set acdIdentifier(value: string);
    get acdIdentifierInput(): string | undefined;
    private _aksName?;
    get aksName(): string;
    set aksName(value: string);
    get aksNameInput(): string | undefined;
    private _aksResourceGroupName?;
    get aksResourceGroupName(): string;
    set aksResourceGroupName(value: string);
    get aksResourceGroupNameInput(): string | undefined;
    private _controllerClusterId?;
    get controllerClusterId(): string;
    set controllerClusterId(value: string);
    resetControllerClusterId(): void;
    get controllerClusterIdInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    get sshPublicKeyInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _autoscaler;
    get autoscaler(): OceanAksAutoscalerOutputReference;
    putAutoscaler(value: OceanAksAutoscaler): void;
    resetAutoscaler(): void;
    get autoscalerInput(): OceanAksAutoscaler | undefined;
    private _extension;
    get extension(): OceanAksExtensionList;
    putExtension(value: OceanAksExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | OceanAksExtension[] | undefined;
    private _health;
    get health(): OceanAksHealthOutputReference;
    putHealth(value: OceanAksHealth): void;
    resetHealth(): void;
    get healthInput(): OceanAksHealth | undefined;
    private _image;
    get image(): OceanAksImageList;
    putImage(value: OceanAksImage[] | cdktf.IResolvable): void;
    resetImage(): void;
    get imageInput(): cdktf.IResolvable | OceanAksImage[] | undefined;
    private _loadBalancer;
    get loadBalancer(): OceanAksLoadBalancerList;
    putLoadBalancer(value: OceanAksLoadBalancer[] | cdktf.IResolvable): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): cdktf.IResolvable | OceanAksLoadBalancer[] | undefined;
    private _managedServiceIdentity;
    get managedServiceIdentity(): OceanAksManagedServiceIdentityList;
    putManagedServiceIdentity(value: OceanAksManagedServiceIdentity[] | cdktf.IResolvable): void;
    resetManagedServiceIdentity(): void;
    get managedServiceIdentityInput(): cdktf.IResolvable | OceanAksManagedServiceIdentity[] | undefined;
    private _network;
    get network(): OceanAksNetworkOutputReference;
    putNetwork(value: OceanAksNetwork): void;
    resetNetwork(): void;
    get networkInput(): OceanAksNetwork | undefined;
    private _osDisk;
    get osDisk(): OceanAksOsDiskOutputReference;
    putOsDisk(value: OceanAksOsDisk): void;
    resetOsDisk(): void;
    get osDiskInput(): OceanAksOsDisk | undefined;
    private _strategy;
    get strategy(): OceanAksStrategyList;
    putStrategy(value: OceanAksStrategy[] | cdktf.IResolvable): void;
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | OceanAksStrategy[] | undefined;
    private _tag;
    get tag(): OceanAksTagList;
    putTag(value: OceanAksTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | OceanAksTag[] | undefined;
    private _vmSizes;
    get vmSizes(): OceanAksVmSizesList;
    putVmSizes(value: OceanAksVmSizes[] | cdktf.IResolvable): void;
    resetVmSizes(): void;
    get vmSizesInput(): cdktf.IResolvable | OceanAksVmSizes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
