import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanAwsLaunchSpecConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#associate_public_ip_address OceanAwsLaunchSpec#associate_public_ip_address}
    */
    readonly associatePublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#iam_instance_profile OceanAwsLaunchSpec#iam_instance_profile}
    */
    readonly iamInstanceProfile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#id OceanAwsLaunchSpec#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#image_id OceanAwsLaunchSpec#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#instance_types OceanAwsLaunchSpec#instance_types}
    */
    readonly instanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#name OceanAwsLaunchSpec#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#ocean_id OceanAwsLaunchSpec#ocean_id}
    */
    readonly oceanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#preferred_spot_types OceanAwsLaunchSpec#preferred_spot_types}
    */
    readonly preferredSpotTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#restrict_scale_down OceanAwsLaunchSpec#restrict_scale_down}
    */
    readonly restrictScaleDown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#root_volume_size OceanAwsLaunchSpec#root_volume_size}
    */
    readonly rootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#security_groups OceanAwsLaunchSpec#security_groups}
    */
    readonly securityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#subnet_ids OceanAwsLaunchSpec#subnet_ids}
    */
    readonly subnetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#user_data OceanAwsLaunchSpec#user_data}
    */
    readonly userData?: string;
    /**
    * autoscale_down block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#autoscale_down OceanAwsLaunchSpec#autoscale_down}
    */
    readonly autoscaleDown?: OceanAwsLaunchSpecAutoscaleDown[] | cdktf.IResolvable;
    /**
    * autoscale_headrooms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#autoscale_headrooms OceanAwsLaunchSpec#autoscale_headrooms}
    */
    readonly autoscaleHeadrooms?: OceanAwsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * autoscale_headrooms_automatic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#autoscale_headrooms_automatic OceanAwsLaunchSpec#autoscale_headrooms_automatic}
    */
    readonly autoscaleHeadroomsAutomatic?: OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    /**
    * block_device_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#block_device_mappings OceanAwsLaunchSpec#block_device_mappings}
    */
    readonly blockDeviceMappings?: OceanAwsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * create_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#create_options OceanAwsLaunchSpec#create_options}
    */
    readonly createOptions?: OceanAwsLaunchSpecCreateOptions;
    /**
    * delete_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#delete_options OceanAwsLaunchSpec#delete_options}
    */
    readonly deleteOptions?: OceanAwsLaunchSpecDeleteOptions;
    /**
    * elastic_ip_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#elastic_ip_pool OceanAwsLaunchSpec#elastic_ip_pool}
    */
    readonly elasticIpPool?: OceanAwsLaunchSpecElasticIpPool[] | cdktf.IResolvable;
    /**
    * instance_metadata_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#instance_metadata_options OceanAwsLaunchSpec#instance_metadata_options}
    */
    readonly instanceMetadataOptions?: OceanAwsLaunchSpecInstanceMetadataOptions;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#labels OceanAwsLaunchSpec#labels}
    */
    readonly labels?: OceanAwsLaunchSpecLabels[] | cdktf.IResolvable;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#resource_limits OceanAwsLaunchSpec#resource_limits}
    */
    readonly resourceLimits?: OceanAwsLaunchSpecResourceLimits[] | cdktf.IResolvable;
    /**
    * scheduling_shutdown_hours block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#scheduling_shutdown_hours OceanAwsLaunchSpec#scheduling_shutdown_hours}
    */
    readonly schedulingShutdownHours?: OceanAwsLaunchSpecSchedulingShutdownHours;
    /**
    * scheduling_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#scheduling_task OceanAwsLaunchSpec#scheduling_task}
    */
    readonly schedulingTask?: OceanAwsLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#strategy OceanAwsLaunchSpec#strategy}
    */
    readonly strategy?: OceanAwsLaunchSpecStrategy[] | cdktf.IResolvable;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#tags OceanAwsLaunchSpec#tags}
    */
    readonly tags?: OceanAwsLaunchSpecTags[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#taints OceanAwsLaunchSpec#taints}
    */
    readonly taints?: OceanAwsLaunchSpecTaints[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#update_policy OceanAwsLaunchSpec#update_policy}
    */
    readonly updatePolicy?: OceanAwsLaunchSpecUpdatePolicy;
}
export interface OceanAwsLaunchSpecAutoscaleDown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#max_scale_down_percentage OceanAwsLaunchSpec#max_scale_down_percentage}
    */
    readonly maxScaleDownPercentage?: number;
}
export declare function oceanAwsLaunchSpecAutoscaleDownToTerraform(struct?: OceanAwsLaunchSpecAutoscaleDown | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecAutoscaleDownOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecAutoscaleDown | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecAutoscaleDown | cdktf.IResolvable | undefined);
    private _maxScaleDownPercentage?;
    get maxScaleDownPercentage(): number;
    set maxScaleDownPercentage(value: number);
    resetMaxScaleDownPercentage(): void;
    get maxScaleDownPercentageInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecAutoscaleDownList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecAutoscaleDown[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecAutoscaleDownOutputReference;
}
export interface OceanAwsLaunchSpecAutoscaleHeadrooms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#cpu_per_unit OceanAwsLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#gpu_per_unit OceanAwsLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#memory_per_unit OceanAwsLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#num_of_units OceanAwsLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanAwsLaunchSpecAutoscaleHeadroomsToTerraform(struct?: OceanAwsLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecAutoscaleHeadroomsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    get numOfUnitsInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecAutoscaleHeadroomsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecAutoscaleHeadroomsOutputReference;
}
export interface OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#auto_headroom_percentage OceanAwsLaunchSpec#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
}
export declare function oceanAwsLaunchSpecAutoscaleHeadroomsAutomaticToTerraform(struct?: OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecAutoscaleHeadroomsAutomaticOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecAutoscaleHeadroomsAutomaticList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecAutoscaleHeadroomsAutomaticOutputReference;
}
export interface OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#base_size OceanAwsLaunchSpec#base_size}
    */
    readonly baseSize: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#resource OceanAwsLaunchSpec#resource}
    */
    readonly resource: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#size_per_resource_unit OceanAwsLaunchSpec#size_per_resource_unit}
    */
    readonly sizePerResourceUnit: number;
}
export declare function oceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeToTerraform(struct?: OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference | OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize): any;
export declare class OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
    set internalValue(value: OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined);
    private _baseSize?;
    get baseSize(): number;
    set baseSize(value: number);
    get baseSizeInput(): number | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _sizePerResourceUnit?;
    get sizePerResourceUnit(): number;
    set sizePerResourceUnit(value: number);
    get sizePerResourceUnitInput(): number | undefined;
}
export interface OceanAwsLaunchSpecBlockDeviceMappingsEbs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#delete_on_termination OceanAwsLaunchSpec#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#encrypted OceanAwsLaunchSpec#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#iops OceanAwsLaunchSpec#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#kms_key_id OceanAwsLaunchSpec#kms_key_id}
    */
    readonly kmsKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#snapshot_id OceanAwsLaunchSpec#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#throughput OceanAwsLaunchSpec#throughput}
    */
    readonly throughput?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#volume_size OceanAwsLaunchSpec#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#volume_type OceanAwsLaunchSpec#volume_type}
    */
    readonly volumeType?: string;
    /**
    * dynamic_volume_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#dynamic_volume_size OceanAwsLaunchSpec#dynamic_volume_size}
    */
    readonly dynamicVolumeSize?: OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize;
}
export declare function oceanAwsLaunchSpecBlockDeviceMappingsEbsToTerraform(struct?: OceanAwsLaunchSpecBlockDeviceMappingsEbsOutputReference | OceanAwsLaunchSpecBlockDeviceMappingsEbs): any;
export declare class OceanAwsLaunchSpecBlockDeviceMappingsEbsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecBlockDeviceMappingsEbs | undefined;
    set internalValue(value: OceanAwsLaunchSpecBlockDeviceMappingsEbs | undefined);
    private _deleteOnTermination?;
    get deleteOnTermination(): boolean | cdktf.IResolvable;
    set deleteOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOnTermination(): void;
    get deleteOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    get encrypted(): boolean | cdktf.IResolvable;
    set encrypted(value: boolean | cdktf.IResolvable);
    resetEncrypted(): void;
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    resetKmsKeyId(): void;
    get kmsKeyIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _dynamicVolumeSize;
    get dynamicVolumeSize(): OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSizeOutputReference;
    putDynamicVolumeSize(value: OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize): void;
    resetDynamicVolumeSize(): void;
    get dynamicVolumeSizeInput(): OceanAwsLaunchSpecBlockDeviceMappingsEbsDynamicVolumeSize | undefined;
}
export interface OceanAwsLaunchSpecBlockDeviceMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#device_name OceanAwsLaunchSpec#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#no_device OceanAwsLaunchSpec#no_device}
    */
    readonly noDevice?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#virtual_name OceanAwsLaunchSpec#virtual_name}
    */
    readonly virtualName?: string;
    /**
    * ebs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#ebs OceanAwsLaunchSpec#ebs}
    */
    readonly ebs?: OceanAwsLaunchSpecBlockDeviceMappingsEbs;
}
export declare function oceanAwsLaunchSpecBlockDeviceMappingsToTerraform(struct?: OceanAwsLaunchSpecBlockDeviceMappings | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecBlockDeviceMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecBlockDeviceMappings | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecBlockDeviceMappings | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _noDevice?;
    get noDevice(): string;
    set noDevice(value: string);
    resetNoDevice(): void;
    get noDeviceInput(): string | undefined;
    private _virtualName?;
    get virtualName(): string;
    set virtualName(value: string);
    resetVirtualName(): void;
    get virtualNameInput(): string | undefined;
    private _ebs;
    get ebs(): OceanAwsLaunchSpecBlockDeviceMappingsEbsOutputReference;
    putEbs(value: OceanAwsLaunchSpecBlockDeviceMappingsEbs): void;
    resetEbs(): void;
    get ebsInput(): OceanAwsLaunchSpecBlockDeviceMappingsEbs | undefined;
}
export declare class OceanAwsLaunchSpecBlockDeviceMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecBlockDeviceMappingsOutputReference;
}
export interface OceanAwsLaunchSpecCreateOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#initial_nodes OceanAwsLaunchSpec#initial_nodes}
    */
    readonly initialNodes?: number;
}
export declare function oceanAwsLaunchSpecCreateOptionsToTerraform(struct?: OceanAwsLaunchSpecCreateOptionsOutputReference | OceanAwsLaunchSpecCreateOptions): any;
export declare class OceanAwsLaunchSpecCreateOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecCreateOptions | undefined;
    set internalValue(value: OceanAwsLaunchSpecCreateOptions | undefined);
    private _initialNodes?;
    get initialNodes(): number;
    set initialNodes(value: number);
    resetInitialNodes(): void;
    get initialNodesInput(): number | undefined;
}
export interface OceanAwsLaunchSpecDeleteOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#delete_nodes OceanAwsLaunchSpec#delete_nodes}
    */
    readonly deleteNodes?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#force_delete OceanAwsLaunchSpec#force_delete}
    */
    readonly forceDelete: boolean | cdktf.IResolvable;
}
export declare function oceanAwsLaunchSpecDeleteOptionsToTerraform(struct?: OceanAwsLaunchSpecDeleteOptionsOutputReference | OceanAwsLaunchSpecDeleteOptions): any;
export declare class OceanAwsLaunchSpecDeleteOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecDeleteOptions | undefined;
    set internalValue(value: OceanAwsLaunchSpecDeleteOptions | undefined);
    private _deleteNodes?;
    get deleteNodes(): boolean | cdktf.IResolvable;
    set deleteNodes(value: boolean | cdktf.IResolvable);
    resetDeleteNodes(): void;
    get deleteNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanAwsLaunchSpecElasticIpPoolTagSelector {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#tag_key OceanAwsLaunchSpec#tag_key}
    */
    readonly tagKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#tag_value OceanAwsLaunchSpec#tag_value}
    */
    readonly tagValue?: string;
}
export declare function oceanAwsLaunchSpecElasticIpPoolTagSelectorToTerraform(struct?: OceanAwsLaunchSpecElasticIpPoolTagSelectorOutputReference | OceanAwsLaunchSpecElasticIpPoolTagSelector): any;
export declare class OceanAwsLaunchSpecElasticIpPoolTagSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecElasticIpPoolTagSelector | undefined;
    set internalValue(value: OceanAwsLaunchSpecElasticIpPoolTagSelector | undefined);
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export interface OceanAwsLaunchSpecElasticIpPool {
    /**
    * tag_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#tag_selector OceanAwsLaunchSpec#tag_selector}
    */
    readonly tagSelector?: OceanAwsLaunchSpecElasticIpPoolTagSelector;
}
export declare function oceanAwsLaunchSpecElasticIpPoolToTerraform(struct?: OceanAwsLaunchSpecElasticIpPool | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecElasticIpPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecElasticIpPool | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecElasticIpPool | cdktf.IResolvable | undefined);
    private _tagSelector;
    get tagSelector(): OceanAwsLaunchSpecElasticIpPoolTagSelectorOutputReference;
    putTagSelector(value: OceanAwsLaunchSpecElasticIpPoolTagSelector): void;
    resetTagSelector(): void;
    get tagSelectorInput(): OceanAwsLaunchSpecElasticIpPoolTagSelector | undefined;
}
export declare class OceanAwsLaunchSpecElasticIpPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecElasticIpPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecElasticIpPoolOutputReference;
}
export interface OceanAwsLaunchSpecInstanceMetadataOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#http_put_response_hop_limit OceanAwsLaunchSpec#http_put_response_hop_limit}
    */
    readonly httpPutResponseHopLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#http_tokens OceanAwsLaunchSpec#http_tokens}
    */
    readonly httpTokens: string;
}
export declare function oceanAwsLaunchSpecInstanceMetadataOptionsToTerraform(struct?: OceanAwsLaunchSpecInstanceMetadataOptionsOutputReference | OceanAwsLaunchSpecInstanceMetadataOptions): any;
export declare class OceanAwsLaunchSpecInstanceMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecInstanceMetadataOptions | undefined;
    set internalValue(value: OceanAwsLaunchSpecInstanceMetadataOptions | undefined);
    private _httpPutResponseHopLimit?;
    get httpPutResponseHopLimit(): number;
    set httpPutResponseHopLimit(value: number);
    resetHttpPutResponseHopLimit(): void;
    get httpPutResponseHopLimitInput(): number | undefined;
    private _httpTokens?;
    get httpTokens(): string;
    set httpTokens(value: string);
    get httpTokensInput(): string | undefined;
}
export interface OceanAwsLaunchSpecLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#key OceanAwsLaunchSpec#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#value OceanAwsLaunchSpec#value}
    */
    readonly value: string;
}
export declare function oceanAwsLaunchSpecLabelsToTerraform(struct?: OceanAwsLaunchSpecLabels | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecLabels | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class OceanAwsLaunchSpecLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecLabelsOutputReference;
}
export interface OceanAwsLaunchSpecResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#max_instance_count OceanAwsLaunchSpec#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#min_instance_count OceanAwsLaunchSpec#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function oceanAwsLaunchSpecResourceLimitsToTerraform(struct?: OceanAwsLaunchSpecResourceLimits | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecResourceLimits | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecResourceLimits | cdktf.IResolvable | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecResourceLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecResourceLimitsOutputReference;
}
export interface OceanAwsLaunchSpecSchedulingShutdownHours {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#is_enabled OceanAwsLaunchSpec#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#time_windows OceanAwsLaunchSpec#time_windows}
    */
    readonly timeWindows: string[];
}
export declare function oceanAwsLaunchSpecSchedulingShutdownHoursToTerraform(struct?: OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference | OceanAwsLaunchSpecSchedulingShutdownHours): any;
export declare class OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecSchedulingShutdownHours | undefined;
    set internalValue(value: OceanAwsLaunchSpecSchedulingShutdownHours | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeWindows?;
    get timeWindows(): string[];
    set timeWindows(value: string[]);
    get timeWindowsInput(): string[] | undefined;
}
export interface OceanAwsLaunchSpecSchedulingTaskTaskHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#cpu_per_unit OceanAwsLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#gpu_per_unit OceanAwsLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#memory_per_unit OceanAwsLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#num_of_units OceanAwsLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanAwsLaunchSpecSchedulingTaskTaskHeadroomToTerraform(struct?: OceanAwsLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecSchedulingTaskTaskHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    get numOfUnitsInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecSchedulingTaskTaskHeadroomList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecSchedulingTaskTaskHeadroomOutputReference;
}
export interface OceanAwsLaunchSpecSchedulingTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#cron_expression OceanAwsLaunchSpec#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#is_enabled OceanAwsLaunchSpec#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#task_type OceanAwsLaunchSpec#task_type}
    */
    readonly taskType: string;
    /**
    * task_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#task_headroom OceanAwsLaunchSpec#task_headroom}
    */
    readonly taskHeadroom?: OceanAwsLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
}
export declare function oceanAwsLaunchSpecSchedulingTaskToTerraform(struct?: OceanAwsLaunchSpecSchedulingTask | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecSchedulingTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecSchedulingTask | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecSchedulingTask | cdktf.IResolvable | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    get cronExpressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
    private _taskHeadroom;
    get taskHeadroom(): OceanAwsLaunchSpecSchedulingTaskTaskHeadroomList;
    putTaskHeadroom(value: OceanAwsLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable): void;
    resetTaskHeadroom(): void;
    get taskHeadroomInput(): cdktf.IResolvable | OceanAwsLaunchSpecSchedulingTaskTaskHeadroom[] | undefined;
}
export declare class OceanAwsLaunchSpecSchedulingTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecSchedulingTaskOutputReference;
}
export interface OceanAwsLaunchSpecStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#spot_percentage OceanAwsLaunchSpec#spot_percentage}
    */
    readonly spotPercentage?: number;
}
export declare function oceanAwsLaunchSpecStrategyToTerraform(struct?: OceanAwsLaunchSpecStrategy | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecStrategy | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecStrategy | cdktf.IResolvable | undefined);
    private _spotPercentage?;
    get spotPercentage(): number;
    set spotPercentage(value: number);
    resetSpotPercentage(): void;
    get spotPercentageInput(): number | undefined;
}
export declare class OceanAwsLaunchSpecStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecStrategy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecStrategyOutputReference;
}
export interface OceanAwsLaunchSpecTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#key OceanAwsLaunchSpec#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#value OceanAwsLaunchSpec#value}
    */
    readonly value: string;
}
export declare function oceanAwsLaunchSpecTagsToTerraform(struct?: OceanAwsLaunchSpecTags | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecTags | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecTags | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class OceanAwsLaunchSpecTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecTagsOutputReference;
}
export interface OceanAwsLaunchSpecTaints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#effect OceanAwsLaunchSpec#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#key OceanAwsLaunchSpec#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#value OceanAwsLaunchSpec#value}
    */
    readonly value: string;
}
export declare function oceanAwsLaunchSpecTaintsToTerraform(struct?: OceanAwsLaunchSpecTaints | cdktf.IResolvable): any;
export declare class OceanAwsLaunchSpecTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanAwsLaunchSpecTaints | cdktf.IResolvable | undefined;
    set internalValue(value: OceanAwsLaunchSpecTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class OceanAwsLaunchSpecTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanAwsLaunchSpecTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanAwsLaunchSpecTaintsOutputReference;
}
export interface OceanAwsLaunchSpecUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#batch_size_percentage OceanAwsLaunchSpec#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
}
export declare function oceanAwsLaunchSpecUpdatePolicyRollConfigToTerraform(struct?: OceanAwsLaunchSpecUpdatePolicyRollConfigOutputReference | OceanAwsLaunchSpecUpdatePolicyRollConfig): any;
export declare class OceanAwsLaunchSpecUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanAwsLaunchSpecUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
}
export interface OceanAwsLaunchSpecUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#should_roll OceanAwsLaunchSpec#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec#roll_config OceanAwsLaunchSpec#roll_config}
    */
    readonly rollConfig?: OceanAwsLaunchSpecUpdatePolicyRollConfig;
}
export declare function oceanAwsLaunchSpecUpdatePolicyToTerraform(struct?: OceanAwsLaunchSpecUpdatePolicyOutputReference | OceanAwsLaunchSpecUpdatePolicy): any;
export declare class OceanAwsLaunchSpecUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanAwsLaunchSpecUpdatePolicy | undefined;
    set internalValue(value: OceanAwsLaunchSpecUpdatePolicy | undefined);
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanAwsLaunchSpecUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanAwsLaunchSpecUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanAwsLaunchSpecUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec spotinst_ocean_aws_launch_spec}
*/
export declare class OceanAwsLaunchSpec extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_aws_launch_spec";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_aws_launch_spec spotinst_ocean_aws_launch_spec} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanAwsLaunchSpecConfig
    */
    constructor(scope: Construct, id: string, config: OceanAwsLaunchSpecConfig);
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | cdktf.IResolvable;
    set associatePublicIpAddress(value: boolean | cdktf.IResolvable);
    resetAssociatePublicIpAddress(): void;
    get associatePublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    resetIamInstanceProfile(): void;
    get iamInstanceProfileInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    resetInstanceTypes(): void;
    get instanceTypesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _preferredSpotTypes?;
    get preferredSpotTypes(): string[];
    set preferredSpotTypes(value: string[]);
    resetPreferredSpotTypes(): void;
    get preferredSpotTypesInput(): string[] | undefined;
    private _restrictScaleDown?;
    get restrictScaleDown(): boolean | cdktf.IResolvable;
    set restrictScaleDown(value: boolean | cdktf.IResolvable);
    resetRestrictScaleDown(): void;
    get restrictScaleDownInput(): boolean | cdktf.IResolvable | undefined;
    private _rootVolumeSize?;
    get rootVolumeSize(): number;
    set rootVolumeSize(value: number);
    resetRootVolumeSize(): void;
    get rootVolumeSizeInput(): number | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    resetSecurityGroups(): void;
    get securityGroupsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    resetSubnetIds(): void;
    get subnetIdsInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _autoscaleDown;
    get autoscaleDown(): OceanAwsLaunchSpecAutoscaleDownList;
    putAutoscaleDown(value: OceanAwsLaunchSpecAutoscaleDown[] | cdktf.IResolvable): void;
    resetAutoscaleDown(): void;
    get autoscaleDownInput(): cdktf.IResolvable | OceanAwsLaunchSpecAutoscaleDown[] | undefined;
    private _autoscaleHeadrooms;
    get autoscaleHeadrooms(): OceanAwsLaunchSpecAutoscaleHeadroomsList;
    putAutoscaleHeadrooms(value: OceanAwsLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable): void;
    resetAutoscaleHeadrooms(): void;
    get autoscaleHeadroomsInput(): cdktf.IResolvable | OceanAwsLaunchSpecAutoscaleHeadrooms[] | undefined;
    private _autoscaleHeadroomsAutomatic;
    get autoscaleHeadroomsAutomatic(): OceanAwsLaunchSpecAutoscaleHeadroomsAutomaticList;
    putAutoscaleHeadroomsAutomatic(value: OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable): void;
    resetAutoscaleHeadroomsAutomatic(): void;
    get autoscaleHeadroomsAutomaticInput(): cdktf.IResolvable | OceanAwsLaunchSpecAutoscaleHeadroomsAutomatic[] | undefined;
    private _blockDeviceMappings;
    get blockDeviceMappings(): OceanAwsLaunchSpecBlockDeviceMappingsList;
    putBlockDeviceMappings(value: OceanAwsLaunchSpecBlockDeviceMappings[] | cdktf.IResolvable): void;
    resetBlockDeviceMappings(): void;
    get blockDeviceMappingsInput(): cdktf.IResolvable | OceanAwsLaunchSpecBlockDeviceMappings[] | undefined;
    private _createOptions;
    get createOptions(): OceanAwsLaunchSpecCreateOptionsOutputReference;
    putCreateOptions(value: OceanAwsLaunchSpecCreateOptions): void;
    resetCreateOptions(): void;
    get createOptionsInput(): OceanAwsLaunchSpecCreateOptions | undefined;
    private _deleteOptions;
    get deleteOptions(): OceanAwsLaunchSpecDeleteOptionsOutputReference;
    putDeleteOptions(value: OceanAwsLaunchSpecDeleteOptions): void;
    resetDeleteOptions(): void;
    get deleteOptionsInput(): OceanAwsLaunchSpecDeleteOptions | undefined;
    private _elasticIpPool;
    get elasticIpPool(): OceanAwsLaunchSpecElasticIpPoolList;
    putElasticIpPool(value: OceanAwsLaunchSpecElasticIpPool[] | cdktf.IResolvable): void;
    resetElasticIpPool(): void;
    get elasticIpPoolInput(): cdktf.IResolvable | OceanAwsLaunchSpecElasticIpPool[] | undefined;
    private _instanceMetadataOptions;
    get instanceMetadataOptions(): OceanAwsLaunchSpecInstanceMetadataOptionsOutputReference;
    putInstanceMetadataOptions(value: OceanAwsLaunchSpecInstanceMetadataOptions): void;
    resetInstanceMetadataOptions(): void;
    get instanceMetadataOptionsInput(): OceanAwsLaunchSpecInstanceMetadataOptions | undefined;
    private _labels;
    get labels(): OceanAwsLaunchSpecLabelsList;
    putLabels(value: OceanAwsLaunchSpecLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | OceanAwsLaunchSpecLabels[] | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanAwsLaunchSpecResourceLimitsList;
    putResourceLimits(value: OceanAwsLaunchSpecResourceLimits[] | cdktf.IResolvable): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | OceanAwsLaunchSpecResourceLimits[] | undefined;
    private _schedulingShutdownHours;
    get schedulingShutdownHours(): OceanAwsLaunchSpecSchedulingShutdownHoursOutputReference;
    putSchedulingShutdownHours(value: OceanAwsLaunchSpecSchedulingShutdownHours): void;
    resetSchedulingShutdownHours(): void;
    get schedulingShutdownHoursInput(): OceanAwsLaunchSpecSchedulingShutdownHours | undefined;
    private _schedulingTask;
    get schedulingTask(): OceanAwsLaunchSpecSchedulingTaskList;
    putSchedulingTask(value: OceanAwsLaunchSpecSchedulingTask[] | cdktf.IResolvable): void;
    resetSchedulingTask(): void;
    get schedulingTaskInput(): cdktf.IResolvable | OceanAwsLaunchSpecSchedulingTask[] | undefined;
    private _strategy;
    get strategy(): OceanAwsLaunchSpecStrategyList;
    putStrategy(value: OceanAwsLaunchSpecStrategy[] | cdktf.IResolvable): void;
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | OceanAwsLaunchSpecStrategy[] | undefined;
    private _tags;
    get tags(): OceanAwsLaunchSpecTagsList;
    putTags(value: OceanAwsLaunchSpecTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | OceanAwsLaunchSpecTags[] | undefined;
    private _taints;
    get taints(): OceanAwsLaunchSpecTaintsList;
    putTaints(value: OceanAwsLaunchSpecTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | OceanAwsLaunchSpecTaints[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanAwsLaunchSpecUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanAwsLaunchSpecUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanAwsLaunchSpecUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
