import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanGkeLaunchSpecImportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec_import#id OceanGkeLaunchSpecImport#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec_import#node_pool_name OceanGkeLaunchSpecImport#node_pool_name}
    */
    readonly nodePoolName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec_import#ocean_id OceanGkeLaunchSpecImport#ocean_id}
    */
    readonly oceanId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec_import spotinst_ocean_gke_launch_spec_import}
*/
export declare class OceanGkeLaunchSpecImport extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_gke_launch_spec_import";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec_import spotinst_ocean_gke_launch_spec_import} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanGkeLaunchSpecImportConfig
    */
    constructor(scope: Construct, id: string, config: OceanGkeLaunchSpecImportConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nodePoolName?;
    get nodePoolName(): string;
    set nodePoolName(value: string);
    get nodePoolNameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
