import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanGkeLaunchSpecConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#id OceanGkeLaunchSpec#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#instance_types OceanGkeLaunchSpec#instance_types}
    */
    readonly instanceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#name OceanGkeLaunchSpec#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#node_pool_name OceanGkeLaunchSpec#node_pool_name}
    */
    readonly nodePoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#ocean_id OceanGkeLaunchSpec#ocean_id}
    */
    readonly oceanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#restrict_scale_down OceanGkeLaunchSpec#restrict_scale_down}
    */
    readonly restrictScaleDown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#root_volume_size OceanGkeLaunchSpec#root_volume_size}
    */
    readonly rootVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#root_volume_type OceanGkeLaunchSpec#root_volume_type}
    */
    readonly rootVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#service_account OceanGkeLaunchSpec#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#source_image OceanGkeLaunchSpec#source_image}
    */
    readonly sourceImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#tags OceanGkeLaunchSpec#tags}
    */
    readonly tags?: string[];
    /**
    * autoscale_headrooms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#autoscale_headrooms OceanGkeLaunchSpec#autoscale_headrooms}
    */
    readonly autoscaleHeadrooms?: OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * autoscale_headrooms_automatic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#autoscale_headrooms_automatic OceanGkeLaunchSpec#autoscale_headrooms_automatic}
    */
    readonly autoscaleHeadroomsAutomatic?: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#labels OceanGkeLaunchSpec#labels}
    */
    readonly labels?: OceanGkeLaunchSpecLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#metadata OceanGkeLaunchSpec#metadata}
    */
    readonly metadata?: OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#resource_limits OceanGkeLaunchSpec#resource_limits}
    */
    readonly resourceLimits?: OceanGkeLaunchSpecResourceLimits;
    /**
    * scheduling_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#scheduling_task OceanGkeLaunchSpec#scheduling_task}
    */
    readonly schedulingTask?: OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#shielded_instance_config OceanGkeLaunchSpec#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: OceanGkeLaunchSpecShieldedInstanceConfig;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#storage OceanGkeLaunchSpec#storage}
    */
    readonly storage?: OceanGkeLaunchSpecStorage;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#strategy OceanGkeLaunchSpec#strategy}
    */
    readonly strategy?: OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#taints OceanGkeLaunchSpec#taints}
    */
    readonly taints?: OceanGkeLaunchSpecTaints[] | cdktf.IResolvable;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#update_policy OceanGkeLaunchSpec#update_policy}
    */
    readonly updatePolicy?: OceanGkeLaunchSpecUpdatePolicy;
}
export interface OceanGkeLaunchSpecAutoscaleHeadrooms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cpu_per_unit OceanGkeLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#gpu_per_unit OceanGkeLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#memory_per_unit OceanGkeLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#num_of_units OceanGkeLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanGkeLaunchSpecAutoscaleHeadroomsToTerraform(struct?: OceanGkeLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecAutoscaleHeadroomsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecAutoscaleHeadrooms | cdktf.IResolvable | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    get numOfUnitsInput(): number | undefined;
}
export declare class OceanGkeLaunchSpecAutoscaleHeadroomsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecAutoscaleHeadroomsOutputReference;
}
export interface OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#auto_headroom_percentage OceanGkeLaunchSpec#auto_headroom_percentage}
    */
    readonly autoHeadroomPercentage?: number;
}
export declare function oceanGkeLaunchSpecAutoscaleHeadroomsAutomaticToTerraform(struct?: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecAutoscaleHeadroomsAutomaticOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic | cdktf.IResolvable | undefined);
    private _autoHeadroomPercentage?;
    get autoHeadroomPercentage(): number;
    set autoHeadroomPercentage(value: number);
    resetAutoHeadroomPercentage(): void;
    get autoHeadroomPercentageInput(): number | undefined;
}
export declare class OceanGkeLaunchSpecAutoscaleHeadroomsAutomaticList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecAutoscaleHeadroomsAutomaticOutputReference;
}
export interface OceanGkeLaunchSpecLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecLabelsToTerraform(struct?: OceanGkeLaunchSpecLabels | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecLabels | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanGkeLaunchSpecLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecLabelsOutputReference;
}
export interface OceanGkeLaunchSpecMetadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecMetadataToTerraform(struct?: OceanGkeLaunchSpecMetadata | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecMetadata | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecMetadata | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanGkeLaunchSpecMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecMetadataOutputReference;
}
export interface OceanGkeLaunchSpecResourceLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#max_instance_count OceanGkeLaunchSpec#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#min_instance_count OceanGkeLaunchSpec#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function oceanGkeLaunchSpecResourceLimitsToTerraform(struct?: OceanGkeLaunchSpecResourceLimitsOutputReference | OceanGkeLaunchSpecResourceLimits): any;
export declare class OceanGkeLaunchSpecResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecResourceLimits | undefined;
    set internalValue(value: OceanGkeLaunchSpecResourceLimits | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export interface OceanGkeLaunchSpecSchedulingTaskTaskHeadroom {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cpu_per_unit OceanGkeLaunchSpec#cpu_per_unit}
    */
    readonly cpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#gpu_per_unit OceanGkeLaunchSpec#gpu_per_unit}
    */
    readonly gpuPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#memory_per_unit OceanGkeLaunchSpec#memory_per_unit}
    */
    readonly memoryPerUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#num_of_units OceanGkeLaunchSpec#num_of_units}
    */
    readonly numOfUnits: number;
}
export declare function oceanGkeLaunchSpecSchedulingTaskTaskHeadroomToTerraform(struct?: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecSchedulingTaskTaskHeadroomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom | cdktf.IResolvable | undefined);
    private _cpuPerUnit?;
    get cpuPerUnit(): number;
    set cpuPerUnit(value: number);
    resetCpuPerUnit(): void;
    get cpuPerUnitInput(): number | undefined;
    private _gpuPerUnit?;
    get gpuPerUnit(): number;
    set gpuPerUnit(value: number);
    resetGpuPerUnit(): void;
    get gpuPerUnitInput(): number | undefined;
    private _memoryPerUnit?;
    get memoryPerUnit(): number;
    set memoryPerUnit(value: number);
    resetMemoryPerUnit(): void;
    get memoryPerUnitInput(): number | undefined;
    private _numOfUnits?;
    get numOfUnits(): number;
    set numOfUnits(value: number);
    get numOfUnitsInput(): number | undefined;
}
export declare class OceanGkeLaunchSpecSchedulingTaskTaskHeadroomList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecSchedulingTaskTaskHeadroomOutputReference;
}
export interface OceanGkeLaunchSpecSchedulingTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#cron_expression OceanGkeLaunchSpec#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#is_enabled OceanGkeLaunchSpec#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#task_type OceanGkeLaunchSpec#task_type}
    */
    readonly taskType: string;
    /**
    * task_headroom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#task_headroom OceanGkeLaunchSpec#task_headroom}
    */
    readonly taskHeadroom?: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable;
}
export declare function oceanGkeLaunchSpecSchedulingTaskToTerraform(struct?: OceanGkeLaunchSpecSchedulingTask | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecSchedulingTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecSchedulingTask | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecSchedulingTask | cdktf.IResolvable | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    get cronExpressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
    private _taskHeadroom;
    get taskHeadroom(): OceanGkeLaunchSpecSchedulingTaskTaskHeadroomList;
    putTaskHeadroom(value: OceanGkeLaunchSpecSchedulingTaskTaskHeadroom[] | cdktf.IResolvable): void;
    resetTaskHeadroom(): void;
    get taskHeadroomInput(): cdktf.IResolvable | OceanGkeLaunchSpecSchedulingTaskTaskHeadroom[] | undefined;
}
export declare class OceanGkeLaunchSpecSchedulingTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecSchedulingTaskOutputReference;
}
export interface OceanGkeLaunchSpecShieldedInstanceConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#enable_integrity_monitoring OceanGkeLaunchSpec#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#enable_secure_boot OceanGkeLaunchSpec#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function oceanGkeLaunchSpecShieldedInstanceConfigToTerraform(struct?: OceanGkeLaunchSpecShieldedInstanceConfigOutputReference | OceanGkeLaunchSpecShieldedInstanceConfig): any;
export declare class OceanGkeLaunchSpecShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecShieldedInstanceConfig | undefined;
    set internalValue(value: OceanGkeLaunchSpecShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanGkeLaunchSpecStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#local_ssd_count OceanGkeLaunchSpec#local_ssd_count}
    */
    readonly localSsdCount?: number;
}
export declare function oceanGkeLaunchSpecStorageToTerraform(struct?: OceanGkeLaunchSpecStorageOutputReference | OceanGkeLaunchSpecStorage): any;
export declare class OceanGkeLaunchSpecStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecStorage | undefined;
    set internalValue(value: OceanGkeLaunchSpecStorage | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
}
export interface OceanGkeLaunchSpecStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#preemptible_percentage OceanGkeLaunchSpec#preemptible_percentage}
    */
    readonly preemptiblePercentage?: number;
}
export declare function oceanGkeLaunchSpecStrategyToTerraform(struct?: OceanGkeLaunchSpecStrategy | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecStrategy | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecStrategy | cdktf.IResolvable | undefined);
    private _preemptiblePercentage?;
    get preemptiblePercentage(): number;
    set preemptiblePercentage(value: number);
    resetPreemptiblePercentage(): void;
    get preemptiblePercentageInput(): number | undefined;
}
export declare class OceanGkeLaunchSpecStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecStrategyOutputReference;
}
export interface OceanGkeLaunchSpecTaints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#effect OceanGkeLaunchSpec#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#key OceanGkeLaunchSpec#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#value OceanGkeLaunchSpec#value}
    */
    readonly value?: string;
}
export declare function oceanGkeLaunchSpecTaintsToTerraform(struct?: OceanGkeLaunchSpecTaints | cdktf.IResolvable): any;
export declare class OceanGkeLaunchSpecTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OceanGkeLaunchSpecTaints | cdktf.IResolvable | undefined;
    set internalValue(value: OceanGkeLaunchSpecTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class OceanGkeLaunchSpecTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OceanGkeLaunchSpecTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OceanGkeLaunchSpecTaintsOutputReference;
}
export interface OceanGkeLaunchSpecUpdatePolicyRollConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#batch_size_percentage OceanGkeLaunchSpec#batch_size_percentage}
    */
    readonly batchSizePercentage: number;
}
export declare function oceanGkeLaunchSpecUpdatePolicyRollConfigToTerraform(struct?: OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference | OceanGkeLaunchSpecUpdatePolicyRollConfig): any;
export declare class OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined;
    set internalValue(value: OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined);
    private _batchSizePercentage?;
    get batchSizePercentage(): number;
    set batchSizePercentage(value: number);
    get batchSizePercentageInput(): number | undefined;
}
export interface OceanGkeLaunchSpecUpdatePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#should_roll OceanGkeLaunchSpec#should_roll}
    */
    readonly shouldRoll: boolean | cdktf.IResolvable;
    /**
    * roll_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec#roll_config OceanGkeLaunchSpec#roll_config}
    */
    readonly rollConfig?: OceanGkeLaunchSpecUpdatePolicyRollConfig;
}
export declare function oceanGkeLaunchSpecUpdatePolicyToTerraform(struct?: OceanGkeLaunchSpecUpdatePolicyOutputReference | OceanGkeLaunchSpecUpdatePolicy): any;
export declare class OceanGkeLaunchSpecUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanGkeLaunchSpecUpdatePolicy | undefined;
    set internalValue(value: OceanGkeLaunchSpecUpdatePolicy | undefined);
    private _shouldRoll?;
    get shouldRoll(): boolean | cdktf.IResolvable;
    set shouldRoll(value: boolean | cdktf.IResolvable);
    get shouldRollInput(): boolean | cdktf.IResolvable | undefined;
    private _rollConfig;
    get rollConfig(): OceanGkeLaunchSpecUpdatePolicyRollConfigOutputReference;
    putRollConfig(value: OceanGkeLaunchSpecUpdatePolicyRollConfig): void;
    resetRollConfig(): void;
    get rollConfigInput(): OceanGkeLaunchSpecUpdatePolicyRollConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec spotinst_ocean_gke_launch_spec}
*/
export declare class OceanGkeLaunchSpec extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_gke_launch_spec";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_gke_launch_spec spotinst_ocean_gke_launch_spec} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanGkeLaunchSpecConfig
    */
    constructor(scope: Construct, id: string, config: OceanGkeLaunchSpecConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceTypes?;
    get instanceTypes(): string[];
    set instanceTypes(value: string[]);
    resetInstanceTypes(): void;
    get instanceTypesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodePoolName?;
    get nodePoolName(): string;
    set nodePoolName(value: string);
    resetNodePoolName(): void;
    get nodePoolNameInput(): string | undefined;
    private _oceanId?;
    get oceanId(): string;
    set oceanId(value: string);
    get oceanIdInput(): string | undefined;
    private _restrictScaleDown?;
    get restrictScaleDown(): boolean | cdktf.IResolvable;
    set restrictScaleDown(value: boolean | cdktf.IResolvable);
    resetRestrictScaleDown(): void;
    get restrictScaleDownInput(): boolean | cdktf.IResolvable | undefined;
    private _rootVolumeSize?;
    get rootVolumeSize(): number;
    set rootVolumeSize(value: number);
    resetRootVolumeSize(): void;
    get rootVolumeSizeInput(): number | undefined;
    private _rootVolumeType?;
    get rootVolumeType(): string;
    set rootVolumeType(value: string);
    resetRootVolumeType(): void;
    get rootVolumeTypeInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _autoscaleHeadrooms;
    get autoscaleHeadrooms(): OceanGkeLaunchSpecAutoscaleHeadroomsList;
    putAutoscaleHeadrooms(value: OceanGkeLaunchSpecAutoscaleHeadrooms[] | cdktf.IResolvable): void;
    resetAutoscaleHeadrooms(): void;
    get autoscaleHeadroomsInput(): cdktf.IResolvable | OceanGkeLaunchSpecAutoscaleHeadrooms[] | undefined;
    private _autoscaleHeadroomsAutomatic;
    get autoscaleHeadroomsAutomatic(): OceanGkeLaunchSpecAutoscaleHeadroomsAutomaticList;
    putAutoscaleHeadroomsAutomatic(value: OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | cdktf.IResolvable): void;
    resetAutoscaleHeadroomsAutomatic(): void;
    get autoscaleHeadroomsAutomaticInput(): cdktf.IResolvable | OceanGkeLaunchSpecAutoscaleHeadroomsAutomatic[] | undefined;
    private _labels;
    get labels(): OceanGkeLaunchSpecLabelsList;
    putLabels(value: OceanGkeLaunchSpecLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | OceanGkeLaunchSpecLabels[] | undefined;
    private _metadata;
    get metadata(): OceanGkeLaunchSpecMetadataList;
    putMetadata(value: OceanGkeLaunchSpecMetadata[] | cdktf.IResolvable): void;
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | OceanGkeLaunchSpecMetadata[] | undefined;
    private _resourceLimits;
    get resourceLimits(): OceanGkeLaunchSpecResourceLimitsOutputReference;
    putResourceLimits(value: OceanGkeLaunchSpecResourceLimits): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): OceanGkeLaunchSpecResourceLimits | undefined;
    private _schedulingTask;
    get schedulingTask(): OceanGkeLaunchSpecSchedulingTaskList;
    putSchedulingTask(value: OceanGkeLaunchSpecSchedulingTask[] | cdktf.IResolvable): void;
    resetSchedulingTask(): void;
    get schedulingTaskInput(): cdktf.IResolvable | OceanGkeLaunchSpecSchedulingTask[] | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): OceanGkeLaunchSpecShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: OceanGkeLaunchSpecShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): OceanGkeLaunchSpecShieldedInstanceConfig | undefined;
    private _storage;
    get storage(): OceanGkeLaunchSpecStorageOutputReference;
    putStorage(value: OceanGkeLaunchSpecStorage): void;
    resetStorage(): void;
    get storageInput(): OceanGkeLaunchSpecStorage | undefined;
    private _strategy;
    get strategy(): OceanGkeLaunchSpecStrategyList;
    putStrategy(value: OceanGkeLaunchSpecStrategy[] | cdktf.IResolvable): void;
    resetStrategy(): void;
    get strategyInput(): cdktf.IResolvable | OceanGkeLaunchSpecStrategy[] | undefined;
    private _taints;
    get taints(): OceanGkeLaunchSpecTaintsList;
    putTaints(value: OceanGkeLaunchSpecTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | OceanGkeLaunchSpecTaints[] | undefined;
    private _updatePolicy;
    get updatePolicy(): OceanGkeLaunchSpecUpdatePolicyOutputReference;
    putUpdatePolicy(value: OceanGkeLaunchSpecUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): OceanGkeLaunchSpecUpdatePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
