import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanSparkVirtualNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark_virtual_node_group#id OceanSparkVirtualNodeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark_virtual_node_group#ocean_spark_cluster_id OceanSparkVirtualNodeGroup#ocean_spark_cluster_id}
    */
    readonly oceanSparkClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark_virtual_node_group#virtual_node_group_id OceanSparkVirtualNodeGroup#virtual_node_group_id}
    */
    readonly virtualNodeGroupId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark_virtual_node_group spotinst_ocean_spark_virtual_node_group}
*/
export declare class OceanSparkVirtualNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_spark_virtual_node_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark_virtual_node_group spotinst_ocean_spark_virtual_node_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanSparkVirtualNodeGroupConfig
    */
    constructor(scope: Construct, id: string, config: OceanSparkVirtualNodeGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _oceanSparkClusterId?;
    get oceanSparkClusterId(): string;
    set oceanSparkClusterId(value: string);
    get oceanSparkClusterIdInput(): string | undefined;
    private _virtualNodeGroupId?;
    get virtualNodeGroupId(): string;
    set virtualNodeGroupId(value: string);
    get virtualNodeGroupIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
