import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OceanSparkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#id OceanSpark#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#ocean_cluster_id OceanSpark#ocean_cluster_id}
    */
    readonly oceanClusterId: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#compute OceanSpark#compute}
    */
    readonly compute?: OceanSparkCompute;
    /**
    * ingress block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#ingress OceanSpark#ingress}
    */
    readonly ingress?: OceanSparkIngress;
    /**
    * log_collection block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#log_collection OceanSpark#log_collection}
    */
    readonly logCollection?: OceanSparkLogCollection;
    /**
    * spark block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#spark OceanSpark#spark}
    */
    readonly spark?: OceanSparkSpark;
    /**
    * webhook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#webhook OceanSpark#webhook}
    */
    readonly webhook?: OceanSparkWebhook;
}
export interface OceanSparkCompute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#create_vngs OceanSpark#create_vngs}
    */
    readonly createVngs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#use_taints OceanSpark#use_taints}
    */
    readonly useTaints?: boolean | cdktf.IResolvable;
}
export declare function oceanSparkComputeToTerraform(struct?: OceanSparkComputeOutputReference | OceanSparkCompute): any;
export declare class OceanSparkComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkCompute | undefined;
    set internalValue(value: OceanSparkCompute | undefined);
    private _createVngs?;
    get createVngs(): boolean | cdktf.IResolvable;
    set createVngs(value: boolean | cdktf.IResolvable);
    resetCreateVngs(): void;
    get createVngsInput(): boolean | cdktf.IResolvable | undefined;
    private _useTaints?;
    get useTaints(): boolean | cdktf.IResolvable;
    set useTaints(value: boolean | cdktf.IResolvable);
    resetUseTaints(): void;
    get useTaintsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanSparkIngressController {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#managed OceanSpark#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
}
export declare function oceanSparkIngressControllerToTerraform(struct?: OceanSparkIngressControllerOutputReference | OceanSparkIngressController): any;
export declare class OceanSparkIngressControllerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkIngressController | undefined;
    set internalValue(value: OceanSparkIngressController | undefined);
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanSparkIngressCustomEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#address OceanSpark#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#enabled OceanSpark#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function oceanSparkIngressCustomEndpointToTerraform(struct?: OceanSparkIngressCustomEndpointOutputReference | OceanSparkIngressCustomEndpoint): any;
export declare class OceanSparkIngressCustomEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkIngressCustomEndpoint | undefined;
    set internalValue(value: OceanSparkIngressCustomEndpoint | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanSparkIngressLoadBalancer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#managed OceanSpark#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#service_annotations OceanSpark#service_annotations}
    */
    readonly serviceAnnotations?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#target_group_arn OceanSpark#target_group_arn}
    */
    readonly targetGroupArn?: string;
}
export declare function oceanSparkIngressLoadBalancerToTerraform(struct?: OceanSparkIngressLoadBalancerOutputReference | OceanSparkIngressLoadBalancer): any;
export declare class OceanSparkIngressLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkIngressLoadBalancer | undefined;
    set internalValue(value: OceanSparkIngressLoadBalancer | undefined);
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAnnotations?;
    get serviceAnnotations(): {
        [key: string]: string;
    };
    set serviceAnnotations(value: {
        [key: string]: string;
    });
    resetServiceAnnotations(): void;
    get serviceAnnotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetGroupArn?;
    get targetGroupArn(): string;
    set targetGroupArn(value: string);
    resetTargetGroupArn(): void;
    get targetGroupArnInput(): string | undefined;
}
export interface OceanSparkIngressPrivateLink {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#enabled OceanSpark#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#vpc_endpoint_service OceanSpark#vpc_endpoint_service}
    */
    readonly vpcEndpointService?: string;
}
export declare function oceanSparkIngressPrivateLinkToTerraform(struct?: OceanSparkIngressPrivateLinkOutputReference | OceanSparkIngressPrivateLink): any;
export declare class OceanSparkIngressPrivateLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkIngressPrivateLink | undefined;
    set internalValue(value: OceanSparkIngressPrivateLink | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vpcEndpointService?;
    get vpcEndpointService(): string;
    set vpcEndpointService(value: string);
    resetVpcEndpointService(): void;
    get vpcEndpointServiceInput(): string | undefined;
}
export interface OceanSparkIngress {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#service_annotations OceanSpark#service_annotations}
    */
    readonly serviceAnnotations?: {
        [key: string]: string;
    };
    /**
    * controller block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#controller OceanSpark#controller}
    */
    readonly controller?: OceanSparkIngressController;
    /**
    * custom_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#custom_endpoint OceanSpark#custom_endpoint}
    */
    readonly customEndpoint?: OceanSparkIngressCustomEndpoint;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#load_balancer OceanSpark#load_balancer}
    */
    readonly loadBalancer?: OceanSparkIngressLoadBalancer;
    /**
    * private_link block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#private_link OceanSpark#private_link}
    */
    readonly privateLink?: OceanSparkIngressPrivateLink;
}
export declare function oceanSparkIngressToTerraform(struct?: OceanSparkIngressOutputReference | OceanSparkIngress): any;
export declare class OceanSparkIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkIngress | undefined;
    set internalValue(value: OceanSparkIngress | undefined);
    private _serviceAnnotations?;
    get serviceAnnotations(): {
        [key: string]: string;
    };
    set serviceAnnotations(value: {
        [key: string]: string;
    });
    resetServiceAnnotations(): void;
    get serviceAnnotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _controller;
    get controller(): OceanSparkIngressControllerOutputReference;
    putController(value: OceanSparkIngressController): void;
    resetController(): void;
    get controllerInput(): OceanSparkIngressController | undefined;
    private _customEndpoint;
    get customEndpoint(): OceanSparkIngressCustomEndpointOutputReference;
    putCustomEndpoint(value: OceanSparkIngressCustomEndpoint): void;
    resetCustomEndpoint(): void;
    get customEndpointInput(): OceanSparkIngressCustomEndpoint | undefined;
    private _loadBalancer;
    get loadBalancer(): OceanSparkIngressLoadBalancerOutputReference;
    putLoadBalancer(value: OceanSparkIngressLoadBalancer): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): OceanSparkIngressLoadBalancer | undefined;
    private _privateLink;
    get privateLink(): OceanSparkIngressPrivateLinkOutputReference;
    putPrivateLink(value: OceanSparkIngressPrivateLink): void;
    resetPrivateLink(): void;
    get privateLinkInput(): OceanSparkIngressPrivateLink | undefined;
}
export interface OceanSparkLogCollection {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#collect_driver_logs OceanSpark#collect_driver_logs}
    */
    readonly collectDriverLogs?: boolean | cdktf.IResolvable;
}
export declare function oceanSparkLogCollectionToTerraform(struct?: OceanSparkLogCollectionOutputReference | OceanSparkLogCollection): any;
export declare class OceanSparkLogCollectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkLogCollection | undefined;
    set internalValue(value: OceanSparkLogCollection | undefined);
    private _collectDriverLogs?;
    get collectDriverLogs(): boolean | cdktf.IResolvable;
    set collectDriverLogs(value: boolean | cdktf.IResolvable);
    resetCollectDriverLogs(): void;
    get collectDriverLogsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OceanSparkSpark {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#additional_app_namespaces OceanSpark#additional_app_namespaces}
    */
    readonly additionalAppNamespaces?: string[];
}
export declare function oceanSparkSparkToTerraform(struct?: OceanSparkSparkOutputReference | OceanSparkSpark): any;
export declare class OceanSparkSparkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkSpark | undefined;
    set internalValue(value: OceanSparkSpark | undefined);
    private _additionalAppNamespaces?;
    get additionalAppNamespaces(): string[];
    set additionalAppNamespaces(value: string[]);
    resetAdditionalAppNamespaces(): void;
    get additionalAppNamespacesInput(): string[] | undefined;
}
export interface OceanSparkWebhook {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#host_network_ports OceanSpark#host_network_ports}
    */
    readonly hostNetworkPorts?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark#use_host_network OceanSpark#use_host_network}
    */
    readonly useHostNetwork?: boolean | cdktf.IResolvable;
}
export declare function oceanSparkWebhookToTerraform(struct?: OceanSparkWebhookOutputReference | OceanSparkWebhook): any;
export declare class OceanSparkWebhookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OceanSparkWebhook | undefined;
    set internalValue(value: OceanSparkWebhook | undefined);
    private _hostNetworkPorts?;
    get hostNetworkPorts(): number[];
    set hostNetworkPorts(value: number[]);
    resetHostNetworkPorts(): void;
    get hostNetworkPortsInput(): number[] | undefined;
    private _useHostNetwork?;
    get useHostNetwork(): boolean | cdktf.IResolvable;
    set useHostNetwork(value: boolean | cdktf.IResolvable);
    resetUseHostNetwork(): void;
    get useHostNetworkInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark spotinst_ocean_spark}
*/
export declare class OceanSpark extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_ocean_spark";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/ocean_spark spotinst_ocean_spark} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OceanSparkConfig
    */
    constructor(scope: Construct, id: string, config: OceanSparkConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _oceanClusterId?;
    get oceanClusterId(): string;
    set oceanClusterId(value: string);
    get oceanClusterIdInput(): string | undefined;
    private _compute;
    get compute(): OceanSparkComputeOutputReference;
    putCompute(value: OceanSparkCompute): void;
    resetCompute(): void;
    get computeInput(): OceanSparkCompute | undefined;
    private _ingress;
    get ingress(): OceanSparkIngressOutputReference;
    putIngress(value: OceanSparkIngress): void;
    resetIngress(): void;
    get ingressInput(): OceanSparkIngress | undefined;
    private _logCollection;
    get logCollection(): OceanSparkLogCollectionOutputReference;
    putLogCollection(value: OceanSparkLogCollection): void;
    resetLogCollection(): void;
    get logCollectionInput(): OceanSparkLogCollection | undefined;
    private _spark;
    get spark(): OceanSparkSparkOutputReference;
    putSpark(value: OceanSparkSpark): void;
    resetSpark(): void;
    get sparkInput(): OceanSparkSpark | undefined;
    private _webhook;
    get webhook(): OceanSparkWebhookOutputReference;
    putWebhook(value: OceanSparkWebhook): void;
    resetWebhook(): void;
    get webhookInput(): OceanSparkWebhook | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
