import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpotinstProviderConfig {
    /**
    * Spotinst Account ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst#account SpotinstProvider#account}
    */
    readonly account?: string;
    /**
    * Spotinst SDK Feature Flags
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst#feature_flags SpotinstProvider#feature_flags}
    */
    readonly featureFlags?: string;
    /**
    * Spotinst Personal API Access Token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst#token SpotinstProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst#alias SpotinstProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst spotinst}
*/
export declare class SpotinstProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "spotinst";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst spotinst} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpotinstProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SpotinstProviderConfig);
    private _account?;
    get account(): string | undefined;
    set account(value: string | undefined);
    resetAccount(): void;
    get accountInput(): string | undefined;
    private _featureFlags?;
    get featureFlags(): string | undefined;
    set featureFlags(value: string | undefined);
    resetFeatureFlags(): void;
    get featureFlagsInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
