import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StatefulNodeAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#custom_data StatefulNodeAzure#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disks_persistence_mode StatefulNodeAzure#data_disks_persistence_mode}
    */
    readonly dataDisksPersistenceMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#description StatefulNodeAzure#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#id StatefulNodeAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#od_sizes StatefulNodeAzure#od_sizes}
    */
    readonly odSizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#os StatefulNodeAzure#os}
    */
    readonly os: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#os_disk_persistence_mode StatefulNodeAzure#os_disk_persistence_mode}
    */
    readonly osDiskPersistenceMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#preferred_spot_sizes StatefulNodeAzure#preferred_spot_sizes}
    */
    readonly preferredSpotSizes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#preferred_zones StatefulNodeAzure#preferred_zones}
    */
    readonly preferredZones?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#region StatefulNodeAzure#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resource_group_name StatefulNodeAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_persist_data_disks StatefulNodeAzure#should_persist_data_disks}
    */
    readonly shouldPersistDataDisks: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_persist_network StatefulNodeAzure#should_persist_network}
    */
    readonly shouldPersistNetwork: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_persist_os_disk StatefulNodeAzure#should_persist_os_disk}
    */
    readonly shouldPersistOsDisk: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_persist_vm StatefulNodeAzure#should_persist_vm}
    */
    readonly shouldPersistVm?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#shutdown_script StatefulNodeAzure#shutdown_script}
    */
    readonly shutdownScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#spot_sizes StatefulNodeAzure#spot_sizes}
    */
    readonly spotSizes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#zones StatefulNodeAzure#zones}
    */
    readonly zones?: string[];
    /**
    * attach_data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#attach_data_disk StatefulNodeAzure#attach_data_disk}
    */
    readonly attachDataDisk?: StatefulNodeAzureAttachDataDisk[] | cdktf.IResolvable;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#boot_diagnostics StatefulNodeAzure#boot_diagnostics}
    */
    readonly bootDiagnostics?: StatefulNodeAzureBootDiagnostics[] | cdktf.IResolvable;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disk StatefulNodeAzure#data_disk}
    */
    readonly dataDisk?: StatefulNodeAzureDataDisk[] | cdktf.IResolvable;
    /**
    * delete block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#delete StatefulNodeAzure#delete}
    */
    readonly delete?: StatefulNodeAzureDelete[] | cdktf.IResolvable;
    /**
    * detach_data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#detach_data_disk StatefulNodeAzure#detach_data_disk}
    */
    readonly detachDataDisk?: StatefulNodeAzureDetachDataDisk[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#extension StatefulNodeAzure#extension}
    */
    readonly extension?: StatefulNodeAzureExtension[] | cdktf.IResolvable;
    /**
    * health block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#health StatefulNodeAzure#health}
    */
    readonly health?: StatefulNodeAzureHealth;
    /**
    * image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#image StatefulNodeAzure#image}
    */
    readonly image: StatefulNodeAzureImage;
    /**
    * import_vm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#import_vm StatefulNodeAzure#import_vm}
    */
    readonly importVm?: StatefulNodeAzureImportVm[] | cdktf.IResolvable;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#load_balancer StatefulNodeAzure#load_balancer}
    */
    readonly loadBalancer?: StatefulNodeAzureLoadBalancer[] | cdktf.IResolvable;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#login StatefulNodeAzure#login}
    */
    readonly login: StatefulNodeAzureLogin;
    /**
    * managed_service_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#managed_service_identities StatefulNodeAzure#managed_service_identities}
    */
    readonly managedServiceIdentities?: StatefulNodeAzureManagedServiceIdentities[] | cdktf.IResolvable;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network StatefulNodeAzure#network}
    */
    readonly network: StatefulNodeAzureNetwork;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#os_disk StatefulNodeAzure#os_disk}
    */
    readonly osDisk?: StatefulNodeAzureOsDisk;
    /**
    * scheduling_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#scheduling_task StatefulNodeAzure#scheduling_task}
    */
    readonly schedulingTask?: StatefulNodeAzureSchedulingTask[] | cdktf.IResolvable;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#secret StatefulNodeAzure#secret}
    */
    readonly secret?: StatefulNodeAzureSecret[] | cdktf.IResolvable;
    /**
    * signal block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#signal StatefulNodeAzure#signal}
    */
    readonly signal?: StatefulNodeAzureSignal[] | cdktf.IResolvable;
    /**
    * strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#strategy StatefulNodeAzure#strategy}
    */
    readonly strategy: StatefulNodeAzureStrategy;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#tag StatefulNodeAzure#tag}
    */
    readonly tag?: StatefulNodeAzureTag[] | cdktf.IResolvable;
    /**
    * update_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#update_state StatefulNodeAzure#update_state}
    */
    readonly updateState?: StatefulNodeAzureUpdateState[] | cdktf.IResolvable;
}
export interface StatefulNodeAzureAttachDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disk_name StatefulNodeAzure#data_disk_name}
    */
    readonly dataDiskName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disk_resource_group_name StatefulNodeAzure#data_disk_resource_group_name}
    */
    readonly dataDiskResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#lun StatefulNodeAzure#lun}
    */
    readonly lun?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#size_gb StatefulNodeAzure#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#storage_account_type StatefulNodeAzure#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#zone StatefulNodeAzure#zone}
    */
    readonly zone?: string;
}
export declare function statefulNodeAzureAttachDataDiskToTerraform(struct?: StatefulNodeAzureAttachDataDisk | cdktf.IResolvable): any;
export declare class StatefulNodeAzureAttachDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureAttachDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureAttachDataDisk | cdktf.IResolvable | undefined);
    private _dataDiskName?;
    get dataDiskName(): string;
    set dataDiskName(value: string);
    get dataDiskNameInput(): string | undefined;
    private _dataDiskResourceGroupName?;
    get dataDiskResourceGroupName(): string;
    set dataDiskResourceGroupName(value: string);
    get dataDiskResourceGroupNameInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export declare class StatefulNodeAzureAttachDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureAttachDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureAttachDataDiskOutputReference;
}
export interface StatefulNodeAzureBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#is_enabled StatefulNodeAzure#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#storage_url StatefulNodeAzure#storage_url}
    */
    readonly storageUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type?: string;
}
export declare function statefulNodeAzureBootDiagnosticsToTerraform(struct?: StatefulNodeAzureBootDiagnostics | cdktf.IResolvable): any;
export declare class StatefulNodeAzureBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureBootDiagnostics | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureBootDiagnostics | cdktf.IResolvable | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUrl?;
    get storageUrl(): string;
    set storageUrl(value: string);
    resetStorageUrl(): void;
    get storageUrlInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureBootDiagnosticsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureBootDiagnostics[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureBootDiagnosticsOutputReference;
}
export interface StatefulNodeAzureDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#lun StatefulNodeAzure#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#size_gb StatefulNodeAzure#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureDataDiskToTerraform(struct?: StatefulNodeAzureDataDisk | cdktf.IResolvable): any;
export declare class StatefulNodeAzureDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureDataDisk | cdktf.IResolvable | undefined);
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureDataDiskOutputReference;
}
export interface StatefulNodeAzureDelete {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#disk_should_deallocate StatefulNodeAzure#disk_should_deallocate}
    */
    readonly diskShouldDeallocate: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#disk_ttl_in_hours StatefulNodeAzure#disk_ttl_in_hours}
    */
    readonly diskTtlInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_should_deallocate StatefulNodeAzure#network_should_deallocate}
    */
    readonly networkShouldDeallocate: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_ttl_in_hours StatefulNodeAzure#network_ttl_in_hours}
    */
    readonly networkTtlInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#public_ip_should_deallocate StatefulNodeAzure#public_ip_should_deallocate}
    */
    readonly publicIpShouldDeallocate: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#public_ip_ttl_in_hours StatefulNodeAzure#public_ip_ttl_in_hours}
    */
    readonly publicIpTtlInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_terminate_vm StatefulNodeAzure#should_terminate_vm}
    */
    readonly shouldTerminateVm: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#snapshot_should_deallocate StatefulNodeAzure#snapshot_should_deallocate}
    */
    readonly snapshotShouldDeallocate: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#snapshot_ttl_in_hours StatefulNodeAzure#snapshot_ttl_in_hours}
    */
    readonly snapshotTtlInHours?: number;
}
export declare function statefulNodeAzureDeleteToTerraform(struct?: StatefulNodeAzureDelete | cdktf.IResolvable): any;
export declare class StatefulNodeAzureDeleteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureDelete | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureDelete | cdktf.IResolvable | undefined);
    private _diskShouldDeallocate?;
    get diskShouldDeallocate(): boolean | cdktf.IResolvable;
    set diskShouldDeallocate(value: boolean | cdktf.IResolvable);
    get diskShouldDeallocateInput(): boolean | cdktf.IResolvable | undefined;
    private _diskTtlInHours?;
    get diskTtlInHours(): number;
    set diskTtlInHours(value: number);
    resetDiskTtlInHours(): void;
    get diskTtlInHoursInput(): number | undefined;
    private _networkShouldDeallocate?;
    get networkShouldDeallocate(): boolean | cdktf.IResolvable;
    set networkShouldDeallocate(value: boolean | cdktf.IResolvable);
    get networkShouldDeallocateInput(): boolean | cdktf.IResolvable | undefined;
    private _networkTtlInHours?;
    get networkTtlInHours(): number;
    set networkTtlInHours(value: number);
    resetNetworkTtlInHours(): void;
    get networkTtlInHoursInput(): number | undefined;
    private _publicIpShouldDeallocate?;
    get publicIpShouldDeallocate(): boolean | cdktf.IResolvable;
    set publicIpShouldDeallocate(value: boolean | cdktf.IResolvable);
    get publicIpShouldDeallocateInput(): boolean | cdktf.IResolvable | undefined;
    private _publicIpTtlInHours?;
    get publicIpTtlInHours(): number;
    set publicIpTtlInHours(value: number);
    resetPublicIpTtlInHours(): void;
    get publicIpTtlInHoursInput(): number | undefined;
    private _shouldTerminateVm?;
    get shouldTerminateVm(): boolean | cdktf.IResolvable;
    set shouldTerminateVm(value: boolean | cdktf.IResolvable);
    get shouldTerminateVmInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotShouldDeallocate?;
    get snapshotShouldDeallocate(): boolean | cdktf.IResolvable;
    set snapshotShouldDeallocate(value: boolean | cdktf.IResolvable);
    get snapshotShouldDeallocateInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotTtlInHours?;
    get snapshotTtlInHours(): number;
    set snapshotTtlInHours(value: number);
    resetSnapshotTtlInHours(): void;
    get snapshotTtlInHoursInput(): number | undefined;
}
export declare class StatefulNodeAzureDeleteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureDelete[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureDeleteOutputReference;
}
export interface StatefulNodeAzureDetachDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disk_name StatefulNodeAzure#data_disk_name}
    */
    readonly dataDiskName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#data_disk_resource_group_name StatefulNodeAzure#data_disk_resource_group_name}
    */
    readonly dataDiskResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#should_deallocate StatefulNodeAzure#should_deallocate}
    */
    readonly shouldDeallocate: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#ttl_in_hours StatefulNodeAzure#ttl_in_hours}
    */
    readonly ttlInHours?: number;
}
export declare function statefulNodeAzureDetachDataDiskToTerraform(struct?: StatefulNodeAzureDetachDataDisk | cdktf.IResolvable): any;
export declare class StatefulNodeAzureDetachDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureDetachDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureDetachDataDisk | cdktf.IResolvable | undefined);
    private _dataDiskName?;
    get dataDiskName(): string;
    set dataDiskName(value: string);
    get dataDiskNameInput(): string | undefined;
    private _dataDiskResourceGroupName?;
    get dataDiskResourceGroupName(): string;
    set dataDiskResourceGroupName(value: string);
    get dataDiskResourceGroupNameInput(): string | undefined;
    private _shouldDeallocate?;
    get shouldDeallocate(): boolean | cdktf.IResolvable;
    set shouldDeallocate(value: boolean | cdktf.IResolvable);
    get shouldDeallocateInput(): boolean | cdktf.IResolvable | undefined;
    private _ttlInHours?;
    get ttlInHours(): number;
    set ttlInHours(value: number);
    resetTtlInHours(): void;
    get ttlInHoursInput(): number | undefined;
}
export declare class StatefulNodeAzureDetachDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureDetachDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureDetachDataDiskOutputReference;
}
export interface StatefulNodeAzureExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#api_version StatefulNodeAzure#api_version}
    */
    readonly apiVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#minor_version_auto_upgrade StatefulNodeAzure#minor_version_auto_upgrade}
    */
    readonly minorVersionAutoUpgrade: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#protected_settings StatefulNodeAzure#protected_settings}
    */
    readonly protectedSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#public_settings StatefulNodeAzure#public_settings}
    */
    readonly publicSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#publisher StatefulNodeAzure#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureExtensionToTerraform(struct?: StatefulNodeAzureExtension | cdktf.IResolvable): any;
export declare class StatefulNodeAzureExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureExtension | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureExtension | cdktf.IResolvable | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    get apiVersionInput(): string | undefined;
    private _minorVersionAutoUpgrade?;
    get minorVersionAutoUpgrade(): boolean | cdktf.IResolvable;
    set minorVersionAutoUpgrade(value: boolean | cdktf.IResolvable);
    get minorVersionAutoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): {
        [key: string]: string;
    };
    set protectedSettings(value: {
        [key: string]: string;
    });
    resetProtectedSettings(): void;
    get protectedSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _publicSettings?;
    get publicSettings(): {
        [key: string]: string;
    };
    set publicSettings(value: {
        [key: string]: string;
    });
    resetPublicSettings(): void;
    get publicSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureExtensionOutputReference;
}
export interface StatefulNodeAzureHealth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#auto_healing StatefulNodeAzure#auto_healing}
    */
    readonly autoHealing: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#grace_period StatefulNodeAzure#grace_period}
    */
    readonly gracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#health_check_types StatefulNodeAzure#health_check_types}
    */
    readonly healthCheckTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#unhealthy_duration StatefulNodeAzure#unhealthy_duration}
    */
    readonly unhealthyDuration?: number;
}
export declare function statefulNodeAzureHealthToTerraform(struct?: StatefulNodeAzureHealthOutputReference | StatefulNodeAzureHealth): any;
export declare class StatefulNodeAzureHealthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureHealth | undefined;
    set internalValue(value: StatefulNodeAzureHealth | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | cdktf.IResolvable;
    set autoHealing(value: boolean | cdktf.IResolvable);
    get autoHealingInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): number;
    set gracePeriod(value: number);
    resetGracePeriod(): void;
    get gracePeriodInput(): number | undefined;
    private _healthCheckTypes?;
    get healthCheckTypes(): string[];
    set healthCheckTypes(value: string[]);
    get healthCheckTypesInput(): string[] | undefined;
    private _unhealthyDuration?;
    get unhealthyDuration(): number;
    set unhealthyDuration(value: number);
    resetUnhealthyDuration(): void;
    get unhealthyDurationInput(): number | undefined;
}
export interface StatefulNodeAzureImageCustomImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#custom_image_resource_group_name StatefulNodeAzure#custom_image_resource_group_name}
    */
    readonly customImageResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
}
export declare function statefulNodeAzureImageCustomImageToTerraform(struct?: StatefulNodeAzureImageCustomImage | cdktf.IResolvable): any;
export declare class StatefulNodeAzureImageCustomImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureImageCustomImage | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureImageCustomImage | cdktf.IResolvable | undefined);
    private _customImageResourceGroupName?;
    get customImageResourceGroupName(): string;
    set customImageResourceGroupName(value: string);
    get customImageResourceGroupNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class StatefulNodeAzureImageCustomImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureImageCustomImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureImageCustomImageOutputReference;
}
export interface StatefulNodeAzureImageGallery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#gallery_name StatefulNodeAzure#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#gallery_resource_group_name StatefulNodeAzure#gallery_resource_group_name}
    */
    readonly galleryResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#image_name StatefulNodeAzure#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#version_name StatefulNodeAzure#version_name}
    */
    readonly versionName: string;
}
export declare function statefulNodeAzureImageGalleryToTerraform(struct?: StatefulNodeAzureImageGallery | cdktf.IResolvable): any;
export declare class StatefulNodeAzureImageGalleryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureImageGallery | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureImageGallery | cdktf.IResolvable | undefined);
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    private _galleryResourceGroupName?;
    get galleryResourceGroupName(): string;
    set galleryResourceGroupName(value: string);
    get galleryResourceGroupNameInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _versionName?;
    get versionName(): string;
    set versionName(value: string);
    get versionNameInput(): string | undefined;
}
export declare class StatefulNodeAzureImageGalleryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureImageGallery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureImageGalleryOutputReference;
}
export interface StatefulNodeAzureImageMarketplaceImage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#offer StatefulNodeAzure#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#publisher StatefulNodeAzure#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#sku StatefulNodeAzure#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#version StatefulNodeAzure#version}
    */
    readonly version: string;
}
export declare function statefulNodeAzureImageMarketplaceImageToTerraform(struct?: StatefulNodeAzureImageMarketplaceImage | cdktf.IResolvable): any;
export declare class StatefulNodeAzureImageMarketplaceImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureImageMarketplaceImage | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureImageMarketplaceImage | cdktf.IResolvable | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class StatefulNodeAzureImageMarketplaceImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureImageMarketplaceImage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureImageMarketplaceImageOutputReference;
}
export interface StatefulNodeAzureImage {
    /**
    * custom_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#custom_image StatefulNodeAzure#custom_image}
    */
    readonly customImage?: StatefulNodeAzureImageCustomImage[] | cdktf.IResolvable;
    /**
    * gallery block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#gallery StatefulNodeAzure#gallery}
    */
    readonly gallery?: StatefulNodeAzureImageGallery[] | cdktf.IResolvable;
    /**
    * marketplace_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#marketplace_image StatefulNodeAzure#marketplace_image}
    */
    readonly marketplaceImage?: StatefulNodeAzureImageMarketplaceImage[] | cdktf.IResolvable;
}
export declare function statefulNodeAzureImageToTerraform(struct?: StatefulNodeAzureImageOutputReference | StatefulNodeAzureImage): any;
export declare class StatefulNodeAzureImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureImage | undefined;
    set internalValue(value: StatefulNodeAzureImage | undefined);
    private _customImage;
    get customImage(): StatefulNodeAzureImageCustomImageList;
    putCustomImage(value: StatefulNodeAzureImageCustomImage[] | cdktf.IResolvable): void;
    resetCustomImage(): void;
    get customImageInput(): cdktf.IResolvable | StatefulNodeAzureImageCustomImage[] | undefined;
    private _gallery;
    get gallery(): StatefulNodeAzureImageGalleryList;
    putGallery(value: StatefulNodeAzureImageGallery[] | cdktf.IResolvable): void;
    resetGallery(): void;
    get galleryInput(): cdktf.IResolvable | StatefulNodeAzureImageGallery[] | undefined;
    private _marketplaceImage;
    get marketplaceImage(): StatefulNodeAzureImageMarketplaceImageList;
    putMarketplaceImage(value: StatefulNodeAzureImageMarketplaceImage[] | cdktf.IResolvable): void;
    resetMarketplaceImage(): void;
    get marketplaceImageInput(): cdktf.IResolvable | StatefulNodeAzureImageMarketplaceImage[] | undefined;
}
export interface StatefulNodeAzureImportVm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#draining_timeout StatefulNodeAzure#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#original_vm_name StatefulNodeAzure#original_vm_name}
    */
    readonly originalVmName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resource_group_name StatefulNodeAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resources_retention_time StatefulNodeAzure#resources_retention_time}
    */
    readonly resourcesRetentionTime?: number;
}
export declare function statefulNodeAzureImportVmToTerraform(struct?: StatefulNodeAzureImportVm | cdktf.IResolvable): any;
export declare class StatefulNodeAzureImportVmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureImportVm | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureImportVm | cdktf.IResolvable | undefined);
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _originalVmName?;
    get originalVmName(): string;
    set originalVmName(value: string);
    get originalVmNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _resourcesRetentionTime?;
    get resourcesRetentionTime(): number;
    set resourcesRetentionTime(value: number);
    resetResourcesRetentionTime(): void;
    get resourcesRetentionTimeInput(): number | undefined;
}
export declare class StatefulNodeAzureImportVmList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureImportVm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureImportVmOutputReference;
}
export interface StatefulNodeAzureLoadBalancer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#backend_pool_names StatefulNodeAzure#backend_pool_names}
    */
    readonly backendPoolNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resource_group_name StatefulNodeAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#sku StatefulNodeAzure#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureLoadBalancerToTerraform(struct?: StatefulNodeAzureLoadBalancer | cdktf.IResolvable): any;
export declare class StatefulNodeAzureLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureLoadBalancer | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureLoadBalancer | cdktf.IResolvable | undefined);
    private _backendPoolNames?;
    get backendPoolNames(): string[];
    set backendPoolNames(value: string[]);
    get backendPoolNamesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureLoadBalancer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureLoadBalancerOutputReference;
}
export interface StatefulNodeAzureLogin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#password StatefulNodeAzure#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#ssh_public_key StatefulNodeAzure#ssh_public_key}
    */
    readonly sshPublicKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#user_name StatefulNodeAzure#user_name}
    */
    readonly userName: string;
}
export declare function statefulNodeAzureLoginToTerraform(struct?: StatefulNodeAzureLoginOutputReference | StatefulNodeAzureLogin): any;
export declare class StatefulNodeAzureLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureLogin | undefined;
    set internalValue(value: StatefulNodeAzureLogin | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    resetSshPublicKey(): void;
    get sshPublicKeyInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
}
export interface StatefulNodeAzureManagedServiceIdentities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resource_group_name StatefulNodeAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function statefulNodeAzureManagedServiceIdentitiesToTerraform(struct?: StatefulNodeAzureManagedServiceIdentities | cdktf.IResolvable): any;
export declare class StatefulNodeAzureManagedServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureManagedServiceIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureManagedServiceIdentities | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
}
export declare class StatefulNodeAzureManagedServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureManagedServiceIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureManagedServiceIdentitiesOutputReference;
}
export interface StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#private_ip_address_version StatefulNodeAzure#private_ip_address_version}
    */
    readonly privateIpAddressVersion: string;
}
export declare function statefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurationsToTerraform(struct?: StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations | cdktf.IResolvable): any;
export declare class StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpAddressVersion?;
    get privateIpAddressVersion(): string;
    set privateIpAddressVersion(value: string);
    get privateIpAddressVersionInput(): string | undefined;
}
export declare class StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurationsOutputReference;
}
export interface StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_resource_group_name StatefulNodeAzure#network_resource_group_name}
    */
    readonly networkResourceGroupName: string;
}
export declare function statefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroupsToTerraform(struct?: StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups | cdktf.IResolvable): any;
export declare class StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkResourceGroupName?;
    get networkResourceGroupName(): string;
    set networkResourceGroupName(value: string);
    get networkResourceGroupNameInput(): string | undefined;
}
export declare class StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroupsOutputReference;
}
export interface StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_resource_group_name StatefulNodeAzure#network_resource_group_name}
    */
    readonly networkResourceGroupName?: string;
}
export declare function statefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroupToTerraform(struct?: StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup | cdktf.IResolvable): any;
export declare class StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkResourceGroupName?;
    get networkResourceGroupName(): string;
    set networkResourceGroupName(value: string);
    resetNetworkResourceGroupName(): void;
    get networkResourceGroupNameInput(): string | undefined;
}
export declare class StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroupOutputReference;
}
export interface StatefulNodeAzureNetworkNetworkInterfacePublicIps {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_resource_group_name StatefulNodeAzure#network_resource_group_name}
    */
    readonly networkResourceGroupName: string;
}
export declare function statefulNodeAzureNetworkNetworkInterfacePublicIpsToTerraform(struct?: StatefulNodeAzureNetworkNetworkInterfacePublicIps | cdktf.IResolvable): any;
export declare class StatefulNodeAzureNetworkNetworkInterfacePublicIpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureNetworkNetworkInterfacePublicIps | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureNetworkNetworkInterfacePublicIps | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkResourceGroupName?;
    get networkResourceGroupName(): string;
    set networkResourceGroupName(value: string);
    get networkResourceGroupNameInput(): string | undefined;
}
export declare class StatefulNodeAzureNetworkNetworkInterfacePublicIpsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureNetworkNetworkInterfacePublicIps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureNetworkNetworkInterfacePublicIpsOutputReference;
}
export interface StatefulNodeAzureNetworkNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#assign_public_ip StatefulNodeAzure#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#enable_ip_forwarding StatefulNodeAzure#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#is_primary StatefulNodeAzure#is_primary}
    */
    readonly isPrimary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#private_ip_addresses StatefulNodeAzure#private_ip_addresses}
    */
    readonly privateIpAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#public_ip_sku StatefulNodeAzure#public_ip_sku}
    */
    readonly publicIpSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#subnet_name StatefulNodeAzure#subnet_name}
    */
    readonly subnetName: string;
    /**
    * additional_ip_configurations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#additional_ip_configurations StatefulNodeAzure#additional_ip_configurations}
    */
    readonly additionalIpConfigurations?: StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations[] | cdktf.IResolvable;
    /**
    * application_security_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#application_security_groups StatefulNodeAzure#application_security_groups}
    */
    readonly applicationSecurityGroups?: StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups[] | cdktf.IResolvable;
    /**
    * network_security_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_security_group StatefulNodeAzure#network_security_group}
    */
    readonly networkSecurityGroup?: StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup[] | cdktf.IResolvable;
    /**
    * public_ips block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#public_ips StatefulNodeAzure#public_ips}
    */
    readonly publicIps?: StatefulNodeAzureNetworkNetworkInterfacePublicIps[] | cdktf.IResolvable;
}
export declare function statefulNodeAzureNetworkNetworkInterfaceToTerraform(struct?: StatefulNodeAzureNetworkNetworkInterface | cdktf.IResolvable): any;
export declare class StatefulNodeAzureNetworkNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureNetworkNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureNetworkNetworkInterface | cdktf.IResolvable | undefined);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _isPrimary?;
    get isPrimary(): boolean | cdktf.IResolvable;
    set isPrimary(value: boolean | cdktf.IResolvable);
    get isPrimaryInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddresses?;
    get privateIpAddresses(): string[];
    set privateIpAddresses(value: string[]);
    resetPrivateIpAddresses(): void;
    get privateIpAddressesInput(): string[] | undefined;
    private _publicIpSku?;
    get publicIpSku(): string;
    set publicIpSku(value: string);
    resetPublicIpSku(): void;
    get publicIpSkuInput(): string | undefined;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    get subnetNameInput(): string | undefined;
    private _additionalIpConfigurations;
    get additionalIpConfigurations(): StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurationsList;
    putAdditionalIpConfigurations(value: StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations[] | cdktf.IResolvable): void;
    resetAdditionalIpConfigurations(): void;
    get additionalIpConfigurationsInput(): cdktf.IResolvable | StatefulNodeAzureNetworkNetworkInterfaceAdditionalIpConfigurations[] | undefined;
    private _applicationSecurityGroups;
    get applicationSecurityGroups(): StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroupsList;
    putApplicationSecurityGroups(value: StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups[] | cdktf.IResolvable): void;
    resetApplicationSecurityGroups(): void;
    get applicationSecurityGroupsInput(): cdktf.IResolvable | StatefulNodeAzureNetworkNetworkInterfaceApplicationSecurityGroups[] | undefined;
    private _networkSecurityGroup;
    get networkSecurityGroup(): StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroupList;
    putNetworkSecurityGroup(value: StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup[] | cdktf.IResolvable): void;
    resetNetworkSecurityGroup(): void;
    get networkSecurityGroupInput(): cdktf.IResolvable | StatefulNodeAzureNetworkNetworkInterfaceNetworkSecurityGroup[] | undefined;
    private _publicIps;
    get publicIps(): StatefulNodeAzureNetworkNetworkInterfacePublicIpsList;
    putPublicIps(value: StatefulNodeAzureNetworkNetworkInterfacePublicIps[] | cdktf.IResolvable): void;
    resetPublicIps(): void;
    get publicIpsInput(): cdktf.IResolvable | StatefulNodeAzureNetworkNetworkInterfacePublicIps[] | undefined;
}
export declare class StatefulNodeAzureNetworkNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureNetworkNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureNetworkNetworkInterfaceOutputReference;
}
export interface StatefulNodeAzureNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_resource_group_name StatefulNodeAzure#network_resource_group_name}
    */
    readonly networkResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#virtual_network_name StatefulNodeAzure#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#network_interface StatefulNodeAzure#network_interface}
    */
    readonly networkInterface: StatefulNodeAzureNetworkNetworkInterface[] | cdktf.IResolvable;
}
export declare function statefulNodeAzureNetworkToTerraform(struct?: StatefulNodeAzureNetworkOutputReference | StatefulNodeAzureNetwork): any;
export declare class StatefulNodeAzureNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureNetwork | undefined;
    set internalValue(value: StatefulNodeAzureNetwork | undefined);
    private _networkResourceGroupName?;
    get networkResourceGroupName(): string;
    set networkResourceGroupName(value: string);
    get networkResourceGroupNameInput(): string | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): StatefulNodeAzureNetworkNetworkInterfaceList;
    putNetworkInterface(value: StatefulNodeAzureNetworkNetworkInterface[] | cdktf.IResolvable): void;
    get networkInterfaceInput(): cdktf.IResolvable | StatefulNodeAzureNetworkNetworkInterface[] | undefined;
}
export interface StatefulNodeAzureOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#size_gb StatefulNodeAzure#size_gb}
    */
    readonly sizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureOsDiskToTerraform(struct?: StatefulNodeAzureOsDiskOutputReference | StatefulNodeAzureOsDisk): any;
export declare class StatefulNodeAzureOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureOsDisk | undefined;
    set internalValue(value: StatefulNodeAzureOsDisk | undefined);
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StatefulNodeAzureSchedulingTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#cron_expression StatefulNodeAzure#cron_expression}
    */
    readonly cronExpression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#is_enabled StatefulNodeAzure#is_enabled}
    */
    readonly isEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureSchedulingTaskToTerraform(struct?: StatefulNodeAzureSchedulingTask | cdktf.IResolvable): any;
export declare class StatefulNodeAzureSchedulingTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureSchedulingTask | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureSchedulingTask | cdktf.IResolvable | undefined);
    private _cronExpression?;
    get cronExpression(): string;
    set cronExpression(value: string);
    get cronExpressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureSchedulingTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureSchedulingTask[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureSchedulingTaskOutputReference;
}
export interface StatefulNodeAzureSecretSourceVault {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#name StatefulNodeAzure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#resource_group_name StatefulNodeAzure#resource_group_name}
    */
    readonly resourceGroupName: string;
}
export declare function statefulNodeAzureSecretSourceVaultToTerraform(struct?: StatefulNodeAzureSecretSourceVault | cdktf.IResolvable): any;
export declare class StatefulNodeAzureSecretSourceVaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureSecretSourceVault | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureSecretSourceVault | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
}
export declare class StatefulNodeAzureSecretSourceVaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureSecretSourceVault[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureSecretSourceVaultOutputReference;
}
export interface StatefulNodeAzureSecretVaultCertificates {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#certificate_store StatefulNodeAzure#certificate_store}
    */
    readonly certificateStore?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#certificate_url StatefulNodeAzure#certificate_url}
    */
    readonly certificateUrl?: string;
}
export declare function statefulNodeAzureSecretVaultCertificatesToTerraform(struct?: StatefulNodeAzureSecretVaultCertificates | cdktf.IResolvable): any;
export declare class StatefulNodeAzureSecretVaultCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureSecretVaultCertificates | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureSecretVaultCertificates | cdktf.IResolvable | undefined);
    private _certificateStore?;
    get certificateStore(): string;
    set certificateStore(value: string);
    resetCertificateStore(): void;
    get certificateStoreInput(): string | undefined;
    private _certificateUrl?;
    get certificateUrl(): string;
    set certificateUrl(value: string);
    resetCertificateUrl(): void;
    get certificateUrlInput(): string | undefined;
}
export declare class StatefulNodeAzureSecretVaultCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureSecretVaultCertificates[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureSecretVaultCertificatesOutputReference;
}
export interface StatefulNodeAzureSecret {
    /**
    * source_vault block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#source_vault StatefulNodeAzure#source_vault}
    */
    readonly sourceVault: StatefulNodeAzureSecretSourceVault[] | cdktf.IResolvable;
    /**
    * vault_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#vault_certificates StatefulNodeAzure#vault_certificates}
    */
    readonly vaultCertificates: StatefulNodeAzureSecretVaultCertificates[] | cdktf.IResolvable;
}
export declare function statefulNodeAzureSecretToTerraform(struct?: StatefulNodeAzureSecret | cdktf.IResolvable): any;
export declare class StatefulNodeAzureSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureSecret | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureSecret | cdktf.IResolvable | undefined);
    private _sourceVault;
    get sourceVault(): StatefulNodeAzureSecretSourceVaultList;
    putSourceVault(value: StatefulNodeAzureSecretSourceVault[] | cdktf.IResolvable): void;
    get sourceVaultInput(): cdktf.IResolvable | StatefulNodeAzureSecretSourceVault[] | undefined;
    private _vaultCertificates;
    get vaultCertificates(): StatefulNodeAzureSecretVaultCertificatesList;
    putVaultCertificates(value: StatefulNodeAzureSecretVaultCertificates[] | cdktf.IResolvable): void;
    get vaultCertificatesInput(): cdktf.IResolvable | StatefulNodeAzureSecretVaultCertificates[] | undefined;
}
export declare class StatefulNodeAzureSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureSecretOutputReference;
}
export interface StatefulNodeAzureSignal {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#timeout StatefulNodeAzure#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#type StatefulNodeAzure#type}
    */
    readonly type: string;
}
export declare function statefulNodeAzureSignalToTerraform(struct?: StatefulNodeAzureSignal | cdktf.IResolvable): any;
export declare class StatefulNodeAzureSignalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureSignal | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureSignal | cdktf.IResolvable | undefined);
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StatefulNodeAzureSignalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureSignal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureSignalOutputReference;
}
export interface StatefulNodeAzureStrategyRevertToSpot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#perform_at StatefulNodeAzure#perform_at}
    */
    readonly performAt: string;
}
export declare function statefulNodeAzureStrategyRevertToSpotToTerraform(struct?: StatefulNodeAzureStrategyRevertToSpotOutputReference | StatefulNodeAzureStrategyRevertToSpot): any;
export declare class StatefulNodeAzureStrategyRevertToSpotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureStrategyRevertToSpot | undefined;
    set internalValue(value: StatefulNodeAzureStrategyRevertToSpot | undefined);
    private _performAt?;
    get performAt(): string;
    set performAt(value: string);
    get performAtInput(): string | undefined;
}
export interface StatefulNodeAzureStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#draining_timeout StatefulNodeAzure#draining_timeout}
    */
    readonly drainingTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#fallback_to_on_demand StatefulNodeAzure#fallback_to_on_demand}
    */
    readonly fallbackToOnDemand: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#optimization_windows StatefulNodeAzure#optimization_windows}
    */
    readonly optimizationWindows?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#preferred_life_cycle StatefulNodeAzure#preferred_life_cycle}
    */
    readonly preferredLifeCycle?: string;
    /**
    * revert_to_spot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#revert_to_spot StatefulNodeAzure#revert_to_spot}
    */
    readonly revertToSpot?: StatefulNodeAzureStrategyRevertToSpot;
}
export declare function statefulNodeAzureStrategyToTerraform(struct?: StatefulNodeAzureStrategyOutputReference | StatefulNodeAzureStrategy): any;
export declare class StatefulNodeAzureStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulNodeAzureStrategy | undefined;
    set internalValue(value: StatefulNodeAzureStrategy | undefined);
    private _drainingTimeout?;
    get drainingTimeout(): number;
    set drainingTimeout(value: number);
    resetDrainingTimeout(): void;
    get drainingTimeoutInput(): number | undefined;
    private _fallbackToOnDemand?;
    get fallbackToOnDemand(): boolean | cdktf.IResolvable;
    set fallbackToOnDemand(value: boolean | cdktf.IResolvable);
    get fallbackToOnDemandInput(): boolean | cdktf.IResolvable | undefined;
    private _optimizationWindows?;
    get optimizationWindows(): string[];
    set optimizationWindows(value: string[]);
    resetOptimizationWindows(): void;
    get optimizationWindowsInput(): string[] | undefined;
    private _preferredLifeCycle?;
    get preferredLifeCycle(): string;
    set preferredLifeCycle(value: string);
    resetPreferredLifeCycle(): void;
    get preferredLifeCycleInput(): string | undefined;
    private _revertToSpot;
    get revertToSpot(): StatefulNodeAzureStrategyRevertToSpotOutputReference;
    putRevertToSpot(value: StatefulNodeAzureStrategyRevertToSpot): void;
    resetRevertToSpot(): void;
    get revertToSpotInput(): StatefulNodeAzureStrategyRevertToSpot | undefined;
}
export interface StatefulNodeAzureTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#tag_key StatefulNodeAzure#tag_key}
    */
    readonly tagKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#tag_value StatefulNodeAzure#tag_value}
    */
    readonly tagValue?: string;
}
export declare function statefulNodeAzureTagToTerraform(struct?: StatefulNodeAzureTag | cdktf.IResolvable): any;
export declare class StatefulNodeAzureTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureTag | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureTag | cdktf.IResolvable | undefined);
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    get tagKeyInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    resetTagValue(): void;
    get tagValueInput(): string | undefined;
}
export declare class StatefulNodeAzureTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureTagOutputReference;
}
export interface StatefulNodeAzureUpdateState {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure#state StatefulNodeAzure#state}
    */
    readonly state: string;
}
export declare function statefulNodeAzureUpdateStateToTerraform(struct?: StatefulNodeAzureUpdateState | cdktf.IResolvable): any;
export declare class StatefulNodeAzureUpdateStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulNodeAzureUpdateState | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulNodeAzureUpdateState | cdktf.IResolvable | undefined);
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export declare class StatefulNodeAzureUpdateStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulNodeAzureUpdateState[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulNodeAzureUpdateStateOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure spotinst_stateful_node_azure}
*/
export declare class StatefulNodeAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "spotinst_stateful_node_azure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/spotinst/r/stateful_node_azure spotinst_stateful_node_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StatefulNodeAzureConfig
    */
    constructor(scope: Construct, id: string, config: StatefulNodeAzureConfig);
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _dataDisksPersistenceMode?;
    get dataDisksPersistenceMode(): string;
    set dataDisksPersistenceMode(value: string);
    resetDataDisksPersistenceMode(): void;
    get dataDisksPersistenceModeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _odSizes?;
    get odSizes(): string[];
    set odSizes(value: string[]);
    get odSizesInput(): string[] | undefined;
    private _os?;
    get os(): string;
    set os(value: string);
    get osInput(): string | undefined;
    private _osDiskPersistenceMode?;
    get osDiskPersistenceMode(): string;
    set osDiskPersistenceMode(value: string);
    resetOsDiskPersistenceMode(): void;
    get osDiskPersistenceModeInput(): string | undefined;
    private _preferredSpotSizes?;
    get preferredSpotSizes(): string[];
    set preferredSpotSizes(value: string[]);
    resetPreferredSpotSizes(): void;
    get preferredSpotSizesInput(): string[] | undefined;
    private _preferredZones?;
    get preferredZones(): string;
    set preferredZones(value: string);
    resetPreferredZones(): void;
    get preferredZonesInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shouldPersistDataDisks?;
    get shouldPersistDataDisks(): boolean | cdktf.IResolvable;
    set shouldPersistDataDisks(value: boolean | cdktf.IResolvable);
    get shouldPersistDataDisksInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldPersistNetwork?;
    get shouldPersistNetwork(): boolean | cdktf.IResolvable;
    set shouldPersistNetwork(value: boolean | cdktf.IResolvable);
    get shouldPersistNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldPersistOsDisk?;
    get shouldPersistOsDisk(): boolean | cdktf.IResolvable;
    set shouldPersistOsDisk(value: boolean | cdktf.IResolvable);
    get shouldPersistOsDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _shouldPersistVm?;
    get shouldPersistVm(): boolean | cdktf.IResolvable;
    set shouldPersistVm(value: boolean | cdktf.IResolvable);
    resetShouldPersistVm(): void;
    get shouldPersistVmInput(): boolean | cdktf.IResolvable | undefined;
    private _shutdownScript?;
    get shutdownScript(): string;
    set shutdownScript(value: string);
    resetShutdownScript(): void;
    get shutdownScriptInput(): string | undefined;
    private _spotSizes?;
    get spotSizes(): string[];
    set spotSizes(value: string[]);
    get spotSizesInput(): string[] | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _attachDataDisk;
    get attachDataDisk(): StatefulNodeAzureAttachDataDiskList;
    putAttachDataDisk(value: StatefulNodeAzureAttachDataDisk[] | cdktf.IResolvable): void;
    resetAttachDataDisk(): void;
    get attachDataDiskInput(): cdktf.IResolvable | StatefulNodeAzureAttachDataDisk[] | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): StatefulNodeAzureBootDiagnosticsList;
    putBootDiagnostics(value: StatefulNodeAzureBootDiagnostics[] | cdktf.IResolvable): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): cdktf.IResolvable | StatefulNodeAzureBootDiagnostics[] | undefined;
    private _dataDisk;
    get dataDisk(): StatefulNodeAzureDataDiskList;
    putDataDisk(value: StatefulNodeAzureDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | StatefulNodeAzureDataDisk[] | undefined;
    private _delete;
    get delete(): StatefulNodeAzureDeleteList;
    putDelete(value: StatefulNodeAzureDelete[] | cdktf.IResolvable): void;
    resetDelete(): void;
    get deleteInput(): cdktf.IResolvable | StatefulNodeAzureDelete[] | undefined;
    private _detachDataDisk;
    get detachDataDisk(): StatefulNodeAzureDetachDataDiskList;
    putDetachDataDisk(value: StatefulNodeAzureDetachDataDisk[] | cdktf.IResolvable): void;
    resetDetachDataDisk(): void;
    get detachDataDiskInput(): cdktf.IResolvable | StatefulNodeAzureDetachDataDisk[] | undefined;
    private _extension;
    get extension(): StatefulNodeAzureExtensionList;
    putExtension(value: StatefulNodeAzureExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | StatefulNodeAzureExtension[] | undefined;
    private _health;
    get health(): StatefulNodeAzureHealthOutputReference;
    putHealth(value: StatefulNodeAzureHealth): void;
    resetHealth(): void;
    get healthInput(): StatefulNodeAzureHealth | undefined;
    private _image;
    get image(): StatefulNodeAzureImageOutputReference;
    putImage(value: StatefulNodeAzureImage): void;
    get imageInput(): StatefulNodeAzureImage | undefined;
    private _importVm;
    get importVm(): StatefulNodeAzureImportVmList;
    putImportVm(value: StatefulNodeAzureImportVm[] | cdktf.IResolvable): void;
    resetImportVm(): void;
    get importVmInput(): cdktf.IResolvable | StatefulNodeAzureImportVm[] | undefined;
    private _loadBalancer;
    get loadBalancer(): StatefulNodeAzureLoadBalancerList;
    putLoadBalancer(value: StatefulNodeAzureLoadBalancer[] | cdktf.IResolvable): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): cdktf.IResolvable | StatefulNodeAzureLoadBalancer[] | undefined;
    private _login;
    get login(): StatefulNodeAzureLoginOutputReference;
    putLogin(value: StatefulNodeAzureLogin): void;
    get loginInput(): StatefulNodeAzureLogin | undefined;
    private _managedServiceIdentities;
    get managedServiceIdentities(): StatefulNodeAzureManagedServiceIdentitiesList;
    putManagedServiceIdentities(value: StatefulNodeAzureManagedServiceIdentities[] | cdktf.IResolvable): void;
    resetManagedServiceIdentities(): void;
    get managedServiceIdentitiesInput(): cdktf.IResolvable | StatefulNodeAzureManagedServiceIdentities[] | undefined;
    private _network;
    get network(): StatefulNodeAzureNetworkOutputReference;
    putNetwork(value: StatefulNodeAzureNetwork): void;
    get networkInput(): StatefulNodeAzureNetwork | undefined;
    private _osDisk;
    get osDisk(): StatefulNodeAzureOsDiskOutputReference;
    putOsDisk(value: StatefulNodeAzureOsDisk): void;
    resetOsDisk(): void;
    get osDiskInput(): StatefulNodeAzureOsDisk | undefined;
    private _schedulingTask;
    get schedulingTask(): StatefulNodeAzureSchedulingTaskList;
    putSchedulingTask(value: StatefulNodeAzureSchedulingTask[] | cdktf.IResolvable): void;
    resetSchedulingTask(): void;
    get schedulingTaskInput(): cdktf.IResolvable | StatefulNodeAzureSchedulingTask[] | undefined;
    private _secret;
    get secret(): StatefulNodeAzureSecretList;
    putSecret(value: StatefulNodeAzureSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | StatefulNodeAzureSecret[] | undefined;
    private _signal;
    get signal(): StatefulNodeAzureSignalList;
    putSignal(value: StatefulNodeAzureSignal[] | cdktf.IResolvable): void;
    resetSignal(): void;
    get signalInput(): cdktf.IResolvable | StatefulNodeAzureSignal[] | undefined;
    private _strategy;
    get strategy(): StatefulNodeAzureStrategyOutputReference;
    putStrategy(value: StatefulNodeAzureStrategy): void;
    get strategyInput(): StatefulNodeAzureStrategy | undefined;
    private _tag;
    get tag(): StatefulNodeAzureTagList;
    putTag(value: StatefulNodeAzureTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | StatefulNodeAzureTag[] | undefined;
    private _updateState;
    get updateState(): StatefulNodeAzureUpdateStateList;
    putUpdateState(value: StatefulNodeAzureUpdateState[] | cdktf.IResolvable): void;
    resetUpdateState(): void;
    get updateStateInput(): cdktf.IResolvable | StatefulNodeAzureUpdateState[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
