# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContentLibraryArgs', 'ContentLibrary']

@pulumi.input_type
class ContentLibraryArgs:
    def __init__(__self__, *,
                 storage_backings: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publication: Optional[pulumi.Input['ContentLibraryPublicationArgs']] = None,
                 subscription: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']] = None):
        """
        The set of arguments for constructing a ContentLibrary resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[_builtins.str] description: A description for the content library.
        :param pulumi.Input[_builtins.str] name: The name of the content library.
        :param pulumi.Input['ContentLibraryPublicationArgs'] publication: Options to publish a local content library.
        :param pulumi.Input['ContentLibrarySubscriptionArgs'] subscription: Options subscribe to a published content library.
        """
        pulumi.set(__self__, "storage_backings", storage_backings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publication is not None:
            pulumi.set(__self__, "publication", publication)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @_builtins.property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @storage_backings.setter
    def storage_backings(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "storage_backings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def publication(self) -> Optional[pulumi.Input['ContentLibraryPublicationArgs']]:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: Optional[pulumi.Input['ContentLibraryPublicationArgs']]):
        pulumi.set(self, "publication", value)

    @_builtins.property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]):
        pulumi.set(self, "subscription", value)


@pulumi.input_type
class _ContentLibraryState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publication: Optional[pulumi.Input['ContentLibraryPublicationArgs']] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscription: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']] = None):
        """
        Input properties used for looking up and filtering ContentLibrary resources.
        :param pulumi.Input[_builtins.str] description: A description for the content library.
        :param pulumi.Input[_builtins.str] name: The name of the content library.
        :param pulumi.Input['ContentLibraryPublicationArgs'] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input['ContentLibrarySubscriptionArgs'] subscription: Options subscribe to a published content library.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publication is not None:
            pulumi.set(__self__, "publication", publication)
        if storage_backings is not None:
            pulumi.set(__self__, "storage_backings", storage_backings)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def publication(self) -> Optional[pulumi.Input['ContentLibraryPublicationArgs']]:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: Optional[pulumi.Input['ContentLibraryPublicationArgs']]):
        pulumi.set(self, "publication", value)

    @_builtins.property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @storage_backings.setter
    def storage_backings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage_backings", value)

    @_builtins.property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input['ContentLibrarySubscriptionArgs']]):
        pulumi.set(self, "subscription", value)


@pulumi.type_token("vsphere:index/contentLibrary:ContentLibrary")
class ContentLibrary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publication: Optional[pulumi.Input[Union['ContentLibraryPublicationArgs', 'ContentLibraryPublicationArgsDict']]] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscription: Optional[pulumi.Input[Union['ContentLibrarySubscriptionArgs', 'ContentLibrarySubscriptionArgsDict']]] = None,
                 __props__=None):
        """
        The `ContentLibrary` resource can be used to manage content libraries.

        > **NOTE:** This resource requires a vCenter Server instance and is not available on direct ESXi host connections.

        ## Example Usage

        The following example creates a publishing content library using the datastore named `publisher-datastore` as the storage backing.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter_a = vsphere.get_datacenter(name="dc-01-a")
        publisher_datastore = vsphere.get_datastore(name="publisher-datastore",
            datacenter_id=datacenter_a.id)
        publisher_content_library = vsphere.ContentLibrary("publisher_content_library",
            name="Publisher Content Library",
            description="A publishing content library.",
            storage_backings=[publisher_datastore.id])
        ```

        The next example creates a subscribed content library using the URL of the publisher content library as the source and the datastore named `subscriber-datastore` as the storage backing.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter_b = vsphere.get_datacenter(name="dc-01-b")
        subscriber_datastore = vsphere.get_datastore(name="subscriber-datastore",
            datacenter_id=datacenter_b.id)
        subscriber_content_library = vsphere.ContentLibrary("subscriber_content_library",
            name="Subscriber Content Library",
            description="A subscribing content library.",
            storage_backings=[subscriber_datastore.id],
            subscription={
                "subscription_url": "https://vc-01-a.example.com:443/cls/vcsp/lib/f42a4b25-844a-44ec-9063-a3a5e9cc88c7/lib.json",
                "automatic_sync": True,
                "on_demand": False,
            })
        ```

        ## Import

        An existing content library can be imported into this resource by supplying the content library ID. For example:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/contentLibrary:ContentLibrary vsphere_content_library publisher_content_library f42a4b25-844a-44ec-9063-a3a5e9cc88c7
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the content library.
        :param pulumi.Input[_builtins.str] name: The name of the content library.
        :param pulumi.Input[Union['ContentLibraryPublicationArgs', 'ContentLibraryPublicationArgsDict']] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[Union['ContentLibrarySubscriptionArgs', 'ContentLibrarySubscriptionArgsDict']] subscription: Options subscribe to a published content library.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentLibraryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ContentLibrary` resource can be used to manage content libraries.

        > **NOTE:** This resource requires a vCenter Server instance and is not available on direct ESXi host connections.

        ## Example Usage

        The following example creates a publishing content library using the datastore named `publisher-datastore` as the storage backing.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter_a = vsphere.get_datacenter(name="dc-01-a")
        publisher_datastore = vsphere.get_datastore(name="publisher-datastore",
            datacenter_id=datacenter_a.id)
        publisher_content_library = vsphere.ContentLibrary("publisher_content_library",
            name="Publisher Content Library",
            description="A publishing content library.",
            storage_backings=[publisher_datastore.id])
        ```

        The next example creates a subscribed content library using the URL of the publisher content library as the source and the datastore named `subscriber-datastore` as the storage backing.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter_b = vsphere.get_datacenter(name="dc-01-b")
        subscriber_datastore = vsphere.get_datastore(name="subscriber-datastore",
            datacenter_id=datacenter_b.id)
        subscriber_content_library = vsphere.ContentLibrary("subscriber_content_library",
            name="Subscriber Content Library",
            description="A subscribing content library.",
            storage_backings=[subscriber_datastore.id],
            subscription={
                "subscription_url": "https://vc-01-a.example.com:443/cls/vcsp/lib/f42a4b25-844a-44ec-9063-a3a5e9cc88c7/lib.json",
                "automatic_sync": True,
                "on_demand": False,
            })
        ```

        ## Import

        An existing content library can be imported into this resource by supplying the content library ID. For example:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/contentLibrary:ContentLibrary vsphere_content_library publisher_content_library f42a4b25-844a-44ec-9063-a3a5e9cc88c7
        ```

        :param str resource_name: The name of the resource.
        :param ContentLibraryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentLibraryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publication: Optional[pulumi.Input[Union['ContentLibraryPublicationArgs', 'ContentLibraryPublicationArgsDict']]] = None,
                 storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscription: Optional[pulumi.Input[Union['ContentLibrarySubscriptionArgs', 'ContentLibrarySubscriptionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentLibraryArgs.__new__(ContentLibraryArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["publication"] = publication
            if storage_backings is None and not opts.urn:
                raise TypeError("Missing required property 'storage_backings'")
            __props__.__dict__["storage_backings"] = storage_backings
            __props__.__dict__["subscription"] = subscription
        super(ContentLibrary, __self__).__init__(
            'vsphere:index/contentLibrary:ContentLibrary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            publication: Optional[pulumi.Input[Union['ContentLibraryPublicationArgs', 'ContentLibraryPublicationArgsDict']]] = None,
            storage_backings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subscription: Optional[pulumi.Input[Union['ContentLibrarySubscriptionArgs', 'ContentLibrarySubscriptionArgsDict']]] = None) -> 'ContentLibrary':
        """
        Get an existing ContentLibrary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the content library.
        :param pulumi.Input[_builtins.str] name: The name of the content library.
        :param pulumi.Input[Union['ContentLibraryPublicationArgs', 'ContentLibraryPublicationArgsDict']] publication: Options to publish a local content library.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_backings: The managed object reference ID of the datastore on which to store the content library items.
        :param pulumi.Input[Union['ContentLibrarySubscriptionArgs', 'ContentLibrarySubscriptionArgsDict']] subscription: Options subscribe to a published content library.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentLibraryState.__new__(_ContentLibraryState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["publication"] = publication
        __props__.__dict__["storage_backings"] = storage_backings
        __props__.__dict__["subscription"] = subscription
        return ContentLibrary(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the content library.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the content library.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publication(self) -> pulumi.Output['outputs.ContentLibraryPublication']:
        """
        Options to publish a local content library.
        """
        return pulumi.get(self, "publication")

    @_builtins.property
    @pulumi.getter(name="storageBackings")
    def storage_backings(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The managed object reference ID of the datastore on which to store the content library items.
        """
        return pulumi.get(self, "storage_backings")

    @_builtins.property
    @pulumi.getter
    def subscription(self) -> pulumi.Output[Optional['outputs.ContentLibrarySubscription']]:
        """
        Options subscribe to a published content library.
        """
        return pulumi.get(self, "subscription")

