# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContentLibraryItemArgs', 'ContentLibraryItem']

@pulumi.input_type
class ContentLibraryItemArgs:
    def __init__(__self__, *,
                 library_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ContentLibraryItem resource.
        :param pulumi.Input[_builtins.str] library_id: The ID of the content library in which to create the item.
        :param pulumi.Input[_builtins.str] description: A description for the content library item.
        :param pulumi.Input[_builtins.str] file_url: File to import as the content library item.
        :param pulumi.Input[_builtins.str] name: The name of the item to be created in the content library.
        :param pulumi.Input[_builtins.str] source_uuid: Virtual machine UUID to clone to content library.
        :param pulumi.Input[_builtins.str] type: Type of content library item.
               One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        pulumi.set(__self__, "library_id", library_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_url is not None:
            pulumi.set(__self__, "file_url", file_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_uuid is not None:
            pulumi.set(__self__, "source_uuid", source_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="libraryId")
    def library_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the content library in which to create the item.
        """
        return pulumi.get(self, "library_id")

    @library_id.setter
    def library_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "library_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the content library item.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileUrl")
    def file_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File to import as the content library item.
        """
        return pulumi.get(self, "file_url")

    @file_url.setter
    def file_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the item to be created in the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceUuid")
    def source_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual machine UUID to clone to content library.
        """
        return pulumi.get(self, "source_uuid")

    @source_uuid.setter
    def source_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uuid", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of content library item.
        One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ContentLibraryItemState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 library_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContentLibraryItem resources.
        :param pulumi.Input[_builtins.str] description: A description for the content library item.
        :param pulumi.Input[_builtins.str] file_url: File to import as the content library item.
        :param pulumi.Input[_builtins.str] library_id: The ID of the content library in which to create the item.
        :param pulumi.Input[_builtins.str] name: The name of the item to be created in the content library.
        :param pulumi.Input[_builtins.str] source_uuid: Virtual machine UUID to clone to content library.
        :param pulumi.Input[_builtins.str] type: Type of content library item.
               One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_url is not None:
            pulumi.set(__self__, "file_url", file_url)
        if library_id is not None:
            pulumi.set(__self__, "library_id", library_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_uuid is not None:
            pulumi.set(__self__, "source_uuid", source_uuid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the content library item.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileUrl")
    def file_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File to import as the content library item.
        """
        return pulumi.get(self, "file_url")

    @file_url.setter
    def file_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_url", value)

    @_builtins.property
    @pulumi.getter(name="libraryId")
    def library_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the content library in which to create the item.
        """
        return pulumi.get(self, "library_id")

    @library_id.setter
    def library_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "library_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the item to be created in the content library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceUuid")
    def source_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual machine UUID to clone to content library.
        """
        return pulumi.get(self, "source_uuid")

    @source_uuid.setter
    def source_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uuid", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of content library item.
        One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vsphere:index/contentLibraryItem:ContentLibraryItem")
class ContentLibraryItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 library_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ContentLibraryItem` resource can be used to create items in a
        vSphere content library. The `file_url` must be accessible from the vSphere
        environment as it will be downloaded from the specified location and stored
        on the content library's storage backing.

        ## Example Usage

        The first example below imports an OVF Template to a content
        library.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="ovf-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS OVF Template",
            file_url="https://releases.example.com/ubuntu/ubuntu/ubuntu-live-server-amd64.ovf",
            library_id=content_library.id)
        ```

        The next example imports an .iso image to a content library.

        [tf-vsphere-vm-resource]: /docs/providers/vsphere/r/virtual_machine.html

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="iso-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS .iso",
            type="iso",
            file_url="https://releases.example.com/ubuntu/ubuntu-live-server-amd64.iso",
            library_id=content_library.id)
        ```

        The last example imports a virtual machine image to a content library from an
        existing virtual machine.

        [tf-vsphere-vm-resource]: /docs/providers/vsphere/r/virtual_machine.html

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="tpl-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS",
            source_uuid="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            library_id=content_library.id)
        ```

        ## Import

        An existing content library item can be imported into this resource by

        supplying the content library ID. An example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/contentLibraryItem:ContentLibraryItem vsphere_content_library_item iso-linux-ubuntu-server-lts xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the content library item.
        :param pulumi.Input[_builtins.str] file_url: File to import as the content library item.
        :param pulumi.Input[_builtins.str] library_id: The ID of the content library in which to create the item.
        :param pulumi.Input[_builtins.str] name: The name of the item to be created in the content library.
        :param pulumi.Input[_builtins.str] source_uuid: Virtual machine UUID to clone to content library.
        :param pulumi.Input[_builtins.str] type: Type of content library item.
               One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentLibraryItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ContentLibraryItem` resource can be used to create items in a
        vSphere content library. The `file_url` must be accessible from the vSphere
        environment as it will be downloaded from the specified location and stored
        on the content library's storage backing.

        ## Example Usage

        The first example below imports an OVF Template to a content
        library.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="ovf-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS OVF Template",
            file_url="https://releases.example.com/ubuntu/ubuntu/ubuntu-live-server-amd64.ovf",
            library_id=content_library.id)
        ```

        The next example imports an .iso image to a content library.

        [tf-vsphere-vm-resource]: /docs/providers/vsphere/r/virtual_machine.html

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="iso-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS .iso",
            type="iso",
            file_url="https://releases.example.com/ubuntu/ubuntu-live-server-amd64.iso",
            library_id=content_library.id)
        ```

        The last example imports a virtual machine image to a content library from an
        existing virtual machine.

        [tf-vsphere-vm-resource]: /docs/providers/vsphere/r/virtual_machine.html

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        content_library = vsphere.get_content_library(name="clb-01")
        content_library_item = vsphere.ContentLibraryItem("content_library_item",
            name="tpl-linux-ubuntu-server-lts",
            description="Ubuntu Server LTS",
            source_uuid="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            library_id=content_library.id)
        ```

        ## Import

        An existing content library item can be imported into this resource by

        supplying the content library ID. An example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/contentLibraryItem:ContentLibraryItem vsphere_content_library_item iso-linux-ubuntu-server-lts xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ContentLibraryItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentLibraryItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_url: Optional[pulumi.Input[_builtins.str]] = None,
                 library_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentLibraryItemArgs.__new__(ContentLibraryItemArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["file_url"] = file_url
            if library_id is None and not opts.urn:
                raise TypeError("Missing required property 'library_id'")
            __props__.__dict__["library_id"] = library_id
            __props__.__dict__["name"] = name
            __props__.__dict__["source_uuid"] = source_uuid
            __props__.__dict__["type"] = type
        super(ContentLibraryItem, __self__).__init__(
            'vsphere:index/contentLibraryItem:ContentLibraryItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_url: Optional[pulumi.Input[_builtins.str]] = None,
            library_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ContentLibraryItem':
        """
        Get an existing ContentLibraryItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the content library item.
        :param pulumi.Input[_builtins.str] file_url: File to import as the content library item.
        :param pulumi.Input[_builtins.str] library_id: The ID of the content library in which to create the item.
        :param pulumi.Input[_builtins.str] name: The name of the item to be created in the content library.
        :param pulumi.Input[_builtins.str] source_uuid: Virtual machine UUID to clone to content library.
        :param pulumi.Input[_builtins.str] type: Type of content library item.
               One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentLibraryItemState.__new__(_ContentLibraryItemState)

        __props__.__dict__["description"] = description
        __props__.__dict__["file_url"] = file_url
        __props__.__dict__["library_id"] = library_id
        __props__.__dict__["name"] = name
        __props__.__dict__["source_uuid"] = source_uuid
        __props__.__dict__["type"] = type
        return ContentLibraryItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the content library item.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileUrl")
    def file_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        File to import as the content library item.
        """
        return pulumi.get(self, "file_url")

    @_builtins.property
    @pulumi.getter(name="libraryId")
    def library_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the content library in which to create the item.
        """
        return pulumi.get(self, "library_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the item to be created in the content library.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceUuid")
    def source_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Virtual machine UUID to clone to content library.
        """
        return pulumi.get(self, "source_uuid")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of content library item.
        One of "ovf", "iso", or "vm-template". Default: `ovf`.
        """
        return pulumi.get(self, "type")

