# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SupervisorArgs', 'Supervisor']

@pulumi.input_type
class SupervisorArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[_builtins.str],
                 content_library: pulumi.Input[_builtins.str],
                 dvs_uuid: pulumi.Input[_builtins.str],
                 edge_cluster: pulumi.Input[_builtins.str],
                 egress_cidrs: pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]],
                 ingress_cidrs: pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]],
                 main_dns: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 main_ntps: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 management_network: pulumi.Input['SupervisorManagementNetworkArgs'],
                 pod_cidrs: pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]],
                 search_domains: pulumi.Input[_builtins.str],
                 service_cidr: pulumi.Input['SupervisorServiceCidrArgs'],
                 sizing_hint: pulumi.Input[_builtins.str],
                 storage_policy: pulumi.Input[_builtins.str],
                 worker_dns: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 worker_ntps: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]] = None):
        """
        The set of arguments for constructing a Supervisor resource.
        :param pulumi.Input[_builtins.str] cluster: The identifier of the compute cluster.
        :param pulumi.Input[_builtins.str] content_library: The identifier of the subscribed content library.
        :param pulumi.Input[_builtins.str] dvs_uuid: The UUID of the distributed switch.
        :param pulumi.Input[_builtins.str] edge_cluster: The identifier of the NSX Edge Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]] egress_cidrs: CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]] ingress_cidrs: CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_dns: The list of addresses of the primary DNS servers.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_ntps: The list of addresses of the primary NTP servers.
        :param pulumi.Input['SupervisorManagementNetworkArgs'] management_network: The configuration for the management network which the control plane VMs will be connected to.
               * * `network` - ID of the network. (e.g. a distributed port group).
               * * `starting_address` - Starting address of the management network range.
               * * `subnet_mask` - Subnet mask.
               * * `gateway` - Gateway IP address.
               * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]] pod_cidrs: CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        :param pulumi.Input[_builtins.str] search_domains: List of DNS search domains.
        :param pulumi.Input['SupervisorServiceCidrArgs'] service_cidr: CIDR block from which Kubernetes allocates service cluster IP addresses.
        :param pulumi.Input[_builtins.str] sizing_hint: The size of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] storage_policy: The name of the storage policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_dns: The list of addresses of the DNS servers to use for the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_ntps: The list of addresses of the NTP servers to use for the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]] namespaces: The list of namespaces to create in the Supervisor cluster
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "content_library", content_library)
        pulumi.set(__self__, "dvs_uuid", dvs_uuid)
        pulumi.set(__self__, "edge_cluster", edge_cluster)
        pulumi.set(__self__, "egress_cidrs", egress_cidrs)
        pulumi.set(__self__, "ingress_cidrs", ingress_cidrs)
        pulumi.set(__self__, "main_dns", main_dns)
        pulumi.set(__self__, "main_ntps", main_ntps)
        pulumi.set(__self__, "management_network", management_network)
        pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        pulumi.set(__self__, "search_domains", search_domains)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "sizing_hint", sizing_hint)
        pulumi.set(__self__, "storage_policy", storage_policy)
        pulumi.set(__self__, "worker_dns", worker_dns)
        pulumi.set(__self__, "worker_ntps", worker_ntps)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the compute cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="contentLibrary")
    def content_library(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the subscribed content library.
        """
        return pulumi.get(self, "content_library")

    @content_library.setter
    def content_library(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_library", value)

    @_builtins.property
    @pulumi.getter(name="dvsUuid")
    def dvs_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        The UUID of the distributed switch.
        """
        return pulumi.get(self, "dvs_uuid")

    @dvs_uuid.setter
    def dvs_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dvs_uuid", value)

    @_builtins.property
    @pulumi.getter(name="edgeCluster")
    def edge_cluster(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the NSX Edge Cluster.
        """
        return pulumi.get(self, "edge_cluster")

    @edge_cluster.setter
    def edge_cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "edge_cluster", value)

    @_builtins.property
    @pulumi.getter(name="egressCidrs")
    def egress_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]]:
        """
        CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        """
        return pulumi.get(self, "egress_cidrs")

    @egress_cidrs.setter
    def egress_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]]):
        pulumi.set(self, "egress_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="ingressCidrs")
    def ingress_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]]:
        """
        CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        """
        return pulumi.get(self, "ingress_cidrs")

    @ingress_cidrs.setter
    def ingress_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]]):
        pulumi.set(self, "ingress_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="mainDns")
    def main_dns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of addresses of the primary DNS servers.
        """
        return pulumi.get(self, "main_dns")

    @main_dns.setter
    def main_dns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "main_dns", value)

    @_builtins.property
    @pulumi.getter(name="mainNtps")
    def main_ntps(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of addresses of the primary NTP servers.
        """
        return pulumi.get(self, "main_ntps")

    @main_ntps.setter
    def main_ntps(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "main_ntps", value)

    @_builtins.property
    @pulumi.getter(name="managementNetwork")
    def management_network(self) -> pulumi.Input['SupervisorManagementNetworkArgs']:
        """
        The configuration for the management network which the control plane VMs will be connected to.
        * * `network` - ID of the network. (e.g. a distributed port group).
        * * `starting_address` - Starting address of the management network range.
        * * `subnet_mask` - Subnet mask.
        * * `gateway` - Gateway IP address.
        * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        """
        return pulumi.get(self, "management_network")

    @management_network.setter
    def management_network(self, value: pulumi.Input['SupervisorManagementNetworkArgs']):
        pulumi.set(self, "management_network", value)

    @_builtins.property
    @pulumi.getter(name="podCidrs")
    def pod_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]]:
        """
        CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        """
        return pulumi.get(self, "pod_cidrs")

    @pod_cidrs.setter
    def pod_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]]):
        pulumi.set(self, "pod_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> pulumi.Input[_builtins.str]:
        """
        List of DNS search domains.
        """
        return pulumi.get(self, "search_domains")

    @search_domains.setter
    def search_domains(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "search_domains", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Input['SupervisorServiceCidrArgs']:
        """
        CIDR block from which Kubernetes allocates service cluster IP addresses.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: pulumi.Input['SupervisorServiceCidrArgs']):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sizingHint")
    def sizing_hint(self) -> pulumi.Input[_builtins.str]:
        """
        The size of the Kubernetes API server.
        """
        return pulumi.get(self, "sizing_hint")

    @sizing_hint.setter
    def sizing_hint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sizing_hint", value)

    @_builtins.property
    @pulumi.getter(name="storagePolicy")
    def storage_policy(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the storage policy.
        """
        return pulumi.get(self, "storage_policy")

    @storage_policy.setter
    def storage_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_policy", value)

    @_builtins.property
    @pulumi.getter(name="workerDns")
    def worker_dns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of addresses of the DNS servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_dns")

    @worker_dns.setter
    def worker_dns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "worker_dns", value)

    @_builtins.property
    @pulumi.getter(name="workerNtps")
    def worker_ntps(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of addresses of the NTP servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_ntps")

    @worker_ntps.setter
    def worker_ntps(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "worker_ntps", value)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]]:
        """
        The list of namespaces to create in the Supervisor cluster
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]]):
        pulumi.set(self, "namespaces", value)


@pulumi.input_type
class _SupervisorState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 content_library: Optional[pulumi.Input[_builtins.str]] = None,
                 dvs_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]]] = None,
                 ingress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]]] = None,
                 main_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_network: Optional[pulumi.Input['SupervisorManagementNetworkArgs']] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]]] = None,
                 search_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input['SupervisorServiceCidrArgs']] = None,
                 sizing_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Supervisor resources.
        :param pulumi.Input[_builtins.str] cluster: The identifier of the compute cluster.
        :param pulumi.Input[_builtins.str] content_library: The identifier of the subscribed content library.
        :param pulumi.Input[_builtins.str] dvs_uuid: The UUID of the distributed switch.
        :param pulumi.Input[_builtins.str] edge_cluster: The identifier of the NSX Edge Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]] egress_cidrs: CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]] ingress_cidrs: CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_dns: The list of addresses of the primary DNS servers.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_ntps: The list of addresses of the primary NTP servers.
        :param pulumi.Input['SupervisorManagementNetworkArgs'] management_network: The configuration for the management network which the control plane VMs will be connected to.
               * * `network` - ID of the network. (e.g. a distributed port group).
               * * `starting_address` - Starting address of the management network range.
               * * `subnet_mask` - Subnet mask.
               * * `gateway` - Gateway IP address.
               * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]] namespaces: The list of namespaces to create in the Supervisor cluster
        :param pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]] pod_cidrs: CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        :param pulumi.Input[_builtins.str] search_domains: List of DNS search domains.
        :param pulumi.Input['SupervisorServiceCidrArgs'] service_cidr: CIDR block from which Kubernetes allocates service cluster IP addresses.
        :param pulumi.Input[_builtins.str] sizing_hint: The size of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] storage_policy: The name of the storage policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_dns: The list of addresses of the DNS servers to use for the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_ntps: The list of addresses of the NTP servers to use for the worker nodes.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if content_library is not None:
            pulumi.set(__self__, "content_library", content_library)
        if dvs_uuid is not None:
            pulumi.set(__self__, "dvs_uuid", dvs_uuid)
        if edge_cluster is not None:
            pulumi.set(__self__, "edge_cluster", edge_cluster)
        if egress_cidrs is not None:
            pulumi.set(__self__, "egress_cidrs", egress_cidrs)
        if ingress_cidrs is not None:
            pulumi.set(__self__, "ingress_cidrs", ingress_cidrs)
        if main_dns is not None:
            pulumi.set(__self__, "main_dns", main_dns)
        if main_ntps is not None:
            pulumi.set(__self__, "main_ntps", main_ntps)
        if management_network is not None:
            pulumi.set(__self__, "management_network", management_network)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if search_domains is not None:
            pulumi.set(__self__, "search_domains", search_domains)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if sizing_hint is not None:
            pulumi.set(__self__, "sizing_hint", sizing_hint)
        if storage_policy is not None:
            pulumi.set(__self__, "storage_policy", storage_policy)
        if worker_dns is not None:
            pulumi.set(__self__, "worker_dns", worker_dns)
        if worker_ntps is not None:
            pulumi.set(__self__, "worker_ntps", worker_ntps)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the compute cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="contentLibrary")
    def content_library(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the subscribed content library.
        """
        return pulumi.get(self, "content_library")

    @content_library.setter
    def content_library(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_library", value)

    @_builtins.property
    @pulumi.getter(name="dvsUuid")
    def dvs_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the distributed switch.
        """
        return pulumi.get(self, "dvs_uuid")

    @dvs_uuid.setter
    def dvs_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dvs_uuid", value)

    @_builtins.property
    @pulumi.getter(name="edgeCluster")
    def edge_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the NSX Edge Cluster.
        """
        return pulumi.get(self, "edge_cluster")

    @edge_cluster.setter
    def edge_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_cluster", value)

    @_builtins.property
    @pulumi.getter(name="egressCidrs")
    def egress_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]]]:
        """
        CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        """
        return pulumi.get(self, "egress_cidrs")

    @egress_cidrs.setter
    def egress_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorEgressCidrArgs']]]]):
        pulumi.set(self, "egress_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="ingressCidrs")
    def ingress_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]]]:
        """
        CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        """
        return pulumi.get(self, "ingress_cidrs")

    @ingress_cidrs.setter
    def ingress_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorIngressCidrArgs']]]]):
        pulumi.set(self, "ingress_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="mainDns")
    def main_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of addresses of the primary DNS servers.
        """
        return pulumi.get(self, "main_dns")

    @main_dns.setter
    def main_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "main_dns", value)

    @_builtins.property
    @pulumi.getter(name="mainNtps")
    def main_ntps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of addresses of the primary NTP servers.
        """
        return pulumi.get(self, "main_ntps")

    @main_ntps.setter
    def main_ntps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "main_ntps", value)

    @_builtins.property
    @pulumi.getter(name="managementNetwork")
    def management_network(self) -> Optional[pulumi.Input['SupervisorManagementNetworkArgs']]:
        """
        The configuration for the management network which the control plane VMs will be connected to.
        * * `network` - ID of the network. (e.g. a distributed port group).
        * * `starting_address` - Starting address of the management network range.
        * * `subnet_mask` - Subnet mask.
        * * `gateway` - Gateway IP address.
        * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        """
        return pulumi.get(self, "management_network")

    @management_network.setter
    def management_network(self, value: Optional[pulumi.Input['SupervisorManagementNetworkArgs']]):
        pulumi.set(self, "management_network", value)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]]:
        """
        The list of namespaces to create in the Supervisor cluster
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorNamespaceArgs']]]]):
        pulumi.set(self, "namespaces", value)

    @_builtins.property
    @pulumi.getter(name="podCidrs")
    def pod_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]]]:
        """
        CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        """
        return pulumi.get(self, "pod_cidrs")

    @pod_cidrs.setter
    def pod_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SupervisorPodCidrArgs']]]]):
        pulumi.set(self, "pod_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of DNS search domains.
        """
        return pulumi.get(self, "search_domains")

    @search_domains.setter
    def search_domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_domains", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input['SupervisorServiceCidrArgs']]:
        """
        CIDR block from which Kubernetes allocates service cluster IP addresses.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input['SupervisorServiceCidrArgs']]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="sizingHint")
    def sizing_hint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the Kubernetes API server.
        """
        return pulumi.get(self, "sizing_hint")

    @sizing_hint.setter
    def sizing_hint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sizing_hint", value)

    @_builtins.property
    @pulumi.getter(name="storagePolicy")
    def storage_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the storage policy.
        """
        return pulumi.get(self, "storage_policy")

    @storage_policy.setter
    def storage_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_policy", value)

    @_builtins.property
    @pulumi.getter(name="workerDns")
    def worker_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of addresses of the DNS servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_dns")

    @worker_dns.setter
    def worker_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_dns", value)

    @_builtins.property
    @pulumi.getter(name="workerNtps")
    def worker_ntps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of addresses of the NTP servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_ntps")

    @worker_ntps.setter
    def worker_ntps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_ntps", value)


@pulumi.type_token("vsphere:index/supervisor:Supervisor")
class Supervisor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 content_library: Optional[pulumi.Input[_builtins.str]] = None,
                 dvs_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorEgressCidrArgs', 'SupervisorEgressCidrArgsDict']]]]] = None,
                 ingress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorIngressCidrArgs', 'SupervisorIngressCidrArgsDict']]]]] = None,
                 main_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_network: Optional[pulumi.Input[Union['SupervisorManagementNetworkArgs', 'SupervisorManagementNetworkArgsDict']]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorNamespaceArgs', 'SupervisorNamespaceArgsDict']]]]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorPodCidrArgs', 'SupervisorPodCidrArgsDict']]]]] = None,
                 search_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[Union['SupervisorServiceCidrArgs', 'SupervisorServiceCidrArgsDict']]] = None,
                 sizing_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource for configuring Workload Management.

        ## Example Usage

        ### S

        ### Enable Workload Management on a Compute Cluster

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vm_class = vsphere.VirtualMachineClass("vm_class",
            name="custom-class",
            cpus=4,
            memory=4096)
        supervisor = vsphere.Supervisor("supervisor",
            cluster="<compute_cluster_id>",
            storage_policy="<storage_policy_name>",
            content_library="<content_library_id>",
            main_dns="10.0.0.250",
            worker_dns="10.0.0.250",
            edge_cluster="<edge_cluster_id>",
            dvs_uuid="<distributed_switch_uuid>",
            sizing_hint="MEDIUM",
            management_network={
                "network": "<portgroup_id>",
                "subnet_mask": "255.255.255.0",
                "starting_address": "10.0.0.150",
                "gateway": "10.0.0.250",
                "address_count": 5,
            },
            ingress_cidrs=[{
                "address": "10.10.10.0",
                "prefix": 24,
            }],
            egress_cidrs=[{
                "address": "10.10.11.0",
                "prefix": 24,
            }],
            pod_cidrs=[{
                "address": "10.244.10.0",
                "prefix": 23,
            }],
            service_cidr={
                "address": "10.10.12.0",
                "prefix": 24,
            },
            search_domains="vsphere.local",
            namespaces=[{
                "name": "custom-namespace",
                "content_libraries": [],
                "vm_classes": [vm_class.id],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster: The identifier of the compute cluster.
        :param pulumi.Input[_builtins.str] content_library: The identifier of the subscribed content library.
        :param pulumi.Input[_builtins.str] dvs_uuid: The UUID of the distributed switch.
        :param pulumi.Input[_builtins.str] edge_cluster: The identifier of the NSX Edge Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorEgressCidrArgs', 'SupervisorEgressCidrArgsDict']]]] egress_cidrs: CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorIngressCidrArgs', 'SupervisorIngressCidrArgsDict']]]] ingress_cidrs: CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_dns: The list of addresses of the primary DNS servers.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_ntps: The list of addresses of the primary NTP servers.
        :param pulumi.Input[Union['SupervisorManagementNetworkArgs', 'SupervisorManagementNetworkArgsDict']] management_network: The configuration for the management network which the control plane VMs will be connected to.
               * * `network` - ID of the network. (e.g. a distributed port group).
               * * `starting_address` - Starting address of the management network range.
               * * `subnet_mask` - Subnet mask.
               * * `gateway` - Gateway IP address.
               * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorNamespaceArgs', 'SupervisorNamespaceArgsDict']]]] namespaces: The list of namespaces to create in the Supervisor cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorPodCidrArgs', 'SupervisorPodCidrArgsDict']]]] pod_cidrs: CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        :param pulumi.Input[_builtins.str] search_domains: List of DNS search domains.
        :param pulumi.Input[Union['SupervisorServiceCidrArgs', 'SupervisorServiceCidrArgsDict']] service_cidr: CIDR block from which Kubernetes allocates service cluster IP addresses.
        :param pulumi.Input[_builtins.str] sizing_hint: The size of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] storage_policy: The name of the storage policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_dns: The list of addresses of the DNS servers to use for the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_ntps: The list of addresses of the NTP servers to use for the worker nodes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SupervisorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for configuring Workload Management.

        ## Example Usage

        ### S

        ### Enable Workload Management on a Compute Cluster

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vm_class = vsphere.VirtualMachineClass("vm_class",
            name="custom-class",
            cpus=4,
            memory=4096)
        supervisor = vsphere.Supervisor("supervisor",
            cluster="<compute_cluster_id>",
            storage_policy="<storage_policy_name>",
            content_library="<content_library_id>",
            main_dns="10.0.0.250",
            worker_dns="10.0.0.250",
            edge_cluster="<edge_cluster_id>",
            dvs_uuid="<distributed_switch_uuid>",
            sizing_hint="MEDIUM",
            management_network={
                "network": "<portgroup_id>",
                "subnet_mask": "255.255.255.0",
                "starting_address": "10.0.0.150",
                "gateway": "10.0.0.250",
                "address_count": 5,
            },
            ingress_cidrs=[{
                "address": "10.10.10.0",
                "prefix": 24,
            }],
            egress_cidrs=[{
                "address": "10.10.11.0",
                "prefix": 24,
            }],
            pod_cidrs=[{
                "address": "10.244.10.0",
                "prefix": 23,
            }],
            service_cidr={
                "address": "10.10.12.0",
                "prefix": 24,
            },
            search_domains="vsphere.local",
            namespaces=[{
                "name": "custom-namespace",
                "content_libraries": [],
                "vm_classes": [vm_class.id],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param SupervisorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SupervisorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 content_library: Optional[pulumi.Input[_builtins.str]] = None,
                 dvs_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorEgressCidrArgs', 'SupervisorEgressCidrArgsDict']]]]] = None,
                 ingress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorIngressCidrArgs', 'SupervisorIngressCidrArgsDict']]]]] = None,
                 main_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_network: Optional[pulumi.Input[Union['SupervisorManagementNetworkArgs', 'SupervisorManagementNetworkArgsDict']]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorNamespaceArgs', 'SupervisorNamespaceArgsDict']]]]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorPodCidrArgs', 'SupervisorPodCidrArgsDict']]]]] = None,
                 search_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[Union['SupervisorServiceCidrArgs', 'SupervisorServiceCidrArgsDict']]] = None,
                 sizing_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SupervisorArgs.__new__(SupervisorArgs)

            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if content_library is None and not opts.urn:
                raise TypeError("Missing required property 'content_library'")
            __props__.__dict__["content_library"] = content_library
            if dvs_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'dvs_uuid'")
            __props__.__dict__["dvs_uuid"] = dvs_uuid
            if edge_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'edge_cluster'")
            __props__.__dict__["edge_cluster"] = edge_cluster
            if egress_cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'egress_cidrs'")
            __props__.__dict__["egress_cidrs"] = egress_cidrs
            if ingress_cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'ingress_cidrs'")
            __props__.__dict__["ingress_cidrs"] = ingress_cidrs
            if main_dns is None and not opts.urn:
                raise TypeError("Missing required property 'main_dns'")
            __props__.__dict__["main_dns"] = main_dns
            if main_ntps is None and not opts.urn:
                raise TypeError("Missing required property 'main_ntps'")
            __props__.__dict__["main_ntps"] = main_ntps
            if management_network is None and not opts.urn:
                raise TypeError("Missing required property 'management_network'")
            __props__.__dict__["management_network"] = management_network
            __props__.__dict__["namespaces"] = namespaces
            if pod_cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'pod_cidrs'")
            __props__.__dict__["pod_cidrs"] = pod_cidrs
            if search_domains is None and not opts.urn:
                raise TypeError("Missing required property 'search_domains'")
            __props__.__dict__["search_domains"] = search_domains
            if service_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'service_cidr'")
            __props__.__dict__["service_cidr"] = service_cidr
            if sizing_hint is None and not opts.urn:
                raise TypeError("Missing required property 'sizing_hint'")
            __props__.__dict__["sizing_hint"] = sizing_hint
            if storage_policy is None and not opts.urn:
                raise TypeError("Missing required property 'storage_policy'")
            __props__.__dict__["storage_policy"] = storage_policy
            if worker_dns is None and not opts.urn:
                raise TypeError("Missing required property 'worker_dns'")
            __props__.__dict__["worker_dns"] = worker_dns
            if worker_ntps is None and not opts.urn:
                raise TypeError("Missing required property 'worker_ntps'")
            __props__.__dict__["worker_ntps"] = worker_ntps
        super(Supervisor, __self__).__init__(
            'vsphere:index/supervisor:Supervisor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[_builtins.str]] = None,
            content_library: Optional[pulumi.Input[_builtins.str]] = None,
            dvs_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            edge_cluster: Optional[pulumi.Input[_builtins.str]] = None,
            egress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorEgressCidrArgs', 'SupervisorEgressCidrArgsDict']]]]] = None,
            ingress_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorIngressCidrArgs', 'SupervisorIngressCidrArgsDict']]]]] = None,
            main_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            main_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            management_network: Optional[pulumi.Input[Union['SupervisorManagementNetworkArgs', 'SupervisorManagementNetworkArgsDict']]] = None,
            namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorNamespaceArgs', 'SupervisorNamespaceArgsDict']]]]] = None,
            pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SupervisorPodCidrArgs', 'SupervisorPodCidrArgsDict']]]]] = None,
            search_domains: Optional[pulumi.Input[_builtins.str]] = None,
            service_cidr: Optional[pulumi.Input[Union['SupervisorServiceCidrArgs', 'SupervisorServiceCidrArgsDict']]] = None,
            sizing_hint: Optional[pulumi.Input[_builtins.str]] = None,
            storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
            worker_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            worker_ntps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Supervisor':
        """
        Get an existing Supervisor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster: The identifier of the compute cluster.
        :param pulumi.Input[_builtins.str] content_library: The identifier of the subscribed content library.
        :param pulumi.Input[_builtins.str] dvs_uuid: The UUID of the distributed switch.
        :param pulumi.Input[_builtins.str] edge_cluster: The identifier of the NSX Edge Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorEgressCidrArgs', 'SupervisorEgressCidrArgsDict']]]] egress_cidrs: CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorIngressCidrArgs', 'SupervisorIngressCidrArgsDict']]]] ingress_cidrs: CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_dns: The list of addresses of the primary DNS servers.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] main_ntps: The list of addresses of the primary NTP servers.
        :param pulumi.Input[Union['SupervisorManagementNetworkArgs', 'SupervisorManagementNetworkArgsDict']] management_network: The configuration for the management network which the control plane VMs will be connected to.
               * * `network` - ID of the network. (e.g. a distributed port group).
               * * `starting_address` - Starting address of the management network range.
               * * `subnet_mask` - Subnet mask.
               * * `gateway` - Gateway IP address.
               * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorNamespaceArgs', 'SupervisorNamespaceArgsDict']]]] namespaces: The list of namespaces to create in the Supervisor cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['SupervisorPodCidrArgs', 'SupervisorPodCidrArgsDict']]]] pod_cidrs: CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        :param pulumi.Input[_builtins.str] search_domains: List of DNS search domains.
        :param pulumi.Input[Union['SupervisorServiceCidrArgs', 'SupervisorServiceCidrArgsDict']] service_cidr: CIDR block from which Kubernetes allocates service cluster IP addresses.
        :param pulumi.Input[_builtins.str] sizing_hint: The size of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] storage_policy: The name of the storage policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_dns: The list of addresses of the DNS servers to use for the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_ntps: The list of addresses of the NTP servers to use for the worker nodes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SupervisorState.__new__(_SupervisorState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["content_library"] = content_library
        __props__.__dict__["dvs_uuid"] = dvs_uuid
        __props__.__dict__["edge_cluster"] = edge_cluster
        __props__.__dict__["egress_cidrs"] = egress_cidrs
        __props__.__dict__["ingress_cidrs"] = ingress_cidrs
        __props__.__dict__["main_dns"] = main_dns
        __props__.__dict__["main_ntps"] = main_ntps
        __props__.__dict__["management_network"] = management_network
        __props__.__dict__["namespaces"] = namespaces
        __props__.__dict__["pod_cidrs"] = pod_cidrs
        __props__.__dict__["search_domains"] = search_domains
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["sizing_hint"] = sizing_hint
        __props__.__dict__["storage_policy"] = storage_policy
        __props__.__dict__["worker_dns"] = worker_dns
        __props__.__dict__["worker_ntps"] = worker_ntps
        return Supervisor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the compute cluster.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="contentLibrary")
    def content_library(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the subscribed content library.
        """
        return pulumi.get(self, "content_library")

    @_builtins.property
    @pulumi.getter(name="dvsUuid")
    def dvs_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the distributed switch.
        """
        return pulumi.get(self, "dvs_uuid")

    @_builtins.property
    @pulumi.getter(name="edgeCluster")
    def edge_cluster(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the NSX Edge Cluster.
        """
        return pulumi.get(self, "edge_cluster")

    @_builtins.property
    @pulumi.getter(name="egressCidrs")
    def egress_cidrs(self) -> pulumi.Output[Sequence['outputs.SupervisorEgressCidr']]:
        """
        CIDR blocks from which NSX assigns IP addresses used for performing SNAT from container IPs to external IPs.
        """
        return pulumi.get(self, "egress_cidrs")

    @_builtins.property
    @pulumi.getter(name="ingressCidrs")
    def ingress_cidrs(self) -> pulumi.Output[Sequence['outputs.SupervisorIngressCidr']]:
        """
        CIDR blocks from which NSX assigns IP addresses for Kubernetes Ingresses and Kubernetes Services of type LoadBalancer.
        """
        return pulumi.get(self, "ingress_cidrs")

    @_builtins.property
    @pulumi.getter(name="mainDns")
    def main_dns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of addresses of the primary DNS servers.
        """
        return pulumi.get(self, "main_dns")

    @_builtins.property
    @pulumi.getter(name="mainNtps")
    def main_ntps(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of addresses of the primary NTP servers.
        """
        return pulumi.get(self, "main_ntps")

    @_builtins.property
    @pulumi.getter(name="managementNetwork")
    def management_network(self) -> pulumi.Output['outputs.SupervisorManagementNetwork']:
        """
        The configuration for the management network which the control plane VMs will be connected to.
        * * `network` - ID of the network. (e.g. a distributed port group).
        * * `starting_address` - Starting address of the management network range.
        * * `subnet_mask` - Subnet mask.
        * * `gateway` - Gateway IP address.
        * * `address_count` - Number of addresses to allocate. Starts from `starting_address`
        """
        return pulumi.get(self, "management_network")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> pulumi.Output[Optional[Sequence['outputs.SupervisorNamespace']]]:
        """
        The list of namespaces to create in the Supervisor cluster
        """
        return pulumi.get(self, "namespaces")

    @_builtins.property
    @pulumi.getter(name="podCidrs")
    def pod_cidrs(self) -> pulumi.Output[Sequence['outputs.SupervisorPodCidr']]:
        """
        CIDR blocks from which Kubernetes allocates pod IP addresses. Minimum subnet size is 23.
        """
        return pulumi.get(self, "pod_cidrs")

    @_builtins.property
    @pulumi.getter(name="searchDomains")
    def search_domains(self) -> pulumi.Output[_builtins.str]:
        """
        List of DNS search domains.
        """
        return pulumi.get(self, "search_domains")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output['outputs.SupervisorServiceCidr']:
        """
        CIDR block from which Kubernetes allocates service cluster IP addresses.
        """
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="sizingHint")
    def sizing_hint(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the Kubernetes API server.
        """
        return pulumi.get(self, "sizing_hint")

    @_builtins.property
    @pulumi.getter(name="storagePolicy")
    def storage_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the storage policy.
        """
        return pulumi.get(self, "storage_policy")

    @_builtins.property
    @pulumi.getter(name="workerDns")
    def worker_dns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of addresses of the DNS servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_dns")

    @_builtins.property
    @pulumi.getter(name="workerNtps")
    def worker_ntps(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of addresses of the NTP servers to use for the worker nodes.
        """
        return pulumi.get(self, "worker_ntps")

