# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineArgs', 'VirtualMachine']

@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 resource_pool_id: pulumi.Input[_builtins.str],
                 alternate_guest_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotation: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cdroms: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]] = None,
                 clone: Optional[pulumi.Input['VirtualMachineCloneArgs']] = None,
                 cpu_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_hot_remove_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_performance_counters_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]] = None,
                 efi_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_disk_uuid: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 ept_rvi_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extra_config_reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 force_power_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_version: Optional[pulumi.Input[_builtins.int]] = None,
                 host_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hv_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ide_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ignored_guest_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 latency_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation_locked_to_max: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 migrate_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nested_hv_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 nvme_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ovf_deploy: Optional[pulumi.Input['VirtualMachineOvfDeployArgs']] = None,
                 pci_device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 poweron_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 replace_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 run_tools_scripts_after_power_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_after_resume: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_standby: Optional[pulumi.Input[_builtins.bool]] = None,
                 sata_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_bus_sharing: Optional[pulumi.Input[_builtins.str]] = None,
                 scsi_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shutdown_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 swap_placement_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_time_with_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_time_with_host_periodically: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tools_upgrade_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 vapp: Optional[pulumi.Input['VirtualMachineVappArgs']] = None,
                 vbs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm: Optional[pulumi.Input['VirtualMachineVtpmArgs']] = None,
                 vvtd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_ip_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_guest_net_routable: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_net_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VirtualMachine resource.
        :param pulumi.Input[_builtins.str] resource_pool_id: The ID of a resource pool to put the virtual machine in.
        :param pulumi.Input[_builtins.str] alternate_guest_name: The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        :param pulumi.Input[_builtins.str] annotation: User-provided description of the virtual machine.
        :param pulumi.Input[_builtins.int] boot_delay: The number of milliseconds to wait before starting the boot sequence.
        :param pulumi.Input[_builtins.int] boot_retry_delay: The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        :param pulumi.Input[_builtins.bool] boot_retry_enabled: If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]] cdroms: A specification for a CDROM device on this virtual machine.
        :param pulumi.Input['VirtualMachineCloneArgs'] clone: A specification for cloning a virtual machine from template.
        :param pulumi.Input[_builtins.bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.bool] cpu_hot_remove_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] cpu_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.bool] cpu_performance_counters_enabled: Enable CPU performance counters on this virtual machine.
        :param pulumi.Input[_builtins.int] cpu_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.int] cpu_share_count: The amount of shares to allocate to cpu for a custom share level.
        :param pulumi.Input[_builtins.str] cpu_share_level: The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[_builtins.str] datacenter_id: The ID of the datacenter where the VM is to be created.
        :param pulumi.Input[_builtins.str] datastore_cluster_id: The ID of a datastore cluster to put the virtual machine in.
        :param pulumi.Input[_builtins.str] datastore_id: The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]] disks: A specification for a virtual disk device on this virtual machine.
        :param pulumi.Input[_builtins.bool] efi_secure_boot_enabled: When the boot type set in firmware is efi, this enables EFI secure boot.
        :param pulumi.Input[_builtins.bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        :param pulumi.Input[_builtins.bool] enable_logging: Enable logging on this virtual machine.
        :param pulumi.Input[_builtins.str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_config: Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] extra_config_reboot_required: Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        :param pulumi.Input[_builtins.str] firmware: The firmware interface to use on the virtual machine. Can be one of bios or efi.
        :param pulumi.Input[_builtins.str] folder: The name of the folder to locate the virtual machine in.
        :param pulumi.Input[_builtins.bool] force_power_off: Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        :param pulumi.Input[_builtins.str] guest_id: The guest ID for the operating system.
        :param pulumi.Input[_builtins.int] hardware_version: The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        :param pulumi.Input[_builtins.str] host_system_id: The ID of an optional host system to pin the virtual machine to.
        :param pulumi.Input[_builtins.str] hv_mode: The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_guest_ips: List of IP addresses and CIDR networks to ignore while waiting for an IP
        :param pulumi.Input[_builtins.str] latency_sensitivity: Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        :param pulumi.Input[_builtins.int] memory: The size of the virtual machine's memory, in MB.
        :param pulumi.Input[_builtins.bool] memory_hot_add_enabled: Allow memory to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] memory_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.int] memory_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.bool] memory_reservation_locked_to_max: If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        :param pulumi.Input[_builtins.int] memory_share_count: The amount of shares to allocate to memory for a custom share level.
        :param pulumi.Input[_builtins.str] memory_share_level: The allocation level for memory resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[_builtins.int] migrate_wait_timeout: The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        :param pulumi.Input[_builtins.str] name: The name of this virtual machine.
        :param pulumi.Input[_builtins.bool] nested_hv_enabled: Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]] network_interfaces: A specification for a virtual NIC on this virtual machine.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        :param pulumi.Input[_builtins.int] num_cpus: The number of virtual processors to assign to this virtual machine.
        :param pulumi.Input['VirtualMachineOvfDeployArgs'] ovf_deploy: A specification for deploying a virtual machine from ovf/ova template.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pci_device_ids: A list of PCI passthrough devices
        :param pulumi.Input[_builtins.int] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[_builtins.str] replace_trigger: Triggers replacement of resource whenever it changes.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_power_on: Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_resume: Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_reboot: Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_shutdown: Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_standby: Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        :param pulumi.Input[_builtins.str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        :param pulumi.Input[_builtins.str] scsi_type: The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        :param pulumi.Input[_builtins.int] shutdown_wait_timeout: The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        :param pulumi.Input[_builtins.str] storage_policy_id: The ID of the storage policy to assign to the virtual machine home directory.
        :param pulumi.Input[_builtins.str] swap_placement_policy: The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        :param pulumi.Input[_builtins.bool] sync_time_with_host: Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        :param pulumi.Input[_builtins.bool] sync_time_with_host_periodically: Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[_builtins.str] tools_upgrade_policy: Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        :param pulumi.Input['VirtualMachineVappArgs'] vapp: vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] vbs_enabled: Flag to specify if Virtualization-based security is enabled for this virtual machine.
        :param pulumi.Input['VirtualMachineVtpmArgs'] vtpm: A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        :param pulumi.Input[_builtins.bool] vvtd_enabled: Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        :param pulumi.Input[_builtins.int] wait_for_guest_ip_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        :param pulumi.Input[_builtins.bool] wait_for_guest_net_routable: Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        :param pulumi.Input[_builtins.int] wait_for_guest_net_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        pulumi.set(__self__, "resource_pool_id", resource_pool_id)
        if alternate_guest_name is not None:
            pulumi.set(__self__, "alternate_guest_name", alternate_guest_name)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if boot_delay is not None:
            pulumi.set(__self__, "boot_delay", boot_delay)
        if boot_retry_delay is not None:
            pulumi.set(__self__, "boot_retry_delay", boot_retry_delay)
        if boot_retry_enabled is not None:
            pulumi.set(__self__, "boot_retry_enabled", boot_retry_enabled)
        if cdroms is not None:
            pulumi.set(__self__, "cdroms", cdroms)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if cpu_hot_add_enabled is not None:
            pulumi.set(__self__, "cpu_hot_add_enabled", cpu_hot_add_enabled)
        if cpu_hot_remove_enabled is not None:
            pulumi.set(__self__, "cpu_hot_remove_enabled", cpu_hot_remove_enabled)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cpu_performance_counters_enabled is not None:
            pulumi.set(__self__, "cpu_performance_counters_enabled", cpu_performance_counters_enabled)
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpu_share_count is not None:
            pulumi.set(__self__, "cpu_share_count", cpu_share_count)
        if cpu_share_level is not None:
            pulumi.set(__self__, "cpu_share_level", cpu_share_level)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if efi_secure_boot_enabled is not None:
            pulumi.set(__self__, "efi_secure_boot_enabled", efi_secure_boot_enabled)
        if enable_disk_uuid is not None:
            pulumi.set(__self__, "enable_disk_uuid", enable_disk_uuid)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if ept_rvi_mode is not None:
            pulumi.set(__self__, "ept_rvi_mode", ept_rvi_mode)
        if extra_config is not None:
            pulumi.set(__self__, "extra_config", extra_config)
        if extra_config_reboot_required is not None:
            pulumi.set(__self__, "extra_config_reboot_required", extra_config_reboot_required)
        if firmware is not None:
            pulumi.set(__self__, "firmware", firmware)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_power_off is not None:
            pulumi.set(__self__, "force_power_off", force_power_off)
        if guest_id is not None:
            pulumi.set(__self__, "guest_id", guest_id)
        if hardware_version is not None:
            pulumi.set(__self__, "hardware_version", hardware_version)
        if host_system_id is not None:
            pulumi.set(__self__, "host_system_id", host_system_id)
        if hv_mode is not None:
            pulumi.set(__self__, "hv_mode", hv_mode)
        if ide_controller_count is not None:
            pulumi.set(__self__, "ide_controller_count", ide_controller_count)
        if ignored_guest_ips is not None:
            pulumi.set(__self__, "ignored_guest_ips", ignored_guest_ips)
        if latency_sensitivity is not None:
            pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_hot_add_enabled is not None:
            pulumi.set(__self__, "memory_hot_add_enabled", memory_hot_add_enabled)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if memory_reservation_locked_to_max is not None:
            pulumi.set(__self__, "memory_reservation_locked_to_max", memory_reservation_locked_to_max)
        if memory_share_count is not None:
            pulumi.set(__self__, "memory_share_count", memory_share_count)
        if memory_share_level is not None:
            pulumi.set(__self__, "memory_share_level", memory_share_level)
        if migrate_wait_timeout is not None:
            pulumi.set(__self__, "migrate_wait_timeout", migrate_wait_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nested_hv_enabled is not None:
            pulumi.set(__self__, "nested_hv_enabled", nested_hv_enabled)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if num_cores_per_socket is not None:
            pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_cpus is not None:
            pulumi.set(__self__, "num_cpus", num_cpus)
        if nvme_controller_count is not None:
            pulumi.set(__self__, "nvme_controller_count", nvme_controller_count)
        if ovf_deploy is not None:
            pulumi.set(__self__, "ovf_deploy", ovf_deploy)
        if pci_device_ids is not None:
            pulumi.set(__self__, "pci_device_ids", pci_device_ids)
        if poweron_timeout is not None:
            pulumi.set(__self__, "poweron_timeout", poweron_timeout)
        if replace_trigger is not None:
            pulumi.set(__self__, "replace_trigger", replace_trigger)
        if run_tools_scripts_after_power_on is not None:
            pulumi.set(__self__, "run_tools_scripts_after_power_on", run_tools_scripts_after_power_on)
        if run_tools_scripts_after_resume is not None:
            pulumi.set(__self__, "run_tools_scripts_after_resume", run_tools_scripts_after_resume)
        if run_tools_scripts_before_guest_reboot is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_reboot", run_tools_scripts_before_guest_reboot)
        if run_tools_scripts_before_guest_shutdown is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_shutdown", run_tools_scripts_before_guest_shutdown)
        if run_tools_scripts_before_guest_standby is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_standby", run_tools_scripts_before_guest_standby)
        if sata_controller_count is not None:
            pulumi.set(__self__, "sata_controller_count", sata_controller_count)
        if scsi_bus_sharing is not None:
            pulumi.set(__self__, "scsi_bus_sharing", scsi_bus_sharing)
        if scsi_controller_count is not None:
            pulumi.set(__self__, "scsi_controller_count", scsi_controller_count)
        if scsi_type is not None:
            pulumi.set(__self__, "scsi_type", scsi_type)
        if shutdown_wait_timeout is not None:
            pulumi.set(__self__, "shutdown_wait_timeout", shutdown_wait_timeout)
        if storage_policy_id is not None:
            pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if swap_placement_policy is not None:
            pulumi.set(__self__, "swap_placement_policy", swap_placement_policy)
        if sync_time_with_host is not None:
            pulumi.set(__self__, "sync_time_with_host", sync_time_with_host)
        if sync_time_with_host_periodically is not None:
            pulumi.set(__self__, "sync_time_with_host_periodically", sync_time_with_host_periodically)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tools_upgrade_policy is not None:
            pulumi.set(__self__, "tools_upgrade_policy", tools_upgrade_policy)
        if vapp is not None:
            pulumi.set(__self__, "vapp", vapp)
        if vbs_enabled is not None:
            pulumi.set(__self__, "vbs_enabled", vbs_enabled)
        if vtpm is not None:
            pulumi.set(__self__, "vtpm", vtpm)
        if vvtd_enabled is not None:
            pulumi.set(__self__, "vvtd_enabled", vvtd_enabled)
        if wait_for_guest_ip_timeout is not None:
            pulumi.set(__self__, "wait_for_guest_ip_timeout", wait_for_guest_ip_timeout)
        if wait_for_guest_net_routable is not None:
            pulumi.set(__self__, "wait_for_guest_net_routable", wait_for_guest_net_routable)
        if wait_for_guest_net_timeout is not None:
            pulumi.set(__self__, "wait_for_guest_net_timeout", wait_for_guest_net_timeout)

    @_builtins.property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of a resource pool to put the virtual machine in.
        """
        return pulumi.get(self, "resource_pool_id")

    @resource_pool_id.setter
    def resource_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="alternateGuestName")
    def alternate_guest_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        """
        return pulumi.get(self, "alternate_guest_name")

    @alternate_guest_name.setter
    def alternate_guest_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternate_guest_name", value)

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the virtual machine.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "annotation", value)

    @_builtins.property
    @pulumi.getter(name="bootDelay")
    def boot_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of milliseconds to wait before starting the boot sequence.
        """
        return pulumi.get(self, "boot_delay")

    @boot_delay.setter
    def boot_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_delay", value)

    @_builtins.property
    @pulumi.getter(name="bootRetryDelay")
    def boot_retry_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        """
        return pulumi.get(self, "boot_retry_delay")

    @boot_retry_delay.setter
    def boot_retry_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_retry_delay", value)

    @_builtins.property
    @pulumi.getter(name="bootRetryEnabled")
    def boot_retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        """
        return pulumi.get(self, "boot_retry_enabled")

    @boot_retry_enabled.setter
    def boot_retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "boot_retry_enabled", value)

    @_builtins.property
    @pulumi.getter
    def cdroms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]]:
        """
        A specification for a CDROM device on this virtual machine.
        """
        return pulumi.get(self, "cdroms")

    @cdroms.setter
    def cdroms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]]):
        pulumi.set(self, "cdroms", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['VirtualMachineCloneArgs']]:
        """
        A specification for cloning a virtual machine from template.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['VirtualMachineCloneArgs']]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="cpuHotAddEnabled")
    def cpu_hot_add_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_add_enabled")

    @cpu_hot_add_enabled.setter
    def cpu_hot_add_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_hot_add_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuHotRemoveEnabled")
    def cpu_hot_remove_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_remove_enabled")

    @cpu_hot_remove_enabled.setter
    def cpu_hot_remove_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_hot_remove_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @_builtins.property
    @pulumi.getter(name="cpuPerformanceCountersEnabled")
    def cpu_performance_counters_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable CPU performance counters on this virtual machine.
        """
        return pulumi.get(self, "cpu_performance_counters_enabled")

    @cpu_performance_counters_enabled.setter
    def cpu_performance_counters_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_performance_counters_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @_builtins.property
    @pulumi.getter(name="cpuShareCount")
    def cpu_share_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of shares to allocate to cpu for a custom share level.
        """
        return pulumi.get(self, "cpu_share_count")

    @cpu_share_count.setter
    def cpu_share_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_share_count", value)

    @_builtins.property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "cpu_share_level")

    @cpu_share_level.setter
    def cpu_share_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_share_level", value)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the datacenter where the VM is to be created.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter_id", value)

    @_builtins.property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a datastore cluster to put the virtual machine in.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datastore_id", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]:
        """
        A specification for a virtual disk device on this virtual machine.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="efiSecureBootEnabled")
    def efi_secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When the boot type set in firmware is efi, this enables EFI secure boot.
        """
        return pulumi.get(self, "efi_secure_boot_enabled")

    @efi_secure_boot_enabled.setter
    def efi_secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "efi_secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="enableDiskUuid")
    def enable_disk_uuid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        """
        return pulumi.get(self, "enable_disk_uuid")

    @enable_disk_uuid.setter
    def enable_disk_uuid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_disk_uuid", value)

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable logging on this virtual machine.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @_builtins.property
    @pulumi.getter(name="eptRviMode")
    def ept_rvi_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        """
        return pulumi.get(self, "ept_rvi_mode")

    @ept_rvi_mode.setter
    def ept_rvi_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ept_rvi_mode", value)

    @_builtins.property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        """
        return pulumi.get(self, "extra_config")

    @extra_config.setter
    def extra_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_config", value)

    @_builtins.property
    @pulumi.getter(name="extraConfigRebootRequired")
    def extra_config_reboot_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        """
        return pulumi.get(self, "extra_config_reboot_required")

    @extra_config_reboot_required.setter
    def extra_config_reboot_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extra_config_reboot_required", value)

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The firmware interface to use on the virtual machine. Can be one of bios or efi.
        """
        return pulumi.get(self, "firmware")

    @firmware.setter
    def firmware(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder to locate the virtual machine in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="forcePowerOff")
    def force_power_off(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        """
        return pulumi.get(self, "force_power_off")

    @force_power_off.setter
    def force_power_off(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_power_off", value)

    @_builtins.property
    @pulumi.getter(name="guestId")
    def guest_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The guest ID for the operating system.
        """
        return pulumi.get(self, "guest_id")

    @guest_id.setter
    def guest_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_id", value)

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        """
        return pulumi.get(self, "hardware_version")

    @hardware_version.setter
    def hardware_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hardware_version", value)

    @_builtins.property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an optional host system to pin the virtual machine to.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_system_id", value)

    @_builtins.property
    @pulumi.getter(name="hvMode")
    def hv_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        """
        return pulumi.get(self, "hv_mode")

    @hv_mode.setter
    def hv_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hv_mode", value)

    @_builtins.property
    @pulumi.getter(name="ideControllerCount")
    def ide_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ide_controller_count")

    @ide_controller_count.setter
    def ide_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ide_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="ignoredGuestIps")
    def ignored_guest_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses and CIDR networks to ignore while waiting for an IP
        """
        return pulumi.get(self, "ignored_guest_ips")

    @ignored_guest_ips.setter
    def ignored_guest_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignored_guest_ips", value)

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        """
        return pulumi.get(self, "latency_sensitivity")

    @latency_sensitivity.setter
    def latency_sensitivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latency_sensitivity", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the virtual machine's memory, in MB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="memoryHotAddEnabled")
    def memory_hot_add_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow memory to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "memory_hot_add_enabled")

    @memory_hot_add_enabled.setter
    def memory_hot_add_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "memory_hot_add_enabled", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservationLockedToMax")
    def memory_reservation_locked_to_max(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        """
        return pulumi.get(self, "memory_reservation_locked_to_max")

    @memory_reservation_locked_to_max.setter
    def memory_reservation_locked_to_max(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "memory_reservation_locked_to_max", value)

    @_builtins.property
    @pulumi.getter(name="memoryShareCount")
    def memory_share_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of shares to allocate to memory for a custom share level.
        """
        return pulumi.get(self, "memory_share_count")

    @memory_share_count.setter
    def memory_share_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_share_count", value)

    @_builtins.property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation level for memory resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "memory_share_level")

    @memory_share_level.setter
    def memory_share_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_share_level", value)

    @_builtins.property
    @pulumi.getter(name="migrateWaitTimeout")
    def migrate_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        """
        return pulumi.get(self, "migrate_wait_timeout")

    @migrate_wait_timeout.setter
    def migrate_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "migrate_wait_timeout", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this virtual machine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nestedHvEnabled")
    def nested_hv_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        """
        return pulumi.get(self, "nested_hv_enabled")

    @nested_hv_enabled.setter
    def nested_hv_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nested_hv_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]]:
        """
        A specification for a virtual NIC on this virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @num_cores_per_socket.setter
    def num_cores_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cores_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numCpus")
    def num_cpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of virtual processors to assign to this virtual machine.
        """
        return pulumi.get(self, "num_cpus")

    @num_cpus.setter
    def num_cpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cpus", value)

    @_builtins.property
    @pulumi.getter(name="nvmeControllerCount")
    def nvme_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "nvme_controller_count")

    @nvme_controller_count.setter
    def nvme_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nvme_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="ovfDeploy")
    def ovf_deploy(self) -> Optional[pulumi.Input['VirtualMachineOvfDeployArgs']]:
        """
        A specification for deploying a virtual machine from ovf/ova template.
        """
        return pulumi.get(self, "ovf_deploy")

    @ovf_deploy.setter
    def ovf_deploy(self, value: Optional[pulumi.Input['VirtualMachineOvfDeployArgs']]):
        pulumi.set(self, "ovf_deploy", value)

    @_builtins.property
    @pulumi.getter(name="pciDeviceIds")
    def pci_device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of PCI passthrough devices
        """
        return pulumi.get(self, "pci_device_ids")

    @pci_device_ids.setter
    def pci_device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pci_device_ids", value)

    @_builtins.property
    @pulumi.getter(name="poweronTimeout")
    def poweron_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in seconds, that we will be trying to power on a VM
        """
        return pulumi.get(self, "poweron_timeout")

    @poweron_timeout.setter
    def poweron_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poweron_timeout", value)

    @_builtins.property
    @pulumi.getter(name="replaceTrigger")
    def replace_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers replacement of resource whenever it changes.
        """
        return pulumi.get(self, "replace_trigger")

    @replace_trigger.setter
    def replace_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replace_trigger", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterPowerOn")
    def run_tools_scripts_after_power_on(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_power_on")

    @run_tools_scripts_after_power_on.setter
    def run_tools_scripts_after_power_on(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_after_power_on", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterResume")
    def run_tools_scripts_after_resume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_resume")

    @run_tools_scripts_after_resume.setter
    def run_tools_scripts_after_resume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_after_resume", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestReboot")
    def run_tools_scripts_before_guest_reboot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_reboot")

    @run_tools_scripts_before_guest_reboot.setter
    def run_tools_scripts_before_guest_reboot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_reboot", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestShutdown")
    def run_tools_scripts_before_guest_shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_shutdown")

    @run_tools_scripts_before_guest_shutdown.setter
    def run_tools_scripts_before_guest_shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_shutdown", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestStandby")
    def run_tools_scripts_before_guest_standby(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_standby")

    @run_tools_scripts_before_guest_standby.setter
    def run_tools_scripts_before_guest_standby(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_standby", value)

    @_builtins.property
    @pulumi.getter(name="sataControllerCount")
    def sata_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "sata_controller_count")

    @sata_controller_count.setter
    def sata_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sata_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="scsiBusSharing")
    def scsi_bus_sharing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        """
        return pulumi.get(self, "scsi_bus_sharing")

    @scsi_bus_sharing.setter
    def scsi_bus_sharing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scsi_bus_sharing", value)

    @_builtins.property
    @pulumi.getter(name="scsiControllerCount")
    def scsi_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "scsi_controller_count")

    @scsi_controller_count.setter
    def scsi_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scsi_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="scsiType")
    def scsi_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        """
        return pulumi.get(self, "scsi_type")

    @scsi_type.setter
    def scsi_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scsi_type", value)

    @_builtins.property
    @pulumi.getter(name="shutdownWaitTimeout")
    def shutdown_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        """
        return pulumi.get(self, "shutdown_wait_timeout")

    @shutdown_wait_timeout.setter
    def shutdown_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shutdown_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage policy to assign to the virtual machine home directory.
        """
        return pulumi.get(self, "storage_policy_id")

    @storage_policy_id.setter
    def storage_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="swapPlacementPolicy")
    def swap_placement_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        """
        return pulumi.get(self, "swap_placement_policy")

    @swap_placement_policy.setter
    def swap_placement_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "swap_placement_policy", value)

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHost")
    def sync_time_with_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host")

    @sync_time_with_host.setter
    def sync_time_with_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_time_with_host", value)

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHostPeriodically")
    def sync_time_with_host_periodically(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host_periodically")

    @sync_time_with_host_periodically.setter
    def sync_time_with_host_periodically(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_time_with_host_periodically", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tag IDs to apply to this object.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="toolsUpgradePolicy")
    def tools_upgrade_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        """
        return pulumi.get(self, "tools_upgrade_policy")

    @tools_upgrade_policy.setter
    def tools_upgrade_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tools_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter
    def vapp(self) -> Optional[pulumi.Input['VirtualMachineVappArgs']]:
        """
        vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        """
        return pulumi.get(self, "vapp")

    @vapp.setter
    def vapp(self, value: Optional[pulumi.Input['VirtualMachineVappArgs']]):
        pulumi.set(self, "vapp", value)

    @_builtins.property
    @pulumi.getter(name="vbsEnabled")
    def vbs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify if Virtualization-based security is enabled for this virtual machine.
        """
        return pulumi.get(self, "vbs_enabled")

    @vbs_enabled.setter
    def vbs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vbs_enabled", value)

    @_builtins.property
    @pulumi.getter
    def vtpm(self) -> Optional[pulumi.Input['VirtualMachineVtpmArgs']]:
        """
        A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        """
        return pulumi.get(self, "vtpm")

    @vtpm.setter
    def vtpm(self, value: Optional[pulumi.Input['VirtualMachineVtpmArgs']]):
        pulumi.set(self, "vtpm", value)

    @_builtins.property
    @pulumi.getter(name="vvtdEnabled")
    def vvtd_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        """
        return pulumi.get(self, "vvtd_enabled")

    @vvtd_enabled.setter
    def vvtd_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vvtd_enabled", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestIpTimeout")
    def wait_for_guest_ip_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_ip_timeout")

    @wait_for_guest_ip_timeout.setter
    def wait_for_guest_ip_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_guest_ip_timeout", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetRoutable")
    def wait_for_guest_net_routable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        """
        return pulumi.get(self, "wait_for_guest_net_routable")

    @wait_for_guest_net_routable.setter
    def wait_for_guest_net_routable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_guest_net_routable", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetTimeout")
    def wait_for_guest_net_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_net_timeout")

    @wait_for_guest_net_timeout.setter
    def wait_for_guest_net_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_guest_net_timeout", value)


@pulumi.input_type
class _VirtualMachineState:
    def __init__(__self__, *,
                 alternate_guest_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotation: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cdroms: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]] = None,
                 change_version: Optional[pulumi.Input[_builtins.str]] = None,
                 clone: Optional[pulumi.Input['VirtualMachineCloneArgs']] = None,
                 cpu_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_hot_remove_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_performance_counters_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]] = None,
                 efi_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_disk_uuid: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 ept_rvi_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extra_config_reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 force_power_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_id: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hardware_version: Optional[pulumi.Input[_builtins.int]] = None,
                 host_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hv_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ide_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ignored_guest_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 imported: Optional[pulumi.Input[_builtins.bool]] = None,
                 latency_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation_locked_to_max: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 migrate_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 moid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nested_hv_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 nvme_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ovf_deploy: Optional[pulumi.Input['VirtualMachineOvfDeployArgs']] = None,
                 pci_device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 poweron_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 replace_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_tools_scripts_after_power_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_after_resume: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_standby: Optional[pulumi.Input[_builtins.bool]] = None,
                 sata_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_bus_sharing: Optional[pulumi.Input[_builtins.str]] = None,
                 scsi_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shutdown_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 swap_placement_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_time_with_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_time_with_host_periodically: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tools_upgrade_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 vapp: Optional[pulumi.Input['VirtualMachineVappArgs']] = None,
                 vapp_transports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vbs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vmware_tools_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vmx_path: Optional[pulumi.Input[_builtins.str]] = None,
                 vtpm: Optional[pulumi.Input['VirtualMachineVtpmArgs']] = None,
                 vvtd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_ip_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_guest_net_routable: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_net_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering VirtualMachine resources.
        :param pulumi.Input[_builtins.str] alternate_guest_name: The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        :param pulumi.Input[_builtins.str] annotation: User-provided description of the virtual machine.
        :param pulumi.Input[_builtins.int] boot_delay: The number of milliseconds to wait before starting the boot sequence.
        :param pulumi.Input[_builtins.int] boot_retry_delay: The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        :param pulumi.Input[_builtins.bool] boot_retry_enabled: If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]] cdroms: A specification for a CDROM device on this virtual machine.
        :param pulumi.Input[_builtins.str] change_version: A unique identifier for a given version of the last configuration was applied.
        :param pulumi.Input['VirtualMachineCloneArgs'] clone: A specification for cloning a virtual machine from template.
        :param pulumi.Input[_builtins.bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.bool] cpu_hot_remove_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] cpu_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.bool] cpu_performance_counters_enabled: Enable CPU performance counters on this virtual machine.
        :param pulumi.Input[_builtins.int] cpu_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.int] cpu_share_count: The amount of shares to allocate to cpu for a custom share level.
        :param pulumi.Input[_builtins.str] cpu_share_level: The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[_builtins.str] datacenter_id: The ID of the datacenter where the VM is to be created.
        :param pulumi.Input[_builtins.str] datastore_cluster_id: The ID of a datastore cluster to put the virtual machine in.
        :param pulumi.Input[_builtins.str] datastore_id: The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        :param pulumi.Input[_builtins.str] default_ip_address: The IP address selected by the provider to be used with any provisioners configured on this resource. When possible, this is the first IPv4 address that is reachable through the default gateway configured on the machine, then the first reachable IPv6 address, and then the first general discovered address if neither exists. If  VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this value will be blank.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]] disks: A specification for a virtual disk device on this virtual machine.
        :param pulumi.Input[_builtins.bool] efi_secure_boot_enabled: When the boot type set in firmware is efi, this enables EFI secure boot.
        :param pulumi.Input[_builtins.bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        :param pulumi.Input[_builtins.bool] enable_logging: Enable logging on this virtual machine.
        :param pulumi.Input[_builtins.str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_config: Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] extra_config_reboot_required: Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        :param pulumi.Input[_builtins.str] firmware: The firmware interface to use on the virtual machine. Can be one of bios or efi.
        :param pulumi.Input[_builtins.str] folder: The name of the folder to locate the virtual machine in.
        :param pulumi.Input[_builtins.bool] force_power_off: Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        :param pulumi.Input[_builtins.str] guest_id: The guest ID for the operating system.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guest_ip_addresses: The current list of IP addresses on this machine, including the value of `default_ip_address`. If VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this list will be empty.
        :param pulumi.Input[_builtins.int] hardware_version: The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        :param pulumi.Input[_builtins.str] host_system_id: The ID of an optional host system to pin the virtual machine to.
        :param pulumi.Input[_builtins.str] hv_mode: The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_guest_ips: List of IP addresses and CIDR networks to ignore while waiting for an IP
        :param pulumi.Input[_builtins.bool] imported: Indicates if the virtual machine resource has been imported, or if the state has been migrated from a previous version of the resource. It influences the behavior of the first post-import apply operation. See the section on importing below.
        :param pulumi.Input[_builtins.str] latency_sensitivity: Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        :param pulumi.Input[_builtins.int] memory: The size of the virtual machine's memory, in MB.
        :param pulumi.Input[_builtins.bool] memory_hot_add_enabled: Allow memory to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] memory_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.int] memory_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.bool] memory_reservation_locked_to_max: If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        :param pulumi.Input[_builtins.int] memory_share_count: The amount of shares to allocate to memory for a custom share level.
        :param pulumi.Input[_builtins.str] memory_share_level: The allocation level for memory resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[_builtins.int] migrate_wait_timeout: The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        :param pulumi.Input[_builtins.str] moid: The managed object reference ID of the created virtual machine.
        :param pulumi.Input[_builtins.str] name: The name of this virtual machine.
        :param pulumi.Input[_builtins.bool] nested_hv_enabled: Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]] network_interfaces: A specification for a virtual NIC on this virtual machine.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        :param pulumi.Input[_builtins.int] num_cpus: The number of virtual processors to assign to this virtual machine.
        :param pulumi.Input['VirtualMachineOvfDeployArgs'] ovf_deploy: A specification for deploying a virtual machine from ovf/ova template.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pci_device_ids: A list of PCI passthrough devices
        :param pulumi.Input[_builtins.str] power_state: A computed value for the current power state of the virtual machine. One of `on`, `off`, or `suspended`.
        :param pulumi.Input[_builtins.int] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[_builtins.str] replace_trigger: Triggers replacement of resource whenever it changes.
        :param pulumi.Input[_builtins.str] resource_pool_id: The ID of a resource pool to put the virtual machine in.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_power_on: Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_resume: Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_reboot: Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_shutdown: Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_standby: Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        :param pulumi.Input[_builtins.str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        :param pulumi.Input[_builtins.str] scsi_type: The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        :param pulumi.Input[_builtins.int] shutdown_wait_timeout: The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        :param pulumi.Input[_builtins.str] storage_policy_id: The ID of the storage policy to assign to the virtual machine home directory.
        :param pulumi.Input[_builtins.str] swap_placement_policy: The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        :param pulumi.Input[_builtins.bool] sync_time_with_host: Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        :param pulumi.Input[_builtins.bool] sync_time_with_host_periodically: Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[_builtins.str] tools_upgrade_policy: Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the virtual machine. Also exposed as the `id` of the resource.
        :param pulumi.Input['VirtualMachineVappArgs'] vapp: vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vapp_transports: Computed value which is only valid for cloned virtual machines. A list of vApp transport methods supported by the source virtual machine or template.
        :param pulumi.Input[_builtins.bool] vbs_enabled: Flag to specify if Virtualization-based security is enabled for this virtual machine.
        :param pulumi.Input[_builtins.str] vmware_tools_status: The state of  VMware Tools in the guest. This will determine the proper course of action for some device operations.
        :param pulumi.Input[_builtins.str] vmx_path: The path of the virtual machine configuration file on the datastore in which the virtual machine is placed.
        :param pulumi.Input['VirtualMachineVtpmArgs'] vtpm: A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        :param pulumi.Input[_builtins.bool] vvtd_enabled: Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        :param pulumi.Input[_builtins.int] wait_for_guest_ip_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        :param pulumi.Input[_builtins.bool] wait_for_guest_net_routable: Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        :param pulumi.Input[_builtins.int] wait_for_guest_net_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        if alternate_guest_name is not None:
            pulumi.set(__self__, "alternate_guest_name", alternate_guest_name)
        if annotation is not None:
            pulumi.set(__self__, "annotation", annotation)
        if boot_delay is not None:
            pulumi.set(__self__, "boot_delay", boot_delay)
        if boot_retry_delay is not None:
            pulumi.set(__self__, "boot_retry_delay", boot_retry_delay)
        if boot_retry_enabled is not None:
            pulumi.set(__self__, "boot_retry_enabled", boot_retry_enabled)
        if cdroms is not None:
            pulumi.set(__self__, "cdroms", cdroms)
        if change_version is not None:
            pulumi.set(__self__, "change_version", change_version)
        if clone is not None:
            pulumi.set(__self__, "clone", clone)
        if cpu_hot_add_enabled is not None:
            pulumi.set(__self__, "cpu_hot_add_enabled", cpu_hot_add_enabled)
        if cpu_hot_remove_enabled is not None:
            pulumi.set(__self__, "cpu_hot_remove_enabled", cpu_hot_remove_enabled)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cpu_performance_counters_enabled is not None:
            pulumi.set(__self__, "cpu_performance_counters_enabled", cpu_performance_counters_enabled)
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpu_share_count is not None:
            pulumi.set(__self__, "cpu_share_count", cpu_share_count)
        if cpu_share_level is not None:
            pulumi.set(__self__, "cpu_share_level", cpu_share_level)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter_id is not None:
            pulumi.set(__self__, "datacenter_id", datacenter_id)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if default_ip_address is not None:
            pulumi.set(__self__, "default_ip_address", default_ip_address)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if efi_secure_boot_enabled is not None:
            pulumi.set(__self__, "efi_secure_boot_enabled", efi_secure_boot_enabled)
        if enable_disk_uuid is not None:
            pulumi.set(__self__, "enable_disk_uuid", enable_disk_uuid)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if ept_rvi_mode is not None:
            pulumi.set(__self__, "ept_rvi_mode", ept_rvi_mode)
        if extra_config is not None:
            pulumi.set(__self__, "extra_config", extra_config)
        if extra_config_reboot_required is not None:
            pulumi.set(__self__, "extra_config_reboot_required", extra_config_reboot_required)
        if firmware is not None:
            pulumi.set(__self__, "firmware", firmware)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_power_off is not None:
            pulumi.set(__self__, "force_power_off", force_power_off)
        if guest_id is not None:
            pulumi.set(__self__, "guest_id", guest_id)
        if guest_ip_addresses is not None:
            pulumi.set(__self__, "guest_ip_addresses", guest_ip_addresses)
        if hardware_version is not None:
            pulumi.set(__self__, "hardware_version", hardware_version)
        if host_system_id is not None:
            pulumi.set(__self__, "host_system_id", host_system_id)
        if hv_mode is not None:
            pulumi.set(__self__, "hv_mode", hv_mode)
        if ide_controller_count is not None:
            pulumi.set(__self__, "ide_controller_count", ide_controller_count)
        if ignored_guest_ips is not None:
            pulumi.set(__self__, "ignored_guest_ips", ignored_guest_ips)
        if imported is not None:
            pulumi.set(__self__, "imported", imported)
        if latency_sensitivity is not None:
            pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_hot_add_enabled is not None:
            pulumi.set(__self__, "memory_hot_add_enabled", memory_hot_add_enabled)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if memory_reservation_locked_to_max is not None:
            pulumi.set(__self__, "memory_reservation_locked_to_max", memory_reservation_locked_to_max)
        if memory_share_count is not None:
            pulumi.set(__self__, "memory_share_count", memory_share_count)
        if memory_share_level is not None:
            pulumi.set(__self__, "memory_share_level", memory_share_level)
        if migrate_wait_timeout is not None:
            pulumi.set(__self__, "migrate_wait_timeout", migrate_wait_timeout)
        if moid is not None:
            pulumi.set(__self__, "moid", moid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nested_hv_enabled is not None:
            pulumi.set(__self__, "nested_hv_enabled", nested_hv_enabled)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if num_cores_per_socket is not None:
            pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_cpus is not None:
            pulumi.set(__self__, "num_cpus", num_cpus)
        if nvme_controller_count is not None:
            pulumi.set(__self__, "nvme_controller_count", nvme_controller_count)
        if ovf_deploy is not None:
            pulumi.set(__self__, "ovf_deploy", ovf_deploy)
        if pci_device_ids is not None:
            pulumi.set(__self__, "pci_device_ids", pci_device_ids)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if poweron_timeout is not None:
            pulumi.set(__self__, "poweron_timeout", poweron_timeout)
        if reboot_required is not None:
            pulumi.set(__self__, "reboot_required", reboot_required)
        if replace_trigger is not None:
            pulumi.set(__self__, "replace_trigger", replace_trigger)
        if resource_pool_id is not None:
            pulumi.set(__self__, "resource_pool_id", resource_pool_id)
        if run_tools_scripts_after_power_on is not None:
            pulumi.set(__self__, "run_tools_scripts_after_power_on", run_tools_scripts_after_power_on)
        if run_tools_scripts_after_resume is not None:
            pulumi.set(__self__, "run_tools_scripts_after_resume", run_tools_scripts_after_resume)
        if run_tools_scripts_before_guest_reboot is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_reboot", run_tools_scripts_before_guest_reboot)
        if run_tools_scripts_before_guest_shutdown is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_shutdown", run_tools_scripts_before_guest_shutdown)
        if run_tools_scripts_before_guest_standby is not None:
            pulumi.set(__self__, "run_tools_scripts_before_guest_standby", run_tools_scripts_before_guest_standby)
        if sata_controller_count is not None:
            pulumi.set(__self__, "sata_controller_count", sata_controller_count)
        if scsi_bus_sharing is not None:
            pulumi.set(__self__, "scsi_bus_sharing", scsi_bus_sharing)
        if scsi_controller_count is not None:
            pulumi.set(__self__, "scsi_controller_count", scsi_controller_count)
        if scsi_type is not None:
            pulumi.set(__self__, "scsi_type", scsi_type)
        if shutdown_wait_timeout is not None:
            pulumi.set(__self__, "shutdown_wait_timeout", shutdown_wait_timeout)
        if storage_policy_id is not None:
            pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if swap_placement_policy is not None:
            pulumi.set(__self__, "swap_placement_policy", swap_placement_policy)
        if sync_time_with_host is not None:
            pulumi.set(__self__, "sync_time_with_host", sync_time_with_host)
        if sync_time_with_host_periodically is not None:
            pulumi.set(__self__, "sync_time_with_host_periodically", sync_time_with_host_periodically)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tools_upgrade_policy is not None:
            pulumi.set(__self__, "tools_upgrade_policy", tools_upgrade_policy)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if vapp is not None:
            pulumi.set(__self__, "vapp", vapp)
        if vapp_transports is not None:
            pulumi.set(__self__, "vapp_transports", vapp_transports)
        if vbs_enabled is not None:
            pulumi.set(__self__, "vbs_enabled", vbs_enabled)
        if vmware_tools_status is not None:
            pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)
        if vmx_path is not None:
            pulumi.set(__self__, "vmx_path", vmx_path)
        if vtpm is not None:
            pulumi.set(__self__, "vtpm", vtpm)
        if vvtd_enabled is not None:
            pulumi.set(__self__, "vvtd_enabled", vvtd_enabled)
        if wait_for_guest_ip_timeout is not None:
            pulumi.set(__self__, "wait_for_guest_ip_timeout", wait_for_guest_ip_timeout)
        if wait_for_guest_net_routable is not None:
            pulumi.set(__self__, "wait_for_guest_net_routable", wait_for_guest_net_routable)
        if wait_for_guest_net_timeout is not None:
            pulumi.set(__self__, "wait_for_guest_net_timeout", wait_for_guest_net_timeout)

    @_builtins.property
    @pulumi.getter(name="alternateGuestName")
    def alternate_guest_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        """
        return pulumi.get(self, "alternate_guest_name")

    @alternate_guest_name.setter
    def alternate_guest_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternate_guest_name", value)

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the virtual machine.
        """
        return pulumi.get(self, "annotation")

    @annotation.setter
    def annotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "annotation", value)

    @_builtins.property
    @pulumi.getter(name="bootDelay")
    def boot_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of milliseconds to wait before starting the boot sequence.
        """
        return pulumi.get(self, "boot_delay")

    @boot_delay.setter
    def boot_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_delay", value)

    @_builtins.property
    @pulumi.getter(name="bootRetryDelay")
    def boot_retry_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        """
        return pulumi.get(self, "boot_retry_delay")

    @boot_retry_delay.setter
    def boot_retry_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_retry_delay", value)

    @_builtins.property
    @pulumi.getter(name="bootRetryEnabled")
    def boot_retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        """
        return pulumi.get(self, "boot_retry_enabled")

    @boot_retry_enabled.setter
    def boot_retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "boot_retry_enabled", value)

    @_builtins.property
    @pulumi.getter
    def cdroms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]]:
        """
        A specification for a CDROM device on this virtual machine.
        """
        return pulumi.get(self, "cdroms")

    @cdroms.setter
    def cdroms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineCdromArgs']]]]):
        pulumi.set(self, "cdroms", value)

    @_builtins.property
    @pulumi.getter(name="changeVersion")
    def change_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a given version of the last configuration was applied.
        """
        return pulumi.get(self, "change_version")

    @change_version.setter
    def change_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_version", value)

    @_builtins.property
    @pulumi.getter
    def clone(self) -> Optional[pulumi.Input['VirtualMachineCloneArgs']]:
        """
        A specification for cloning a virtual machine from template.
        """
        return pulumi.get(self, "clone")

    @clone.setter
    def clone(self, value: Optional[pulumi.Input['VirtualMachineCloneArgs']]):
        pulumi.set(self, "clone", value)

    @_builtins.property
    @pulumi.getter(name="cpuHotAddEnabled")
    def cpu_hot_add_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_add_enabled")

    @cpu_hot_add_enabled.setter
    def cpu_hot_add_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_hot_add_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuHotRemoveEnabled")
    def cpu_hot_remove_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_remove_enabled")

    @cpu_hot_remove_enabled.setter
    def cpu_hot_remove_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_hot_remove_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @_builtins.property
    @pulumi.getter(name="cpuPerformanceCountersEnabled")
    def cpu_performance_counters_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable CPU performance counters on this virtual machine.
        """
        return pulumi.get(self, "cpu_performance_counters_enabled")

    @cpu_performance_counters_enabled.setter
    def cpu_performance_counters_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cpu_performance_counters_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @_builtins.property
    @pulumi.getter(name="cpuShareCount")
    def cpu_share_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of shares to allocate to cpu for a custom share level.
        """
        return pulumi.get(self, "cpu_share_count")

    @cpu_share_count.setter
    def cpu_share_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_share_count", value)

    @_builtins.property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "cpu_share_level")

    @cpu_share_level.setter
    def cpu_share_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_share_level", value)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the datacenter where the VM is to be created.
        """
        return pulumi.get(self, "datacenter_id")

    @datacenter_id.setter
    def datacenter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter_id", value)

    @_builtins.property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a datastore cluster to put the virtual machine in.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datastore_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultIpAddress")
    def default_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address selected by the provider to be used with any provisioners configured on this resource. When possible, this is the first IPv4 address that is reachable through the default gateway configured on the machine, then the first reachable IPv6 address, and then the first general discovered address if neither exists. If  VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this value will be blank.
        """
        return pulumi.get(self, "default_ip_address")

    @default_ip_address.setter
    def default_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]:
        """
        A specification for a virtual disk device on this virtual machine.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="efiSecureBootEnabled")
    def efi_secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When the boot type set in firmware is efi, this enables EFI secure boot.
        """
        return pulumi.get(self, "efi_secure_boot_enabled")

    @efi_secure_boot_enabled.setter
    def efi_secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "efi_secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="enableDiskUuid")
    def enable_disk_uuid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        """
        return pulumi.get(self, "enable_disk_uuid")

    @enable_disk_uuid.setter
    def enable_disk_uuid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_disk_uuid", value)

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable logging on this virtual machine.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @_builtins.property
    @pulumi.getter(name="eptRviMode")
    def ept_rvi_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        """
        return pulumi.get(self, "ept_rvi_mode")

    @ept_rvi_mode.setter
    def ept_rvi_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ept_rvi_mode", value)

    @_builtins.property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        """
        return pulumi.get(self, "extra_config")

    @extra_config.setter
    def extra_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extra_config", value)

    @_builtins.property
    @pulumi.getter(name="extraConfigRebootRequired")
    def extra_config_reboot_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        """
        return pulumi.get(self, "extra_config_reboot_required")

    @extra_config_reboot_required.setter
    def extra_config_reboot_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extra_config_reboot_required", value)

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The firmware interface to use on the virtual machine. Can be one of bios or efi.
        """
        return pulumi.get(self, "firmware")

    @firmware.setter
    def firmware(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder to locate the virtual machine in.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="forcePowerOff")
    def force_power_off(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        """
        return pulumi.get(self, "force_power_off")

    @force_power_off.setter
    def force_power_off(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_power_off", value)

    @_builtins.property
    @pulumi.getter(name="guestId")
    def guest_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The guest ID for the operating system.
        """
        return pulumi.get(self, "guest_id")

    @guest_id.setter
    def guest_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_id", value)

    @_builtins.property
    @pulumi.getter(name="guestIpAddresses")
    def guest_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The current list of IP addresses on this machine, including the value of `default_ip_address`. If VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this list will be empty.
        """
        return pulumi.get(self, "guest_ip_addresses")

    @guest_ip_addresses.setter
    def guest_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guest_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        """
        return pulumi.get(self, "hardware_version")

    @hardware_version.setter
    def hardware_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hardware_version", value)

    @_builtins.property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an optional host system to pin the virtual machine to.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_system_id", value)

    @_builtins.property
    @pulumi.getter(name="hvMode")
    def hv_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        """
        return pulumi.get(self, "hv_mode")

    @hv_mode.setter
    def hv_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hv_mode", value)

    @_builtins.property
    @pulumi.getter(name="ideControllerCount")
    def ide_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ide_controller_count")

    @ide_controller_count.setter
    def ide_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ide_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="ignoredGuestIps")
    def ignored_guest_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses and CIDR networks to ignore while waiting for an IP
        """
        return pulumi.get(self, "ignored_guest_ips")

    @ignored_guest_ips.setter
    def ignored_guest_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignored_guest_ips", value)

    @_builtins.property
    @pulumi.getter
    def imported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the virtual machine resource has been imported, or if the state has been migrated from a previous version of the resource. It influences the behavior of the first post-import apply operation. See the section on importing below.
        """
        return pulumi.get(self, "imported")

    @imported.setter
    def imported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "imported", value)

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        """
        return pulumi.get(self, "latency_sensitivity")

    @latency_sensitivity.setter
    def latency_sensitivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latency_sensitivity", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the virtual machine's memory, in MB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="memoryHotAddEnabled")
    def memory_hot_add_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow memory to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "memory_hot_add_enabled")

    @memory_hot_add_enabled.setter
    def memory_hot_add_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "memory_hot_add_enabled", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservationLockedToMax")
    def memory_reservation_locked_to_max(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        """
        return pulumi.get(self, "memory_reservation_locked_to_max")

    @memory_reservation_locked_to_max.setter
    def memory_reservation_locked_to_max(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "memory_reservation_locked_to_max", value)

    @_builtins.property
    @pulumi.getter(name="memoryShareCount")
    def memory_share_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of shares to allocate to memory for a custom share level.
        """
        return pulumi.get(self, "memory_share_count")

    @memory_share_count.setter
    def memory_share_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_share_count", value)

    @_builtins.property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The allocation level for memory resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "memory_share_level")

    @memory_share_level.setter
    def memory_share_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_share_level", value)

    @_builtins.property
    @pulumi.getter(name="migrateWaitTimeout")
    def migrate_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        """
        return pulumi.get(self, "migrate_wait_timeout")

    @migrate_wait_timeout.setter
    def migrate_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "migrate_wait_timeout", value)

    @_builtins.property
    @pulumi.getter
    def moid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed object reference ID of the created virtual machine.
        """
        return pulumi.get(self, "moid")

    @moid.setter
    def moid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "moid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this virtual machine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nestedHvEnabled")
    def nested_hv_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        """
        return pulumi.get(self, "nested_hv_enabled")

    @nested_hv_enabled.setter
    def nested_hv_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "nested_hv_enabled", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]]:
        """
        A specification for a virtual NIC on this virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @num_cores_per_socket.setter
    def num_cores_per_socket(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cores_per_socket", value)

    @_builtins.property
    @pulumi.getter(name="numCpus")
    def num_cpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of virtual processors to assign to this virtual machine.
        """
        return pulumi.get(self, "num_cpus")

    @num_cpus.setter
    def num_cpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_cpus", value)

    @_builtins.property
    @pulumi.getter(name="nvmeControllerCount")
    def nvme_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "nvme_controller_count")

    @nvme_controller_count.setter
    def nvme_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "nvme_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="ovfDeploy")
    def ovf_deploy(self) -> Optional[pulumi.Input['VirtualMachineOvfDeployArgs']]:
        """
        A specification for deploying a virtual machine from ovf/ova template.
        """
        return pulumi.get(self, "ovf_deploy")

    @ovf_deploy.setter
    def ovf_deploy(self, value: Optional[pulumi.Input['VirtualMachineOvfDeployArgs']]):
        pulumi.set(self, "ovf_deploy", value)

    @_builtins.property
    @pulumi.getter(name="pciDeviceIds")
    def pci_device_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of PCI passthrough devices
        """
        return pulumi.get(self, "pci_device_ids")

    @pci_device_ids.setter
    def pci_device_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pci_device_ids", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A computed value for the current power state of the virtual machine. One of `on`, `off`, or `suspended`.
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="poweronTimeout")
    def poweron_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in seconds, that we will be trying to power on a VM
        """
        return pulumi.get(self, "poweron_timeout")

    @poweron_timeout.setter
    def poweron_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poweron_timeout", value)

    @_builtins.property
    @pulumi.getter(name="rebootRequired")
    def reboot_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "reboot_required")

    @reboot_required.setter
    def reboot_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reboot_required", value)

    @_builtins.property
    @pulumi.getter(name="replaceTrigger")
    def replace_trigger(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Triggers replacement of resource whenever it changes.
        """
        return pulumi.get(self, "replace_trigger")

    @replace_trigger.setter
    def replace_trigger(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replace_trigger", value)

    @_builtins.property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a resource pool to put the virtual machine in.
        """
        return pulumi.get(self, "resource_pool_id")

    @resource_pool_id.setter
    def resource_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterPowerOn")
    def run_tools_scripts_after_power_on(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_power_on")

    @run_tools_scripts_after_power_on.setter
    def run_tools_scripts_after_power_on(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_after_power_on", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterResume")
    def run_tools_scripts_after_resume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_resume")

    @run_tools_scripts_after_resume.setter
    def run_tools_scripts_after_resume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_after_resume", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestReboot")
    def run_tools_scripts_before_guest_reboot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_reboot")

    @run_tools_scripts_before_guest_reboot.setter
    def run_tools_scripts_before_guest_reboot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_reboot", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestShutdown")
    def run_tools_scripts_before_guest_shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_shutdown")

    @run_tools_scripts_before_guest_shutdown.setter
    def run_tools_scripts_before_guest_shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_shutdown", value)

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestStandby")
    def run_tools_scripts_before_guest_standby(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_standby")

    @run_tools_scripts_before_guest_standby.setter
    def run_tools_scripts_before_guest_standby(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_tools_scripts_before_guest_standby", value)

    @_builtins.property
    @pulumi.getter(name="sataControllerCount")
    def sata_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "sata_controller_count")

    @sata_controller_count.setter
    def sata_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sata_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="scsiBusSharing")
    def scsi_bus_sharing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        """
        return pulumi.get(self, "scsi_bus_sharing")

    @scsi_bus_sharing.setter
    def scsi_bus_sharing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scsi_bus_sharing", value)

    @_builtins.property
    @pulumi.getter(name="scsiControllerCount")
    def scsi_controller_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "scsi_controller_count")

    @scsi_controller_count.setter
    def scsi_controller_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scsi_controller_count", value)

    @_builtins.property
    @pulumi.getter(name="scsiType")
    def scsi_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        """
        return pulumi.get(self, "scsi_type")

    @scsi_type.setter
    def scsi_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scsi_type", value)

    @_builtins.property
    @pulumi.getter(name="shutdownWaitTimeout")
    def shutdown_wait_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        """
        return pulumi.get(self, "shutdown_wait_timeout")

    @shutdown_wait_timeout.setter
    def shutdown_wait_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shutdown_wait_timeout", value)

    @_builtins.property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage policy to assign to the virtual machine home directory.
        """
        return pulumi.get(self, "storage_policy_id")

    @storage_policy_id.setter
    def storage_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="swapPlacementPolicy")
    def swap_placement_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        """
        return pulumi.get(self, "swap_placement_policy")

    @swap_placement_policy.setter
    def swap_placement_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "swap_placement_policy", value)

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHost")
    def sync_time_with_host(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host")

    @sync_time_with_host.setter
    def sync_time_with_host(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_time_with_host", value)

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHostPeriodically")
    def sync_time_with_host_periodically(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host_periodically")

    @sync_time_with_host_periodically.setter
    def sync_time_with_host_periodically(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_time_with_host_periodically", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tag IDs to apply to this object.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="toolsUpgradePolicy")
    def tools_upgrade_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        """
        return pulumi.get(self, "tools_upgrade_policy")

    @tools_upgrade_policy.setter
    def tools_upgrade_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tools_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the virtual machine. Also exposed as the `id` of the resource.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)

    @_builtins.property
    @pulumi.getter
    def vapp(self) -> Optional[pulumi.Input['VirtualMachineVappArgs']]:
        """
        vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        """
        return pulumi.get(self, "vapp")

    @vapp.setter
    def vapp(self, value: Optional[pulumi.Input['VirtualMachineVappArgs']]):
        pulumi.set(self, "vapp", value)

    @_builtins.property
    @pulumi.getter(name="vappTransports")
    def vapp_transports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Computed value which is only valid for cloned virtual machines. A list of vApp transport methods supported by the source virtual machine or template.
        """
        return pulumi.get(self, "vapp_transports")

    @vapp_transports.setter
    def vapp_transports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vapp_transports", value)

    @_builtins.property
    @pulumi.getter(name="vbsEnabled")
    def vbs_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify if Virtualization-based security is enabled for this virtual machine.
        """
        return pulumi.get(self, "vbs_enabled")

    @vbs_enabled.setter
    def vbs_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vbs_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of  VMware Tools in the guest. This will determine the proper course of action for some device operations.
        """
        return pulumi.get(self, "vmware_tools_status")

    @vmware_tools_status.setter
    def vmware_tools_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmware_tools_status", value)

    @_builtins.property
    @pulumi.getter(name="vmxPath")
    def vmx_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the virtual machine configuration file on the datastore in which the virtual machine is placed.
        """
        return pulumi.get(self, "vmx_path")

    @vmx_path.setter
    def vmx_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmx_path", value)

    @_builtins.property
    @pulumi.getter
    def vtpm(self) -> Optional[pulumi.Input['VirtualMachineVtpmArgs']]:
        """
        A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        """
        return pulumi.get(self, "vtpm")

    @vtpm.setter
    def vtpm(self, value: Optional[pulumi.Input['VirtualMachineVtpmArgs']]):
        pulumi.set(self, "vtpm", value)

    @_builtins.property
    @pulumi.getter(name="vvtdEnabled")
    def vvtd_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        """
        return pulumi.get(self, "vvtd_enabled")

    @vvtd_enabled.setter
    def vvtd_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vvtd_enabled", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestIpTimeout")
    def wait_for_guest_ip_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_ip_timeout")

    @wait_for_guest_ip_timeout.setter
    def wait_for_guest_ip_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_guest_ip_timeout", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetRoutable")
    def wait_for_guest_net_routable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        """
        return pulumi.get(self, "wait_for_guest_net_routable")

    @wait_for_guest_net_routable.setter
    def wait_for_guest_net_routable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_guest_net_routable", value)

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetTimeout")
    def wait_for_guest_net_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_net_timeout")

    @wait_for_guest_net_timeout.setter
    def wait_for_guest_net_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wait_for_guest_net_timeout", value)


@pulumi.type_token("vsphere:index/virtualMachine:VirtualMachine")
class VirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_guest_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotation: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cdroms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCdromArgs', 'VirtualMachineCdromArgsDict']]]]] = None,
                 clone: Optional[pulumi.Input[Union['VirtualMachineCloneArgs', 'VirtualMachineCloneArgsDict']]] = None,
                 cpu_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_hot_remove_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_performance_counters_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskArgs', 'VirtualMachineDiskArgsDict']]]]] = None,
                 efi_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_disk_uuid: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 ept_rvi_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extra_config_reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 force_power_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_version: Optional[pulumi.Input[_builtins.int]] = None,
                 host_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hv_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ide_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ignored_guest_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 latency_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation_locked_to_max: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 migrate_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nested_hv_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNetworkInterfaceArgs', 'VirtualMachineNetworkInterfaceArgsDict']]]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 nvme_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ovf_deploy: Optional[pulumi.Input[Union['VirtualMachineOvfDeployArgs', 'VirtualMachineOvfDeployArgsDict']]] = None,
                 pci_device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 poweron_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 replace_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_tools_scripts_after_power_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_after_resume: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_standby: Optional[pulumi.Input[_builtins.bool]] = None,
                 sata_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_bus_sharing: Optional[pulumi.Input[_builtins.str]] = None,
                 scsi_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shutdown_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 swap_placement_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_time_with_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_time_with_host_periodically: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tools_upgrade_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 vapp: Optional[pulumi.Input[Union['VirtualMachineVappArgs', 'VirtualMachineVappArgsDict']]] = None,
                 vbs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm: Optional[pulumi.Input[Union['VirtualMachineVtpmArgs', 'VirtualMachineVtpmArgsDict']]] = None,
                 vvtd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_ip_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_guest_net_routable: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_net_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        ### Additional Importing Requirements

        Many of the requirements for [cloning](#additional-requirements-and-notes-for-cloning) apply to importing. Although importing writes directly to the Terraform state, some rules can not be enforced during import time, so every effort should be made to ensure the correctness of the configuration before the import.

        The following requirements apply to import:

        * The disks must have a [`label`](#label) argument assigned in a convention matching `Hard Disk`, starting with disk number 0, based on each virtual disk order on the SCSI bus. As an example, a disk on SCSI controller `0` with a unit number of `0` would be labeled as `Hard Disk 0`, a disk on the same controller with a unit number of `1` would be `Hard Disk 1`, but the next disk, which is on SCSI controller `1` with a unit number of `0`, still becomes `Hard Disk 2`.

        * Disks are always imported with [`keep_on_remove`](#keep_on_remove) enabled until the first `pulumi up` run which will remove the setting for known disks. This process safeguards against naming or accounting mistakes in the disk configuration.

        * The storage controller count for the resource is set to the number of contiguous storage controllers found, starting with the controller at SCSI bus number `0`. If no storage controllers are discovered, the virtual machine is not eligible for import. For maximum compatibility, ensure that the virtual machine has the exact number of storage controllers needed and set the storage controller count accordingly.

        After importing, you should run `pulumi preview`. Unless you have changed anything else in the configuration that would cause other attributes to change. The only difference should be configuration-only changes, which are typically comprised of:

        * The [`imported`](#imported) flag will transition from `true` to `false`.

        * The [`keep_on_remove`](#keep_on_remove) of known disks will transition from `true` to `false`.

        * Configuration supplied in the [`clone`](#clone) block, if present, will be persisted to state. This initial persistence operation does not perform any cloning or customization actions, nor does it force a new resource. After the first apply operation, further changes to `clone` will force the creation of a new resource.

        These changes only update Terraform state when applied. Hence, it is safe to run when the virtual machine is running. If more settings are modified, you may need to plan maintenance accordingly for any necessary virtual machine re-configurations.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternate_guest_name: The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        :param pulumi.Input[_builtins.str] annotation: User-provided description of the virtual machine.
        :param pulumi.Input[_builtins.int] boot_delay: The number of milliseconds to wait before starting the boot sequence.
        :param pulumi.Input[_builtins.int] boot_retry_delay: The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        :param pulumi.Input[_builtins.bool] boot_retry_enabled: If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCdromArgs', 'VirtualMachineCdromArgsDict']]]] cdroms: A specification for a CDROM device on this virtual machine.
        :param pulumi.Input[Union['VirtualMachineCloneArgs', 'VirtualMachineCloneArgsDict']] clone: A specification for cloning a virtual machine from template.
        :param pulumi.Input[_builtins.bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.bool] cpu_hot_remove_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] cpu_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.bool] cpu_performance_counters_enabled: Enable CPU performance counters on this virtual machine.
        :param pulumi.Input[_builtins.int] cpu_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.int] cpu_share_count: The amount of shares to allocate to cpu for a custom share level.
        :param pulumi.Input[_builtins.str] cpu_share_level: The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[_builtins.str] datacenter_id: The ID of the datacenter where the VM is to be created.
        :param pulumi.Input[_builtins.str] datastore_cluster_id: The ID of a datastore cluster to put the virtual machine in.
        :param pulumi.Input[_builtins.str] datastore_id: The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskArgs', 'VirtualMachineDiskArgsDict']]]] disks: A specification for a virtual disk device on this virtual machine.
        :param pulumi.Input[_builtins.bool] efi_secure_boot_enabled: When the boot type set in firmware is efi, this enables EFI secure boot.
        :param pulumi.Input[_builtins.bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        :param pulumi.Input[_builtins.bool] enable_logging: Enable logging on this virtual machine.
        :param pulumi.Input[_builtins.str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_config: Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] extra_config_reboot_required: Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        :param pulumi.Input[_builtins.str] firmware: The firmware interface to use on the virtual machine. Can be one of bios or efi.
        :param pulumi.Input[_builtins.str] folder: The name of the folder to locate the virtual machine in.
        :param pulumi.Input[_builtins.bool] force_power_off: Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        :param pulumi.Input[_builtins.str] guest_id: The guest ID for the operating system.
        :param pulumi.Input[_builtins.int] hardware_version: The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        :param pulumi.Input[_builtins.str] host_system_id: The ID of an optional host system to pin the virtual machine to.
        :param pulumi.Input[_builtins.str] hv_mode: The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_guest_ips: List of IP addresses and CIDR networks to ignore while waiting for an IP
        :param pulumi.Input[_builtins.str] latency_sensitivity: Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        :param pulumi.Input[_builtins.int] memory: The size of the virtual machine's memory, in MB.
        :param pulumi.Input[_builtins.bool] memory_hot_add_enabled: Allow memory to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] memory_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.int] memory_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.bool] memory_reservation_locked_to_max: If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        :param pulumi.Input[_builtins.int] memory_share_count: The amount of shares to allocate to memory for a custom share level.
        :param pulumi.Input[_builtins.str] memory_share_level: The allocation level for memory resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[_builtins.int] migrate_wait_timeout: The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        :param pulumi.Input[_builtins.str] name: The name of this virtual machine.
        :param pulumi.Input[_builtins.bool] nested_hv_enabled: Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNetworkInterfaceArgs', 'VirtualMachineNetworkInterfaceArgsDict']]]] network_interfaces: A specification for a virtual NIC on this virtual machine.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        :param pulumi.Input[_builtins.int] num_cpus: The number of virtual processors to assign to this virtual machine.
        :param pulumi.Input[Union['VirtualMachineOvfDeployArgs', 'VirtualMachineOvfDeployArgsDict']] ovf_deploy: A specification for deploying a virtual machine from ovf/ova template.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pci_device_ids: A list of PCI passthrough devices
        :param pulumi.Input[_builtins.int] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[_builtins.str] replace_trigger: Triggers replacement of resource whenever it changes.
        :param pulumi.Input[_builtins.str] resource_pool_id: The ID of a resource pool to put the virtual machine in.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_power_on: Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_resume: Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_reboot: Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_shutdown: Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_standby: Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        :param pulumi.Input[_builtins.str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        :param pulumi.Input[_builtins.str] scsi_type: The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        :param pulumi.Input[_builtins.int] shutdown_wait_timeout: The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        :param pulumi.Input[_builtins.str] storage_policy_id: The ID of the storage policy to assign to the virtual machine home directory.
        :param pulumi.Input[_builtins.str] swap_placement_policy: The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        :param pulumi.Input[_builtins.bool] sync_time_with_host: Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        :param pulumi.Input[_builtins.bool] sync_time_with_host_periodically: Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[_builtins.str] tools_upgrade_policy: Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        :param pulumi.Input[Union['VirtualMachineVappArgs', 'VirtualMachineVappArgsDict']] vapp: vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] vbs_enabled: Flag to specify if Virtualization-based security is enabled for this virtual machine.
        :param pulumi.Input[Union['VirtualMachineVtpmArgs', 'VirtualMachineVtpmArgsDict']] vtpm: A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        :param pulumi.Input[_builtins.bool] vvtd_enabled: Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        :param pulumi.Input[_builtins.int] wait_for_guest_ip_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        :param pulumi.Input[_builtins.bool] wait_for_guest_net_routable: Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        :param pulumi.Input[_builtins.int] wait_for_guest_net_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ### Additional Importing Requirements

        Many of the requirements for [cloning](#additional-requirements-and-notes-for-cloning) apply to importing. Although importing writes directly to the Terraform state, some rules can not be enforced during import time, so every effort should be made to ensure the correctness of the configuration before the import.

        The following requirements apply to import:

        * The disks must have a [`label`](#label) argument assigned in a convention matching `Hard Disk`, starting with disk number 0, based on each virtual disk order on the SCSI bus. As an example, a disk on SCSI controller `0` with a unit number of `0` would be labeled as `Hard Disk 0`, a disk on the same controller with a unit number of `1` would be `Hard Disk 1`, but the next disk, which is on SCSI controller `1` with a unit number of `0`, still becomes `Hard Disk 2`.

        * Disks are always imported with [`keep_on_remove`](#keep_on_remove) enabled until the first `pulumi up` run which will remove the setting for known disks. This process safeguards against naming or accounting mistakes in the disk configuration.

        * The storage controller count for the resource is set to the number of contiguous storage controllers found, starting with the controller at SCSI bus number `0`. If no storage controllers are discovered, the virtual machine is not eligible for import. For maximum compatibility, ensure that the virtual machine has the exact number of storage controllers needed and set the storage controller count accordingly.

        After importing, you should run `pulumi preview`. Unless you have changed anything else in the configuration that would cause other attributes to change. The only difference should be configuration-only changes, which are typically comprised of:

        * The [`imported`](#imported) flag will transition from `true` to `false`.

        * The [`keep_on_remove`](#keep_on_remove) of known disks will transition from `true` to `false`.

        * Configuration supplied in the [`clone`](#clone) block, if present, will be persisted to state. This initial persistence operation does not perform any cloning or customization actions, nor does it force a new resource. After the first apply operation, further changes to `clone` will force the creation of a new resource.

        These changes only update Terraform state when applied. Hence, it is safe to run when the virtual machine is running. If more settings are modified, you may need to plan maintenance accordingly for any necessary virtual machine re-configurations.

        :param str resource_name: The name of the resource.
        :param VirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_guest_name: Optional[pulumi.Input[_builtins.str]] = None,
                 annotation: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 boot_retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cdroms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCdromArgs', 'VirtualMachineCdromArgsDict']]]]] = None,
                 clone: Optional[pulumi.Input[Union['VirtualMachineCloneArgs', 'VirtualMachineCloneArgsDict']]] = None,
                 cpu_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_hot_remove_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_performance_counters_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 datacenter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskArgs', 'VirtualMachineDiskArgsDict']]]]] = None,
                 efi_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_disk_uuid: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 ept_rvi_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extra_config_reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 force_power_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 guest_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hardware_version: Optional[pulumi.Input[_builtins.int]] = None,
                 host_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hv_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ide_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ignored_guest_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 latency_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation_locked_to_max: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory_share_count: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[_builtins.str]] = None,
                 migrate_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nested_hv_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNetworkInterfaceArgs', 'VirtualMachineNetworkInterfaceArgsDict']]]]] = None,
                 num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
                 num_cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 nvme_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ovf_deploy: Optional[pulumi.Input[Union['VirtualMachineOvfDeployArgs', 'VirtualMachineOvfDeployArgsDict']]] = None,
                 pci_device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 poweron_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 replace_trigger: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 run_tools_scripts_after_power_on: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_after_resume: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_tools_scripts_before_guest_standby: Optional[pulumi.Input[_builtins.bool]] = None,
                 sata_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_bus_sharing: Optional[pulumi.Input[_builtins.str]] = None,
                 scsi_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scsi_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shutdown_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 swap_placement_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_time_with_host: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_time_with_host_periodically: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tools_upgrade_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 vapp: Optional[pulumi.Input[Union['VirtualMachineVappArgs', 'VirtualMachineVappArgsDict']]] = None,
                 vbs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm: Optional[pulumi.Input[Union['VirtualMachineVtpmArgs', 'VirtualMachineVtpmArgsDict']]] = None,
                 vvtd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_ip_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_guest_net_routable: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_guest_net_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

            __props__.__dict__["alternate_guest_name"] = alternate_guest_name
            __props__.__dict__["annotation"] = annotation
            __props__.__dict__["boot_delay"] = boot_delay
            __props__.__dict__["boot_retry_delay"] = boot_retry_delay
            __props__.__dict__["boot_retry_enabled"] = boot_retry_enabled
            __props__.__dict__["cdroms"] = cdroms
            __props__.__dict__["clone"] = clone
            __props__.__dict__["cpu_hot_add_enabled"] = cpu_hot_add_enabled
            __props__.__dict__["cpu_hot_remove_enabled"] = cpu_hot_remove_enabled
            __props__.__dict__["cpu_limit"] = cpu_limit
            __props__.__dict__["cpu_performance_counters_enabled"] = cpu_performance_counters_enabled
            __props__.__dict__["cpu_reservation"] = cpu_reservation
            __props__.__dict__["cpu_share_count"] = cpu_share_count
            __props__.__dict__["cpu_share_level"] = cpu_share_level
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["datacenter_id"] = datacenter_id
            __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
            __props__.__dict__["datastore_id"] = datastore_id
            __props__.__dict__["disks"] = disks
            __props__.__dict__["efi_secure_boot_enabled"] = efi_secure_boot_enabled
            __props__.__dict__["enable_disk_uuid"] = enable_disk_uuid
            __props__.__dict__["enable_logging"] = enable_logging
            __props__.__dict__["ept_rvi_mode"] = ept_rvi_mode
            __props__.__dict__["extra_config"] = extra_config
            __props__.__dict__["extra_config_reboot_required"] = extra_config_reboot_required
            __props__.__dict__["firmware"] = firmware
            __props__.__dict__["folder"] = folder
            __props__.__dict__["force_power_off"] = force_power_off
            __props__.__dict__["guest_id"] = guest_id
            __props__.__dict__["hardware_version"] = hardware_version
            __props__.__dict__["host_system_id"] = host_system_id
            __props__.__dict__["hv_mode"] = hv_mode
            __props__.__dict__["ide_controller_count"] = ide_controller_count
            __props__.__dict__["ignored_guest_ips"] = ignored_guest_ips
            __props__.__dict__["latency_sensitivity"] = latency_sensitivity
            __props__.__dict__["memory"] = memory
            __props__.__dict__["memory_hot_add_enabled"] = memory_hot_add_enabled
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["memory_reservation"] = memory_reservation
            __props__.__dict__["memory_reservation_locked_to_max"] = memory_reservation_locked_to_max
            __props__.__dict__["memory_share_count"] = memory_share_count
            __props__.__dict__["memory_share_level"] = memory_share_level
            __props__.__dict__["migrate_wait_timeout"] = migrate_wait_timeout
            __props__.__dict__["name"] = name
            __props__.__dict__["nested_hv_enabled"] = nested_hv_enabled
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["num_cores_per_socket"] = num_cores_per_socket
            __props__.__dict__["num_cpus"] = num_cpus
            __props__.__dict__["nvme_controller_count"] = nvme_controller_count
            __props__.__dict__["ovf_deploy"] = ovf_deploy
            __props__.__dict__["pci_device_ids"] = pci_device_ids
            __props__.__dict__["poweron_timeout"] = poweron_timeout
            __props__.__dict__["replace_trigger"] = replace_trigger
            if resource_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_pool_id'")
            __props__.__dict__["resource_pool_id"] = resource_pool_id
            __props__.__dict__["run_tools_scripts_after_power_on"] = run_tools_scripts_after_power_on
            __props__.__dict__["run_tools_scripts_after_resume"] = run_tools_scripts_after_resume
            __props__.__dict__["run_tools_scripts_before_guest_reboot"] = run_tools_scripts_before_guest_reboot
            __props__.__dict__["run_tools_scripts_before_guest_shutdown"] = run_tools_scripts_before_guest_shutdown
            __props__.__dict__["run_tools_scripts_before_guest_standby"] = run_tools_scripts_before_guest_standby
            __props__.__dict__["sata_controller_count"] = sata_controller_count
            __props__.__dict__["scsi_bus_sharing"] = scsi_bus_sharing
            __props__.__dict__["scsi_controller_count"] = scsi_controller_count
            __props__.__dict__["scsi_type"] = scsi_type
            __props__.__dict__["shutdown_wait_timeout"] = shutdown_wait_timeout
            __props__.__dict__["storage_policy_id"] = storage_policy_id
            __props__.__dict__["swap_placement_policy"] = swap_placement_policy
            __props__.__dict__["sync_time_with_host"] = sync_time_with_host
            __props__.__dict__["sync_time_with_host_periodically"] = sync_time_with_host_periodically
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tools_upgrade_policy"] = tools_upgrade_policy
            __props__.__dict__["vapp"] = vapp
            __props__.__dict__["vbs_enabled"] = vbs_enabled
            __props__.__dict__["vtpm"] = vtpm
            __props__.__dict__["vvtd_enabled"] = vvtd_enabled
            __props__.__dict__["wait_for_guest_ip_timeout"] = wait_for_guest_ip_timeout
            __props__.__dict__["wait_for_guest_net_routable"] = wait_for_guest_net_routable
            __props__.__dict__["wait_for_guest_net_timeout"] = wait_for_guest_net_timeout
            __props__.__dict__["change_version"] = None
            __props__.__dict__["default_ip_address"] = None
            __props__.__dict__["guest_ip_addresses"] = None
            __props__.__dict__["imported"] = None
            __props__.__dict__["moid"] = None
            __props__.__dict__["power_state"] = None
            __props__.__dict__["reboot_required"] = None
            __props__.__dict__["uuid"] = None
            __props__.__dict__["vapp_transports"] = None
            __props__.__dict__["vmware_tools_status"] = None
            __props__.__dict__["vmx_path"] = None
        super(VirtualMachine, __self__).__init__(
            'vsphere:index/virtualMachine:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_guest_name: Optional[pulumi.Input[_builtins.str]] = None,
            annotation: Optional[pulumi.Input[_builtins.str]] = None,
            boot_delay: Optional[pulumi.Input[_builtins.int]] = None,
            boot_retry_delay: Optional[pulumi.Input[_builtins.int]] = None,
            boot_retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cdroms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCdromArgs', 'VirtualMachineCdromArgsDict']]]]] = None,
            change_version: Optional[pulumi.Input[_builtins.str]] = None,
            clone: Optional[pulumi.Input[Union['VirtualMachineCloneArgs', 'VirtualMachineCloneArgsDict']]] = None,
            cpu_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cpu_hot_remove_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_performance_counters_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_share_count: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_share_level: Optional[pulumi.Input[_builtins.str]] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            datacenter_id: Optional[pulumi.Input[_builtins.str]] = None,
            datastore_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            datastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskArgs', 'VirtualMachineDiskArgsDict']]]]] = None,
            efi_secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_disk_uuid: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_logging: Optional[pulumi.Input[_builtins.bool]] = None,
            ept_rvi_mode: Optional[pulumi.Input[_builtins.str]] = None,
            extra_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            extra_config_reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
            firmware: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            force_power_off: Optional[pulumi.Input[_builtins.bool]] = None,
            guest_id: Optional[pulumi.Input[_builtins.str]] = None,
            guest_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hardware_version: Optional[pulumi.Input[_builtins.int]] = None,
            host_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            hv_mode: Optional[pulumi.Input[_builtins.str]] = None,
            ide_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
            ignored_guest_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            imported: Optional[pulumi.Input[_builtins.bool]] = None,
            latency_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            memory_hot_add_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
            memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
            memory_reservation_locked_to_max: Optional[pulumi.Input[_builtins.bool]] = None,
            memory_share_count: Optional[pulumi.Input[_builtins.int]] = None,
            memory_share_level: Optional[pulumi.Input[_builtins.str]] = None,
            migrate_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            moid: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nested_hv_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNetworkInterfaceArgs', 'VirtualMachineNetworkInterfaceArgsDict']]]]] = None,
            num_cores_per_socket: Optional[pulumi.Input[_builtins.int]] = None,
            num_cpus: Optional[pulumi.Input[_builtins.int]] = None,
            nvme_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
            ovf_deploy: Optional[pulumi.Input[Union['VirtualMachineOvfDeployArgs', 'VirtualMachineOvfDeployArgsDict']]] = None,
            pci_device_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            power_state: Optional[pulumi.Input[_builtins.str]] = None,
            poweron_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            reboot_required: Optional[pulumi.Input[_builtins.bool]] = None,
            replace_trigger: Optional[pulumi.Input[_builtins.str]] = None,
            resource_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            run_tools_scripts_after_power_on: Optional[pulumi.Input[_builtins.bool]] = None,
            run_tools_scripts_after_resume: Optional[pulumi.Input[_builtins.bool]] = None,
            run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[_builtins.bool]] = None,
            run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
            run_tools_scripts_before_guest_standby: Optional[pulumi.Input[_builtins.bool]] = None,
            sata_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
            scsi_bus_sharing: Optional[pulumi.Input[_builtins.str]] = None,
            scsi_controller_count: Optional[pulumi.Input[_builtins.int]] = None,
            scsi_type: Optional[pulumi.Input[_builtins.str]] = None,
            shutdown_wait_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            storage_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            swap_placement_policy: Optional[pulumi.Input[_builtins.str]] = None,
            sync_time_with_host: Optional[pulumi.Input[_builtins.bool]] = None,
            sync_time_with_host_periodically: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tools_upgrade_policy: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None,
            vapp: Optional[pulumi.Input[Union['VirtualMachineVappArgs', 'VirtualMachineVappArgsDict']]] = None,
            vapp_transports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vbs_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            vmware_tools_status: Optional[pulumi.Input[_builtins.str]] = None,
            vmx_path: Optional[pulumi.Input[_builtins.str]] = None,
            vtpm: Optional[pulumi.Input[Union['VirtualMachineVtpmArgs', 'VirtualMachineVtpmArgsDict']]] = None,
            vvtd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            wait_for_guest_ip_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            wait_for_guest_net_routable: Optional[pulumi.Input[_builtins.bool]] = None,
            wait_for_guest_net_timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternate_guest_name: The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        :param pulumi.Input[_builtins.str] annotation: User-provided description of the virtual machine.
        :param pulumi.Input[_builtins.int] boot_delay: The number of milliseconds to wait before starting the boot sequence.
        :param pulumi.Input[_builtins.int] boot_retry_delay: The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        :param pulumi.Input[_builtins.bool] boot_retry_enabled: If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineCdromArgs', 'VirtualMachineCdromArgsDict']]]] cdroms: A specification for a CDROM device on this virtual machine.
        :param pulumi.Input[_builtins.str] change_version: A unique identifier for a given version of the last configuration was applied.
        :param pulumi.Input[Union['VirtualMachineCloneArgs', 'VirtualMachineCloneArgsDict']] clone: A specification for cloning a virtual machine from template.
        :param pulumi.Input[_builtins.bool] cpu_hot_add_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.bool] cpu_hot_remove_enabled: Allow CPUs to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] cpu_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.bool] cpu_performance_counters_enabled: Enable CPU performance counters on this virtual machine.
        :param pulumi.Input[_builtins.int] cpu_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.int] cpu_share_count: The amount of shares to allocate to cpu for a custom share level.
        :param pulumi.Input[_builtins.str] cpu_share_level: The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[_builtins.str] datacenter_id: The ID of the datacenter where the VM is to be created.
        :param pulumi.Input[_builtins.str] datastore_cluster_id: The ID of a datastore cluster to put the virtual machine in.
        :param pulumi.Input[_builtins.str] datastore_id: The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        :param pulumi.Input[_builtins.str] default_ip_address: The IP address selected by the provider to be used with any provisioners configured on this resource. When possible, this is the first IPv4 address that is reachable through the default gateway configured on the machine, then the first reachable IPv6 address, and then the first general discovered address if neither exists. If  VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this value will be blank.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineDiskArgs', 'VirtualMachineDiskArgsDict']]]] disks: A specification for a virtual disk device on this virtual machine.
        :param pulumi.Input[_builtins.bool] efi_secure_boot_enabled: When the boot type set in firmware is efi, this enables EFI secure boot.
        :param pulumi.Input[_builtins.bool] enable_disk_uuid: Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        :param pulumi.Input[_builtins.bool] enable_logging: Enable logging on this virtual machine.
        :param pulumi.Input[_builtins.str] ept_rvi_mode: The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extra_config: Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        :param pulumi.Input[_builtins.bool] extra_config_reboot_required: Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        :param pulumi.Input[_builtins.str] firmware: The firmware interface to use on the virtual machine. Can be one of bios or efi.
        :param pulumi.Input[_builtins.str] folder: The name of the folder to locate the virtual machine in.
        :param pulumi.Input[_builtins.bool] force_power_off: Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        :param pulumi.Input[_builtins.str] guest_id: The guest ID for the operating system.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guest_ip_addresses: The current list of IP addresses on this machine, including the value of `default_ip_address`. If VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this list will be empty.
        :param pulumi.Input[_builtins.int] hardware_version: The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        :param pulumi.Input[_builtins.str] host_system_id: The ID of an optional host system to pin the virtual machine to.
        :param pulumi.Input[_builtins.str] hv_mode: The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_guest_ips: List of IP addresses and CIDR networks to ignore while waiting for an IP
        :param pulumi.Input[_builtins.bool] imported: Indicates if the virtual machine resource has been imported, or if the state has been migrated from a previous version of the resource. It influences the behavior of the first post-import apply operation. See the section on importing below.
        :param pulumi.Input[_builtins.str] latency_sensitivity: Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        :param pulumi.Input[_builtins.int] memory: The size of the virtual machine's memory, in MB.
        :param pulumi.Input[_builtins.bool] memory_hot_add_enabled: Allow memory to be added to this virtual machine while it is running.
        :param pulumi.Input[_builtins.int] memory_limit: The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        :param pulumi.Input[_builtins.int] memory_reservation: The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        :param pulumi.Input[_builtins.bool] memory_reservation_locked_to_max: If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        :param pulumi.Input[_builtins.int] memory_share_count: The amount of shares to allocate to memory for a custom share level.
        :param pulumi.Input[_builtins.str] memory_share_level: The allocation level for memory resources. Can be one of high, low, normal, or custom.
        :param pulumi.Input[_builtins.int] migrate_wait_timeout: The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        :param pulumi.Input[_builtins.str] moid: The managed object reference ID of the created virtual machine.
        :param pulumi.Input[_builtins.str] name: The name of this virtual machine.
        :param pulumi.Input[_builtins.bool] nested_hv_enabled: Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualMachineNetworkInterfaceArgs', 'VirtualMachineNetworkInterfaceArgsDict']]]] network_interfaces: A specification for a virtual NIC on this virtual machine.
        :param pulumi.Input[_builtins.int] num_cores_per_socket: The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        :param pulumi.Input[_builtins.int] num_cpus: The number of virtual processors to assign to this virtual machine.
        :param pulumi.Input[Union['VirtualMachineOvfDeployArgs', 'VirtualMachineOvfDeployArgsDict']] ovf_deploy: A specification for deploying a virtual machine from ovf/ova template.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pci_device_ids: A list of PCI passthrough devices
        :param pulumi.Input[_builtins.str] power_state: A computed value for the current power state of the virtual machine. One of `on`, `off`, or `suspended`.
        :param pulumi.Input[_builtins.int] poweron_timeout: The amount of time, in seconds, that we will be trying to power on a VM
        :param pulumi.Input[_builtins.str] replace_trigger: Triggers replacement of resource whenever it changes.
        :param pulumi.Input[_builtins.str] resource_pool_id: The ID of a resource pool to put the virtual machine in.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_power_on: Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_after_resume: Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_reboot: Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_shutdown: Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        :param pulumi.Input[_builtins.bool] run_tools_scripts_before_guest_standby: Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        :param pulumi.Input[_builtins.str] scsi_bus_sharing: Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        :param pulumi.Input[_builtins.str] scsi_type: The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        :param pulumi.Input[_builtins.int] shutdown_wait_timeout: The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        :param pulumi.Input[_builtins.str] storage_policy_id: The ID of the storage policy to assign to the virtual machine home directory.
        :param pulumi.Input[_builtins.str] swap_placement_policy: The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        :param pulumi.Input[_builtins.bool] sync_time_with_host: Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        :param pulumi.Input[_builtins.bool] sync_time_with_host_periodically: Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tag IDs to apply to this object.
        :param pulumi.Input[_builtins.str] tools_upgrade_policy: Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the virtual machine. Also exposed as the `id` of the resource.
        :param pulumi.Input[Union['VirtualMachineVappArgs', 'VirtualMachineVappArgsDict']] vapp: vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vapp_transports: Computed value which is only valid for cloned virtual machines. A list of vApp transport methods supported by the source virtual machine or template.
        :param pulumi.Input[_builtins.bool] vbs_enabled: Flag to specify if Virtualization-based security is enabled for this virtual machine.
        :param pulumi.Input[_builtins.str] vmware_tools_status: The state of  VMware Tools in the guest. This will determine the proper course of action for some device operations.
        :param pulumi.Input[_builtins.str] vmx_path: The path of the virtual machine configuration file on the datastore in which the virtual machine is placed.
        :param pulumi.Input[Union['VirtualMachineVtpmArgs', 'VirtualMachineVtpmArgsDict']] vtpm: A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        :param pulumi.Input[_builtins.bool] vvtd_enabled: Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        :param pulumi.Input[_builtins.int] wait_for_guest_ip_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        :param pulumi.Input[_builtins.bool] wait_for_guest_net_routable: Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        :param pulumi.Input[_builtins.int] wait_for_guest_net_timeout: The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineState.__new__(_VirtualMachineState)

        __props__.__dict__["alternate_guest_name"] = alternate_guest_name
        __props__.__dict__["annotation"] = annotation
        __props__.__dict__["boot_delay"] = boot_delay
        __props__.__dict__["boot_retry_delay"] = boot_retry_delay
        __props__.__dict__["boot_retry_enabled"] = boot_retry_enabled
        __props__.__dict__["cdroms"] = cdroms
        __props__.__dict__["change_version"] = change_version
        __props__.__dict__["clone"] = clone
        __props__.__dict__["cpu_hot_add_enabled"] = cpu_hot_add_enabled
        __props__.__dict__["cpu_hot_remove_enabled"] = cpu_hot_remove_enabled
        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["cpu_performance_counters_enabled"] = cpu_performance_counters_enabled
        __props__.__dict__["cpu_reservation"] = cpu_reservation
        __props__.__dict__["cpu_share_count"] = cpu_share_count
        __props__.__dict__["cpu_share_level"] = cpu_share_level
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datacenter_id"] = datacenter_id
        __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
        __props__.__dict__["datastore_id"] = datastore_id
        __props__.__dict__["default_ip_address"] = default_ip_address
        __props__.__dict__["disks"] = disks
        __props__.__dict__["efi_secure_boot_enabled"] = efi_secure_boot_enabled
        __props__.__dict__["enable_disk_uuid"] = enable_disk_uuid
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["ept_rvi_mode"] = ept_rvi_mode
        __props__.__dict__["extra_config"] = extra_config
        __props__.__dict__["extra_config_reboot_required"] = extra_config_reboot_required
        __props__.__dict__["firmware"] = firmware
        __props__.__dict__["folder"] = folder
        __props__.__dict__["force_power_off"] = force_power_off
        __props__.__dict__["guest_id"] = guest_id
        __props__.__dict__["guest_ip_addresses"] = guest_ip_addresses
        __props__.__dict__["hardware_version"] = hardware_version
        __props__.__dict__["host_system_id"] = host_system_id
        __props__.__dict__["hv_mode"] = hv_mode
        __props__.__dict__["ide_controller_count"] = ide_controller_count
        __props__.__dict__["ignored_guest_ips"] = ignored_guest_ips
        __props__.__dict__["imported"] = imported
        __props__.__dict__["latency_sensitivity"] = latency_sensitivity
        __props__.__dict__["memory"] = memory
        __props__.__dict__["memory_hot_add_enabled"] = memory_hot_add_enabled
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["memory_reservation"] = memory_reservation
        __props__.__dict__["memory_reservation_locked_to_max"] = memory_reservation_locked_to_max
        __props__.__dict__["memory_share_count"] = memory_share_count
        __props__.__dict__["memory_share_level"] = memory_share_level
        __props__.__dict__["migrate_wait_timeout"] = migrate_wait_timeout
        __props__.__dict__["moid"] = moid
        __props__.__dict__["name"] = name
        __props__.__dict__["nested_hv_enabled"] = nested_hv_enabled
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["num_cores_per_socket"] = num_cores_per_socket
        __props__.__dict__["num_cpus"] = num_cpus
        __props__.__dict__["nvme_controller_count"] = nvme_controller_count
        __props__.__dict__["ovf_deploy"] = ovf_deploy
        __props__.__dict__["pci_device_ids"] = pci_device_ids
        __props__.__dict__["power_state"] = power_state
        __props__.__dict__["poweron_timeout"] = poweron_timeout
        __props__.__dict__["reboot_required"] = reboot_required
        __props__.__dict__["replace_trigger"] = replace_trigger
        __props__.__dict__["resource_pool_id"] = resource_pool_id
        __props__.__dict__["run_tools_scripts_after_power_on"] = run_tools_scripts_after_power_on
        __props__.__dict__["run_tools_scripts_after_resume"] = run_tools_scripts_after_resume
        __props__.__dict__["run_tools_scripts_before_guest_reboot"] = run_tools_scripts_before_guest_reboot
        __props__.__dict__["run_tools_scripts_before_guest_shutdown"] = run_tools_scripts_before_guest_shutdown
        __props__.__dict__["run_tools_scripts_before_guest_standby"] = run_tools_scripts_before_guest_standby
        __props__.__dict__["sata_controller_count"] = sata_controller_count
        __props__.__dict__["scsi_bus_sharing"] = scsi_bus_sharing
        __props__.__dict__["scsi_controller_count"] = scsi_controller_count
        __props__.__dict__["scsi_type"] = scsi_type
        __props__.__dict__["shutdown_wait_timeout"] = shutdown_wait_timeout
        __props__.__dict__["storage_policy_id"] = storage_policy_id
        __props__.__dict__["swap_placement_policy"] = swap_placement_policy
        __props__.__dict__["sync_time_with_host"] = sync_time_with_host
        __props__.__dict__["sync_time_with_host_periodically"] = sync_time_with_host_periodically
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tools_upgrade_policy"] = tools_upgrade_policy
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["vapp"] = vapp
        __props__.__dict__["vapp_transports"] = vapp_transports
        __props__.__dict__["vbs_enabled"] = vbs_enabled
        __props__.__dict__["vmware_tools_status"] = vmware_tools_status
        __props__.__dict__["vmx_path"] = vmx_path
        __props__.__dict__["vtpm"] = vtpm
        __props__.__dict__["vvtd_enabled"] = vvtd_enabled
        __props__.__dict__["wait_for_guest_ip_timeout"] = wait_for_guest_ip_timeout
        __props__.__dict__["wait_for_guest_net_routable"] = wait_for_guest_net_routable
        __props__.__dict__["wait_for_guest_net_timeout"] = wait_for_guest_net_timeout
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alternateGuestName")
    def alternate_guest_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The guest name for the operating system when guest_id is otherGuest or otherGuest64.
        """
        return pulumi.get(self, "alternate_guest_name")

    @_builtins.property
    @pulumi.getter
    def annotation(self) -> pulumi.Output[_builtins.str]:
        """
        User-provided description of the virtual machine.
        """
        return pulumi.get(self, "annotation")

    @_builtins.property
    @pulumi.getter(name="bootDelay")
    def boot_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of milliseconds to wait before starting the boot sequence.
        """
        return pulumi.get(self, "boot_delay")

    @_builtins.property
    @pulumi.getter(name="bootRetryDelay")
    def boot_retry_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
        """
        return pulumi.get(self, "boot_retry_delay")

    @_builtins.property
    @pulumi.getter(name="bootRetryEnabled")
    def boot_retry_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
        """
        return pulumi.get(self, "boot_retry_enabled")

    @_builtins.property
    @pulumi.getter
    def cdroms(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineCdrom']]]:
        """
        A specification for a CDROM device on this virtual machine.
        """
        return pulumi.get(self, "cdroms")

    @_builtins.property
    @pulumi.getter(name="changeVersion")
    def change_version(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for a given version of the last configuration was applied.
        """
        return pulumi.get(self, "change_version")

    @_builtins.property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.VirtualMachineClone']]:
        """
        A specification for cloning a virtual machine from template.
        """
        return pulumi.get(self, "clone")

    @_builtins.property
    @pulumi.getter(name="cpuHotAddEnabled")
    def cpu_hot_add_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_add_enabled")

    @_builtins.property
    @pulumi.getter(name="cpuHotRemoveEnabled")
    def cpu_hot_remove_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow CPUs to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "cpu_hot_remove_enabled")

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "cpu_limit")

    @_builtins.property
    @pulumi.getter(name="cpuPerformanceCountersEnabled")
    def cpu_performance_counters_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable CPU performance counters on this virtual machine.
        """
        return pulumi.get(self, "cpu_performance_counters_enabled")

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "cpu_reservation")

    @_builtins.property
    @pulumi.getter(name="cpuShareCount")
    def cpu_share_count(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of shares to allocate to cpu for a custom share level.
        """
        return pulumi.get(self, "cpu_share_count")

    @_builtins.property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The allocation level for cpu resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "cpu_share_level")

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @_builtins.property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the datacenter where the VM is to be created.
        """
        return pulumi.get(self, "datacenter_id")

    @_builtins.property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a datastore cluster to put the virtual machine in.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @_builtins.property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
        """
        return pulumi.get(self, "datastore_id")

    @_builtins.property
    @pulumi.getter(name="defaultIpAddress")
    def default_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address selected by the provider to be used with any provisioners configured on this resource. When possible, this is the first IPv4 address that is reachable through the default gateway configured on the machine, then the first reachable IPv6 address, and then the first general discovered address if neither exists. If  VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this value will be blank.
        """
        return pulumi.get(self, "default_ip_address")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence['outputs.VirtualMachineDisk']]:
        """
        A specification for a virtual disk device on this virtual machine.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="efiSecureBootEnabled")
    def efi_secure_boot_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When the boot type set in firmware is efi, this enables EFI secure boot.
        """
        return pulumi.get(self, "efi_secure_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="enableDiskUuid")
    def enable_disk_uuid(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
        """
        return pulumi.get(self, "enable_disk_uuid")

    @_builtins.property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable logging on this virtual machine.
        """
        return pulumi.get(self, "enable_logging")

    @_builtins.property
    @pulumi.getter(name="eptRviMode")
    def ept_rvi_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
        """
        return pulumi.get(self, "ept_rvi_mode")

    @_builtins.property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
        """
        return pulumi.get(self, "extra_config")

    @_builtins.property
    @pulumi.getter(name="extraConfigRebootRequired")
    def extra_config_reboot_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
        """
        return pulumi.get(self, "extra_config_reboot_required")

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The firmware interface to use on the virtual machine. Can be one of bios or efi.
        """
        return pulumi.get(self, "firmware")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the folder to locate the virtual machine in.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="forcePowerOff")
    def force_power_off(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
        """
        return pulumi.get(self, "force_power_off")

    @_builtins.property
    @pulumi.getter(name="guestId")
    def guest_id(self) -> pulumi.Output[_builtins.str]:
        """
        The guest ID for the operating system.
        """
        return pulumi.get(self, "guest_id")

    @_builtins.property
    @pulumi.getter(name="guestIpAddresses")
    def guest_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The current list of IP addresses on this machine, including the value of `default_ip_address`. If VMware Tools is not running on the virtual machine, or if the virtual machine is powered off, this list will be empty.
        """
        return pulumi.get(self, "guest_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> pulumi.Output[_builtins.int]:
        """
        The hardware version for the virtual machine. Allows versions within ranges: 4, 7-11, 13-15, 17-22.
        """
        return pulumi.get(self, "hardware_version")

    @_builtins.property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of an optional host system to pin the virtual machine to.
        """
        return pulumi.get(self, "host_system_id")

    @_builtins.property
    @pulumi.getter(name="hvMode")
    def hv_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
        """
        return pulumi.get(self, "hv_mode")

    @_builtins.property
    @pulumi.getter(name="ideControllerCount")
    def ide_controller_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "ide_controller_count")

    @_builtins.property
    @pulumi.getter(name="ignoredGuestIps")
    def ignored_guest_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of IP addresses and CIDR networks to ignore while waiting for an IP
        """
        return pulumi.get(self, "ignored_guest_ips")

    @_builtins.property
    @pulumi.getter
    def imported(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the virtual machine resource has been imported, or if the state has been migrated from a previous version of the resource. It influences the behavior of the first post-import apply operation. See the section on importing below.
        """
        return pulumi.get(self, "imported")

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
        """
        return pulumi.get(self, "latency_sensitivity")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the virtual machine's memory, in MB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="memoryHotAddEnabled")
    def memory_hot_add_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow memory to be added to this virtual machine while it is running.
        """
        return pulumi.get(self, "memory_hot_add_enabled")

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
        """
        return pulumi.get(self, "memory_limit")

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
        """
        return pulumi.get(self, "memory_reservation")

    @_builtins.property
    @pulumi.getter(name="memoryReservationLockedToMax")
    def memory_reservation_locked_to_max(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set true, memory resource reservation for this virtual machine will always be equal to the virtual machine's memory size;increases in memory size will be rejected when a corresponding reservation increase is not possible. This feature may only be enabled if it is currently possible to reserve all of the virtual machine's memory.
        """
        return pulumi.get(self, "memory_reservation_locked_to_max")

    @_builtins.property
    @pulumi.getter(name="memoryShareCount")
    def memory_share_count(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of shares to allocate to memory for a custom share level.
        """
        return pulumi.get(self, "memory_share_count")

    @_builtins.property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The allocation level for memory resources. Can be one of high, low, normal, or custom.
        """
        return pulumi.get(self, "memory_share_level")

    @_builtins.property
    @pulumi.getter(name="migrateWaitTimeout")
    def migrate_wait_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
        """
        return pulumi.get(self, "migrate_wait_timeout")

    @_builtins.property
    @pulumi.getter
    def moid(self) -> pulumi.Output[_builtins.str]:
        """
        The managed object reference ID of the created virtual machine.
        """
        return pulumi.get(self, "moid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this virtual machine.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nestedHvEnabled")
    def nested_hv_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
        """
        return pulumi.get(self, "nested_hv_enabled")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineNetworkInterface']]]:
        """
        A specification for a virtual NIC on this virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @_builtins.property
    @pulumi.getter(name="numCpus")
    def num_cpus(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of virtual processors to assign to this virtual machine.
        """
        return pulumi.get(self, "num_cpus")

    @_builtins.property
    @pulumi.getter(name="nvmeControllerCount")
    def nvme_controller_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "nvme_controller_count")

    @_builtins.property
    @pulumi.getter(name="ovfDeploy")
    def ovf_deploy(self) -> pulumi.Output[Optional['outputs.VirtualMachineOvfDeploy']]:
        """
        A specification for deploying a virtual machine from ovf/ova template.
        """
        return pulumi.get(self, "ovf_deploy")

    @_builtins.property
    @pulumi.getter(name="pciDeviceIds")
    def pci_device_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of PCI passthrough devices
        """
        return pulumi.get(self, "pci_device_ids")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[_builtins.str]:
        """
        A computed value for the current power state of the virtual machine. One of `on`, `off`, or `suspended`.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="poweronTimeout")
    def poweron_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in seconds, that we will be trying to power on a VM
        """
        return pulumi.get(self, "poweron_timeout")

    @_builtins.property
    @pulumi.getter(name="rebootRequired")
    def reboot_required(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "reboot_required")

    @_builtins.property
    @pulumi.getter(name="replaceTrigger")
    def replace_trigger(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Triggers replacement of resource whenever it changes.
        """
        return pulumi.get(self, "replace_trigger")

    @_builtins.property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of a resource pool to put the virtual machine in.
        """
        return pulumi.get(self, "resource_pool_id")

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterPowerOn")
    def run_tools_scripts_after_power_on(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_power_on")

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsAfterResume")
    def run_tools_scripts_after_resume(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_after_resume")

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestReboot")
    def run_tools_scripts_before_guest_reboot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_reboot")

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestShutdown")
    def run_tools_scripts_before_guest_shutdown(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_shutdown")

    @_builtins.property
    @pulumi.getter(name="runToolsScriptsBeforeGuestStandby")
    def run_tools_scripts_before_guest_standby(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the run of scripts before guest operating system standby when VMware Tools is installed.
        """
        return pulumi.get(self, "run_tools_scripts_before_guest_standby")

    @_builtins.property
    @pulumi.getter(name="sataControllerCount")
    def sata_controller_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "sata_controller_count")

    @_builtins.property
    @pulumi.getter(name="scsiBusSharing")
    def scsi_bus_sharing(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
        """
        return pulumi.get(self, "scsi_bus_sharing")

    @_builtins.property
    @pulumi.getter(name="scsiControllerCount")
    def scsi_controller_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "scsi_controller_count")

    @_builtins.property
    @pulumi.getter(name="scsiType")
    def scsi_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
        """
        return pulumi.get(self, "scsi_type")

    @_builtins.property
    @pulumi.getter(name="shutdownWaitTimeout")
    def shutdown_wait_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
        """
        return pulumi.get(self, "shutdown_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the storage policy to assign to the virtual machine home directory.
        """
        return pulumi.get(self, "storage_policy_id")

    @_builtins.property
    @pulumi.getter(name="swapPlacementPolicy")
    def swap_placement_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
        """
        return pulumi.get(self, "swap_placement_policy")

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHost")
    def sync_time_with_host(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host")

    @_builtins.property
    @pulumi.getter(name="syncTimeWithHostPeriodically")
    def sync_time_with_host_periodically(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
        """
        return pulumi.get(self, "sync_time_with_host_periodically")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tag IDs to apply to this object.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="toolsUpgradePolicy")
    def tools_upgrade_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
        """
        return pulumi.get(self, "tools_upgrade_policy")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the virtual machine. Also exposed as the `id` of the resource.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter
    def vapp(self) -> pulumi.Output[Optional['outputs.VirtualMachineVapp']]:
        """
        vApp configuration data for this virtual machine. Can be used to provide configuration data for OVF images.
        """
        return pulumi.get(self, "vapp")

    @_builtins.property
    @pulumi.getter(name="vappTransports")
    def vapp_transports(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Computed value which is only valid for cloned virtual machines. A list of vApp transport methods supported by the source virtual machine or template.
        """
        return pulumi.get(self, "vapp_transports")

    @_builtins.property
    @pulumi.getter(name="vbsEnabled")
    def vbs_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify if Virtualization-based security is enabled for this virtual machine.
        """
        return pulumi.get(self, "vbs_enabled")

    @_builtins.property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> pulumi.Output[_builtins.str]:
        """
        The state of  VMware Tools in the guest. This will determine the proper course of action for some device operations.
        """
        return pulumi.get(self, "vmware_tools_status")

    @_builtins.property
    @pulumi.getter(name="vmxPath")
    def vmx_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the virtual machine configuration file on the datastore in which the virtual machine is placed.
        """
        return pulumi.get(self, "vmx_path")

    @_builtins.property
    @pulumi.getter
    def vtpm(self) -> pulumi.Output[Optional['outputs.VirtualMachineVtpm']]:
        """
        A specification for a virtual Trusted Platform Module (TPM) device on the virtual machine.
        """
        return pulumi.get(self, "vtpm")

    @_builtins.property
    @pulumi.getter(name="vvtdEnabled")
    def vvtd_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
        """
        return pulumi.get(self, "vvtd_enabled")

    @_builtins.property
    @pulumi.getter(name="waitForGuestIpTimeout")
    def wait_for_guest_ip_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_ip_timeout")

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetRoutable")
    def wait_for_guest_net_routable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
        """
        return pulumi.get(self, "wait_for_guest_net_routable")

    @_builtins.property
    @pulumi.getter(name="waitForGuestNetTimeout")
    def wait_for_guest_net_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
        """
        return pulumi.get(self, "wait_for_guest_net_timeout")

