# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessPolicyArgs', 'AccessPolicy']

@pulumi.input_type
class AccessPolicyArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 scopes: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccessPolicy resource.
        :param pulumi.Input[builtins.str] parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy.
               Format: 'organizations/{{organization_id}}'
        :param pulumi.Input[builtins.str] title: Human readable title. Does not affect behavior.
               
               
               - - -
        :param pulumi.Input[builtins.str] scopes: Folder or project on which this policy is applicable.
               Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        """
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "title", title)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent of this AccessPolicy in the Cloud Resource Hierarchy.
        Format: 'organizations/{{organization_id}}'
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        Human readable title. Does not affect behavior.


        - - -
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Folder or project on which this policy is applicable.
        Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _AccessPolicyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicy resources.
        :param pulumi.Input[builtins.str] create_time: Time the AccessPolicy was created in UTC.
        :param pulumi.Input[builtins.str] name: Resource name of the AccessPolicy. Format: '{{policy_id}}'
        :param pulumi.Input[builtins.str] parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy.
               Format: 'organizations/{{organization_id}}'
        :param pulumi.Input[builtins.str] scopes: Folder or project on which this policy is applicable.
               Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        :param pulumi.Input[builtins.str] title: Human readable title. Does not affect behavior.
               
               
               - - -
        :param pulumi.Input[builtins.str] update_time: Time the AccessPolicy was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the AccessPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the AccessPolicy. Format: '{{policy_id}}'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of this AccessPolicy in the Cloud Resource Hierarchy.
        Format: 'organizations/{{organization_id}}'
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Folder or project on which this policy is applicable.
        Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable title. Does not affect behavior.


        - - -
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the AccessPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:accesscontextmanager/accessPolicy:AccessPolicy")
class AccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        AccessPolicy is a container for AccessLevels (which define the necessary
        attributes to use GCP services) and ServicePerimeters (which define
        regions of services able to freely pass data within a perimeter). An
        access policy is globally visible within an organization, and the
        restrictions it specifies apply to all projects within an organization.

        To get more information about AccessPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies)
        * How-to Guides
            * [Access Policy Quickstart](https://cloud.google.com/access-context-manager/docs/quickstart)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage

        ### Access Context Manager Access Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="Org Access Policy")
        ```
        ### Access Context Manager Access Policy Scoped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project-name",
            name="my-project-name",
            org_id="123456789",
            deletion_policy="DELETE")
        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="Scoped Access Policy",
            scopes=project.number.apply(lambda number: f"projects/{number}"))
        ```

        ## Import

        AccessPolicy can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, AccessPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessPolicy:AccessPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy.
               Format: 'organizations/{{organization_id}}'
        :param pulumi.Input[builtins.str] scopes: Folder or project on which this policy is applicable.
               Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        :param pulumi.Input[builtins.str] title: Human readable title. Does not affect behavior.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AccessPolicy is a container for AccessLevels (which define the necessary
        attributes to use GCP services) and ServicePerimeters (which define
        regions of services able to freely pass data within a perimeter). An
        access policy is globally visible within an organization, and the
        restrictions it specifies apply to all projects within an organization.

        To get more information about AccessPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies)
        * How-to Guides
            * [Access Policy Quickstart](https://cloud.google.com/access-context-manager/docs/quickstart)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage

        ### Access Context Manager Access Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="Org Access Policy")
        ```
        ### Access Context Manager Access Policy Scoped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project-name",
            name="my-project-name",
            org_id="123456789",
            deletion_policy="DELETE")
        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="Scoped Access Policy",
            scopes=project.number.apply(lambda number: f"projects/{number}"))
        ```

        ## Import

        AccessPolicy can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, AccessPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessPolicy:AccessPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyArgs.__new__(AccessPolicyArgs)

            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["scopes"] = scopes
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(AccessPolicy, __self__).__init__(
            'gcp:accesscontextmanager/accessPolicy:AccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            scopes: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AccessPolicy':
        """
        Get an existing AccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Time the AccessPolicy was created in UTC.
        :param pulumi.Input[builtins.str] name: Resource name of the AccessPolicy. Format: '{{policy_id}}'
        :param pulumi.Input[builtins.str] parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy.
               Format: 'organizations/{{organization_id}}'
        :param pulumi.Input[builtins.str] scopes: Folder or project on which this policy is applicable.
               Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        :param pulumi.Input[builtins.str] title: Human readable title. Does not affect behavior.
               
               
               - - -
        :param pulumi.Input[builtins.str] update_time: Time the AccessPolicy was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyState.__new__(_AccessPolicyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["title"] = title
        __props__.__dict__["update_time"] = update_time
        return AccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the AccessPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Resource name of the AccessPolicy. Format: '{{policy_id}}'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of this AccessPolicy in the Cloud Resource Hierarchy.
        Format: 'organizations/{{organization_id}}'
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Folder or project on which this policy is applicable.
        Format: 'folders/{{folder_id}}' or 'projects/{{project_number}}'
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        Human readable title. Does not affect behavior.


        - - -
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the AccessPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

