# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccessPolicyResult',
    'AwaitableGetAccessPolicyResult',
    'get_access_policy',
    'get_access_policy_output',
]

@pulumi.output_type
class GetAccessPolicyResult:
    """
    A collection of values returned by getAccessPolicy.
    """
    def __init__(__self__, id=None, name=None, parent=None, scopes=None, title=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Resource name of the AccessPolicy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> builtins.str:
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        Human readable title. Does not affect behavior.
        """
        return pulumi.get(self, "title")


class AwaitableGetAccessPolicyResult(GetAccessPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPolicyResult(
            id=self.id,
            name=self.name,
            parent=self.parent,
            scopes=self.scopes,
            title=self.title)


def get_access_policy(parent: Optional[builtins.str] = None,
                      scopes: Optional[Sequence[builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPolicyResult:
    """
    Get information about an Access Context Manager AccessPolicy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy_org = gcp.accesscontextmanager.get_access_policy(parent="organizations/1234567")
    policy_scoped = gcp.accesscontextmanager.get_access_policy(parent="organizations/1234567",
        scopes=["projects/1234567"])
    ```


    :param builtins.str parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy. Format: `organizations/{{organization_id}}`
    :param Sequence[builtins.str] scopes: Folder or project on which this policy is applicable. Format: `folders/{{folder_id}}` or `projects/{{project_number}}`
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['scopes'] = scopes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:accesscontextmanager/getAccessPolicy:getAccessPolicy', __args__, opts=opts, typ=GetAccessPolicyResult).value

    return AwaitableGetAccessPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'),
        scopes=pulumi.get(__ret__, 'scopes'),
        title=pulumi.get(__ret__, 'title'))
def get_access_policy_output(parent: Optional[pulumi.Input[builtins.str]] = None,
                             scopes: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessPolicyResult]:
    """
    Get information about an Access Context Manager AccessPolicy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy_org = gcp.accesscontextmanager.get_access_policy(parent="organizations/1234567")
    policy_scoped = gcp.accesscontextmanager.get_access_policy(parent="organizations/1234567",
        scopes=["projects/1234567"])
    ```


    :param builtins.str parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy. Format: `organizations/{{organization_id}}`
    :param Sequence[builtins.str] scopes: Folder or project on which this policy is applicable. Format: `folders/{{folder_id}}` or `projects/{{project_number}}`
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['scopes'] = scopes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:accesscontextmanager/getAccessPolicy:getAccessPolicy', __args__, opts=opts, typ=GetAccessPolicyResult)
    return __ret__.apply(lambda __response__: GetAccessPolicyResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent'),
        scopes=pulumi.get(__response__, 'scopes'),
        title=pulumi.get(__response__, 'title')))
