# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 automated_backup_policy: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 continuous_backup_config: Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 initial_user: Optional[pulumi.Input['ClusterInitialUserArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maintenance_update_policy: Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']] = None,
                 network_config: Optional[pulumi.Input['ClusterNetworkConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input['ClusterPscConfigArgs']] = None,
                 restore_backup_source: Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']] = None,
                 restore_continuous_backup_source: Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']] = None,
                 secondary_config: Optional[pulumi.Input['ClusterSecondaryConfigArgs']] = None,
                 skip_await_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[builtins.str] location: The location where the alloydb cluster should reside.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['ClusterAutomatedBackupPolicyArgs'] automated_backup_policy: The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_type: The type of cluster. If not set, defaults to PRIMARY.
               Default value is `PRIMARY`.
               Possible values are: `PRIMARY`, `SECONDARY`.
        :param pulumi.Input['ClusterContinuousBackupConfigArgs'] continuous_backup_config: The continuous backup config for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[builtins.str] database_version: The database engine major version. This is an optional field and it's populated at the Cluster creation time.
               Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the cluster should be deleted forcefully.
               Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
               Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input['ClusterEncryptionConfigArgs'] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input['ClusterInitialUserArgs'] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the alloydb cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['ClusterMaintenanceUpdatePolicyArgs'] maintenance_update_policy: MaintenanceUpdatePolicy defines the policy for system updates.
               Structure is documented below.
        :param pulumi.Input['ClusterNetworkConfigArgs'] network_config: Metadata related to network configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ClusterPscConfigArgs'] psc_config: Configuration for Private Service Connect (PSC) for the cluster.
               Structure is documented below.
        :param pulumi.Input['ClusterRestoreBackupSourceArgs'] restore_backup_source: The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterRestoreContinuousBackupSourceArgs'] restore_continuous_backup_source: The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterSecondaryConfigArgs'] secondary_config: Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] skip_await_major_version_upgrade: Set to true to skip awaiting on the major version upgrade of the cluster.
               Possible values: true, false
               Default value: "true"
        :param pulumi.Input[builtins.str] subscription_type: The subscrition type of cluster.
               Possible values are: `TRIAL`, `STANDARD`.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if continuous_backup_config is not None:
            pulumi.set(__self__, "continuous_backup_config", continuous_backup_config)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if initial_user is not None:
            pulumi.set(__self__, "initial_user", initial_user)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_update_policy is not None:
            pulumi.set(__self__, "maintenance_update_policy", maintenance_update_policy)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)
        if restore_backup_source is not None:
            pulumi.set(__self__, "restore_backup_source", restore_backup_source)
        if restore_continuous_backup_source is not None:
            pulumi.set(__self__, "restore_continuous_backup_source", restore_continuous_backup_source)
        if secondary_config is not None:
            pulumi.set(__self__, "secondary_config", secondary_config)
        if skip_await_major_version_upgrade is not None:
            pulumi.set(__self__, "skip_await_major_version_upgrade", skip_await_major_version_upgrade)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location where the alloydb cluster should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]:
        """
        The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of cluster. If not set, defaults to PRIMARY.
        Default value is `PRIMARY`.
        Possible values are: `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="continuousBackupConfig")
    def continuous_backup_config(self) -> Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']]:
        """
        The continuous backup config for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "continuous_backup_config")

    @continuous_backup_config.setter
    def continuous_backup_config(self, value: Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']]):
        pulumi.set(self, "continuous_backup_config", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database engine major version. This is an optional field and it's populated at the Cluster creation time.
        Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine if the cluster should be deleted forcefully.
        Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
        Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> Optional[pulumi.Input['ClusterInitialUserArgs']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: Optional[pulumi.Input['ClusterInitialUserArgs']]):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the alloydb cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceUpdatePolicy")
    def maintenance_update_policy(self) -> Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']]:
        """
        MaintenanceUpdatePolicy defines the policy for system updates.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_update_policy")

    @maintenance_update_policy.setter
    def maintenance_update_policy(self, value: Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']]):
        pulumi.set(self, "maintenance_update_policy", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['ClusterNetworkConfigArgs']]:
        """
        Metadata related to network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['ClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['ClusterPscConfigArgs']]:
        """
        Configuration for Private Service Connect (PSC) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['ClusterPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)

    @property
    @pulumi.getter(name="restoreBackupSource")
    def restore_backup_source(self) -> Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']]:
        """
        The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_backup_source")

    @restore_backup_source.setter
    def restore_backup_source(self, value: Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']]):
        pulumi.set(self, "restore_backup_source", value)

    @property
    @pulumi.getter(name="restoreContinuousBackupSource")
    def restore_continuous_backup_source(self) -> Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']]:
        """
        The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_continuous_backup_source")

    @restore_continuous_backup_source.setter
    def restore_continuous_backup_source(self, value: Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']]):
        pulumi.set(self, "restore_continuous_backup_source", value)

    @property
    @pulumi.getter(name="secondaryConfig")
    def secondary_config(self) -> Optional[pulumi.Input['ClusterSecondaryConfigArgs']]:
        """
        Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_config")

    @secondary_config.setter
    def secondary_config(self, value: Optional[pulumi.Input['ClusterSecondaryConfigArgs']]):
        pulumi.set(self, "secondary_config", value)

    @property
    @pulumi.getter(name="skipAwaitMajorVersionUpgrade")
    def skip_await_major_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to skip awaiting on the major version upgrade of the cluster.
        Possible values: true, false
        Default value: "true"
        """
        return pulumi.get(self, "skip_await_major_version_upgrade")

    @skip_await_major_version_upgrade.setter
    def skip_await_major_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_await_major_version_upgrade", value)

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subscrition type of cluster.
        Possible values are: `TRIAL`, `STANDARD`.
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_type", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 automated_backup_policy: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']] = None,
                 backup_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 continuous_backup_config: Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']] = None,
                 continuous_backup_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoArgs']]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 encryption_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionInfoArgs']]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 initial_user: Optional[pulumi.Input['ClusterInitialUserArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_update_policy: Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']] = None,
                 migration_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['ClusterNetworkConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input['ClusterPscConfigArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 restore_backup_source: Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']] = None,
                 restore_continuous_backup_source: Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']] = None,
                 secondary_config: Optional[pulumi.Input['ClusterSecondaryConfigArgs']] = None,
                 skip_await_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_type: Optional[pulumi.Input[builtins.str]] = None,
                 trial_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTrialMetadataArgs']]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['ClusterAutomatedBackupPolicyArgs'] automated_backup_policy: The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]] backup_sources: Cluster created from backup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[builtins.str] cluster_type: The type of cluster. If not set, defaults to PRIMARY.
               Default value is `PRIMARY`.
               Possible values are: `PRIMARY`, `SECONDARY`.
        :param pulumi.Input['ClusterContinuousBackupConfigArgs'] continuous_backup_config: The continuous backup config for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoArgs']]] continuous_backup_infos: ContinuousBackupInfo describes the continuous backup properties of a cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] database_version: The database engine major version. This is an optional field and it's populated at the Cluster creation time.
               Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the cluster should be deleted forcefully.
               Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
               Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ClusterEncryptionConfigArgs'] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionInfoArgs']]] encryption_infos: (Output)
               Output only. The encryption information for the WALs and backups required for ContinuousBackup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input['ClusterInitialUserArgs'] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the alloydb cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the alloydb cluster should reside.
               
               
               - - -
        :param pulumi.Input['ClusterMaintenanceUpdatePolicyArgs'] maintenance_update_policy: MaintenanceUpdatePolicy defines the policy for system updates.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]] migration_sources: Cluster created via DMS migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the cluster resource.
        :param pulumi.Input['ClusterNetworkConfigArgs'] network_config: Metadata related to network configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ClusterPscConfigArgs'] psc_config: Configuration for Private Service Connect (PSC) for the cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Output only. Reconciling (https://google.aip.dev/128#reconciliation).
               Set to true if the current state of Cluster does not match the user's intended state, and the service is actively updating the resource to reconcile them.
               This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input['ClusterRestoreBackupSourceArgs'] restore_backup_source: The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterRestoreContinuousBackupSourceArgs'] restore_continuous_backup_source: The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterSecondaryConfigArgs'] secondary_config: Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] skip_await_major_version_upgrade: Set to true to skip awaiting on the major version upgrade of the cluster.
               Possible values: true, false
               Default value: "true"
        :param pulumi.Input[builtins.str] state: Output only. The current serving state of the cluster.
        :param pulumi.Input[builtins.str] subscription_type: The subscrition type of cluster.
               Possible values are: `TRIAL`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTrialMetadataArgs']]] trial_metadatas: Contains information and all metadata related to TRIAL clusters.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if backup_sources is not None:
            pulumi.set(__self__, "backup_sources", backup_sources)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if continuous_backup_config is not None:
            pulumi.set(__self__, "continuous_backup_config", continuous_backup_config)
        if continuous_backup_infos is not None:
            pulumi.set(__self__, "continuous_backup_infos", continuous_backup_infos)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if encryption_infos is not None:
            pulumi.set(__self__, "encryption_infos", encryption_infos)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if initial_user is not None:
            pulumi.set(__self__, "initial_user", initial_user)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_update_policy is not None:
            pulumi.set(__self__, "maintenance_update_policy", maintenance_update_policy)
        if migration_sources is not None:
            pulumi.set(__self__, "migration_sources", migration_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if restore_backup_source is not None:
            pulumi.set(__self__, "restore_backup_source", restore_backup_source)
        if restore_continuous_backup_source is not None:
            pulumi.set(__self__, "restore_continuous_backup_source", restore_continuous_backup_source)
        if secondary_config is not None:
            pulumi.set(__self__, "secondary_config", secondary_config)
        if skip_await_major_version_upgrade is not None:
            pulumi.set(__self__, "skip_await_major_version_upgrade", skip_await_major_version_upgrade)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_type is not None:
            pulumi.set(__self__, "subscription_type", subscription_type)
        if trial_metadatas is not None:
            pulumi.set(__self__, "trial_metadatas", trial_metadatas)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]:
        """
        The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @property
    @pulumi.getter(name="backupSources")
    def backup_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]]:
        """
        Cluster created from backup.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_sources")

    @backup_sources.setter
    def backup_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]]):
        pulumi.set(self, "backup_sources", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of cluster. If not set, defaults to PRIMARY.
        Default value is `PRIMARY`.
        Possible values are: `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="continuousBackupConfig")
    def continuous_backup_config(self) -> Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']]:
        """
        The continuous backup config for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "continuous_backup_config")

    @continuous_backup_config.setter
    def continuous_backup_config(self, value: Optional[pulumi.Input['ClusterContinuousBackupConfigArgs']]):
        pulumi.set(self, "continuous_backup_config", value)

    @property
    @pulumi.getter(name="continuousBackupInfos")
    def continuous_backup_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoArgs']]]]:
        """
        ContinuousBackupInfo describes the continuous backup properties of a cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "continuous_backup_infos")

    @continuous_backup_infos.setter
    def continuous_backup_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoArgs']]]]):
        pulumi.set(self, "continuous_backup_infos", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database engine major version. This is an optional field and it's populated at the Cluster creation time.
        Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine if the cluster should be deleted forcefully.
        Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
        Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionInfoArgs']]]]:
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_infos")

    @encryption_infos.setter
    def encryption_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEncryptionInfoArgs']]]]):
        pulumi.set(self, "encryption_infos", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> Optional[pulumi.Input['ClusterInitialUserArgs']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: Optional[pulumi.Input['ClusterInitialUserArgs']]):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the alloydb cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the alloydb cluster should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceUpdatePolicy")
    def maintenance_update_policy(self) -> Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']]:
        """
        MaintenanceUpdatePolicy defines the policy for system updates.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_update_policy")

    @maintenance_update_policy.setter
    def maintenance_update_policy(self, value: Optional[pulumi.Input['ClusterMaintenanceUpdatePolicyArgs']]):
        pulumi.set(self, "maintenance_update_policy", value)

    @property
    @pulumi.getter(name="migrationSources")
    def migration_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]]:
        """
        Cluster created via DMS migration.
        Structure is documented below.
        """
        return pulumi.get(self, "migration_sources")

    @migration_sources.setter
    def migration_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]]):
        pulumi.set(self, "migration_sources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['ClusterNetworkConfigArgs']]:
        """
        Metadata related to network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['ClusterNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['ClusterPscConfigArgs']]:
        """
        Configuration for Private Service Connect (PSC) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['ClusterPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. Reconciling (https://google.aip.dev/128#reconciliation).
        Set to true if the current state of Cluster does not match the user's intended state, and the service is actively updating the resource to reconcile them.
        This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="restoreBackupSource")
    def restore_backup_source(self) -> Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']]:
        """
        The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_backup_source")

    @restore_backup_source.setter
    def restore_backup_source(self, value: Optional[pulumi.Input['ClusterRestoreBackupSourceArgs']]):
        pulumi.set(self, "restore_backup_source", value)

    @property
    @pulumi.getter(name="restoreContinuousBackupSource")
    def restore_continuous_backup_source(self) -> Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']]:
        """
        The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_continuous_backup_source")

    @restore_continuous_backup_source.setter
    def restore_continuous_backup_source(self, value: Optional[pulumi.Input['ClusterRestoreContinuousBackupSourceArgs']]):
        pulumi.set(self, "restore_continuous_backup_source", value)

    @property
    @pulumi.getter(name="secondaryConfig")
    def secondary_config(self) -> Optional[pulumi.Input['ClusterSecondaryConfigArgs']]:
        """
        Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_config")

    @secondary_config.setter
    def secondary_config(self, value: Optional[pulumi.Input['ClusterSecondaryConfigArgs']]):
        pulumi.set(self, "secondary_config", value)

    @property
    @pulumi.getter(name="skipAwaitMajorVersionUpgrade")
    def skip_await_major_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to skip awaiting on the major version upgrade of the cluster.
        Possible values: true, false
        Default value: "true"
        """
        return pulumi.get(self, "skip_await_major_version_upgrade")

    @skip_await_major_version_upgrade.setter
    def skip_await_major_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_await_major_version_upgrade", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The current serving state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subscrition type of cluster.
        Possible values are: `TRIAL`, `STANDARD`.
        """
        return pulumi.get(self, "subscription_type")

    @subscription_type.setter
    def subscription_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_type", value)

    @property
    @pulumi.getter(name="trialMetadatas")
    def trial_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTrialMetadataArgs']]]]:
        """
        Contains information and all metadata related to TRIAL clusters.
        Structure is documented below.
        """
        return pulumi.get(self, "trial_metadatas")

    @trial_metadatas.setter
    def trial_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTrialMetadataArgs']]]]):
        pulumi.set(self, "trial_metadatas", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("gcp:alloydb/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 automated_backup_policy: Optional[pulumi.Input[Union['ClusterAutomatedBackupPolicyArgs', 'ClusterAutomatedBackupPolicyArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 continuous_backup_config: Optional[pulumi.Input[Union['ClusterContinuousBackupConfigArgs', 'ClusterContinuousBackupConfigArgsDict']]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 initial_user: Optional[pulumi.Input[Union['ClusterInitialUserArgs', 'ClusterInitialUserArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_update_policy: Optional[pulumi.Input[Union['ClusterMaintenanceUpdatePolicyArgs', 'ClusterMaintenanceUpdatePolicyArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['ClusterNetworkConfigArgs', 'ClusterNetworkConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]] = None,
                 restore_backup_source: Optional[pulumi.Input[Union['ClusterRestoreBackupSourceArgs', 'ClusterRestoreBackupSourceArgsDict']]] = None,
                 restore_continuous_backup_source: Optional[pulumi.Input[Union['ClusterRestoreContinuousBackupSourceArgs', 'ClusterRestoreContinuousBackupSourceArgsDict']]] = None,
                 secondary_config: Optional[pulumi.Input[Union['ClusterSecondaryConfigArgs', 'ClusterSecondaryConfigArgsDict']]] = None,
                 skip_await_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Alloydb Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="alloydb-cluster")
        default = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default_network.id,
            })
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Cluster Before Upgrade

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_14",
            initial_user={
                "password": "alloydb-cluster",
            })
        default_instance = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            })
        ```
        ### Alloydb Cluster After Upgrade

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "password": "alloydb-cluster",
            })
        default_instance = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            })
        ```
        ### Alloydb Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-cluster-full")
        full = gcp.alloydb.Cluster("full",
            cluster_id="alloydb-cluster-full",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "alloydb-cluster-full",
                "password": "alloydb-cluster-full",
            },
            continuous_backup_config={
                "enabled": True,
                "recovery_window_days": 14,
            },
            automated_backup_policy={
                "location": "us-central1",
                "backup_window": "1800s",
                "enabled": True,
                "weekly_schedule": {
                    "days_of_weeks": ["MONDAY"],
                    "start_times": [{
                        "hours": 23,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    }],
                },
                "quantity_based_retention": {
                    "count": 1,
                },
                "labels": {
                    "test": "alloydb-cluster-full",
                },
            },
            labels={
                "test": "alloydb-cluster-full",
            })
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Secondary Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-secondary-cluster")
        primary = gcp.alloydb.Cluster("primary",
            cluster_id="alloydb-primary-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-secondary-cluster",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        primary_instance = gcp.alloydb.Instance("primary",
            cluster=primary.name,
            instance_id="alloydb-primary-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        secondary = gcp.alloydb.Cluster("secondary",
            cluster_id="alloydb-secondary-cluster",
            location="us-east1",
            network_config={
                "network": default.id,
            },
            cluster_type="SECONDARY",
            continuous_backup_config={
                "enabled": False,
            },
            secondary_config={
                "primary_cluster_name": primary.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[primary_instance]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}`

        * `{{project}}/{{location}}/{{cluster_id}}`

        * `{{location}}/{{cluster_id}}`

        * `{{cluster_id}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['ClusterAutomatedBackupPolicyArgs', 'ClusterAutomatedBackupPolicyArgsDict']] automated_backup_policy: The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[builtins.str] cluster_type: The type of cluster. If not set, defaults to PRIMARY.
               Default value is `PRIMARY`.
               Possible values are: `PRIMARY`, `SECONDARY`.
        :param pulumi.Input[Union['ClusterContinuousBackupConfigArgs', 'ClusterContinuousBackupConfigArgsDict']] continuous_backup_config: The continuous backup config for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[builtins.str] database_version: The database engine major version. This is an optional field and it's populated at the Cluster creation time.
               Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the cluster should be deleted forcefully.
               Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
               Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[Union['ClusterInitialUserArgs', 'ClusterInitialUserArgsDict']] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the alloydb cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the alloydb cluster should reside.
               
               
               - - -
        :param pulumi.Input[Union['ClusterMaintenanceUpdatePolicyArgs', 'ClusterMaintenanceUpdatePolicyArgsDict']] maintenance_update_policy: MaintenanceUpdatePolicy defines the policy for system updates.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterNetworkConfigArgs', 'ClusterNetworkConfigArgsDict']] network_config: Metadata related to network configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']] psc_config: Configuration for Private Service Connect (PSC) for the cluster.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterRestoreBackupSourceArgs', 'ClusterRestoreBackupSourceArgsDict']] restore_backup_source: The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterRestoreContinuousBackupSourceArgs', 'ClusterRestoreContinuousBackupSourceArgsDict']] restore_continuous_backup_source: The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterSecondaryConfigArgs', 'ClusterSecondaryConfigArgsDict']] secondary_config: Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] skip_await_major_version_upgrade: Set to true to skip awaiting on the major version upgrade of the cluster.
               Possible values: true, false
               Default value: "true"
        :param pulumi.Input[builtins.str] subscription_type: The subscrition type of cluster.
               Possible values are: `TRIAL`, `STANDARD`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Alloydb Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="alloydb-cluster")
        default = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default_network.id,
            })
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Cluster Before Upgrade

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_14",
            initial_user={
                "password": "alloydb-cluster",
            })
        default_instance = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            })
        ```
        ### Alloydb Cluster After Upgrade

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "password": "alloydb-cluster",
            })
        default_instance = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            })
        ```
        ### Alloydb Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-cluster-full")
        full = gcp.alloydb.Cluster("full",
            cluster_id="alloydb-cluster-full",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "alloydb-cluster-full",
                "password": "alloydb-cluster-full",
            },
            continuous_backup_config={
                "enabled": True,
                "recovery_window_days": 14,
            },
            automated_backup_policy={
                "location": "us-central1",
                "backup_window": "1800s",
                "enabled": True,
                "weekly_schedule": {
                    "days_of_weeks": ["MONDAY"],
                    "start_times": [{
                        "hours": 23,
                        "minutes": 0,
                        "seconds": 0,
                        "nanos": 0,
                    }],
                },
                "quantity_based_retention": {
                    "count": 1,
                },
                "labels": {
                    "test": "alloydb-cluster-full",
                },
            },
            labels={
                "test": "alloydb-cluster-full",
            })
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Secondary Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-secondary-cluster")
        primary = gcp.alloydb.Cluster("primary",
            cluster_id="alloydb-primary-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-secondary-cluster",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        primary_instance = gcp.alloydb.Instance("primary",
            cluster=primary.name,
            instance_id="alloydb-primary-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        secondary = gcp.alloydb.Cluster("secondary",
            cluster_id="alloydb-secondary-cluster",
            location="us-east1",
            network_config={
                "network": default.id,
            },
            cluster_type="SECONDARY",
            continuous_backup_config={
                "enabled": False,
            },
            secondary_config={
                "primary_cluster_name": primary.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[primary_instance]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}`

        * `{{project}}/{{location}}/{{cluster_id}}`

        * `{{location}}/{{cluster_id}}`

        * `{{cluster_id}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/cluster:Cluster default {{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 automated_backup_policy: Optional[pulumi.Input[Union['ClusterAutomatedBackupPolicyArgs', 'ClusterAutomatedBackupPolicyArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 continuous_backup_config: Optional[pulumi.Input[Union['ClusterContinuousBackupConfigArgs', 'ClusterContinuousBackupConfigArgsDict']]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 initial_user: Optional[pulumi.Input[Union['ClusterInitialUserArgs', 'ClusterInitialUserArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_update_policy: Optional[pulumi.Input[Union['ClusterMaintenanceUpdatePolicyArgs', 'ClusterMaintenanceUpdatePolicyArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['ClusterNetworkConfigArgs', 'ClusterNetworkConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]] = None,
                 restore_backup_source: Optional[pulumi.Input[Union['ClusterRestoreBackupSourceArgs', 'ClusterRestoreBackupSourceArgsDict']]] = None,
                 restore_continuous_backup_source: Optional[pulumi.Input[Union['ClusterRestoreContinuousBackupSourceArgs', 'ClusterRestoreContinuousBackupSourceArgsDict']]] = None,
                 secondary_config: Optional[pulumi.Input[Union['ClusterSecondaryConfigArgs', 'ClusterSecondaryConfigArgsDict']]] = None,
                 skip_await_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 subscription_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["automated_backup_policy"] = automated_backup_policy
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["continuous_backup_config"] = continuous_backup_config
            __props__.__dict__["database_version"] = database_version
            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["etag"] = etag
            __props__.__dict__["initial_user"] = initial_user
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_update_policy"] = maintenance_update_policy
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["project"] = project
            __props__.__dict__["psc_config"] = psc_config
            __props__.__dict__["restore_backup_source"] = restore_backup_source
            __props__.__dict__["restore_continuous_backup_source"] = restore_continuous_backup_source
            __props__.__dict__["secondary_config"] = secondary_config
            __props__.__dict__["skip_await_major_version_upgrade"] = skip_await_major_version_upgrade
            __props__.__dict__["subscription_type"] = subscription_type
            __props__.__dict__["backup_sources"] = None
            __props__.__dict__["continuous_backup_infos"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["encryption_infos"] = None
            __props__.__dict__["migration_sources"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["trial_metadatas"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'gcp:alloydb/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            automated_backup_policy: Optional[pulumi.Input[Union['ClusterAutomatedBackupPolicyArgs', 'ClusterAutomatedBackupPolicyArgsDict']]] = None,
            backup_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBackupSourceArgs', 'ClusterBackupSourceArgsDict']]]]] = None,
            cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[builtins.str]] = None,
            continuous_backup_config: Optional[pulumi.Input[Union['ClusterContinuousBackupConfigArgs', 'ClusterContinuousBackupConfigArgsDict']]] = None,
            continuous_backup_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterContinuousBackupInfoArgs', 'ClusterContinuousBackupInfoArgsDict']]]]] = None,
            database_version: Optional[pulumi.Input[builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
            encryption_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterEncryptionInfoArgs', 'ClusterEncryptionInfoArgsDict']]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            initial_user: Optional[pulumi.Input[Union['ClusterInitialUserArgs', 'ClusterInitialUserArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_update_policy: Optional[pulumi.Input[Union['ClusterMaintenanceUpdatePolicyArgs', 'ClusterMaintenanceUpdatePolicyArgsDict']]] = None,
            migration_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMigrationSourceArgs', 'ClusterMigrationSourceArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['ClusterNetworkConfigArgs', 'ClusterNetworkConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            psc_config: Optional[pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            restore_backup_source: Optional[pulumi.Input[Union['ClusterRestoreBackupSourceArgs', 'ClusterRestoreBackupSourceArgsDict']]] = None,
            restore_continuous_backup_source: Optional[pulumi.Input[Union['ClusterRestoreContinuousBackupSourceArgs', 'ClusterRestoreContinuousBackupSourceArgsDict']]] = None,
            secondary_config: Optional[pulumi.Input[Union['ClusterSecondaryConfigArgs', 'ClusterSecondaryConfigArgsDict']]] = None,
            skip_await_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subscription_type: Optional[pulumi.Input[builtins.str]] = None,
            trial_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterTrialMetadataArgs', 'ClusterTrialMetadataArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['ClusterAutomatedBackupPolicyArgs', 'ClusterAutomatedBackupPolicyArgsDict']] automated_backup_policy: The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBackupSourceArgs', 'ClusterBackupSourceArgsDict']]]] backup_sources: Cluster created from backup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[builtins.str] cluster_type: The type of cluster. If not set, defaults to PRIMARY.
               Default value is `PRIMARY`.
               Possible values are: `PRIMARY`, `SECONDARY`.
        :param pulumi.Input[Union['ClusterContinuousBackupConfigArgs', 'ClusterContinuousBackupConfigArgsDict']] continuous_backup_config: The continuous backup config for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterContinuousBackupInfoArgs', 'ClusterContinuousBackupInfoArgsDict']]]] continuous_backup_infos: ContinuousBackupInfo describes the continuous backup properties of a cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] database_version: The database engine major version. This is an optional field and it's populated at the Cluster creation time.
               Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the cluster should be deleted forcefully.
               Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
               Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterEncryptionInfoArgs', 'ClusterEncryptionInfoArgsDict']]]] encryption_infos: (Output)
               Output only. The encryption information for the WALs and backups required for ContinuousBackup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] etag: For Resource freshness validation (https://google.aip.dev/154)
        :param pulumi.Input[Union['ClusterInitialUserArgs', 'ClusterInitialUserArgsDict']] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the alloydb cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the alloydb cluster should reside.
               
               
               - - -
        :param pulumi.Input[Union['ClusterMaintenanceUpdatePolicyArgs', 'ClusterMaintenanceUpdatePolicyArgsDict']] maintenance_update_policy: MaintenanceUpdatePolicy defines the policy for system updates.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMigrationSourceArgs', 'ClusterMigrationSourceArgsDict']]]] migration_sources: Cluster created via DMS migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the cluster resource.
        :param pulumi.Input[Union['ClusterNetworkConfigArgs', 'ClusterNetworkConfigArgsDict']] network_config: Metadata related to network configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ClusterPscConfigArgs', 'ClusterPscConfigArgsDict']] psc_config: Configuration for Private Service Connect (PSC) for the cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Output only. Reconciling (https://google.aip.dev/128#reconciliation).
               Set to true if the current state of Cluster does not match the user's intended state, and the service is actively updating the resource to reconcile them.
               This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input[Union['ClusterRestoreBackupSourceArgs', 'ClusterRestoreBackupSourceArgsDict']] restore_backup_source: The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterRestoreContinuousBackupSourceArgs', 'ClusterRestoreContinuousBackupSourceArgsDict']] restore_continuous_backup_source: The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
               Structure is documented below.
        :param pulumi.Input[Union['ClusterSecondaryConfigArgs', 'ClusterSecondaryConfigArgsDict']] secondary_config: Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] skip_await_major_version_upgrade: Set to true to skip awaiting on the major version upgrade of the cluster.
               Possible values: true, false
               Default value: "true"
        :param pulumi.Input[builtins.str] state: Output only. The current serving state of the cluster.
        :param pulumi.Input[builtins.str] subscription_type: The subscrition type of cluster.
               Possible values are: `TRIAL`, `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterTrialMetadataArgs', 'ClusterTrialMetadataArgsDict']]]] trial_metadatas: Contains information and all metadata related to TRIAL clusters.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: The system-generated UID of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["automated_backup_policy"] = automated_backup_policy
        __props__.__dict__["backup_sources"] = backup_sources
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["continuous_backup_config"] = continuous_backup_config
        __props__.__dict__["continuous_backup_infos"] = continuous_backup_infos
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["encryption_infos"] = encryption_infos
        __props__.__dict__["etag"] = etag
        __props__.__dict__["initial_user"] = initial_user
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_update_policy"] = maintenance_update_policy
        __props__.__dict__["migration_sources"] = migration_sources
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_config"] = psc_config
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["restore_backup_source"] = restore_backup_source
        __props__.__dict__["restore_continuous_backup_source"] = restore_continuous_backup_source
        __props__.__dict__["secondary_config"] = secondary_config
        __props__.__dict__["skip_await_major_version_upgrade"] = skip_await_major_version_upgrade
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_type"] = subscription_type
        __props__.__dict__["trial_metadatas"] = trial_metadatas
        __props__.__dict__["uid"] = uid
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels. https://google.aip.dev/128
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> pulumi.Output['outputs.ClusterAutomatedBackupPolicy']:
        """
        The automated backup policy for this cluster. AutomatedBackupPolicy is disabled by default.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @property
    @pulumi.getter(name="backupSources")
    def backup_sources(self) -> pulumi.Output[Sequence['outputs.ClusterBackupSource']]:
        """
        Cluster created from backup.
        Structure is documented below.
        """
        return pulumi.get(self, "backup_sources")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of cluster. If not set, defaults to PRIMARY.
        Default value is `PRIMARY`.
        Possible values are: `PRIMARY`, `SECONDARY`.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="continuousBackupConfig")
    def continuous_backup_config(self) -> pulumi.Output['outputs.ClusterContinuousBackupConfig']:
        """
        The continuous backup config for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "continuous_backup_config")

    @property
    @pulumi.getter(name="continuousBackupInfos")
    def continuous_backup_infos(self) -> pulumi.Output[Sequence['outputs.ClusterContinuousBackupInfo']]:
        """
        ContinuousBackupInfo describes the continuous backup properties of a cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "continuous_backup_infos")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[builtins.str]:
        """
        The database engine major version. This is an optional field and it's populated at the Cluster creation time.
        Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Policy to determine if the cluster should be deleted forcefully.
        Deleting a cluster forcefully, deletes the cluster and all its associated instances within the cluster.
        Deleting a Secondary cluster with a secondary instance REQUIRES setting deletion_policy = "FORCE" otherwise an error is returned. This is needed as there is no support to delete just the secondary instance, and the only way to delete secondary instance is to delete the associated secondary cluster forcefully which also deletes the secondary instance.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output[Optional['outputs.ClusterEncryptionConfig']]:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> pulumi.Output[Sequence['outputs.ClusterEncryptionInfo']]:
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_infos")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For Resource freshness validation (https://google.aip.dev/154)
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> pulumi.Output[Optional['outputs.ClusterInitialUser']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels for the alloydb cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location where the alloydb cluster should reside.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceUpdatePolicy")
    def maintenance_update_policy(self) -> pulumi.Output[Optional['outputs.ClusterMaintenanceUpdatePolicy']]:
        """
        MaintenanceUpdatePolicy defines the policy for system updates.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_update_policy")

    @property
    @pulumi.getter(name="migrationSources")
    def migration_sources(self) -> pulumi.Output[Sequence['outputs.ClusterMigrationSource']]:
        """
        Cluster created via DMS migration.
        Structure is documented below.
        """
        return pulumi.get(self, "migration_sources")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.ClusterNetworkConfig']:
        """
        Metadata related to network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> pulumi.Output[Optional['outputs.ClusterPscConfig']]:
        """
        Configuration for Private Service Connect (PSC) for the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. Reconciling (https://google.aip.dev/128#reconciliation).
        Set to true if the current state of Cluster does not match the user's intended state, and the service is actively updating the resource to reconcile them.
        This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="restoreBackupSource")
    def restore_backup_source(self) -> pulumi.Output[Optional['outputs.ClusterRestoreBackupSource']]:
        """
        The source when restoring from a backup. Conflicts with 'restore_continuous_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_backup_source")

    @property
    @pulumi.getter(name="restoreContinuousBackupSource")
    def restore_continuous_backup_source(self) -> pulumi.Output[Optional['outputs.ClusterRestoreContinuousBackupSource']]:
        """
        The source when restoring via point in time recovery (PITR). Conflicts with 'restore_backup_source', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "restore_continuous_backup_source")

    @property
    @pulumi.getter(name="secondaryConfig")
    def secondary_config(self) -> pulumi.Output[Optional['outputs.ClusterSecondaryConfig']]:
        """
        Configuration of the secondary cluster for Cross Region Replication. This should be set if and only if the cluster is of type SECONDARY.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_config")

    @property
    @pulumi.getter(name="skipAwaitMajorVersionUpgrade")
    def skip_await_major_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to true to skip awaiting on the major version upgrade of the cluster.
        Possible values: true, false
        Default value: "true"
        """
        return pulumi.get(self, "skip_await_major_version_upgrade")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The current serving state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[builtins.str]:
        """
        The subscrition type of cluster.
        Possible values are: `TRIAL`, `STANDARD`.
        """
        return pulumi.get(self, "subscription_type")

    @property
    @pulumi.getter(name="trialMetadatas")
    def trial_metadatas(self) -> pulumi.Output[Sequence['outputs.ClusterTrialMetadata']]:
        """
        Contains information and all metadata related to TRIAL clusters.
        Structure is documented below.
        """
        return pulumi.get(self, "trial_metadatas")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

