# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddonsConfigArgs', 'AddonsConfig']

@pulumi.input_type
class AddonsConfigArgs:
    def __init__(__self__, *,
                 org: pulumi.Input[builtins.str],
                 addons_config: Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']] = None):
        """
        The set of arguments for constructing a AddonsConfig resource.
        :param pulumi.Input[builtins.str] org: Name of the Apigee organization.
               
               
               - - -
        :param pulumi.Input['AddonsConfigAddonsConfigArgs'] addons_config: Addon configurations of the Apigee organization.
               Structure is documented below.
        """
        pulumi.set(__self__, "org", org)
        if addons_config is not None:
            pulumi.set(__self__, "addons_config", addons_config)

    @property
    @pulumi.getter
    def org(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Apigee organization.


        - - -
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org", value)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']]:
        """
        Addon configurations of the Apigee organization.
        Structure is documented below.
        """
        return pulumi.get(self, "addons_config")

    @addons_config.setter
    def addons_config(self, value: Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']]):
        pulumi.set(self, "addons_config", value)


@pulumi.input_type
class _AddonsConfigState:
    def __init__(__self__, *,
                 addons_config: Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddonsConfig resources.
        :param pulumi.Input['AddonsConfigAddonsConfigArgs'] addons_config: Addon configurations of the Apigee organization.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org: Name of the Apigee organization.
               
               
               - - -
        """
        if addons_config is not None:
            pulumi.set(__self__, "addons_config", addons_config)
        if org is not None:
            pulumi.set(__self__, "org", org)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']]:
        """
        Addon configurations of the Apigee organization.
        Structure is documented below.
        """
        return pulumi.get(self, "addons_config")

    @addons_config.setter
    def addons_config(self, value: Optional[pulumi.Input['AddonsConfigAddonsConfigArgs']]):
        pulumi.set(self, "addons_config", value)

    @property
    @pulumi.getter
    def org(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Apigee organization.


        - - -
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org", value)


@pulumi.type_token("gcp:apigee/addonsConfig:AddonsConfig")
class AddonsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons_config: Optional[pulumi.Input[Union['AddonsConfigAddonsConfigArgs', 'AddonsConfigAddonsConfigArgsDict']]] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Configures the add-ons for the Apigee organization. The existing add-on configuration will be fully replaced.

        To get more information about AddonsConfig, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations#setaddons)
        * How-to Guides
            * [Creating an API organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org)

        ## Example Usage

        ### Apigee Addons Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_organization = gcp.apigee.AddonsConfig("test_organization",
            org="test_organization",
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
                "monetization_config": {
                    "enabled": True,
                },
            })
        ```
        ### Apigee Addons Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee = gcp.projects.Service("apigee",
            project=current.project,
            service="apigee.googleapis.com")
        compute = gcp.projects.Service("compute",
            project=current.project,
            service="compute.googleapis.com")
        servicenetworking = gcp.projects.Service("servicenetworking",
            project=current.project,
            service="servicenetworking.googleapis.com")
        apigee_network = gcp.compute.Network("apigee_network",
            name="apigee-network",
            project=current.project,
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id,
            project=current.project)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            billing_type="EVALUATION",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee,
                ]))
        test_organization = gcp.apigee.AddonsConfig("test_organization",
            org=org.name,
            addons_config={
                "integration_config": {
                    "enabled": True,
                },
                "api_security_config": {
                    "enabled": True,
                },
                "connectors_platform_config": {
                    "enabled": True,
                },
                "monetization_config": {
                    "enabled": True,
                },
                "advanced_api_ops_config": {
                    "enabled": True,
                },
            })
        ```

        ## Import

        AddonsConfig can be imported using any of these accepted formats:

        * `organizations/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AddonsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/addonsConfig:AddonsConfig default organizations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/addonsConfig:AddonsConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AddonsConfigAddonsConfigArgs', 'AddonsConfigAddonsConfigArgsDict']] addons_config: Addon configurations of the Apigee organization.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org: Name of the Apigee organization.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures the add-ons for the Apigee organization. The existing add-on configuration will be fully replaced.

        To get more information about AddonsConfig, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations#setaddons)
        * How-to Guides
            * [Creating an API organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org)

        ## Example Usage

        ### Apigee Addons Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_organization = gcp.apigee.AddonsConfig("test_organization",
            org="test_organization",
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
                "monetization_config": {
                    "enabled": True,
                },
            })
        ```
        ### Apigee Addons Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee = gcp.projects.Service("apigee",
            project=current.project,
            service="apigee.googleapis.com")
        compute = gcp.projects.Service("compute",
            project=current.project,
            service="compute.googleapis.com")
        servicenetworking = gcp.projects.Service("servicenetworking",
            project=current.project,
            service="servicenetworking.googleapis.com")
        apigee_network = gcp.compute.Network("apigee_network",
            name="apigee-network",
            project=current.project,
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id,
            project=current.project)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        org = gcp.apigee.Organization("org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            billing_type="EVALUATION",
            opts = pulumi.ResourceOptions(depends_on=[
                    apigee_vpc_connection,
                    apigee,
                ]))
        test_organization = gcp.apigee.AddonsConfig("test_organization",
            org=org.name,
            addons_config={
                "integration_config": {
                    "enabled": True,
                },
                "api_security_config": {
                    "enabled": True,
                },
                "connectors_platform_config": {
                    "enabled": True,
                },
                "monetization_config": {
                    "enabled": True,
                },
                "advanced_api_ops_config": {
                    "enabled": True,
                },
            })
        ```

        ## Import

        AddonsConfig can be imported using any of these accepted formats:

        * `organizations/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AddonsConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/addonsConfig:AddonsConfig default organizations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/addonsConfig:AddonsConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AddonsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons_config: Optional[pulumi.Input[Union['AddonsConfigAddonsConfigArgs', 'AddonsConfigAddonsConfigArgsDict']]] = None,
                 org: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonsConfigArgs.__new__(AddonsConfigArgs)

            __props__.__dict__["addons_config"] = addons_config
            if org is None and not opts.urn:
                raise TypeError("Missing required property 'org'")
            __props__.__dict__["org"] = org
        super(AddonsConfig, __self__).__init__(
            'gcp:apigee/addonsConfig:AddonsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons_config: Optional[pulumi.Input[Union['AddonsConfigAddonsConfigArgs', 'AddonsConfigAddonsConfigArgsDict']]] = None,
            org: Optional[pulumi.Input[builtins.str]] = None) -> 'AddonsConfig':
        """
        Get an existing AddonsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AddonsConfigAddonsConfigArgs', 'AddonsConfigAddonsConfigArgsDict']] addons_config: Addon configurations of the Apigee organization.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org: Name of the Apigee organization.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonsConfigState.__new__(_AddonsConfigState)

        __props__.__dict__["addons_config"] = addons_config
        __props__.__dict__["org"] = org
        return AddonsConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> pulumi.Output[Optional['outputs.AddonsConfigAddonsConfig']]:
        """
        Addon configurations of the Apigee organization.
        Structure is documented below.
        """
        return pulumi.get(self, "addons_config")

    @property
    @pulumi.getter
    def org(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Apigee organization.


        - - -
        """
        return pulumi.get(self, "org")

