# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 org_id: pulumi.Input[builtins.str],
                 api_proxy_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_ip_resolution_config: Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 forward_proxy_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input['EnvironmentNodeConfigArgs']] = None,
                 properties: Optional[pulumi.Input['EnvironmentPropertiesArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee environment,
               in the format `organizations/{{org_name}}`.
               
               
               - - -
        :param pulumi.Input[builtins.str] api_proxy_type: Optional. API Proxy type supported by the environment. The type can be set when creating
               the Environment and cannot be changed.
               Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        :param pulumi.Input['EnvironmentClientIpResolutionConfigArgs'] client_ip_resolution_config: The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
               Structure is documented below.
        :param pulumi.Input[builtins.str] deployment_type: Optional. Deployment type supported by the environment. The deployment type can be
               set when creating the environment and cannot be changed. When you enable archive
               deployment, you will be prevented from performing a subset of actions within the
               environment, including:
               Managing the deployment of API proxy or shared flow revisions;
               Creating, updating, or deleting resource files;
               Creating, updating, or deleting target servers.
               Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        :param pulumi.Input[builtins.str] description: Description of the environment.
        :param pulumi.Input[builtins.str] display_name: Display name of the environment.
        :param pulumi.Input[builtins.str] forward_proxy_uri: Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        :param pulumi.Input[builtins.str] name: The resource ID of the environment.
        :param pulumi.Input['EnvironmentNodeConfigArgs'] node_config: NodeConfig for setting the min/max number of nodes associated with the environment.
               Structure is documented below.
        :param pulumi.Input['EnvironmentPropertiesArgs'] properties: Key-value pairs that may be used for customizing the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: Types that can be selected for an Environment. Each of the types are
               limited by capability and capacity. Refer to Apigee's public documentation
               to understand about each of these types in details.
               An Apigee org can support heterogeneous Environments.
               Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        pulumi.set(__self__, "org_id", org_id)
        if api_proxy_type is not None:
            pulumi.set(__self__, "api_proxy_type", api_proxy_type)
        if client_ip_resolution_config is not None:
            pulumi.set(__self__, "client_ip_resolution_config", client_ip_resolution_config)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if forward_proxy_uri is not None:
            pulumi.set(__self__, "forward_proxy_uri", forward_proxy_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[builtins.str]:
        """
        The Apigee Organization associated with the Apigee environment,
        in the format `organizations/{{org_name}}`.


        - - -
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="apiProxyType")
    def api_proxy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. API Proxy type supported by the environment. The type can be set when creating
        the Environment and cannot be changed.
        Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        """
        return pulumi.get(self, "api_proxy_type")

    @api_proxy_type.setter
    def api_proxy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_proxy_type", value)

    @property
    @pulumi.getter(name="clientIpResolutionConfig")
    def client_ip_resolution_config(self) -> Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']]:
        """
        The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
        Structure is documented below.
        """
        return pulumi.get(self, "client_ip_resolution_config")

    @client_ip_resolution_config.setter
    def client_ip_resolution_config(self, value: Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']]):
        pulumi.set(self, "client_ip_resolution_config", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Deployment type supported by the environment. The deployment type can be
        set when creating the environment and cannot be changed. When you enable archive
        deployment, you will be prevented from performing a subset of actions within the
        environment, including:
        Managing the deployment of API proxy or shared flow revisions;
        Creating, updating, or deleting resource files;
        Creating, updating, or deleting target servers.
        Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the environment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="forwardProxyUri")
    def forward_proxy_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        """
        return pulumi.get(self, "forward_proxy_uri")

    @forward_proxy_uri.setter
    def forward_proxy_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forward_proxy_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['EnvironmentNodeConfigArgs']]:
        """
        NodeConfig for setting the min/max number of nodes associated with the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['EnvironmentNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['EnvironmentPropertiesArgs']]:
        """
        Key-value pairs that may be used for customizing the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['EnvironmentPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Types that can be selected for an Environment. Each of the types are
        limited by capability and capacity. Refer to Apigee's public documentation
        to understand about each of these types in details.
        An Apigee org can support heterogeneous Environments.
        Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 api_proxy_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_ip_resolution_config: Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 forward_proxy_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input['EnvironmentNodeConfigArgs']] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['EnvironmentPropertiesArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[builtins.str] api_proxy_type: Optional. API Proxy type supported by the environment. The type can be set when creating
               the Environment and cannot be changed.
               Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        :param pulumi.Input['EnvironmentClientIpResolutionConfigArgs'] client_ip_resolution_config: The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
               Structure is documented below.
        :param pulumi.Input[builtins.str] deployment_type: Optional. Deployment type supported by the environment. The deployment type can be
               set when creating the environment and cannot be changed. When you enable archive
               deployment, you will be prevented from performing a subset of actions within the
               environment, including:
               Managing the deployment of API proxy or shared flow revisions;
               Creating, updating, or deleting resource files;
               Creating, updating, or deleting target servers.
               Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        :param pulumi.Input[builtins.str] description: Description of the environment.
        :param pulumi.Input[builtins.str] display_name: Display name of the environment.
        :param pulumi.Input[builtins.str] forward_proxy_uri: Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        :param pulumi.Input[builtins.str] name: The resource ID of the environment.
        :param pulumi.Input['EnvironmentNodeConfigArgs'] node_config: NodeConfig for setting the min/max number of nodes associated with the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee environment,
               in the format `organizations/{{org_name}}`.
               
               
               - - -
        :param pulumi.Input['EnvironmentPropertiesArgs'] properties: Key-value pairs that may be used for customizing the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: Types that can be selected for an Environment. Each of the types are
               limited by capability and capacity. Refer to Apigee's public documentation
               to understand about each of these types in details.
               An Apigee org can support heterogeneous Environments.
               Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        if api_proxy_type is not None:
            pulumi.set(__self__, "api_proxy_type", api_proxy_type)
        if client_ip_resolution_config is not None:
            pulumi.set(__self__, "client_ip_resolution_config", client_ip_resolution_config)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if forward_proxy_uri is not None:
            pulumi.set(__self__, "forward_proxy_uri", forward_proxy_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiProxyType")
    def api_proxy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. API Proxy type supported by the environment. The type can be set when creating
        the Environment and cannot be changed.
        Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        """
        return pulumi.get(self, "api_proxy_type")

    @api_proxy_type.setter
    def api_proxy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_proxy_type", value)

    @property
    @pulumi.getter(name="clientIpResolutionConfig")
    def client_ip_resolution_config(self) -> Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']]:
        """
        The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
        Structure is documented below.
        """
        return pulumi.get(self, "client_ip_resolution_config")

    @client_ip_resolution_config.setter
    def client_ip_resolution_config(self, value: Optional[pulumi.Input['EnvironmentClientIpResolutionConfigArgs']]):
        pulumi.set(self, "client_ip_resolution_config", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Deployment type supported by the environment. The deployment type can be
        set when creating the environment and cannot be changed. When you enable archive
        deployment, you will be prevented from performing a subset of actions within the
        environment, including:
        Managing the deployment of API proxy or shared flow revisions;
        Creating, updating, or deleting resource files;
        Creating, updating, or deleting target servers.
        Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the environment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="forwardProxyUri")
    def forward_proxy_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        """
        return pulumi.get(self, "forward_proxy_uri")

    @forward_proxy_uri.setter
    def forward_proxy_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forward_proxy_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['EnvironmentNodeConfigArgs']]:
        """
        NodeConfig for setting the min/max number of nodes associated with the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['EnvironmentNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Apigee Organization associated with the Apigee environment,
        in the format `organizations/{{org_name}}`.


        - - -
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['EnvironmentPropertiesArgs']]:
        """
        Key-value pairs that may be used for customizing the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['EnvironmentPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Types that can be selected for an Environment. Each of the types are
        limited by capability and capacity. Refer to Apigee's public documentation
        to understand about each of these types in details.
        An Apigee org can support heterogeneous Environments.
        Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:apigee/environment:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_proxy_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_ip_resolution_config: Optional[pulumi.Input[Union['EnvironmentClientIpResolutionConfigArgs', 'EnvironmentClientIpResolutionConfigArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 forward_proxy_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['EnvironmentNodeConfigArgs', 'EnvironmentNodeConfigArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['EnvironmentPropertiesArgs', 'EnvironmentPropertiesArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An `Environment` in Apigee.

        To get more information about Environment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage

        ### Apigee Environment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id,
            client_ip_resolution_config={
                "header_index_algorithm": {
                    "ip_header_name": "X-Forwarded-For",
                    "ip_header_index": 1,
                },
            })
        ```

        ## Import

        Environment can be imported using any of these accepted formats:

        * `{{org_id}}/environments/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Environment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environment:Environment default {{org_id}}/environments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environment:Environment default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_proxy_type: Optional. API Proxy type supported by the environment. The type can be set when creating
               the Environment and cannot be changed.
               Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        :param pulumi.Input[Union['EnvironmentClientIpResolutionConfigArgs', 'EnvironmentClientIpResolutionConfigArgsDict']] client_ip_resolution_config: The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
               Structure is documented below.
        :param pulumi.Input[builtins.str] deployment_type: Optional. Deployment type supported by the environment. The deployment type can be
               set when creating the environment and cannot be changed. When you enable archive
               deployment, you will be prevented from performing a subset of actions within the
               environment, including:
               Managing the deployment of API proxy or shared flow revisions;
               Creating, updating, or deleting resource files;
               Creating, updating, or deleting target servers.
               Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        :param pulumi.Input[builtins.str] description: Description of the environment.
        :param pulumi.Input[builtins.str] display_name: Display name of the environment.
        :param pulumi.Input[builtins.str] forward_proxy_uri: Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        :param pulumi.Input[builtins.str] name: The resource ID of the environment.
        :param pulumi.Input[Union['EnvironmentNodeConfigArgs', 'EnvironmentNodeConfigArgsDict']] node_config: NodeConfig for setting the min/max number of nodes associated with the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee environment,
               in the format `organizations/{{org_name}}`.
               
               
               - - -
        :param pulumi.Input[Union['EnvironmentPropertiesArgs', 'EnvironmentPropertiesArgsDict']] properties: Key-value pairs that may be used for customizing the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: Types that can be selected for an Environment. Each of the types are
               limited by capability and capacity. Refer to Apigee's public documentation
               to understand about each of these types in details.
               An Apigee org can support heterogeneous Environments.
               Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Environment` in Apigee.

        To get more information about Environment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage

        ### Apigee Environment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env = gcp.apigee.Environment("env",
            name="my-environment",
            description="Apigee Environment",
            display_name="environment-1",
            org_id=apigee_org.id,
            client_ip_resolution_config={
                "header_index_algorithm": {
                    "ip_header_name": "X-Forwarded-For",
                    "ip_header_index": 1,
                },
            })
        ```

        ## Import

        Environment can be imported using any of these accepted formats:

        * `{{org_id}}/environments/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Environment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environment:Environment default {{org_id}}/environments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environment:Environment default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_proxy_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_ip_resolution_config: Optional[pulumi.Input[Union['EnvironmentClientIpResolutionConfigArgs', 'EnvironmentClientIpResolutionConfigArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 forward_proxy_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['EnvironmentNodeConfigArgs', 'EnvironmentNodeConfigArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['EnvironmentPropertiesArgs', 'EnvironmentPropertiesArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["api_proxy_type"] = api_proxy_type
            __props__.__dict__["client_ip_resolution_config"] = client_ip_resolution_config
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["forward_proxy_uri"] = forward_proxy_uri
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config"] = node_config
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["properties"] = properties
            __props__.__dict__["type"] = type
        super(Environment, __self__).__init__(
            'gcp:apigee/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_proxy_type: Optional[pulumi.Input[builtins.str]] = None,
            client_ip_resolution_config: Optional[pulumi.Input[Union['EnvironmentClientIpResolutionConfigArgs', 'EnvironmentClientIpResolutionConfigArgsDict']]] = None,
            deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            forward_proxy_uri: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_config: Optional[pulumi.Input[Union['EnvironmentNodeConfigArgs', 'EnvironmentNodeConfigArgsDict']]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['EnvironmentPropertiesArgs', 'EnvironmentPropertiesArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_proxy_type: Optional. API Proxy type supported by the environment. The type can be set when creating
               the Environment and cannot be changed.
               Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        :param pulumi.Input[Union['EnvironmentClientIpResolutionConfigArgs', 'EnvironmentClientIpResolutionConfigArgsDict']] client_ip_resolution_config: The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
               Structure is documented below.
        :param pulumi.Input[builtins.str] deployment_type: Optional. Deployment type supported by the environment. The deployment type can be
               set when creating the environment and cannot be changed. When you enable archive
               deployment, you will be prevented from performing a subset of actions within the
               environment, including:
               Managing the deployment of API proxy or shared flow revisions;
               Creating, updating, or deleting resource files;
               Creating, updating, or deleting target servers.
               Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        :param pulumi.Input[builtins.str] description: Description of the environment.
        :param pulumi.Input[builtins.str] display_name: Display name of the environment.
        :param pulumi.Input[builtins.str] forward_proxy_uri: Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        :param pulumi.Input[builtins.str] name: The resource ID of the environment.
        :param pulumi.Input[Union['EnvironmentNodeConfigArgs', 'EnvironmentNodeConfigArgsDict']] node_config: NodeConfig for setting the min/max number of nodes associated with the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] org_id: The Apigee Organization associated with the Apigee environment,
               in the format `organizations/{{org_name}}`.
               
               
               - - -
        :param pulumi.Input[Union['EnvironmentPropertiesArgs', 'EnvironmentPropertiesArgsDict']] properties: Key-value pairs that may be used for customizing the environment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: Types that can be selected for an Environment. Each of the types are
               limited by capability and capacity. Refer to Apigee's public documentation
               to understand about each of these types in details.
               An Apigee org can support heterogeneous Environments.
               Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["api_proxy_type"] = api_proxy_type
        __props__.__dict__["client_ip_resolution_config"] = client_ip_resolution_config
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["forward_proxy_uri"] = forward_proxy_uri
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["type"] = type
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiProxyType")
    def api_proxy_type(self) -> pulumi.Output[builtins.str]:
        """
        Optional. API Proxy type supported by the environment. The type can be set when creating
        the Environment and cannot be changed.
        Possible values are: `API_PROXY_TYPE_UNSPECIFIED`, `PROGRAMMABLE`, `CONFIGURABLE`.
        """
        return pulumi.get(self, "api_proxy_type")

    @property
    @pulumi.getter(name="clientIpResolutionConfig")
    def client_ip_resolution_config(self) -> pulumi.Output[Optional['outputs.EnvironmentClientIpResolutionConfig']]:
        """
        The algorithm to resolve IP. This will affect Analytics, API Security, and other features that use the client ip. To remove a client ip resolution config, update the field to an empty value. Example: '{ "clientIpResolutionConfig" = {} }' For more information, see: https://cloud.google.com/apigee/docs/api-platform/system-administration/client-ip-resolution
        Structure is documented below.
        """
        return pulumi.get(self, "client_ip_resolution_config")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[builtins.str]:
        """
        Optional. Deployment type supported by the environment. The deployment type can be
        set when creating the environment and cannot be changed. When you enable archive
        deployment, you will be prevented from performing a subset of actions within the
        environment, including:
        Managing the deployment of API proxy or shared flow revisions;
        Creating, updating, or deleting resource files;
        Creating, updating, or deleting target servers.
        Possible values are: `DEPLOYMENT_TYPE_UNSPECIFIED`, `PROXY`, `ARCHIVE`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display name of the environment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="forwardProxyUri")
    def forward_proxy_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. URI of the forward proxy to be applied to the runtime instances in this environment. Must be in the format of {scheme}://{hostname}:{port}. Note that the scheme must be one of "http" or "https", and the port must be supplied.
        """
        return pulumi.get(self, "forward_proxy_uri")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource ID of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.EnvironmentNodeConfig']:
        """
        NodeConfig for setting the min/max number of nodes associated with the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[builtins.str]:
        """
        The Apigee Organization associated with the Apigee environment,
        in the format `organizations/{{org_name}}`.


        - - -
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional['outputs.EnvironmentProperties']]:
        """
        Key-value pairs that may be used for customizing the environment.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Types that can be selected for an Environment. Each of the types are
        limited by capability and capacity. Refer to Apigee's public documentation
        to understand about each of these types in details.
        An Apigee org can support heterogeneous Environments.
        Possible values are: `ENVIRONMENT_TYPE_UNSPECIFIED`, `BASE`, `INTERMEDIATE`, `COMPREHENSIVE`.
        """
        return pulumi.get(self, "type")

